/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.pdf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PageFormat;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Vector;
import org.stamppagetor.pdf.PDFFontMetrics;
import org.stamppagetor.pdf.PDFObjectXObject;

public class PDFGraphics2D
extends Graphics2D {
    private StringBuilder sb = new StringBuilder();
    private final PageFormat format;
    private Vector<PDFObjectXObject> imageData = new Vector();
    private Font font = null;
    private int fontId = 1;

    public PDFGraphics2D(PageFormat pageFormat) {
        this.format = pageFormat;
    }

    public String getContent() {
        return this.sb.toString();
    }

    private double roty(double d) {
        if (this.format == null) {
            return d;
        }
        return this.format.getHeight() - d;
    }

    private double roty(int n) {
        if (this.format == null) {
            return n;
        }
        return this.format.getHeight() - (double)n;
    }

    private String toPdfString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '(': {
                    stringBuilder.append('\\');
                    stringBuilder.append('(');
                    continue block5;
                }
                case ')': {
                    stringBuilder.append('\\');
                    stringBuilder.append(')');
                    continue block5;
                }
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\\');
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
    }

    @Override
    public void clip(Shape shape) {
    }

    @Override
    public void draw(Shape shape) {
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.sb.append("BT\r");
        this.sb.append("/F" + this.fontId + " " + this.font.getSize() + " Tf\r");
        this.sb.append(f + " " + this.roty(f2) + " Td\r");
        this.sb.append("(" + this.toPdfString(string) + ") Tj\r");
        this.sb.append("ET\r");
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
    }

    @Override
    public void fill(Shape shape) {
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public Composite getComposite() {
        return null;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return null;
    }

    @Override
    public Paint getPaint() {
        return null;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public Stroke getStroke() {
        return null;
    }

    @Override
    public AffineTransform getTransform() {
        return null;
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return false;
    }

    @Override
    public void rotate(double d) {
    }

    @Override
    public void rotate(double d, double d2, double d3) {
    }

    @Override
    public void scale(double d, double d2) {
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public void setComposite(Composite composite) {
    }

    @Override
    public void setPaint(Paint paint) {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            this.sb.append(basicStroke.getLineWidth());
            this.sb.append(" w\r");
        }
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
    }

    @Override
    public void shear(double d, double d2) {
    }

    @Override
    public void transform(AffineTransform affineTransform) {
    }

    @Override
    public void translate(int n, int n2) {
    }

    @Override
    public void translate(double d, double d2) {
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public Graphics create() {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return false;
    }

    public Vector<PDFObjectXObject> getImagesData() {
        return this.imageData;
    }

    private int storeImage(Image image) {
        int n = this.imageData.size() + 1;
        BufferedImage bufferedImage = (BufferedImage)image;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int[] nArray = bufferedImage.getRGB(0, 0, n2, n3, null, 0, n2);
        this.imageData.add(new PDFObjectXObject(n2, n3, nArray, n));
        return n;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        int n9 = this.storeImage(image);
        this.sb.append("q\r");
        this.sb.append(n3 - n + " 0 0 " + (n4 - n2) + " " + n + " " + (this.roty(n2) - (double)(n4 - n2)) + " cm\r");
        this.sb.append("/Im" + n9 + " Do\r");
        this.sb.append("Q\r");
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return false;
    }

    private void moveTo(int n, int n2) {
        this.sb.append(n);
        this.sb.append(" ");
        this.sb.append(this.roty(n2));
        this.sb.append(" m\r");
    }

    private void lineTo(int n, int n2) {
        this.sb.append(n);
        this.sb.append(" ");
        this.sb.append(this.roty(n2));
        this.sb.append(" l\r");
    }

    private void stroke() {
        this.sb.append("S\r");
    }

    private void closePath() {
        this.sb.append("h\r");
    }

    private void setLineCapProjectingSquare() {
        this.sb.append("2 J\r");
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.setLineCapProjectingSquare();
        this.moveTo(n, n2);
        this.lineTo(n3, n4);
        this.stroke();
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.sb.append(n + " " + this.roty(n2) + " " + n3 + " " + -n4 + " re\r");
        this.stroke();
    }

    private void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.sb.append(d + " " + this.roty(d2) + " " + d3 + " " + this.roty(d4) + " " + d5 + " " + this.roty(d6) + " c\r");
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        double d = (float)n + (float)n3 * 0.5f;
        double d2 = n2;
        double d3 = (double)n + (double)((float)n3 * 0.5f) * 1.551784;
        double d4 = d2;
        double d5 = n + n3;
        double d6 = (double)n2 + (double)((float)n4 * 0.5f) * 0.44821599999999995;
        double d7 = d5;
        double d8 = (float)n2 + (float)n4 * 0.5f;
        double d9 = d5;
        double d10 = (double)n2 + (double)((float)n4 * 0.5f) * 1.551784;
        double d11 = d3;
        double d12 = n2 + n4;
        double d13 = d;
        double d14 = d12;
        double d15 = (double)n + (double)((float)n3 * 0.5f) * 0.44821599999999995;
        double d16 = d12;
        double d17 = n;
        double d18 = d10;
        double d19 = d17;
        double d20 = d8;
        double d21 = d17;
        double d22 = d6;
        double d23 = d15;
        double d24 = d2;
        this.moveTo((int)d, (int)d2);
        this.curveTo(d3, d4, d5, d6, d7, d8);
        this.curveTo(d9, d10, d11, d12, d13, d14);
        this.curveTo(d15, d16, d17, d18, d19, d20);
        this.curveTo(d21, d22, d23, d24, d, d2);
        this.stroke();
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            this.moveTo(nArray[0], nArray2[0]);
            for (int i = 1; i < n; ++i) {
                this.lineTo(nArray[i], nArray2[i]);
            }
            this.closePath();
            this.stroke();
        }
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        return null;
    }

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return new PDFFontMetrics(font);
    }

    @Override
    public void setClip(Shape shape) {
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
    }

    @Override
    public void setColor(Color color) {
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        int n = this.font.getStyle();
        this.fontId = (n & 2) == 2 ? 2 : ((n & 1) == 1 ? 3 : 1);
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }
}

