/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.EllipseRoi;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.SplineFitter;
import ij.plugin.frame.LineWidthAdjuster;
import ij.plugin.frame.Recorder;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import ij.process.PolygonFiller;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class PolygonRoi
extends Roi {
    protected int maxPoints = 1000;
    protected int[] xp;
    protected int[] yp;
    protected float[] xpf;
    protected float[] ypf;
    protected int[] xp2;
    protected int[] yp2;
    protected int nPoints;
    protected float[] xSpline;
    protected float[] ySpline;
    protected int splinePoints = 200;
    Rectangle clip;
    private double angle1;
    private double degrees = Double.NaN;
    private int xClipMin;
    private int yClipMin;
    private int xClipMax;
    private int yClipMax;
    private boolean userCreated;
    private boolean subPixel;
    private double startXD;
    private double startYD;
    private boolean drawOffset;
    long mouseUpTime = 0L;

    public PolygonRoi(int[] xPoints, int[] yPoints, int nPoints, int type) {
        super(0, 0, null);
        this.init1(nPoints, type);
        this.xp = xPoints;
        this.yp = yPoints;
        if (type != 4) {
            this.xp = new int[nPoints];
            this.yp = new int[nPoints];
            for (int i = 0; i < nPoints; ++i) {
                this.xp[i] = xPoints[i];
                this.yp[i] = yPoints[i];
            }
        }
        this.xp2 = new int[nPoints];
        this.yp2 = new int[nPoints];
        this.init2(type);
    }

    public PolygonRoi(float[] xPoints, float[] yPoints, int nPoints, int type) {
        super(0, 0, null);
        this.init1(nPoints, type);
        this.xpf = xPoints;
        this.ypf = yPoints;
        this.subPixel = true;
        this.xp2 = new int[nPoints];
        this.yp2 = new int[nPoints];
        this.init2(type);
    }

    private void init1(int nPoints, int type) throws IllegalArgumentException {
        this.maxPoints = nPoints;
        this.nPoints = nPoints;
        if (type == 2) {
            this.type = 2;
        } else if (type == 3) {
            this.type = 3;
        } else if (type == 4) {
            this.type = 4;
        } else if (type == 6) {
            this.type = 6;
        } else if (type == 7) {
            this.type = 7;
        } else if (type == 8) {
            this.type = 8;
        } else if (type == 10) {
            this.type = 10;
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
    }

    private void init2(int type) {
        if (type == 8 && this.nPoints == 3) {
            this.getAngleAsString();
        }
        if (type == 10 && Toolbar.getMultiPointMode()) {
            Prefs.pointAutoMeasure = false;
            Prefs.pointAutoNextSlice = false;
            Prefs.pointAddToManager = false;
            this.userCreated = true;
        }
        if (lineWidth > 1 && this.isLine()) {
            this.updateWideLine(lineWidth);
        }
        this.finishPolygon();
    }

    public PolygonRoi(Polygon p, int type) {
        this(p.xpoints, p.ypoints, p.npoints, type);
    }

    public PolygonRoi(FloatPolygon p, int type) {
        this(p.xpoints, p.ypoints, p.npoints, type);
    }

    public PolygonRoi(int[] xPoints, int[] yPoints, int nPoints, ImagePlus imp, int type) {
        this(xPoints, yPoints, nPoints, type);
        this.setImage(imp);
    }

    public PolygonRoi(int sx, int sy, ImagePlus imp) {
        super(sx, sy, imp);
        int tool = Toolbar.getToolId();
        switch (tool) {
            case 2: {
                this.type = 2;
                break;
            }
            case 3: {
                this.type = 3;
                break;
            }
            case 6: {
                this.type = 7;
                if (!Prefs.subPixelResolution) break;
                this.subPixel = true;
                break;
            }
            case 14: {
                this.type = 8;
                break;
            }
            default: {
                this.type = 6;
                if (!Prefs.subPixelResolution) break;
                this.subPixel = true;
            }
        }
        if (this instanceof EllipseRoi) {
            this.subPixel = true;
        }
        this.x = this.ic.offScreenX(sx);
        this.y = this.ic.offScreenY(sy);
        this.startXD = this.subPixelResolution() ? this.ic.offScreenXD(sx) : (double)this.x;
        double d = this.startYD = this.subPixelResolution() ? this.ic.offScreenYD(sy) : (double)this.y;
        if (this.subPixelResolution()) {
            this.xpf = new float[this.maxPoints];
            this.ypf = new float[this.maxPoints];
            this.xpf[0] = (float)(this.startXD - (double)this.x);
            this.ypf[0] = (float)(this.startYD - (double)this.y);
            this.xpf[1] = this.xpf[0];
            this.ypf[1] = this.ypf[0];
        } else {
            this.xp = new int[this.maxPoints];
            this.yp = new int[this.maxPoints];
        }
        this.xp2 = new int[this.maxPoints];
        this.yp2 = new int[this.maxPoints];
        this.nPoints = 2;
        this.width = 1;
        this.height = 1;
        this.clipX = this.x;
        this.clipY = this.y;
        this.clipWidth = 1;
        this.clipHeight = 1;
        this.state = 0;
        this.userCreated = true;
        if (lineWidth > 1 && this.isLine()) {
            this.updateWideLine(lineWidth);
        }
        this.drawOffset = this.subPixelResolution();
    }

    private void drawStartBox(Graphics g) {
        if (this.type != 8) {
            double offset = this.getOffset(0.5);
            g.drawRect(this.ic.screenXD(this.startXD + offset) - 4, this.ic.screenYD(this.startYD + offset) - 4, 8, 8);
        }
    }

    public void draw(Graphics g) {
        boolean isActiveOverlayRoi;
        this.updatePolygon();
        Color color = this.strokeColor != null ? this.strokeColor : ROIColor;
        boolean hasHandles = this.xSpline != null || this.type == 2 || this.type == 6 || this.type == 8;
        boolean bl = isActiveOverlayRoi = !this.overlay && this.isActiveOverlayRoi();
        if (isActiveOverlayRoi && !hasHandles) {
            color = color == Color.cyan ? Color.magenta : Color.cyan;
        }
        boolean fill = false;
        this.mag = this.getMagnification();
        if (this.fillColor != null && !this.isLine() && this.state != 0) {
            color = this.fillColor;
            fill = true;
        }
        g.setColor(color);
        Graphics2D g2d = (Graphics2D)g;
        if (this.stroke != null && !isActiveOverlayRoi) {
            g2d.setStroke(this.getScaledStroke());
        }
        if (this.xSpline != null) {
            if (this.type == 6 || this.type == 7) {
                this.drawSpline(g, this.xSpline, this.ySpline, this.splinePoints, false, fill, isActiveOverlayRoi);
                if (this.wideLine && !this.overlay) {
                    g2d.setStroke(onePixelWide);
                    g.setColor(PolygonRoi.getColor());
                    this.drawSpline(g, this.xSpline, this.ySpline, this.splinePoints, false, fill, isActiveOverlayRoi);
                }
            } else {
                this.drawSpline(g, this.xSpline, this.ySpline, this.splinePoints, true, fill, isActiveOverlayRoi);
            }
        } else {
            if (this.type == 6 || this.type == 7 || this.type == 8 || this.state == 0) {
                g.drawPolyline(this.xp2, this.yp2, this.nPoints);
                if (this.wideLine && !this.overlay) {
                    g2d.setStroke(onePixelWide);
                    g.setColor(PolygonRoi.getColor());
                    g.drawPolyline(this.xp2, this.yp2, this.nPoints);
                }
            } else if (fill) {
                if (isActiveOverlayRoi) {
                    g.setColor(Color.cyan);
                    g.drawPolygon(this.xp2, this.yp2, this.nPoints);
                } else {
                    g.fillPolygon(this.xp2, this.yp2, this.nPoints);
                }
            } else {
                g.drawPolygon(this.xp2, this.yp2, this.nPoints);
            }
            if (this.state == 0 && this.type != 3 && this.type != 7) {
                this.drawStartBox(g);
            }
        }
        if (hasHandles && this.state != 0 && this.clipboard == null && !this.overlay) {
            int size2 = 2;
            if (this.activeHandle > 0) {
                this.drawHandle(g, this.xp2[this.activeHandle - 1] - size2, this.yp2[this.activeHandle - 1] - size2);
            }
            if (this.activeHandle < this.nPoints - 1) {
                this.drawHandle(g, this.xp2[this.activeHandle + 1] - size2, this.yp2[this.activeHandle + 1] - size2);
            }
            this.handleColor = this.strokeColor != null ? this.strokeColor : ROIColor;
            this.drawHandle(g, this.xp2[0] - size2, this.yp2[0] - size2);
            this.handleColor = Color.white;
            for (int i = 1; i < this.nPoints; ++i) {
                this.drawHandle(g, this.xp2[i] - size2, this.yp2[i] - size2);
            }
        }
        this.drawPreviousRoi(g);
        if (this.state != 4 && this.state != 0 && this.state != 3) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    private void drawSpline(Graphics g, float[] xpoints, float[] ypoints, int npoints, boolean closed, boolean fill, boolean isActiveOverlayRoi) {
        double srcx = 0.0;
        double srcy = 0.9;
        double mag = 1.0;
        if (this.ic != null) {
            Rectangle srcRect = this.ic.getSrcRect();
            srcx = srcRect.x;
            srcy = srcRect.y;
            mag = this.ic.getMagnification();
        }
        double xd = this.x;
        double yd = this.y;
        Graphics2D g2d = (Graphics2D)g;
        GeneralPath path = new GeneralPath();
        double offset = this.getOffset(0.5);
        if (mag == 1.0 && srcx == 0.0 && srcy == 0.0) {
            path.moveTo((double)xpoints[0] + xd, (double)ypoints[0] + yd);
            for (int i = 1; i < npoints; ++i) {
                path.lineTo((double)xpoints[i] + xd, (double)ypoints[i] + yd);
            }
        } else {
            path.moveTo(((double)xpoints[0] - srcx + xd) * mag + offset, ((double)ypoints[0] - srcy + yd + offset) * mag);
            for (int i = 1; i < npoints; ++i) {
                path.lineTo(((double)xpoints[i] - srcx + xd + offset) * mag, ((double)ypoints[i] - srcy + yd + offset) * mag);
            }
        }
        if (closed) {
            path.lineTo(((double)xpoints[0] - srcx + xd + offset) * mag, ((double)ypoints[0] - srcy + yd + offset) * mag);
        }
        if (fill) {
            if (isActiveOverlayRoi) {
                g2d.setColor(Color.cyan);
                g2d.draw(path);
            } else {
                g2d.fill(path);
            }
        } else {
            g2d.draw(path);
        }
    }

    public void drawPixels(ImageProcessor ip) {
        int saveWidth = ip.getLineWidth();
        if (this.getStrokeWidth() > 1.0f) {
            ip.setLineWidth(Math.round(this.getStrokeWidth()));
        }
        double offset = this.getOffset(0.5);
        if (this.xSpline != null) {
            ip.moveTo(this.x + (int)((double)Math.round(this.xSpline[0]) + offset), this.y + (int)Math.round((double)this.ySpline[0] + offset));
            for (int i = 1; i < this.splinePoints; ++i) {
                ip.lineTo(this.x + (int)((double)Math.round(this.xSpline[i]) + offset), this.y + (int)Math.round((double)this.ySpline[i] + offset));
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                ip.lineTo(this.x + (int)((double)Math.round(this.xSpline[0]) + offset), this.y + (int)Math.round((double)this.ySpline[0] + offset));
            }
        } else if (this.xpf != null) {
            ip.moveTo(this.x + (int)((double)Math.round(this.xpf[0]) + offset), this.y + (int)Math.round((double)this.ypf[0] + offset));
            for (int i = 1; i < this.nPoints; ++i) {
                ip.lineTo(this.x + (int)((double)Math.round(this.xpf[i]) + offset), this.y + (int)Math.round((double)this.ypf[i] + offset));
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                ip.lineTo(this.x + (int)((double)Math.round(this.xpf[0]) + offset), this.y + (int)Math.round((double)this.ypf[0] + offset));
            }
        } else {
            ip.moveTo(this.x + this.xp[0], this.y + this.yp[0]);
            for (int i = 1; i < this.nPoints; ++i) {
                ip.lineTo(this.x + this.xp[i], this.y + this.yp[i]);
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                ip.lineTo(this.x + this.xp[0], this.y + this.yp[0]);
            }
        }
        ip.setLineWidth(saveWidth);
        this.updateFullWindow = true;
    }

    protected void grow(int sx, int sy) {
    }

    protected void updatePolygon() {
        double mag;
        int basex = 0;
        int basey = 0;
        if (this.ic != null) {
            Rectangle srcRect = this.ic.getSrcRect();
            basex = srcRect.x;
            basey = srcRect.y;
        }
        if ((mag = this.getMagnification()) == 1.0 && basex == 0 && basey == 0) {
            if (this.xpf != null) {
                float xbase = this.x;
                float ybase = this.y;
                if (this.bounds != null) {
                    xbase = (float)this.bounds.x;
                    ybase = (float)this.bounds.y;
                }
                for (int i = 0; i < this.nPoints; ++i) {
                    this.xp2[i] = (int)(this.xpf[i] + xbase);
                    this.yp2[i] = (int)(this.ypf[i] + ybase);
                }
            } else {
                for (int i = 0; i < this.nPoints; ++i) {
                    this.xp2[i] = this.xp[i] + this.x;
                    this.yp2[i] = this.yp[i] + this.y;
                }
            }
        } else if (this.xpf != null) {
            double xbase = this.x;
            double ybase = this.y;
            if (this.bounds != null) {
                xbase = this.bounds.x;
                ybase = this.bounds.y;
            }
            double offset = this.getOffset(0.5);
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp2[i] = this.ic.screenXD((double)this.xpf[i] + xbase + offset);
                this.yp2[i] = this.ic.screenYD((double)this.ypf[i] + ybase + offset);
            }
        } else {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp2[i] = this.ic.screenX(this.xp[i] + this.x);
                this.yp2[i] = this.ic.screenY(this.yp[i] + this.y);
            }
        }
    }

    void handleMouseMove(int sx, int sy) {
        int tool = Toolbar.getToolId();
        if (tool != 2 && tool != 5 && tool != 14) {
            this.imp.deleteRoi();
            this.imp.draw();
            return;
        }
        this.drawRubberBand(sx, sy);
        this.degrees = Double.NaN;
        double len = -1.0;
        if (this.nPoints > 1) {
            double y2;
            double x2;
            double y1;
            double x1;
            if (this.xpf != null) {
                x1 = this.xpf[this.nPoints - 2];
                y1 = this.ypf[this.nPoints - 2];
                x2 = this.xpf[this.nPoints - 1];
                y2 = this.ypf[this.nPoints - 1];
            } else {
                x1 = this.xp[this.nPoints - 2];
                y1 = this.yp[this.nPoints - 2];
                x2 = this.xp[this.nPoints - 1];
                y2 = this.yp[this.nPoints - 1];
            }
            this.degrees = this.getAngle((int)Math.round(x1), (int)Math.round(y1), (int)Math.round(x2), (int)Math.round(y2));
            if (tool != 14) {
                Calibration cal = this.imp.getCalibration();
                double pw = cal.pixelWidth;
                double ph = cal.pixelHeight;
                if (IJ.altKeyDown()) {
                    pw = 1.0;
                    ph = 1.0;
                }
                len = Math.sqrt((x2 - x1) * pw * (x2 - x1) * pw + (y2 - y1) * ph * (y2 - y1) * ph);
            }
        }
        if (tool == 14) {
            if (this.nPoints == 2) {
                this.angle1 = this.degrees;
            } else if (this.nPoints == 3) {
                double angle2 = this.getAngle(this.xp[1], this.yp[1], this.xp[2], this.yp[2]);
                this.degrees = Math.abs(180.0 - Math.abs(this.angle1 - angle2));
                if (this.degrees > 180.0) {
                    this.degrees = 360.0 - this.degrees;
                }
            }
        }
        String length = len != -1.0 ? ", length=" + IJ.d2s(len) : "";
        double degrees2 = tool == 14 && this.nPoints == 3 && Prefs.reflexAngle ? 360.0 - this.degrees : this.degrees;
        String angle = !Double.isNaN(this.degrees) ? ", angle=" + IJ.d2s(degrees2) : "";
        int ox = this.ic != null ? this.ic.offScreenX(sx) : sx;
        int oy = this.ic != null ? this.ic.offScreenY(sy) : sy;
        IJ.showStatus(this.imp.getLocationAsString(ox, oy) + length + angle);
    }

    void drawRubberBand(int sx, int sy) {
        double mag;
        int y2;
        int x2;
        int y1;
        int x1;
        double oxd = this.ic != null ? this.ic.offScreenXD(sx) : (double)sx;
        double oyd = this.ic != null ? this.ic.offScreenYD(sy) : (double)sy;
        int ox = (int)oxd;
        int oy = (int)oyd;
        if (this.xpf != null) {
            x1 = (int)this.xpf[this.nPoints - 2] + this.x;
            y1 = (int)this.ypf[this.nPoints - 2] + this.y;
            x2 = (int)this.xpf[this.nPoints - 1] + this.x;
            y2 = (int)this.ypf[this.nPoints - 1] + this.y;
        } else {
            x1 = this.xp[this.nPoints - 2] + this.x;
            y1 = this.yp[this.nPoints - 2] + this.y;
            x2 = this.xp[this.nPoints - 1] + this.x;
            y2 = this.yp[this.nPoints - 1] + this.y;
        }
        int xmin = 9999;
        int ymin = 9999;
        int xmax = 0;
        int ymax = 0;
        if (x1 < xmin) {
            xmin = x1;
        }
        if (x2 < xmin) {
            xmin = x2;
        }
        if (ox < xmin) {
            xmin = ox;
        }
        if (x1 > xmax) {
            xmax = x1;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (ox > xmax) {
            xmax = ox;
        }
        if (y1 < ymin) {
            ymin = y1;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (oy < ymin) {
            ymin = oy;
        }
        if (y1 > ymax) {
            ymax = y1;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        if (oy > ymax) {
            ymax = oy;
        }
        int margin = 4;
        if (this.ic != null && (mag = this.ic.getMagnification()) < 1.0) {
            margin = (int)((double)margin / mag);
        }
        margin = (int)((float)margin + this.getStrokeWidth());
        if (this.xpf != null) {
            this.xpf[this.nPoints - 1] = (float)(oxd - (double)this.x);
            this.ypf[this.nPoints - 1] = (float)(oyd - (double)this.y);
        } else {
            this.xp[this.nPoints - 1] = ox - this.x;
            this.yp[this.nPoints - 1] = oy - this.y;
        }
        this.imp.draw(xmin - margin, ymin - margin, xmax - xmin + margin * 2, ymax - ymin + margin * 2);
    }

    void finishPolygon() {
        if (this.xpf != null) {
            FloatPolygon poly = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
            Rectangle r = poly.getBounds();
            this.x = r.x;
            this.y = r.y;
            this.width = r.width;
            this.height = r.height;
            this.bounds = poly.getFloatBounds();
            float xbase = (float)this.bounds.getX();
            float ybase = (float)this.bounds.getY();
            int i = 0;
            while (i < this.nPoints) {
                int n = i;
                this.xpf[n] = this.xpf[n] - xbase;
                int n2 = i++;
                this.ypf[n2] = this.ypf[n2] - ybase;
            }
        } else {
            Polygon poly = new Polygon(this.xp, this.yp, this.nPoints);
            Rectangle r = poly.getBounds();
            this.x = r.x;
            this.y = r.y;
            this.width = r.width;
            this.height = r.height;
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp[i] = this.xp[i] - this.x;
                this.yp[i] = this.yp[i] - this.y;
            }
            this.bounds = null;
        }
        if (this.nPoints < 2 || this.type != 7 && this.type != 6 && this.type != 8 && (this.nPoints < 3 || this.width == 0 || this.height == 0)) {
            if (this.imp != null) {
                this.imp.deleteRoi();
            }
            if (this.type != 10) {
                return;
            }
        }
        this.state = 3;
        if (this.imp != null && this.type != 4) {
            this.imp.draw(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        if (Recorder.record && this.userCreated && (this.type == 2 || this.type == 6 || this.type == 8 || this.type == 10 && Recorder.scriptMode() && this.nPoints == 3)) {
            Recorder.recordRoi(this.getPolygon(), this.type);
        }
        if (this.type != 10) {
            this.modifyRoi();
        }
        LineWidthAdjuster.update();
    }

    public void exitConstructingMode() {
        if (this.type == 6 && this.state == 0) {
            this.addOffset();
            this.finishPolygon();
        }
    }

    protected void moveHandle(int sx, int sy) {
        if (this.clipboard != null) {
            return;
        }
        int ox = this.ic.offScreenX(sx);
        int oy = this.ic.offScreenY(sy);
        if (this.xpf != null) {
            double offset = this.getOffset(-0.5);
            this.xpf[this.activeHandle] = (float)(this.ic.offScreenXD(sx) - (double)this.x + offset);
            this.ypf[this.activeHandle] = (float)(this.ic.offScreenYD(sy) - (double)this.y + offset);
        } else {
            this.xp[this.activeHandle] = ox - this.x;
            this.yp[this.activeHandle] = oy - this.y;
        }
        if (this.xSpline != null) {
            this.fitSpline(this.splinePoints);
            this.updateClipRect();
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.oldX = this.x;
            this.oldY = this.y;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
        } else {
            this.resetBoundingRect();
            if (this.type == 10 && this.width == 0 && this.height == 0) {
                this.width = 1;
                this.height = 1;
            }
            this.updateClipRectAndDraw();
        }
        String angle = this.type == 8 ? this.getAngleAsString() : "";
        IJ.showStatus(this.imp.getLocationAsString(ox, oy) + angle);
    }

    void updateClipRectAndDraw() {
        int handleSize;
        int y2;
        int x2;
        if (this.xpf != null) {
            this.xp = PolygonRoi.toInt(this.xpf, this.xp, this.nPoints);
            this.yp = PolygonRoi.toInt(this.ypf, this.yp, this.nPoints);
        }
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = 0;
        int ymax = 0;
        if (this.activeHandle > 0) {
            x2 = this.x + this.xp[this.activeHandle - 1];
            y2 = this.y + this.yp[this.activeHandle - 1];
        } else {
            x2 = this.x + this.xp[this.nPoints - 1];
            y2 = this.y + this.yp[this.nPoints - 1];
        }
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        x2 = this.x + this.xp[this.activeHandle];
        y2 = this.y + this.yp[this.activeHandle];
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        if (this.activeHandle < this.nPoints - 1) {
            x2 = this.x + this.xp[this.activeHandle + 1];
            y2 = this.y + this.yp[this.activeHandle + 1];
        } else {
            x2 = this.x + this.xp[0];
            y2 = this.y + this.yp[0];
        }
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        int xmin2 = xmin;
        int ymin2 = ymin;
        int xmax2 = xmax;
        int ymax2 = ymax;
        if (this.xClipMin < xmin2) {
            xmin2 = this.xClipMin;
        }
        if (this.yClipMin < ymin2) {
            ymin2 = this.yClipMin;
        }
        if (this.xClipMax > xmax2) {
            xmax2 = this.xClipMax;
        }
        if (this.yClipMax > ymax2) {
            ymax2 = this.yClipMax;
        }
        this.xClipMin = xmin;
        this.yClipMin = ymin;
        this.xClipMax = xmax;
        this.yClipMax = ymax;
        double mag = this.ic.getMagnification();
        int n = handleSize = this.type == 10 ? 17 : 5;
        if ((float)handleSize < this.getStrokeWidth() && this.isLine()) {
            handleSize = (int)this.getStrokeWidth();
        }
        int m = mag < 1.0 ? (int)((double)handleSize / mag) : handleSize;
        m = (int)((float)m * this.getStrokeWidth());
        this.imp.draw(xmin2 - m, ymin2 - m, xmax2 - xmin2 + m * 2, ymax2 - ymin2 + m * 2);
    }

    void resetBoundingRect() {
        int i;
        if (this.xpf != null) {
            this.resetSubPixelBoundingRect();
            this.xp = PolygonRoi.toInt(this.xpf, this.xp, this.nPoints);
            this.yp = PolygonRoi.toInt(this.ypf, this.yp, this.nPoints);
            return;
        }
        int xmin = Integer.MAX_VALUE;
        int xmax = -xmin;
        int ymin = xmin;
        int ymax = xmax;
        for (i = 0; i < this.nPoints; ++i) {
            int yy;
            int xx = this.xp[i];
            if (xx < xmin) {
                xmin = xx;
            }
            if (xx > xmax) {
                xmax = xx;
            }
            if ((yy = this.yp[i]) < ymin) {
                ymin = yy;
            }
            if (yy <= ymax) continue;
            ymax = yy;
        }
        if (xmin != 0) {
            i = 0;
            while (i < this.nPoints) {
                int n = i++;
                this.xp[n] = this.xp[n] - xmin;
            }
        }
        if (ymin != 0) {
            i = 0;
            while (i < this.nPoints) {
                int n = i++;
                this.yp[n] = this.yp[n] - ymin;
            }
        }
        this.x += xmin;
        this.y += ymin;
        this.width = xmax - xmin;
        this.height = ymax - ymin;
        this.bounds = null;
    }

    void resetSubPixelBoundingRect() {
        float xbase = this.x;
        float ybase = this.y;
        if (this.bounds != null) {
            xbase = (float)this.bounds.x;
            ybase = (float)this.bounds.y;
        }
        for (int i = 0; i < this.nPoints; ++i) {
            this.xpf[i] = this.xpf[i] + xbase;
            this.ypf[i] = this.ypf[i] + ybase;
        }
        FloatPolygon poly = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
        Rectangle r = poly.getBounds();
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
        this.bounds = poly.getFloatBounds();
        xbase = (float)this.bounds.getX();
        ybase = (float)this.bounds.getY();
        int i = 0;
        while (i < this.nPoints) {
            int n = i;
            this.xpf[n] = this.xpf[n] - xbase;
            int n2 = i++;
            this.ypf[n2] = this.ypf[n2] - ybase;
        }
    }

    String getAngleAsString() {
        double angle1 = 0.0;
        double angle2 = 0.0;
        if (this.xpf != null) {
            angle1 = this.getFloatAngle(this.xpf[0], this.ypf[0], this.xpf[1], this.ypf[1]);
            angle2 = this.getFloatAngle(this.xpf[1], this.ypf[1], this.xpf[2], this.ypf[2]);
        } else {
            angle1 = this.getFloatAngle(this.xp[0], this.yp[0], this.xp[1], this.yp[1]);
            angle2 = this.getFloatAngle(this.xp[1], this.yp[1], this.xp[2], this.yp[2]);
        }
        this.degrees = Math.abs(180.0 - Math.abs(angle1 - angle2));
        if (this.degrees > 180.0) {
            this.degrees = 360.0 - this.degrees;
        }
        double degrees2 = Prefs.reflexAngle && this.type == 8 ? 360.0 - this.degrees : this.degrees;
        return ", angle=" + IJ.d2s(degrees2);
    }

    protected void mouseDownInHandle(int handle, int sx, int sy) {
        if (this.state == 0) {
            return;
        }
        int ox = this.ic.offScreenX(sx);
        int oy = this.ic.offScreenY(sy);
        double oxd = this.ic.offScreenXD(sx);
        double oyd = this.ic.offScreenYD(sy);
        if (IJ.altKeyDown() && (this.nPoints > 3 || this.type == 10)) {
            this.deleteHandle(oxd, oyd);
            return;
        }
        if (IJ.shiftKeyDown() && this.type != 10) {
            this.addHandle(oxd, oyd);
            return;
        }
        this.state = 4;
        this.activeHandle = handle;
        int m = (int)(10.0 / this.ic.getMagnification());
        this.xClipMin = ox - m;
        this.yClipMin = oy - m;
        this.xClipMax = ox + m;
        this.yClipMax = oy + m;
    }

    public void deleteHandle(double ox, double oy) {
        if (this.imp == null) {
            return;
        }
        if (this.nPoints <= 1) {
            this.imp.deleteRoi();
            return;
        }
        boolean splineFit = this.xSpline != null;
        this.xSpline = null;
        FloatPolygon points = this.getFloatPolygon();
        this.modState = 0;
        if (previousRoi != null) {
            PolygonRoi.previousRoi.modState = 0;
        }
        int pointToDelete = this.getClosestPoint(ox, oy, points);
        FloatPolygon points2 = new FloatPolygon();
        for (int i = 0; i < points.npoints; ++i) {
            if (i == pointToDelete) continue;
            points2.addPoint(points.xpoints[i], points.ypoints[i]);
        }
        if (this.type == 10) {
            this.imp.setRoi(new PointRoi(points2.xpoints, points2.ypoints, points2.npoints));
        } else {
            if (this.subPixelResolution()) {
                PolygonRoi roi2 = new PolygonRoi(points2, this.type);
                ((Roi)roi2).setDrawOffset(this.getDrawOffset());
                this.imp.setRoi(roi2);
            } else {
                this.imp.setRoi(new PolygonRoi(PolygonRoi.toInt(points2.xpoints), PolygonRoi.toInt(points2.ypoints), points2.npoints, this.type));
            }
            if (splineFit) {
                ((PolygonRoi)this.imp.getRoi()).fitSpline(this.splinePoints);
            }
        }
    }

    void addHandle(double ox, double oy) {
        if (this.imp == null || this.type == 8) {
            return;
        }
        boolean splineFit = this.xSpline != null;
        this.xSpline = null;
        FloatPolygon points = this.getFloatPolygon();
        int n = points.npoints;
        this.modState = 0;
        if (previousRoi != null) {
            PolygonRoi.previousRoi.modState = 0;
        }
        int pointToDuplicate = this.getClosestPoint(ox, oy, points);
        FloatPolygon points2 = new FloatPolygon();
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 == pointToDuplicate) {
                int i3;
                int i1 = i2 - 1;
                if (i1 == -1) {
                    int n2 = i1 = this.isLine() ? i2 : n - 1;
                }
                if ((i3 = i2 + 1) == n) {
                    i3 = this.isLine() ? i2 : 0;
                }
                double x1 = points.xpoints[i1] + 2.0f * (points.xpoints[i2] - points.xpoints[i1]) / 3.0f;
                double y1 = points.ypoints[i1] + 2.0f * (points.ypoints[i2] - points.ypoints[i1]) / 3.0f;
                double x2 = points.xpoints[i2] + (points.xpoints[i3] - points.xpoints[i2]) / 3.0f;
                double y2 = points.ypoints[i2] + (points.ypoints[i3] - points.ypoints[i2]) / 3.0f;
                points2.addPoint(x1, y1);
                points2.addPoint(x2, y2);
                continue;
            }
            points2.addPoint(points.xpoints[i2], points.ypoints[i2]);
        }
        if (this.type == 10) {
            this.imp.setRoi(new PointRoi(points2));
        } else {
            if (this.subPixelResolution()) {
                PolygonRoi roi2 = new PolygonRoi(points2, this.type);
                ((Roi)roi2).setDrawOffset(this.getDrawOffset());
                this.imp.setRoi(roi2);
            } else {
                this.imp.setRoi(new PolygonRoi(PolygonRoi.toInt(points2.xpoints), PolygonRoi.toInt(points2.ypoints), points2.npoints, this.type));
            }
            if (splineFit) {
                ((PolygonRoi)this.imp.getRoi()).fitSpline(this.splinePoints);
            }
        }
    }

    int getClosestPoint(double x, double y, FloatPolygon points) {
        int index = 0;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < points.npoints; ++i) {
            double dx = (double)points.xpoints[i] - x;
            double dy = (double)points.ypoints[i] - y;
            double distance2 = dx * dx + dy * dy;
            if (!(distance2 < distance)) continue;
            distance = distance2;
            index = i;
        }
        return index;
    }

    public void fitSpline(int evaluationPoints) {
        int i;
        if (this.xpf == null) {
            this.xpf = PolygonRoi.toFloat(this.xp);
            this.ypf = PolygonRoi.toFloat(this.yp);
            this.subPixel = true;
        }
        if (this.xSpline == null || this.splinePoints != evaluationPoints) {
            this.splinePoints = evaluationPoints;
            this.xSpline = new float[this.splinePoints];
            this.ySpline = new float[this.splinePoints];
        }
        int nNodes = this.nPoints;
        if (this.type == 2) {
            if (++nNodes >= this.xpf.length) {
                this.enlargeArrays();
            }
            this.xpf[nNodes - 1] = this.xpf[0];
            this.ypf[nNodes - 1] = this.ypf[0];
        }
        float[] xindex = new float[nNodes];
        for (int i2 = 0; i2 < nNodes; ++i2) {
            xindex[i2] = i2;
        }
        SplineFitter sfx = new SplineFitter(xindex, this.xpf, nNodes);
        SplineFitter sfy = new SplineFitter(xindex, this.ypf, nNodes);
        double scale = (double)(nNodes - 1) / (double)(this.splinePoints - 1);
        float xs = 0.0f;
        float ys = 0.0f;
        float xmin = Float.MAX_VALUE;
        float xmax = -xmin;
        float ymin = xmin;
        float ymax = xmax;
        for (int i3 = 0; i3 < this.splinePoints; ++i3) {
            double xvalue = (double)i3 * scale;
            xs = (float)sfx.evalSpline(xindex, this.xpf, nNodes, xvalue);
            if (xs < xmin) {
                xmin = xs;
            }
            if (xs > xmax) {
                xmax = xs;
            }
            this.xSpline[i3] = xs;
            ys = (float)sfy.evalSpline(xindex, this.ypf, nNodes, xvalue);
            if (ys < ymin) {
                ymin = ys;
            }
            if (ys > ymax) {
                ymax = ys;
            }
            this.ySpline[i3] = ys;
        }
        int ixmin = (int)Math.floor(xmin + 0.5f);
        int ixmax = (int)Math.floor(xmax + 0.5f);
        int iymin = (int)Math.floor(ymin + 0.5f);
        int iymax = (int)Math.floor(ymax + 0.5f);
        if (ixmin != 0) {
            i = 0;
            while (i < this.nPoints) {
                int n = i++;
                this.xpf[n] = this.xpf[n] - (float)ixmin;
            }
            i = 0;
            while (i < this.splinePoints) {
                int n = i++;
                this.xSpline[n] = this.xSpline[n] - (float)ixmin;
            }
        }
        if (iymin != 0) {
            i = 0;
            while (i < this.nPoints) {
                int n = i++;
                this.ypf[n] = this.ypf[n] - (float)iymin;
            }
            i = 0;
            while (i < this.splinePoints) {
                int n = i++;
                this.ySpline[n] = this.ySpline[n] - (float)iymin;
            }
        }
        this.x += ixmin;
        this.y += iymin;
        this.width = ixmax - ixmin;
        this.height = iymax - iymin;
        this.bounds = null;
        this.cachedMask = null;
        this.xp = PolygonRoi.toInt(this.xpf, this.xp, this.nPoints);
        this.yp = PolygonRoi.toInt(this.ypf, this.yp, this.nPoints);
    }

    public void fitSpline() {
        double mag;
        double length = this.getUncalibratedLength();
        int evaluationPoints = (int)(length / 2.0);
        if (this.ic != null && (mag = this.ic.getMagnification()) < 1.0) {
            evaluationPoints = (int)((double)evaluationPoints * mag);
        }
        if (evaluationPoints < 100) {
            evaluationPoints = 100;
        }
        this.fitSpline(evaluationPoints);
    }

    public void removeSplineFit() {
        this.xSpline = null;
        this.ySpline = null;
    }

    public boolean isSplineFit() {
        return this.xSpline != null;
    }

    public void fitSplineForStraightening() {
        this.fitSpline((int)this.getUncalibratedLength() * 2);
        if (this.splinePoints == 0) {
            return;
        }
        float[] xpoints = new float[this.splinePoints * 2];
        float[] ypoints = new float[this.splinePoints * 2];
        xpoints[0] = this.xSpline[0];
        ypoints[0] = this.ySpline[0];
        int n = 1;
        double inc = 0.01;
        double distance = 0.0;
        double distance2 = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double x2 = this.xSpline[0];
        double y2 = this.ySpline[0];
        for (int i = 1; i < this.splinePoints; ++i) {
            double x1 = x2;
            double y1 = y2;
            double x = x1;
            double y = y1;
            x2 = this.xSpline[i];
            y2 = this.ySpline[i];
            dx = x2 - x1;
            dy = y2 - y1;
            distance = Math.sqrt(dx * dx + dy * dy);
            double xinc = dx * inc / distance;
            double yinc = dy * inc / distance;
            double lastx = xpoints[n - 1];
            double lasty = ypoints[n - 1];
            int n2 = (int)(distance / inc);
            if (this.splinePoints == 2) {
                ++n2;
            }
            do {
                if ((distance2 = Math.sqrt((dx = x - lastx) * dx + (dy = y - lasty) * dy)) >= 1.0 - inc / 2.0 && n < xpoints.length - 1) {
                    xpoints[n] = (float)x;
                    ypoints[n] = (float)y;
                    ++n;
                    lastx = x;
                    lasty = y;
                }
                x += xinc;
                y += yinc;
            } while (--n2 > 0);
        }
        this.xSpline = xpoints;
        this.ySpline = ypoints;
        this.splinePoints = n;
    }

    public double getUncalibratedLength() {
        ImagePlus saveImp = this.imp;
        this.imp = null;
        double length = this.getLength();
        this.imp = saveImp;
        return length;
    }

    protected void handleMouseUp(int sx, int sy) {
        if (this.state == 1) {
            this.state = 3;
            return;
        }
        if (this.state == 4) {
            this.cachedMask = null;
            this.state = 3;
            this.updateClipRect();
            this.oldX = this.x;
            this.oldY = this.y;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
            return;
        }
        if (this.state != 0) {
            return;
        }
        if (IJ.spaceBarDown()) {
            return;
        }
        boolean samePoint = false;
        samePoint = this.xpf != null ? this.xpf[this.nPoints - 2] == this.xpf[this.nPoints - 1] && this.ypf[this.nPoints - 2] == this.ypf[this.nPoints - 1] : this.xp[this.nPoints - 2] == this.xp[this.nPoints - 1] && this.yp[this.nPoints - 2] == this.yp[this.nPoints - 1];
        Rectangle biggerStartBox = new Rectangle(this.ic.screenXD(this.startXD) - 5, this.ic.screenYD(this.startYD) - 5, 10, 10);
        if (this.nPoints > 2 && (biggerStartBox.contains(sx, sy) || this.ic.offScreenXD(sx) == this.startXD && this.ic.offScreenYD(sy) == this.startYD || samePoint && System.currentTimeMillis() - this.mouseUpTime <= 500L)) {
            --this.nPoints;
            this.addOffset();
            this.finishPolygon();
            return;
        }
        if (!samePoint) {
            this.mouseUpTime = System.currentTimeMillis();
            if (this.type == 8 && this.nPoints == 3) {
                this.addOffset();
                this.finishPolygon();
                return;
            }
            if (this.xpf != null) {
                this.xpf[this.nPoints] = this.xpf[this.nPoints - 1];
                this.ypf[this.nPoints] = this.ypf[this.nPoints - 1];
                ++this.nPoints;
                if (this.nPoints == this.xpf.length) {
                    this.enlargeArrays();
                }
            } else {
                this.xp[this.nPoints] = this.xp[this.nPoints - 1];
                this.yp[this.nPoints] = this.yp[this.nPoints - 1];
                ++this.nPoints;
                if (this.nPoints == this.xp.length) {
                    this.enlargeArrays();
                }
            }
        }
    }

    protected void addOffset() {
        if (this.xpf != null) {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xpf[i] = this.xpf[i] + (float)this.x;
                this.ypf[i] = this.ypf[i] + (float)this.y;
            }
        } else {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp[i] = this.xp[i] + this.x;
                this.yp[i] = this.yp[i] + this.y;
            }
        }
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        if (this.xSpline != null) {
            FloatPolygon poly = new FloatPolygon(this.xSpline, this.ySpline, this.splinePoints);
            return poly.contains(x - this.x, y - this.y);
        }
        if (this.xpf != null) {
            FloatPolygon poly = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
            return poly.contains(x - this.x, y - this.y);
        }
        Polygon poly = new Polygon(this.xp, this.yp, this.nPoints);
        return poly.contains(x - this.x, y - this.y);
    }

    public int isHandle(int sx, int sy) {
        if (this.xSpline == null && this.type != 2 && this.type != 6 && this.type != 8 && this.type != 10 || this.clipboard != null) {
            return -1;
        }
        int size = 10;
        int halfSize = size / 2;
        int handle = -1;
        for (int i = 0; i < this.nPoints; ++i) {
            int sx2 = this.xp2[i] - halfSize;
            int sy2 = this.yp2[i] - halfSize;
            if (sx < sx2 || sx > sx2 + size || sy < sy2 || sy > sy2 + size) continue;
            handle = i;
            break;
        }
        return handle;
    }

    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        PolygonFiller pf = new PolygonFiller();
        if (this.xSpline != null) {
            pf.setPolygon(PolygonRoi.toIntR(this.xSpline), PolygonRoi.toIntR(this.ySpline), this.splinePoints);
        } else if (this.xpf != null) {
            pf.setPolygon(PolygonRoi.toIntR(this.xpf), PolygonRoi.toIntR(this.ypf), this.nPoints);
        } else {
            pf.setPolygon(this.xp, this.yp, this.nPoints);
        }
        this.cachedMask = pf.getMask(this.width, this.height);
        return this.cachedMask;
    }

    double getSmoothedLineLength() {
        if (this.subPixelResolution() && this.xpf != null) {
            return this.getFloatSmoothedLineLength();
        }
        double length = 0.0;
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double dx = (double)(this.xp[0] + this.xp[1] + this.xp[2]) / 3.0 - (double)this.xp[0];
        double dy = (double)(this.yp[0] + this.yp[1] + this.yp[2]) / 3.0 - (double)this.yp[0];
        length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        for (int i = 1; i < this.nPoints - 2; ++i) {
            dx = (double)(this.xp[i + 2] - this.xp[i - 1]) / 3.0;
            dy = (double)(this.yp[i + 2] - this.yp[i - 1]) / 3.0;
            length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        }
        dx = (double)this.xp[this.nPoints - 1] - (double)(this.xp[this.nPoints - 3] + this.xp[this.nPoints - 2] + this.xp[this.nPoints - 1]) / 3.0;
        dy = (double)this.yp[this.nPoints - 1] - (double)(this.yp[this.nPoints - 3] + this.yp[this.nPoints - 2] + this.yp[this.nPoints - 1]) / 3.0;
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    double getFloatSmoothedLineLength() {
        double length = 0.0;
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double dx = (double)(this.xpf[0] + this.xpf[1] + this.xpf[2]) / 3.0 - (double)this.xpf[0];
        double dy = (double)(this.ypf[0] + this.ypf[1] + this.ypf[2]) / 3.0 - (double)this.ypf[0];
        length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        for (int i = 1; i < this.nPoints - 2; ++i) {
            dx = (double)(this.xpf[i + 2] - this.xpf[i - 1]) / 3.0;
            dy = (double)(this.ypf[i + 2] - this.ypf[i - 1]) / 3.0;
            length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        }
        dx = (double)this.xpf[this.nPoints - 1] - (double)(this.xpf[this.nPoints - 3] + this.xpf[this.nPoints - 2] + this.xpf[this.nPoints - 1]) / 3.0;
        dy = (double)this.ypf[this.nPoints - 1] - (double)(this.ypf[this.nPoints - 3] + this.ypf[this.nPoints - 2] + this.ypf[this.nPoints - 1]) / 3.0;
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    double getSmoothedPerimeter() {
        if (this.subPixelResolution() && this.xpf != null) {
            return this.getFloatSmoothedPerimeter();
        }
        double length = this.getSmoothedLineLength();
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double dx = this.xp[this.nPoints - 1] - this.xp[0];
        double dy = this.yp[this.nPoints - 1] - this.yp[0];
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    double getFloatSmoothedPerimeter() {
        double length = this.getSmoothedLineLength();
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double dx = this.xpf[this.nPoints - 1] - this.xpf[0];
        double dy = this.ypf[this.nPoints - 1] - this.ypf[0];
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    double getTracedPerimeter() {
        int sumdx = 0;
        int sumdy = 0;
        int nCorners = 0;
        int dx1 = this.xp[0] - this.xp[this.nPoints - 1];
        int dy1 = this.yp[0] - this.yp[this.nPoints - 1];
        int side1 = Math.abs(dx1) + Math.abs(dy1);
        boolean corner = false;
        for (int i = 0; i < this.nPoints; ++i) {
            int nexti = i + 1;
            if (nexti == this.nPoints) {
                nexti = 0;
            }
            int dx2 = this.xp[nexti] - this.xp[i];
            int dy2 = this.yp[nexti] - this.yp[i];
            sumdx += Math.abs(dx1);
            sumdy += Math.abs(dy1);
            int side2 = Math.abs(dx2) + Math.abs(dy2);
            if (side1 > 1 || !corner) {
                corner = true;
                ++nCorners;
            } else {
                corner = false;
            }
            dx1 = dx2;
            dy1 = dy2;
            side1 = side2;
        }
        double w = 1.0;
        double h = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w = cal.pixelWidth;
            h = cal.pixelHeight;
        }
        return (double)sumdx * w + (double)sumdy * h - (double)nCorners * (w + h - Math.sqrt(w * w + h * h));
    }

    public double getLength() {
        if (this.type == 4) {
            return this.getTracedPerimeter();
        }
        if (this.nPoints > 2) {
            if (this.type == 3) {
                return this.getSmoothedPerimeter();
            }
            if (this.type == 7 && this.width != 0 && this.height != 0) {
                return this.getSmoothedLineLength();
            }
        }
        double length = 0.0;
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        if (this.xSpline != null) {
            double fdy;
            for (int i = 0; i < this.splinePoints - 1; ++i) {
                double fdx = this.xSpline[i + 1] - this.xSpline[i];
                fdy = this.ySpline[i + 1] - this.ySpline[i];
                length += Math.sqrt(fdx * fdx * w2 + fdy * fdy * h2);
            }
            if (this.type == 2) {
                double fdx = this.xSpline[0] - this.xSpline[this.splinePoints - 1];
                fdy = this.ySpline[0] - this.ySpline[this.splinePoints - 1];
                length += Math.sqrt(fdx * fdx * w2 + fdy * fdy * h2);
            }
        } else if (this.xpf != null) {
            double fdy;
            for (int i = 0; i < this.nPoints - 1; ++i) {
                double fdx = this.xpf[i + 1] - this.xpf[i];
                fdy = this.ypf[i + 1] - this.ypf[i];
                length += Math.sqrt(fdx * fdx * w2 + fdy * fdy * h2);
            }
            if (this.type == 2) {
                double fdx = this.xpf[0] - this.xpf[this.nPoints - 1];
                fdy = this.ypf[0] - this.ypf[this.nPoints - 1];
                length += Math.sqrt(fdx * fdx * w2 + fdy * fdy * h2);
            }
        } else {
            int dy;
            int dx;
            for (int i = 0; i < this.nPoints - 1; ++i) {
                dx = this.xp[i + 1] - this.xp[i];
                dy = this.yp[i + 1] - this.yp[i];
                length += Math.sqrt((double)(dx * dx) * w2 + (double)(dy * dy) * h2);
            }
            if (this.type == 2) {
                dx = this.xp[0] - this.xp[this.nPoints - 1];
                dy = this.yp[0] - this.yp[this.nPoints - 1];
                length += Math.sqrt((double)(dx * dx) * w2 + (double)(dy * dy) * h2);
            }
        }
        return length;
    }

    public double getAngle() {
        return this.degrees;
    }

    public int getNCoordinates() {
        if (this.xSpline != null) {
            return this.splinePoints;
        }
        return this.nPoints;
    }

    public int[] getXCoordinates() {
        if (this.xSpline != null) {
            return PolygonRoi.toIntR(this.xSpline);
        }
        if (this.xpf != null) {
            return PolygonRoi.toIntR(this.xpf);
        }
        return this.xp;
    }

    public int[] getYCoordinates() {
        if (this.xSpline != null) {
            return PolygonRoi.toIntR(this.ySpline);
        }
        if (this.ypf != null) {
            return PolygonRoi.toIntR(this.ypf);
        }
        return this.yp;
    }

    public Polygon getNonSplineCoordinates() {
        if (this.xpf != null) {
            return new Polygon(PolygonRoi.toIntR(this.xpf), PolygonRoi.toIntR(this.ypf), this.nPoints);
        }
        return new Polygon(this.xp, this.yp, this.nPoints);
    }

    public FloatPolygon getNonSplineFloatCoordinates() {
        if (this.xpf != null) {
            return new FloatPolygon(this.xpf, this.ypf, this.nPoints).duplicate();
        }
        return new FloatPolygon(PolygonRoi.toFloat(this.xp), PolygonRoi.toFloat(this.yp), this.nPoints);
    }

    public Polygon getPolygon() {
        int[] ypoints1;
        int[] xpoints1;
        int n;
        if (this.xSpline != null) {
            n = this.splinePoints;
            xpoints1 = PolygonRoi.toInt(this.xSpline);
            ypoints1 = PolygonRoi.toInt(this.ySpline);
        } else if (this.xpf != null) {
            n = this.nPoints;
            xpoints1 = PolygonRoi.toIntR(this.xpf);
            ypoints1 = PolygonRoi.toIntR(this.ypf);
        } else {
            n = this.nPoints;
            xpoints1 = this.xp;
            ypoints1 = this.yp;
        }
        int[] xpoints2 = new int[n];
        int[] ypoints2 = new int[n];
        for (int i = 0; i < n; ++i) {
            xpoints2[i] = xpoints1[i] + this.x;
            ypoints2[i] = ypoints1[i] + this.y;
        }
        return new Polygon(xpoints2, ypoints2, n);
    }

    public FloatPolygon getFloatPolygon() {
        int n = this.xSpline != null ? this.splinePoints : this.nPoints;
        float[] xpoints2 = new float[n];
        float[] ypoints2 = new float[n];
        if (this.xSpline != null) {
            for (int i = 0; i < n; ++i) {
                xpoints2[i] = this.xSpline[i] + (float)this.x;
                ypoints2[i] = this.ySpline[i] + (float)this.y;
            }
        } else if (this.xpf != null) {
            for (int i = 0; i < n; ++i) {
                float xbase = this.x;
                float ybase = this.y;
                if (this.bounds != null) {
                    xbase = (float)this.bounds.x;
                    ybase = (float)this.bounds.y;
                }
                xpoints2[i] = this.xpf[i] + xbase;
                ypoints2[i] = this.ypf[i] + ybase;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                xpoints2[i] = this.xp[i] + this.x;
                ypoints2[i] = this.yp[i] + this.y;
            }
        }
        return new FloatPolygon(xpoints2, ypoints2, n);
    }

    public boolean subPixelResolution() {
        return this.subPixel;
    }

    public Polygon getConvexHull() {
        int p2;
        int y;
        int n = this.getNCoordinates();
        int[] xCoordinates = this.getXCoordinates();
        int[] yCoordinates = this.getYCoordinates();
        Rectangle r = this.getBounds();
        int xbase = r.x;
        int ybase = r.y;
        int[] xx = new int[n];
        int[] yy = new int[n];
        int n2 = 0;
        int smallestY = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            y = yCoordinates[i];
            if (y >= smallestY) continue;
            smallestY = y;
        }
        int smallestX = Integer.MAX_VALUE;
        int p1 = 0;
        for (int i = 0; i < n; ++i) {
            int x = xCoordinates[i];
            y = yCoordinates[i];
            if (y != smallestY || x >= smallestX) continue;
            smallestX = x;
            p1 = i;
        }
        int pstart = p1;
        int count = 0;
        do {
            int x1 = xCoordinates[p1];
            int y1 = yCoordinates[p1];
            p2 = p1 + 1;
            if (p2 == n) {
                p2 = 0;
            }
            int x2 = xCoordinates[p2];
            int y2 = yCoordinates[p2];
            int p3 = p2 + 1;
            if (p3 == n) {
                p3 = 0;
            }
            do {
                int x3;
                int y3;
                int determinate;
                if ((determinate = x1 * (y2 - (y3 = yCoordinates[p3])) - y1 * (x2 - (x3 = xCoordinates[p3])) + (y3 * x2 - y2 * x3)) > 0) {
                    x2 = x3;
                    y2 = y3;
                    p2 = p3;
                }
                if (++p3 != n) continue;
                p3 = 0;
            } while (p3 != p1);
            if (n2 < n) {
                xx[n2] = xbase + x1;
                yy[n2] = ybase + y1;
                ++n2;
                continue;
            }
            if (++count <= 10) continue;
            return null;
        } while ((p1 = p2) != pstart);
        return new Polygon(xx, yy, n2);
    }

    public FloatPolygon getInterpolatedPolygon(double interval, boolean smooth) {
        FloatPolygon p = this.getFloatPolygon();
        if (smooth && (this.type == 4 || this.type == 3 || this.type == 7)) {
            for (int i = 1; i < p.npoints - 2; ++i) {
                p.xpoints[i] = (p.xpoints[i - 1] + p.xpoints[i] + p.xpoints[i + 1]) / 3.0f;
                p.ypoints[i] = (p.ypoints[i - 1] + p.ypoints[i] + p.ypoints[i + 1]) / 3.0f;
            }
            if (this.type != 7) {
                p.xpoints[0] = (p.xpoints[p.npoints - 1] + p.xpoints[0] + p.xpoints[1]) / 3.0f;
                p.ypoints[0] = (p.ypoints[p.npoints - 1] + p.ypoints[0] + p.ypoints[1]) / 3.0f;
                p.xpoints[p.npoints - 1] = (p.xpoints[p.npoints - 2] + p.xpoints[p.npoints - 1] + p.xpoints[0]) / 3.0f;
                p.ypoints[p.npoints - 1] = (p.ypoints[p.npoints - 2] + p.ypoints[p.npoints - 1] + p.ypoints[0]) / 3.0f;
            }
        }
        return super.getInterpolatedPolygon(p, interval, smooth);
    }

    protected int clipRectMargin() {
        return this.type == 10 ? 4 : 0;
    }

    public synchronized Object clone() {
        int i;
        PolygonRoi r = (PolygonRoi)super.clone();
        if (this.xpf != null) {
            r.xpf = new float[this.maxPoints];
            r.ypf = new float[this.maxPoints];
        } else {
            r.xp = new int[this.maxPoints];
            r.yp = new int[this.maxPoints];
        }
        r.xp2 = new int[this.maxPoints];
        r.yp2 = new int[this.maxPoints];
        for (i = 0; i < this.nPoints; ++i) {
            if (this.xpf != null) {
                r.xpf[i] = this.xpf[i];
                r.ypf[i] = this.ypf[i];
            } else {
                r.xp[i] = this.xp[i];
                r.yp[i] = this.yp[i];
            }
            r.xp2[i] = this.xp2[i];
            r.yp2[i] = this.yp2[i];
        }
        if (this.xSpline != null) {
            r.xSpline = new float[this.splinePoints];
            r.ySpline = new float[this.splinePoints];
            r.splinePoints = this.splinePoints;
            for (i = 0; i < this.splinePoints; ++i) {
                r.xSpline[i] = this.xSpline[i];
                r.ySpline[i] = this.ySpline[i];
            }
        }
        return r;
    }

    void enlargeArrays() {
        if (this.xp != null) {
            int[] xptemp = new int[this.maxPoints * 2];
            int[] yptemp = new int[this.maxPoints * 2];
            System.arraycopy(this.xp, 0, xptemp, 0, this.maxPoints);
            System.arraycopy(this.yp, 0, yptemp, 0, this.maxPoints);
            this.xp = xptemp;
            this.yp = yptemp;
        }
        if (this.xpf != null) {
            float[] xpftemp = new float[this.maxPoints * 2];
            float[] ypftemp = new float[this.maxPoints * 2];
            System.arraycopy(this.xpf, 0, xpftemp, 0, this.maxPoints);
            System.arraycopy(this.ypf, 0, ypftemp, 0, this.maxPoints);
            this.xpf = xpftemp;
            this.ypf = ypftemp;
        }
        int[] xp2temp = new int[this.maxPoints * 2];
        int[] yp2temp = new int[this.maxPoints * 2];
        System.arraycopy(this.xp2, 0, xp2temp, 0, this.maxPoints);
        System.arraycopy(this.yp2, 0, yp2temp, 0, this.maxPoints);
        this.xp2 = xp2temp;
        this.yp2 = yp2temp;
        if (IJ.debugMode) {
            IJ.log("PolygonRoi: " + this.maxPoints + " points");
        }
        this.maxPoints *= 2;
    }

    private double getOffset(double value) {
        return this.getDrawOffset() && this.getMagnification() > 1.0 && (this.type == 6 || this.type == 7) ? value : 0.0;
    }

    public boolean getDrawOffset() {
        return this.drawOffset;
    }

    public void setDrawOffset(boolean drawOffset) {
        this.drawOffset = drawOffset && this.subPixelResolution();
    }
}

