/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.ChannelSplitter;
import ij.plugin.Concatenator;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class Projector
implements PlugIn {
    private static final int xAxis = 0;
    private static final int yAxis = 1;
    private static final int zAxis = 2;
    private static final int nearestPoint = 0;
    private static final int brightestPoint = 1;
    private static final int meanValue = 2;
    private static final int BIGPOWEROF2 = 8192;
    private static final String[] axisList = new String[]{"X-Axis", "Y-Axis", "Z-Axis"};
    private static final String[] methodList = new String[]{"Nearest Point", "Brightest Point", "Mean Value"};
    private static int axisOfRotationS = 1;
    private static int projectionMethodS = 1;
    private static int initAngleS = 0;
    private static int totalAngleS = 360;
    private static int angleIncS = 10;
    private static int opacityS = 0;
    private static int depthCueSurfS = 0;
    private static int depthCueIntS = 50;
    private static boolean interpolateS;
    private static boolean allTimePointsS;
    private int axisOfRotation = axisOfRotationS;
    private int projectionMethod = projectionMethodS;
    private int initAngle = initAngleS;
    private int totalAngle = totalAngleS;
    private int angleInc = angleIncS;
    private int opacity = opacityS;
    private int depthCueSurf = depthCueSurfS;
    private int depthCueInt = depthCueIntS;
    private boolean interpolate = interpolateS;
    private boolean allTimePoints = allTimePointsS;
    private boolean debugMode;
    private double sliceInterval = 1.0;
    private int transparencyLower = 1;
    private int transparencyUpper = 255;
    private ImagePlus imp;
    private ImageStack stack;
    private ImageStack stack2;
    private int width;
    private int height;
    private int imageWidth;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private byte[] projArray;
    private byte[] opaArray;
    private byte[] brightCueArray;
    private short[] zBuffer;
    private short[] cueZBuffer;
    private short[] countBuffer;
    private int[] sumBuffer;
    private boolean isRGB;
    private String label = "";
    private boolean done;
    private boolean batchMode = Interpreter.isBatchMode();
    private double progressBase = 0.0;
    private double progressScale = 1.0;
    private boolean showMicroProgress = true;

    public void run(String arg) {
        ImageProcessor ip;
        this.imp = IJ.getImage();
        if (this.imp.getBitDepth() == 16 || this.imp.getBitDepth() == 32) {
            if (!IJ.isMacro() && !IJ.showMessageWithCancel("3D Project", "Convert this stack to 8-bits?")) {
                return;
            }
            IJ.run(this.imp, "8-bit", "");
        }
        if ((ip = this.imp.getProcessor()).isInvertedLut() && !IJ.isMacro() && !IJ.showMessageWithCancel("3D Project", "Stacks with inverter LUTs may not project correctly.\nTo create a standard LUT, invert the stack (Edit/Invert)\nand invert the LUT (Image/Lookup Tables/Invert LUT).")) {
            return;
        }
        if (!this.showDialog()) {
            return;
        }
        this.imp.startTiming();
        boolean bl = this.isRGB = this.imp.getType() == 4;
        if (this.imp.isHyperStack()) {
            if (this.imp.getNSlices() > 1) {
                this.doHyperstackProjections(this.imp);
            } else {
                IJ.error("Hyperstack Z dimension must be greater than 1");
            }
            return;
        }
        if (this.interpolate && this.sliceInterval > 1.0) {
            this.imp = this.zScale(this.imp, true);
            if (this.imp == null) {
                return;
            }
            this.sliceInterval = 1.0;
        }
        if (this.isRGB) {
            this.doRGBProjections(this.imp);
        } else {
            ImagePlus imp2 = this.doProjections(this.imp);
            if (imp2 != null) {
                imp2.show();
            }
        }
    }

    private boolean showDialog() {
        ImageProcessor ip = this.imp.getProcessor();
        double lower = ip.getMinThreshold();
        if (lower != -808080.0) {
            this.transparencyLower = (int)lower;
            this.transparencyUpper = (int)ip.getMaxThreshold();
        }
        Calibration cal = this.imp.getCalibration();
        boolean hyperstack = this.imp.isHyperStack() && this.imp.getNFrames() > 1;
        GenericDialog gd = new GenericDialog("3D Projection");
        gd.addChoice("Projection method:", methodList, methodList[this.projectionMethod]);
        gd.addChoice("Axis of rotation:", axisList, axisList[this.axisOfRotation]);
        gd.addNumericField("Slice spacing (" + cal.getUnits() + "):", cal.pixelDepth, 2);
        gd.addNumericField("Initial angle (0-359 degrees):", this.initAngle, 0);
        gd.addNumericField("Total rotation (0-359 degrees):", this.totalAngle, 0);
        gd.addNumericField("Rotation angle increment:", this.angleInc, 0);
        gd.addNumericField("Lower transparency bound:", this.transparencyLower, 0);
        gd.addNumericField("Upper transparency bound:", this.transparencyUpper, 0);
        gd.addNumericField("Opacity (0-100%):", this.opacity, 0);
        gd.addNumericField("Surface depth-cueing (0-100%):", 100 - this.depthCueSurf, 0);
        gd.addNumericField("Interior depth-cueing (0-100%):", 100 - this.depthCueInt, 0);
        gd.addCheckbox("Interpolate", this.interpolate);
        if (hyperstack) {
            gd.addCheckbox("All time points", this.allTimePoints);
        }
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/image.html#project");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.projectionMethod = gd.getNextChoiceIndex();
        this.axisOfRotation = gd.getNextChoiceIndex();
        cal.pixelDepth = gd.getNextNumber();
        if (cal.pixelWidth == 0.0) {
            cal.pixelWidth = 1.0;
        }
        this.sliceInterval = cal.pixelDepth / cal.pixelWidth;
        this.initAngle = (int)gd.getNextNumber();
        this.totalAngle = (int)gd.getNextNumber();
        this.angleInc = (int)gd.getNextNumber();
        this.transparencyLower = (int)gd.getNextNumber();
        this.transparencyUpper = (int)gd.getNextNumber();
        this.opacity = (int)gd.getNextNumber();
        this.depthCueSurf = 100 - (int)gd.getNextNumber();
        this.depthCueInt = 100 - (int)gd.getNextNumber();
        this.interpolate = gd.getNextBoolean();
        if (hyperstack) {
            this.allTimePoints = gd.getNextBoolean();
        }
        axisOfRotationS = this.axisOfRotation;
        projectionMethodS = this.projectionMethod;
        initAngleS = this.initAngle;
        totalAngleS = this.totalAngle;
        angleIncS = this.angleInc;
        opacityS = this.opacity;
        depthCueSurfS = this.depthCueSurf;
        depthCueIntS = this.depthCueInt;
        interpolateS = this.interpolate;
        allTimePointsS = this.allTimePoints;
        return true;
    }

    private void doHyperstackProjections(ImagePlus imp) {
        double originalSliceInterval = this.sliceInterval;
        ImagePlus buildImp = null;
        ImagePlus projImpD = null;
        int finalChannels = imp.getNChannels();
        int finalSlices = imp.getNSlices();
        int finalFrames = imp.getNFrames();
        int f1 = 0;
        int f2 = imp.getNFrames() - 1;
        if (imp.getBitDepth() == 24) {
            this.allTimePoints = false;
        }
        if (!this.allTimePoints) {
            f1 = f2 = imp.getFrame();
        }
        int channels = imp.getNChannels();
        this.progressScale = 1.0 / (double)channels;
        if (this.allTimePoints) {
            this.showMicroProgress = false;
        }
        int count = 1;
        for (int c = 0; c < channels; ++c) {
            for (int f = f1; f <= f2; ++f) {
                if (this.allTimePoints) {
                    IJ.showProgress(count++, channels * imp.getNFrames());
                }
                this.sliceInterval = originalSliceInterval;
                ImagePlus impD = new Duplicator().run(imp, c + 1, c + 1, 1, imp.getNSlices(), f + 1, f + 1);
                impD.setCalibration(imp.getCalibration());
                if (this.interpolate && this.sliceInterval > 1.0) {
                    if ((impD = this.zScale(impD, false)) == null) {
                        return;
                    }
                    this.sliceInterval = 1.0;
                }
                if (this.isRGB) {
                    this.doRGBProjections(impD);
                } else {
                    this.progressBase = (double)c / (double)channels;
                    projImpD = this.doProjections(impD);
                    if (projImpD == null) {
                        return;
                    }
                    finalSlices = projImpD.getNSlices();
                    impD.close();
                    if (!(f != 0 && this.allTimePoints || c != 0)) {
                        buildImp = projImpD;
                        buildImp.setTitle("BuildStack");
                    } else {
                        Concatenator concat = new Concatenator();
                        buildImp = concat.concatenate(buildImp, projImpD, false);
                    }
                }
                if (!this.done) continue;
                return;
            }
        }
        if (imp.getNFrames() == 1 || !this.allTimePoints) {
            finalFrames = finalSlices;
            finalSlices = 1;
        }
        if (imp.getNChannels() > 1) {
            IJ.run(buildImp, "Stack to Hyperstack...", "order=xyztc channels=" + finalChannels + " slices=" + finalSlices + " frames=" + finalFrames + " display=Composite");
        }
        buildImp = WindowManager.getCurrentImage();
        if (imp.isComposite()) {
            CompositeImage buildImp2 = new CompositeImage(buildImp, 0);
            buildImp2.copyLuts(imp);
            buildImp = buildImp2;
        }
        buildImp.setTitle("Projections of " + imp.getShortTitle());
        buildImp.show();
        if (WindowManager.getImage("Concatenated Stacks") != null) {
            WindowManager.getImage("Concatenated Stacks").hide();
        }
    }

    private void doRGBProjections(ImagePlus imp) {
        boolean saveUseInvertingLut = Prefs.useInvertingLut;
        Prefs.useInvertingLut = false;
        ImageStack[] channels = ChannelSplitter.splitRGB(imp.getStack(), true);
        ImagePlus red = new ImagePlus("Red", channels[0]);
        ImagePlus green = new ImagePlus("Green", channels[1]);
        ImagePlus blue = new ImagePlus("Blue", channels[2]);
        Calibration cal = imp.getCalibration();
        Roi roi = imp.getRoi();
        if (roi != null) {
            red.setRoi(roi);
            green.setRoi(roi);
            blue.setRoi(roi);
        }
        red.setCalibration(cal);
        green.setCalibration(cal);
        blue.setCalibration(cal);
        this.label = "Red: ";
        this.progressBase = 0.0;
        this.progressScale = 0.3333333333333333;
        red = this.doProjections(red);
        if (red == null || this.done) {
            return;
        }
        this.label = "Green: ";
        this.progressBase = 0.3333333333333333;
        if ((green = this.doProjections(green)) == null || this.done) {
            return;
        }
        this.label = "Blue: ";
        this.progressBase = 0.6666666666666666;
        if ((blue = this.doProjections(blue)) == null || this.done) {
            return;
        }
        int w = red.getWidth();
        int h = red.getHeight();
        int d = red.getStackSize();
        RGBStackMerge merge = new RGBStackMerge();
        ImageStack stack = merge.mergeStacks(w, h, d, red.getStack(), green.getStack(), blue.getStack(), true);
        new ImagePlus("Projection of  " + imp.getShortTitle(), stack).show();
        Prefs.useInvertingLut = saveUseInvertingLut;
    }

    private ImagePlus doProjections(ImagePlus imp) {
        int i;
        int angle;
        boolean negInc;
        boolean minProjSize = true;
        this.stack = imp.getStack();
        if (this.angleInc == 0 && this.totalAngle != 0) {
            this.angleInc = 5;
        }
        boolean bl = negInc = this.angleInc < 0;
        if (negInc) {
            this.angleInc = -this.angleInc;
        }
        int nProjections = 0;
        if (this.angleInc == 0) {
            nProjections = 1;
        } else {
            for (angle = 0; angle <= this.totalAngle; angle += this.angleInc) {
                ++nProjections;
            }
        }
        if (angle > 360) {
            --nProjections;
        }
        if (nProjections <= 0) {
            nProjections = 1;
        }
        if (negInc) {
            this.angleInc = -this.angleInc;
        }
        ImageProcessor ip = imp.getProcessor();
        Rectangle r = ip.getRoi();
        this.left = r.x;
        this.top = r.y;
        this.right = r.x + r.width;
        this.bottom = r.y + r.height;
        int nSlices = imp.getStackSize();
        this.imageWidth = imp.getWidth();
        this.width = this.right - this.left;
        this.height = this.bottom - this.top;
        int xcenter = (this.left + this.right) / 2;
        int ycenter = (this.top + this.bottom) / 2;
        int zcenter = (int)((double)nSlices * this.sliceInterval / 2.0 + 0.5);
        int projwidth = 0;
        int projheight = 0;
        if (minProjSize && this.axisOfRotation != 2) {
            switch (this.axisOfRotation) {
                case 0: {
                    projheight = (int)(Math.sqrt((double)nSlices * this.sliceInterval * (double)nSlices * this.sliceInterval + (double)(this.height * this.height)) + 0.5);
                    projwidth = this.width;
                    break;
                }
                case 1: {
                    projwidth = (int)(Math.sqrt((double)nSlices * this.sliceInterval * (double)nSlices * this.sliceInterval + (double)(this.width * this.width)) + 0.5);
                    projheight = this.height;
                }
            }
        } else {
            projwidth = (int)(Math.sqrt((double)nSlices * this.sliceInterval * (double)nSlices * this.sliceInterval + (double)(this.width * this.width)) + 0.5);
            projheight = (int)(Math.sqrt((double)nSlices * this.sliceInterval * (double)nSlices * this.sliceInterval + (double)(this.height * this.height)) + 0.5);
        }
        if (projwidth % 2 == 1) {
            ++projwidth;
        }
        int projsize = projwidth * projheight;
        if (projwidth <= 0 || projheight <= 0) {
            IJ.error("'projwidth' or 'projheight' <= 0");
            return null;
        }
        try {
            this.allocateArrays(nProjections, projwidth, projheight);
        }
        catch (OutOfMemoryError e) {
            Object[] images = this.stack2.getImageArray();
            if (images != null) {
                for (int i2 = 0; i2 < images.length; ++i2) {
                    images[i2] = null;
                }
            }
            this.stack2 = null;
            IJ.error("Projector - Out of Memory", "To use less memory, use a rectanguar\nselection,  reduce \"Total Rotation\",\nand/or increase \"Angle Increment\".");
            return null;
        }
        ImagePlus projections = new ImagePlus("Projections of " + imp.getShortTitle(), this.stack2);
        projections.setCalibration(imp.getCalibration());
        IJ.resetEscape();
        int theta = this.initAngle;
        IJ.resetEscape();
        for (int n = 0; n < nProjections; ++n) {
            int i3;
            IJ.showStatus(n + "/" + nProjections);
            this.showProgress((double)n / (double)nProjections);
            double thetarad = (double)theta * Math.PI / 180.0;
            int costheta = (int)(8192.0 * Math.cos(thetarad) + 0.5);
            int sintheta = (int)(8192.0 * Math.sin(thetarad) + 0.5);
            this.projArray = (byte[])this.stack2.getPixels(n + 1);
            if (this.projArray == null) break;
            if (this.projectionMethod == 0 || this.opacity > 0) {
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.zBuffer[i3] = Short.MAX_VALUE;
                }
            }
            if (this.opacity > 0 && this.projectionMethod != 0) {
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.opaArray[i3] = 0;
                }
            }
            if (this.projectionMethod == 1 && this.depthCueInt < 100) {
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.brightCueArray[i3] = 0;
                }
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.cueZBuffer[i3] = 0;
                }
            }
            if (this.projectionMethod == 2) {
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.sumBuffer[i3] = 0;
                }
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.countBuffer[i3] = 0;
                }
            }
            switch (this.axisOfRotation) {
                case 0: {
                    this.doOneProjectionX(nSlices, ycenter, zcenter, projwidth, projheight, costheta, sintheta);
                    break;
                }
                case 1: {
                    this.doOneProjectionY(nSlices, xcenter, zcenter, projwidth, projheight, costheta, sintheta);
                    break;
                }
                case 2: {
                    this.doOneProjectionZ(nSlices, xcenter, ycenter, zcenter, projwidth, projheight, costheta, sintheta);
                }
            }
            if (this.projectionMethod == 2) {
                for (i = 0; i < projsize; ++i) {
                    short count = this.countBuffer[i];
                    if (count == 0) continue;
                    this.projArray[i] = (byte)(this.sumBuffer[i] / count);
                }
            }
            if (this.opacity > 0 && this.projectionMethod != 0) {
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.projArray[i3] = (byte)((this.opacity * (this.opaArray[i3] & 0xFF) + (100 - this.opacity) * (this.projArray[i3] & 0xFF)) / 100);
                }
            }
            if (this.axisOfRotation == 2) {
                for (i3 = projwidth; i3 < projsize - projwidth; ++i3) {
                    int curval = this.projArray[i3] & 0xFF;
                    int prevval = this.projArray[i3 - 1] & 0xFF;
                    int nextval = this.projArray[i3 + 1] & 0xFF;
                    int aboveval = this.projArray[i3 - projwidth] & 0xFF;
                    int belowval = this.projArray[i3 + projwidth] & 0xFF;
                    if (curval != 0 || prevval == 0 || nextval == 0 || aboveval == 0 || belowval == 0) continue;
                    this.projArray[i3] = (byte)((prevval + nextval + aboveval + belowval) / 4);
                }
            }
            theta = (theta + this.angleInc) % 360;
            if (IJ.escapePressed()) {
                this.done = true;
                IJ.beep();
                IJ.showProgress(1.0);
                IJ.showStatus("aborted");
                break;
            }
            projections.setSlice(n + 1);
        }
        this.showProgress(1.0);
        if (this.debugMode) {
            if (this.projArray != null) {
                new ImagePlus("projArray", new ByteProcessor(projwidth, projheight, this.projArray, null)).show();
            }
            if (this.opaArray != null) {
                new ImagePlus("opaArray", new ByteProcessor(projwidth, projheight, this.opaArray, null)).show();
            }
            if (this.brightCueArray != null) {
                new ImagePlus("brightCueArray", new ByteProcessor(projwidth, projheight, this.brightCueArray, null)).show();
            }
            if (this.zBuffer != null) {
                new ImagePlus("zBuffer", new ShortProcessor(projwidth, projheight, this.zBuffer, null)).show();
            }
            if (this.cueZBuffer != null) {
                new ImagePlus("cueZBuffer", new ShortProcessor(projwidth, projheight, this.cueZBuffer, null)).show();
            }
            if (this.countBuffer != null) {
                new ImagePlus("countBuffer", new ShortProcessor(projwidth, projheight, this.countBuffer, null)).show();
            }
            if (this.sumBuffer != null) {
                float[] tmp = new float[projwidth * projheight];
                for (i = 0; i < projwidth * projheight; ++i) {
                    tmp[i] = this.sumBuffer[i];
                }
                new ImagePlus("sumBuffer", new FloatProcessor(projwidth, projheight, tmp, null)).show();
            }
        }
        return projections;
    }

    private void allocateArrays(int nProjections, int projwidth, int projheight) {
        int projsize = projwidth * projheight;
        ColorModel cm = this.imp.getProcessor().getColorModel();
        if (this.isRGB) {
            cm = null;
        }
        this.stack2 = new ImageStack(projwidth, projheight, cm);
        this.projArray = new byte[projsize];
        for (int i = 0; i < nProjections; ++i) {
            this.stack2.addSlice(null, new byte[projsize]);
        }
        if (this.projectionMethod == 0 || this.opacity > 0) {
            this.zBuffer = new short[projsize];
        }
        if (this.opacity > 0 && this.projectionMethod != 0) {
            this.opaArray = new byte[projsize];
        }
        if (this.projectionMethod == 1 && this.depthCueInt < 100) {
            this.brightCueArray = new byte[projsize];
            this.cueZBuffer = new short[projsize];
        }
        if (this.projectionMethod == 2) {
            this.sumBuffer = new int[projsize];
            this.countBuffer = new short[projsize];
        }
    }

    private void doOneProjectionX(int nSlices, int ycenter, int zcenter, int projwidth, int projheight, int costheta, int sintheta) {
        int projsize = projwidth * projheight;
        int zmax = zcenter + projheight / 2;
        int zmin = zcenter - projheight / 2;
        int zmaxminuszmintimes100 = 100 * (zmax - zmin);
        int c100minusDepthCueInt = 100 - this.depthCueInt;
        int c100minusDepthCueSurf = 100 - this.depthCueSurf;
        boolean DepthCueIntLessThan100 = this.depthCueInt < 100;
        boolean DepthCueSurfLessThan100 = this.depthCueSurf < 100;
        boolean OpacityOrNearestPt = this.projectionMethod == 0 || this.opacity > 0;
        boolean OpacityAndNotNearestPt = this.opacity > 0 && this.projectionMethod != 0;
        boolean MeanVal = this.projectionMethod == 2;
        boolean BrightestPt = this.projectionMethod == 1;
        int ycosthetainit = (this.top - ycenter - 1) * costheta;
        int ysinthetainit = (this.top - ycenter - 1) * sintheta;
        int offsetinit = (projheight - this.bottom + this.top) / 2 * projwidth + (projwidth - this.right + this.left) / 2 - 1;
        for (int k = 1; k <= nSlices; ++k) {
            byte[] pixels = (byte[])this.stack.getPixels(k);
            int z = (int)((double)(k - 1) * this.sliceInterval + 0.5) - zcenter;
            int zcostheta = z * costheta;
            int zsintheta = z * sintheta;
            int ycostheta = ycosthetainit;
            int ysintheta = ysinthetainit;
            for (int j = this.top; j < this.bottom; ++j) {
                int ynew = ((ycostheta += costheta) - zsintheta) / 8192 + ycenter - this.top;
                int znew = ((ysintheta += sintheta) + zcostheta) / 8192 + zcenter;
                int offset = offsetinit + ynew * projwidth;
                int lineIndex = j * this.imageWidth;
                for (int i = this.left; i < this.right; ++i) {
                    int thispixel = pixels[lineIndex + i] & 0xFF;
                    if (++offset >= projsize || offset < 0) {
                        offset = 0;
                    }
                    if (thispixel > this.transparencyUpper || thispixel < this.transparencyLower) continue;
                    if (OpacityOrNearestPt && znew < this.zBuffer[offset]) {
                        this.zBuffer[offset] = (short)znew;
                        if (OpacityAndNotNearestPt) {
                            this.opaArray[offset] = DepthCueSurfLessThan100 ? (byte)(this.depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                        } else {
                            this.projArray[offset] = DepthCueSurfLessThan100 ? (byte)(this.depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                        }
                    }
                    if (MeanVal) {
                        int n = offset;
                        this.sumBuffer[n] = this.sumBuffer[n] + thispixel;
                        int n2 = offset;
                        this.countBuffer[n2] = (short)(this.countBuffer[n2] + 1);
                        continue;
                    }
                    if (!BrightestPt) continue;
                    if (DepthCueIntLessThan100) {
                        if (thispixel <= (this.brightCueArray[offset] & 0xFF) && (thispixel != (this.brightCueArray[offset] & 0xFF) || znew <= this.cueZBuffer[offset])) continue;
                        this.brightCueArray[offset] = (byte)thispixel;
                        this.cueZBuffer[offset] = (short)znew;
                        this.projArray[offset] = (byte)(this.depthCueInt * thispixel / 100 + c100minusDepthCueInt * thispixel * (zmax - znew) / zmaxminuszmintimes100);
                        continue;
                    }
                    if (thispixel <= (this.projArray[offset] & 0xFF)) continue;
                    this.projArray[offset] = (byte)thispixel;
                }
            }
        }
    }

    private void doOneProjectionY(int nSlices, int xcenter, int zcenter, int projwidth, int projheight, int costheta, int sintheta) {
        int projsize = projwidth * projheight;
        int zmax = zcenter + projwidth / 2;
        int zmin = zcenter - projwidth / 2;
        int zmaxminuszmintimes100 = 100 * (zmax - zmin);
        int c100minusDepthCueInt = 100 - this.depthCueInt;
        int c100minusDepthCueSurf = 100 - this.depthCueSurf;
        boolean DepthCueIntLessThan100 = this.depthCueInt < 100;
        boolean DepthCueSurfLessThan100 = this.depthCueSurf < 100;
        boolean OpacityOrNearestPt = this.projectionMethod == 0 || this.opacity > 0;
        boolean OpacityAndNotNearestPt = this.opacity > 0 && this.projectionMethod != 0;
        boolean MeanVal = this.projectionMethod == 2;
        boolean BrightestPt = this.projectionMethod == 1;
        int xcosthetainit = (this.left - xcenter - 1) * costheta;
        int xsinthetainit = (this.left - xcenter - 1) * sintheta;
        for (int k = 1; k <= nSlices; ++k) {
            byte[] pixels = (byte[])this.stack.getPixels(k);
            int z = (int)((double)(k - 1) * this.sliceInterval + 0.5) - zcenter;
            int zcostheta = z * costheta;
            int zsintheta = z * sintheta;
            int offsetinit = (projheight - this.bottom + this.top) / 2 * projwidth + (projwidth - this.right + this.left) / 2 - projwidth;
            for (int j = this.top; j < this.bottom; ++j) {
                int xcostheta = xcosthetainit;
                int xsintheta = xsinthetainit;
                offsetinit += projwidth;
                int lineOffset = j * this.imageWidth;
                for (int i = this.left; i < this.right; ++i) {
                    int thispixel = pixels[lineOffset + i] & 0xFF;
                    xcostheta += costheta;
                    xsintheta += sintheta;
                    if (thispixel > this.transparencyUpper || thispixel < this.transparencyLower) continue;
                    int xnew = (xcostheta + zsintheta) / 8192 + xcenter - this.left;
                    int znew = (zcostheta - xsintheta) / 8192 + zcenter;
                    int offset = offsetinit + xnew;
                    if (offset >= projsize || offset < 0) {
                        offset = 0;
                    }
                    if (OpacityOrNearestPt && znew < this.zBuffer[offset]) {
                        this.zBuffer[offset] = (short)znew;
                        if (OpacityAndNotNearestPt) {
                            this.opaArray[offset] = DepthCueSurfLessThan100 ? (byte)(this.depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                        } else {
                            this.projArray[offset] = DepthCueSurfLessThan100 ? (byte)(this.depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                        }
                    }
                    if (MeanVal) {
                        int n = offset;
                        this.sumBuffer[n] = this.sumBuffer[n] + thispixel;
                        int n2 = offset;
                        this.countBuffer[n2] = (short)(this.countBuffer[n2] + 1);
                        continue;
                    }
                    if (!BrightestPt) continue;
                    if (DepthCueIntLessThan100) {
                        if (thispixel <= (this.brightCueArray[offset] & 0xFF) && (thispixel != (this.brightCueArray[offset] & 0xFF) || znew <= this.cueZBuffer[offset])) continue;
                        this.brightCueArray[offset] = (byte)thispixel;
                        this.cueZBuffer[offset] = (short)znew;
                        this.projArray[offset] = (byte)(this.depthCueInt * thispixel / 100 + c100minusDepthCueInt * thispixel * (zmax - znew) / zmaxminuszmintimes100);
                        continue;
                    }
                    if (thispixel <= (this.projArray[offset] & 0xFF)) continue;
                    this.projArray[offset] = (byte)thispixel;
                }
            }
        }
    }

    private void doOneProjectionZ(int nSlices, int xcenter, int ycenter, int zcenter, int projwidth, int projheight, int costheta, int sintheta) {
        int projsize = projwidth * projheight;
        int zmax = (int)((double)(nSlices - 1) * this.sliceInterval + 0.5) - zcenter;
        int zmin = -zcenter;
        int zmaxminuszmintimes100 = 100 * (zmax - zmin);
        int c100minusDepthCueInt = 100 - this.depthCueInt;
        int c100minusDepthCueSurf = 100 - this.depthCueSurf;
        boolean DepthCueIntLessThan100 = this.depthCueInt < 100;
        boolean DepthCueSurfLessThan100 = this.depthCueSurf < 100;
        boolean OpacityOrNearestPt = this.projectionMethod == 0 || this.opacity > 0;
        boolean OpacityAndNotNearestPt = this.opacity > 0 && this.projectionMethod != 0;
        boolean MeanVal = this.projectionMethod == 2;
        boolean BrightestPt = this.projectionMethod == 1;
        int xcosthetainit = (this.left - xcenter - 1) * costheta;
        int xsinthetainit = (this.left - xcenter - 1) * sintheta;
        int ycosthetainit = (this.top - ycenter - 1) * costheta;
        int ysinthetainit = (this.top - ycenter - 1) * sintheta;
        int offsetinit = (projheight - this.bottom + this.top) / 2 * projwidth + (projwidth - this.right + this.left) / 2 - 1;
        for (int k = 1; k <= nSlices; ++k) {
            byte[] pixels = (byte[])this.stack.getPixels(k);
            int z = (int)((double)(k - 1) * this.sliceInterval + 0.5) - zcenter;
            int ycostheta = ycosthetainit;
            int ysintheta = ysinthetainit;
            for (int j = this.top; j < this.bottom; ++j) {
                ycostheta += costheta;
                ysintheta += sintheta;
                int xcostheta = xcosthetainit;
                int xsintheta = xsinthetainit;
                int lineIndex = j * this.imageWidth;
                for (int i = this.left; i < this.right; ++i) {
                    int thispixel = pixels[lineIndex + i] & 0xFF;
                    xcostheta += costheta;
                    xsintheta += sintheta;
                    if (thispixel > this.transparencyUpper || thispixel < this.transparencyLower) continue;
                    int ynew = (xsintheta + ycostheta) / 8192 + ycenter - this.top;
                    int xnew = (xcostheta - ysintheta) / 8192 + xcenter - this.left;
                    int offset = offsetinit + ynew * projwidth + xnew;
                    if (offset >= projsize || offset < 0) {
                        offset = 0;
                    }
                    if (OpacityOrNearestPt && z < this.zBuffer[offset]) {
                        this.zBuffer[offset] = (short)z;
                        if (OpacityAndNotNearestPt) {
                            this.opaArray[offset] = DepthCueSurfLessThan100 ? (byte)(this.depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - z) / zmaxminuszmintimes100) : (byte)thispixel;
                        } else if (DepthCueSurfLessThan100) {
                            int v = this.depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - z) / zmaxminuszmintimes100;
                            this.projArray[offset] = (byte)v;
                        } else {
                            this.projArray[offset] = (byte)thispixel;
                        }
                    }
                    if (MeanVal) {
                        int n = offset;
                        this.sumBuffer[n] = this.sumBuffer[n] + thispixel;
                        int n2 = offset;
                        this.countBuffer[n2] = (short)(this.countBuffer[n2] + 1);
                        continue;
                    }
                    if (!BrightestPt) continue;
                    if (DepthCueIntLessThan100) {
                        if (thispixel <= (this.brightCueArray[offset] & 0xFF) && (thispixel != (this.brightCueArray[offset] & 0xFF) || z <= this.cueZBuffer[offset])) continue;
                        this.brightCueArray[offset] = (byte)thispixel;
                        this.cueZBuffer[offset] = (short)z;
                        this.projArray[offset] = (byte)(this.depthCueInt * thispixel / 100 + c100minusDepthCueInt * thispixel * (zmax - z) / zmaxminuszmintimes100);
                        continue;
                    }
                    if (thispixel <= (this.projArray[offset] & 0xFF)) continue;
                    this.projArray[offset] = (byte)thispixel;
                }
            }
        }
    }

    private ImagePlus zScale(ImagePlus imp, boolean showProgress) {
        IJ.showStatus("Z Scaling...");
        ImageStack stack1 = imp.getStack();
        int depth1 = stack1.getSize();
        ImagePlus imp2 = null;
        String title = imp.getTitle();
        ImageProcessor ip = imp.getProcessor();
        ColorModel cm = ip.getColorModel();
        int width1 = imp.getWidth();
        int height1 = imp.getHeight();
        Rectangle r = ip.getRoi();
        int width2 = r.width;
        int height2 = r.height;
        int depth2 = (int)((double)stack1.getSize() * this.sliceInterval + 0.5);
        imp2 = NewImage.createImage(title, width2, height2, depth2, this.isRGB ? 24 : 8, 1);
        if (imp2 == null || depth2 != imp2.getStackSize()) {
            return null;
        }
        ImageStack stack2 = imp2.getStack();
        ImageProcessor xzPlane1 = ip.createProcessor(width2, depth1);
        xzPlane1.setInterpolate(true);
        int[] line = new int[width2];
        for (int y = 0; y < height2; ++y) {
            int z;
            for (z = 0; z < depth1; ++z) {
                if (this.isRGB) {
                    this.getRGBRow(stack1, r.x, r.y + y, z, width1, width2, line);
                } else {
                    this.getByteRow(stack1, r.x, r.y + y, z, width1, width2, line);
                }
                xzPlane1.putRow(0, z, line, width2);
            }
            xzPlane1.setProgressBar(null);
            ImageProcessor xzPlane2 = xzPlane1.resize(width2, depth2);
            for (z = 0; z < depth2; ++z) {
                xzPlane2.getRow(0, z, line, width2);
                if (this.isRGB) {
                    this.putRGBRow(stack2, y, z, width2, line);
                    continue;
                }
                this.putByteRow(stack2, y, z, width2, line);
            }
            if (!showProgress) continue;
            IJ.showProgress(y, height2 - 1);
        }
        ImageProcessor ip2 = imp2.getProcessor();
        ip2.setColorModel(cm);
        return imp2;
    }

    private void showProgress(double percent) {
        if (this.showMicroProgress && !this.done) {
            IJ.showProgress(this.progressBase + percent * this.progressScale);
        }
    }

    private void getByteRow(ImageStack stack, int x, int y, int z, int width1, int width2, int[] line) {
        byte[] pixels = (byte[])stack.getPixels(z + 1);
        int j = x + y * width1;
        for (int i = 0; i < width2; ++i) {
            line[i] = pixels[j++] & 0xFF;
        }
    }

    private void putByteRow(ImageStack stack, int y, int z, int width, int[] line) {
        byte[] pixels = (byte[])stack.getPixels(z + 1);
        int j = y * width;
        for (int i = 0; i < width; ++i) {
            pixels[j++] = (byte)line[i];
        }
    }

    private void getRGBRow(ImageStack stack, int x, int y, int z, int width1, int width2, int[] line) {
        int[] pixels = (int[])stack.getPixels(z + 1);
        int j = x + y * width1;
        for (int i = 0; i < width2; ++i) {
            line[i] = pixels[j++];
        }
    }

    private void putRGBRow(ImageStack stack, int y, int z, int width, int[] line) {
        int[] pixels = (int[])stack.getPixels(z + 1);
        int j = y * width;
        for (int i = 0; i < width; ++i) {
            pixels[j++] = line[i];
        }
    }
}

