/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;

public class WandToolOptions
implements PlugIn {
    private static final String[] modes = new String[]{"Legacy", "4-connected", "8-connected"};
    private static String mode = modes[0];
    private static double tolerance;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        boolean showCheckbox = imp != null && imp.getBitDepth() != 24 && WindowManager.getFrame("Threshold") == null;
        GenericDialog gd = new GenericDialog("Wand Tool");
        gd.addChoice("Mode: ", modes, mode);
        gd.addNumericField("Tolerance: ", tolerance, 1);
        if (showCheckbox) {
            gd.addCheckbox("Enable Thresholding", false);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        mode = gd.getNextChoice();
        tolerance = gd.getNextNumber();
        if (showCheckbox && gd.getNextBoolean()) {
            imp.deleteRoi();
            IJ.run("Threshold...");
        }
    }

    public static String getMode() {
        return mode;
    }

    public static double getTolerance() {
        return tolerance;
    }
}

