/*
 * Decompiled with CFR 0.152.
 */
package org.bric.processor;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.bric.gui.output.ProgressBarFrame;
import org.bric.imageEditParameters.OutputParameters;
import org.bric.imageEditParameters.ResizeParameters;
import org.bric.imageEditParameters.RotateParameters;
import org.bric.imageEditParameters.WatermarkParameters;
import org.bric.input.ImportedImage;
import org.bric.processor.ImageProcessor;
import org.bric.processor.ResizeProcessor;
import org.bric.processor.RotateProcessor;
import org.bric.processor.WatermarkProcessor;
import org.bric.utils.PDFToImage;
import org.bric.utils.Utils;

public class ImageProcessHandler {
    DefaultListModel model;
    ResizeParameters resizeParameters;
    RotateParameters rotateParameters;
    WatermarkParameters watermarkParameters;
    OutputParameters outputParameters;
    ProgressBarFrame progressBar;
    int modelSize;
    static boolean preview = false;
    static int duplicateAction;
    int numberingIndex;
    String outputExtension;
    String outputPath;
    HashSet<Integer> blackList;

    public ImageProcessHandler(DefaultListModel model) {
        this.model = model;
        this.modelSize = model.size();
        this.blackList = new HashSet();
        duplicateAction = 4;
        preview = false;
    }

    public ImageProcessHandler(ImportedImage image) {
        duplicateAction = 4;
        this.model = new DefaultListModel();
        this.model.addElement(image);
        this.modelSize = this.model.size();
        preview = true;
    }

    public void setResizeParameters(ResizeParameters resizeParameters) {
        this.resizeParameters = resizeParameters;
    }

    public void setRotateParameters(RotateParameters rotateParameters) {
        this.rotateParameters = rotateParameters;
    }

    public void setWatermarkParameters(WatermarkParameters watermarkParameters) {
        this.watermarkParameters = watermarkParameters;
    }

    public void setOutputParameters(OutputParameters outputParameters) {
        this.outputParameters = outputParameters;
        this.numberingIndex = outputParameters.getNumberingStartIndex();
        this.outputExtension = outputParameters.getOutputFormat().toLowerCase();
        this.outputPath = outputParameters.getOutputPath();
    }

    public void start() {
        if (preview && ((ImportedImage)this.model.get(0)).getImageType().equalsIgnoreCase("pdf")) {
            JOptionPane.showMessageDialog(null, "PDF preview is not supported yet!");
            return;
        }
        this.progressBar = new ProgressBarFrame();
        this.progressBar.setVisible(true);
        this.progressBar.setImagesCount(this.modelSize);
        int processors = Utils.prefs.getInt("exportNumThreads", 0) == 0 ? Runtime.getRuntime().availableProcessors() : Utils.prefs.getInt("exportNumThreads", 1);
        int step = (int)Math.ceil((double)this.modelSize / (double)processors);
        if (this.outputExtension.equalsIgnoreCase("pdf")) {
            this.generatePDF();
        } else {
            for (int j = 0; j < this.modelSize; j += step) {
                this.startNewThread(this.progressBar, j, step);
            }
        }
    }

    public void generatePDF() {
        ResizeProcessor resizer = new ResizeProcessor(this.resizeParameters);
        RotateProcessor rotator = new RotateProcessor(this.rotateParameters);
        WatermarkProcessor watermarker = new WatermarkProcessor(this.watermarkParameters);
        try {
            Document doc = new Document();
            PdfWriter.getInstance(doc, new FileOutputStream(new File(this.applyFileNameMasks(this.outputPath, (ImportedImage)this.model.get(0)))));
            doc.open();
            for (int i = 0; i < this.modelSize; ++i) {
                String filepath = ((ImportedImage)this.model.get(i)).getPath();
                if (this.getExtension(filepath).equalsIgnoreCase("pdf")) {
                    ArrayList extractedImages = (ArrayList)PDFToImage.getBImagesFromPDF(((ImportedImage)this.model.get(i)).getPath(), 1, Integer.MAX_VALUE);
                    for (BufferedImage currentImage : extractedImages) {
                        BufferedImage image = this.bufferedImageProcess(resizer, rotator, watermarker, currentImage);
                        image = this.bufferedImageProcess(resizer, rotator, watermarker, image);
                        this.addImageToPDDocument(doc, image);
                    }
                } else {
                    BufferedImage image = Utils.loadImage(filepath);
                    image = this.bufferedImageProcess(resizer, rotator, watermarker, image);
                    this.addImageToPDDocument(doc, image);
                }
                this.progressBar.showProgress(((ImportedImage)this.model.get(i)).getPath());
                this.progressBar.updateValue(true);
            }
            doc.close();
        }
        catch (DocumentException ex) {
            Logger.getLogger(ImageProcessHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ImageProcessHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void generatePDF(ImportedImage importedImage) {
        ResizeProcessor resizer = new ResizeProcessor(this.resizeParameters);
        RotateProcessor rotator = new RotateProcessor(this.rotateParameters);
        WatermarkProcessor watermarker = new WatermarkProcessor(this.watermarkParameters);
        try {
            Document doc = new Document();
            PdfWriter.getInstance(doc, new FileOutputStream(new File(this.applyFileNameMasks(this.outputPath, importedImage))));
            doc.open();
            String filepath = importedImage.getPath();
            if (this.getExtension(filepath).equalsIgnoreCase("pdf")) {
                ArrayList extractedImages = (ArrayList)PDFToImage.getBImagesFromPDF(importedImage.getPath(), 1, Integer.MAX_VALUE);
                for (BufferedImage currentImage : extractedImages) {
                    BufferedImage image = this.bufferedImageProcess(resizer, rotator, watermarker, currentImage);
                    image = this.bufferedImageProcess(resizer, rotator, watermarker, image);
                    this.addImageToPDDocument(doc, image);
                }
            } else {
                BufferedImage image = Utils.loadImage(filepath);
                image = this.bufferedImageProcess(resizer, rotator, watermarker, image);
                this.addImageToPDDocument(doc, image);
            }
            doc.close();
        }
        catch (DocumentException ex) {
            Logger.getLogger(ImageProcessHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ImageProcessHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addImageToPDDocument(Document doc, BufferedImage sourceImage) {
        try {
            Rectangle pageSize = new Rectangle(sourceImage.getWidth(), sourceImage.getHeight());
            doc.setPageSize(pageSize);
            doc.newPage();
            Image iTextImage = Image.getInstance(sourceImage, null);
            Image pdfImage = Image.getInstance(iTextImage);
            pdfImage.setAbsolutePosition(0.0f, 0.0f);
            doc.add(pdfImage);
        }
        catch (DocumentException ex) {
            Logger.getLogger(ImageProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ImageProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void startNewThread(final ProgressBarFrame progressBar, final int from, final int step) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ResizeProcessor resizer = new ResizeProcessor(ImageProcessHandler.this.resizeParameters);
                RotateProcessor rotator = new RotateProcessor(ImageProcessHandler.this.rotateParameters);
                WatermarkProcessor watermarker = new WatermarkProcessor(ImageProcessHandler.this.watermarkParameters);
                for (int i = from; i < from + step; ++i) {
                    if (!progressBar.isVisible() || i >= ImageProcessHandler.this.modelSize) {
                        return;
                    }
                    String inputExtension = ((ImportedImage)ImageProcessHandler.this.model.get(i)).getImageType();
                    if (inputExtension.equalsIgnoreCase("pdf")) {
                        if (ImageProcessHandler.this.outputExtension.equalsIgnoreCase("same as first")) {
                            ImageProcessHandler.this.generatePDF((ImportedImage)ImageProcessHandler.this.model.get(i));
                        } else {
                            ArrayList extractedImages = (ArrayList)PDFToImage.getBImagesFromPDF(((ImportedImage)ImageProcessHandler.this.model.get(i)).getPath(), 1, Integer.MAX_VALUE);
                            for (BufferedImage currentImage : extractedImages) {
                                currentImage = ImageProcessHandler.this.bufferedImageProcess(resizer, rotator, watermarker, currentImage);
                                ImageProcessHandler.this.save(currentImage, ImageProcessHandler.this.applyFileNameMasks(ImageProcessHandler.this.outputPath, (ImportedImage)ImageProcessHandler.this.model.get(i)));
                            }
                        }
                    } else {
                        BufferedImage currentImage = ImageProcessHandler.this.bufferedImageProcess(resizer, rotator, watermarker, Utils.loadImage(((ImportedImage)ImageProcessHandler.this.model.get(i)).getPath()));
                        ImageProcessHandler.this.save(currentImage, ImageProcessHandler.this.applyFileNameMasks(ImageProcessHandler.this.outputPath, (ImportedImage)ImageProcessHandler.this.model.get(i)));
                    }
                    progressBar.showProgress(((ImportedImage)ImageProcessHandler.this.model.get(i)).getPath());
                    progressBar.updateValue(true);
                }
            }
        }).start();
    }

    private BufferedImage bufferedImageProcess(ResizeProcessor resizer, RotateProcessor rotator, WatermarkProcessor watermarker, BufferedImage sourceImage) {
        if (this.resizeParameters.isEnabled()) {
            sourceImage = resizer.process(sourceImage);
        }
        if (this.rotateParameters.isEnabled()) {
            sourceImage = rotator.process(sourceImage);
        }
        if (this.watermarkParameters.isEnabled()) {
            sourceImage = watermarker.process(sourceImage);
        }
        return sourceImage;
    }

    private String getExtension(String filename) {
        String extension = filename.substring(filename.lastIndexOf(".") + 1);
        return extension;
    }

    private synchronized String applyFileNameMasks(String filepath, ImportedImage currentImage) {
        if (this.outputPath.substring(this.outputPath.lastIndexOf(Utils.FS) + 1).equals("")) {
            filepath = filepath.lastIndexOf(Utils.FS) == filepath.length() - 1 ? filepath : filepath + Utils.FS;
            filepath = filepath + "%F";
            if (currentImage.getImageType().equalsIgnoreCase("pdf") && !this.outputExtension.equalsIgnoreCase("pdf")) {
                filepath = filepath + "(#)";
            }
        }
        if (filepath.contains("^P")) {
            if (!filepath.contains("^P" + Utils.FS)) {
                filepath = filepath.replace("^P", "^P" + Utils.FS);
            }
            if (!(filepath.contains("%") || filepath.contains("*") || filepath.contains("#"))) {
                filepath = filepath + "%F";
            }
        }
        filepath = filepath.replaceAll("\\*", Integer.toString(this.numberingIndex));
        Calendar cal = Calendar.getInstance();
        filepath = filepath.replaceAll("%D", cal.get(5) + "");
        filepath = filepath.replaceAll("%M", cal.get(2) + 1 + "");
        filepath = filepath.replaceAll("%Y", cal.get(1) + "");
        String extension = this.outputExtension;
        filepath = filepath.replaceAll("%F", currentImage.getName());
        filepath = filepath.replace("^P", currentImage.getPath().substring(0, currentImage.getPath().lastIndexOf(Utils.FS)));
        if (this.outputExtension.equals("same as first")) {
            for (String ext : Utils.supportedOutputExtensions) {
                if (ext.equalsIgnoreCase(currentImage.getImageType())) {
                    extension = currentImage.getImageType();
                    break;
                }
                extension = Utils.prefs.get("defaultFileType", "jpg");
            }
        }
        if (filepath.contains("#")) {
            filepath = this.applyFileNameMask(filepath, extension);
        }
        filepath = filepath + '.' + extension;
        return filepath;
    }

    private synchronized String applyFileNameMask(String filepath, String extension) {
        String f;
        int index;
        int i = index = this.outputParameters.getNumberingStartIndex();
        while (true) {
            if (!new File((f = filepath.replaceAll("#", "" + i)) + '.' + extension).exists() && !this.blackList.contains(i)) {
                this.blackList.add(i);
                if (duplicateAction == 0 || duplicateAction == 1) {
                    this.blackList.clear();
                }
                break;
            }
            ++i;
        }
        filepath = f;
        return filepath;
    }

    public static synchronized void duplicatePane(String file) {
        if (duplicateAction == 4 || duplicateAction == 5 || duplicateAction == 3 || duplicateAction == 1) {
            Object selection;
            Object[] selectionValues = new Object[]{"Overwrite", "Overwrite All", "Skip", "Skip All", "Add", "Add All"};
            String initialSelection = selectionValues[4].toString();
            while ((selection = JOptionPane.showInputDialog(null, String.format("This image\n%s\n already exists on the output folder", file), "Warning Duplicate", 3, null, selectionValues, initialSelection)) == null) {
            }
            int answer = 0;
            int i = 0;
            for (Object value : selectionValues) {
                if (selection == value.toString()) {
                    answer = i;
                }
                ++i;
            }
            switch (answer) {
                case 0: {
                    duplicateAction = 5;
                    break;
                }
                case 1: {
                    duplicateAction = 6;
                    break;
                }
                case 2: {
                    duplicateAction = 3;
                    break;
                }
                case 3: {
                    duplicateAction = 2;
                    break;
                }
                case 4: {
                    duplicateAction = 1;
                    break;
                }
                case 5: {
                    duplicateAction = 0;
                    break;
                }
                default: {
                    duplicateAction = 1;
                }
            }
        }
    }

    private String duplicateAddAction(String filename) {
        String file = filename.substring(0, filename.lastIndexOf(46));
        file = file + "(#)";
        String extension = this.getExtension(filename);
        file = this.applyFileNameMask(file, extension);
        return file + "." + extension;
    }

    public boolean fileExistsCheck(String newFilepath) {
        File virtualFile = new File(newFilepath);
        if (virtualFile.exists()) {
            ImageProcessHandler.duplicatePane(newFilepath);
        }
        return duplicateAction == 3 || duplicateAction == 2;
    }

    public void previewProcess(BufferedImage image) {
        try {
            File temporary = File.createTempFile("preview", ".jpg");
            temporary.deleteOnExit();
            ImageFormat format = ImageFormat.IMAGE_FORMAT_PNG;
            Sanselan.writeImage(image, temporary, format, null);
            Desktop.getDesktop().open(temporary);
        }
        catch (ImageWriteException ex) {
            Logger.getLogger(ImageProcessHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ImageProcessHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void save(BufferedImage imageForSave, String newFilepath) {
        if (preview) {
            this.previewProcess(imageForSave);
            return;
        }
        ++this.numberingIndex;
        if (this.fileExistsCheck(newFilepath)) {
            return;
        }
        if ((duplicateAction == 1 || duplicateAction == 0) && new File(newFilepath).exists()) {
            newFilepath = this.duplicateAddAction(newFilepath);
        }
        File outputFile = new File(newFilepath);
        String extension = this.getExtension(outputFile.getPath());
        try {
            if (extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg")) {
                this.saveJPG(imageForSave, outputFile);
            } else if (extension.equalsIgnoreCase("gif")) {
                ImageFormat format = ImageFormat.IMAGE_FORMAT_GIF;
                Sanselan.writeImage(imageForSave, outputFile, format, null);
            } else if (extension.equalsIgnoreCase("tif") || extension.equalsIgnoreCase("tiff")) {
                ImageFormat format = ImageFormat.IMAGE_FORMAT_TIFF;
                Sanselan.writeImage(imageForSave, outputFile, format, null);
            } else if (extension.equalsIgnoreCase("pgm")) {
                ImageFormat format = ImageFormat.IMAGE_FORMAT_PGM;
                Sanselan.writeImage(imageForSave, outputFile, format, null);
            } else if (extension.equalsIgnoreCase("ppm")) {
                ImageFormat format = ImageFormat.IMAGE_FORMAT_PPM;
                Sanselan.writeImage(imageForSave, outputFile, format, null);
            } else if (extension.equalsIgnoreCase("pnm")) {
                ImageFormat format = ImageFormat.IMAGE_FORMAT_PNM;
                Sanselan.writeImage(imageForSave, outputFile, format, null);
            } else if (extension.equalsIgnoreCase("pbm")) {
                ImageFormat format = ImageFormat.IMAGE_FORMAT_PBM;
                Sanselan.writeImage(imageForSave, outputFile, format, null);
            } else if (extension.equalsIgnoreCase("bmp")) {
                ImageFormat format = ImageFormat.IMAGE_FORMAT_BMP;
                Sanselan.writeImage(imageForSave, outputFile, format, null);
            } else if (extension.equalsIgnoreCase("png")) {
                ImageFormat format = ImageFormat.IMAGE_FORMAT_PNG;
                Sanselan.writeImage(imageForSave, outputFile, format, null);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void saveJPG(BufferedImage imageForSave, File outputfile) {
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(this.outputParameters.getQuality());
            FileImageOutputStream output = new FileImageOutputStream(outputfile);
            writer.setOutput(output);
            IIOImage image2 = new IIOImage(imageForSave, null, null);
            writer.write(null, image2, iwp);
            output.flush();
            writer.dispose();
            output.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ImageProcessHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

