/*
 * Decompiled with CFR 0.152.
 */
package org.bric.processor;

import com.jhlabs.image.FlipFilter;
import com.jhlabs.image.RotateFilter;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.bric.imageEditParameters.RotateParameters;
import org.bric.processor.ImageProcessor;

public class RotateProcessor
implements ImageProcessor {
    RotateParameters rotateParameters;

    public RotateProcessor(RotateParameters rotateParameters) {
        this.rotateParameters = rotateParameters;
    }

    @Override
    public BufferedImage process(BufferedImage image) {
        if (this.rotateParameters.isCustom()) {
            return this.customRotate(image);
        }
        return this.predefinedRotate(image);
    }

    private BufferedImage predefinedRotate(BufferedImage image) {
        int action = this.rotateParameters.getAction();
        switch (action) {
            case 0: 
            case 4: {
                action = 6;
                break;
            }
            case 1: {
                action = 5;
                break;
            }
            case 2: {
                action = 4;
                break;
            }
            case 3: {
                action = 1;
                break;
            }
            case 5: {
                action = 2;
            }
        }
        FlipFilter flipFilter = new FlipFilter(action);
        return flipFilter.filter(image, null);
    }

    public BufferedImage customRotate(BufferedImage image) {
        int angle = this.rotateParameters.getAngle();
        if (this.rotateParameters.isDifferentValues()) {
            Random rand = new Random();
            int max = this.rotateParameters.getTo();
            int min = this.rotateParameters.getFrom();
            angle = this.rotateParameters.isLimit() ? rand.nextInt(max - min + 1) + min : rand.nextInt(360);
        } else if (this.rotateParameters.isRandom()) {
            angle = this.rotateParameters.getRandomAngle();
        }
        float radAngle = (float)((double)(360 - angle) * Math.PI / 180.0);
        RotateFilter rotateFilter = new RotateFilter(radAngle);
        return rotateFilter.filter(image, null);
    }
}

