/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.grelf.PointFloat;
import net.grelf.Statistics;
import net.grelf.Timer;
import net.grelf.Util;
import net.grelf.astro.Dec;
import net.grelf.astro.Epoch;
import net.grelf.astro.Magnitude;
import net.grelf.astro.RA;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.Star;
import net.grelf.astro.Variability;
import net.grelf.grip.Blob;
import net.grelf.grip.BlobMask;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.Blob_;
import net.grelf.grip.Config;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.GlassPane;
import net.grelf.grip.ImFrame;
import net.grelf.grip.PointList;
import net.grelf.grip.XYText;
import net.grelf.image.Image;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class BlobMeasList
extends LinkedList<BlobMeas>
implements Serializable {
    private ImFrame imframe = null;

    public ImFrame getImFrame() {
        return this.imframe;
    }

    public BlobMeasList(ImFrame imFrame) {
        this.imframe = imFrame;
    }

    public BlobMeasList crop(Point point, Point point2) {
        Point point3 = new Point(Math.min(point.x, point2.x), Math.min(point.y, point2.y));
        Point point4 = new Point(Math.max(point.x, point2.x), Math.max(point.y, point2.y));
        BlobMeasList blobMeasList = new BlobMeasList(this.imframe);
        for (BlobMeas blobMeas : this) {
            if (blobMeas.minX < point3.x || blobMeas.minY < point3.y || blobMeas.maxX >= point4.x || blobMeas.maxY >= point4.y) continue;
            blobMeasList.insert(blobMeas);
            if (null != blobMeas.blob) {
                blobMeas.blob.translate(-point3.x, -point3.y);
            }
            blobMeas.minX -= point3.x;
            blobMeas.minY -= point3.y;
            blobMeas.maxX -= point3.x;
            blobMeas.maxY -= point3.y;
            blobMeas.centre.x -= (float)point3.x;
            blobMeas.centre.y -= (float)point3.y;
        }
        return blobMeasList;
    }

    public void drawBoundaries(ImFrame imFrame) {
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        GlassPane glassPane = imFrame.getGP();
        glassPane.setDrawingMode(DrawingMode.MASK);
        Image image = imFrame.getImPane().getImage();
        byte[][] byArray = new byte[image.getWidth()][image.getHeight()];
        glassPane.setMask(new BlobMask(byArray));
        for (BlobMeas blobMeas : this) {
            blobMeas.blob.drawBoundary(byArray, (byte)1);
        }
        imFrame.redisplay();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void drawRegions(ImFrame imFrame) {
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        GlassPane glassPane = imFrame.getGP();
        glassPane.setDrawingMode(DrawingMode.MASK);
        Image image = imFrame.getImPane().getImage();
        byte[][] byArray = new byte[image.getWidth()][image.getHeight()];
        glassPane.setMask(new BlobMask(byArray));
        for (BlobMeas blobMeas : this) {
            blobMeas.blob.drawRegion(byArray, (byte)1);
        }
        imFrame.redisplay();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public BlobMeas getNearestBlob(int n, int n2) {
        BlobMeas blobMeas = null;
        double d = Double.NaN;
        boolean bl = true;
        for (BlobMeas blobMeas2 : this) {
            double d2 = blobMeas2.centre.x - (float)n;
            double d3 = blobMeas2.centre.y - (float)n2;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            if (bl) {
                d = d4;
                blobMeas = blobMeas2;
                bl = false;
                continue;
            }
            if (!(d4 < d)) continue;
            d = d4;
            blobMeas = blobMeas2;
        }
        return blobMeas;
    }

    public BlobMeas getNearestBlob(Blob blob) {
        BlobMeas blobMeas = null;
        double d = Double.NaN;
        boolean bl = true;
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl2 = false;
        for (BlobMeas blobMeas2 : this) {
            if (blobMeas2.blob != blob) continue;
            f = blobMeas2.centre.x;
            f2 = blobMeas2.centre.y;
            bl2 = true;
            break;
        }
        if (!bl2) {
            Util.warning("Error", "Comparison blob not found");
            return null;
        }
        for (BlobMeas blobMeas2 : this) {
            if (blobMeas2.blob == blob) continue;
            double d2 = blobMeas2.centre.x - f;
            double d3 = blobMeas2.centre.y - f2;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            if (bl) {
                d = d4;
                blobMeas = blobMeas2;
                bl = false;
                continue;
            }
            if (!(d4 < d)) continue;
            d = d4;
            blobMeas = blobMeas2;
        }
        return blobMeas;
    }

    public boolean insert(BlobMeas blobMeas) {
        try {
            if (this.size() == 0) {
                return this.add(blobMeas);
            }
            ListIterator<BlobMeas> listIterator = this.listIterator();
            BlobMeas blobMeas2 = (BlobMeas)listIterator.next();
            while (blobMeas.compareTo(blobMeas2) > 0 && listIterator.hasNext()) {
                blobMeas2 = (BlobMeas)listIterator.next();
            }
            if (listIterator.hasNext()) {
                listIterator.previous();
            }
            listIterator.add(blobMeas);
            return true;
        }
        catch (Throwable throwable) {
            Util.logWarning("EXCEPTION: {0}", throwable.toString());
            return false;
        }
    }

    public void showBrightestBlobs(ImFrame imFrame) {
        int n;
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        GlassPane glassPane = imFrame.getGP();
        glassPane.setDrawingMode(DrawingMode.MASK);
        PointList pointList = glassPane.getPoints();
        Image image = imFrame.getImPane().getImage();
        byte[][] byArray = new byte[image.getWidth()][image.getHeight()];
        glassPane.setMask(new BlobMask(byArray));
        try {
            n = Integer.parseInt(Config.getValue("NBrightest.value"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 16;
        }
        ArrayList<XYText> arrayList = new ArrayList<XYText>();
        pointList.setLabels(arrayList);
        int n2 = 1;
        for (BlobMeas blobMeas : this) {
            blobMeas.blob.drawBoundary(byArray, (byte)1);
            XYText xYText = new XYText(blobMeas.minX, blobMeas.minY, Integer.toString(n2));
            arrayList.add(xYText);
            if (++n2 <= n) continue;
            break;
        }
        imFrame.redisplay();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void saveAsXML(String string) {
        Timer timer = new Timer("Saving blob data in " + string, null);
        try {
            PrintWriter printWriter = new PrintWriter(string);
            printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            printWriter.println("<!-- Written by GRIP v12.6.24 from www.grelf.net -->");
            printWriter.println(this.toXML().toString());
            printWriter.close();
            timer.stop();
        }
        catch (IOException iOException) {
            Util.logWarning(iOException.toString());
            Util.warning("Error", "Failed to save blob data");
        }
    }

    public StringBuffer toXML() {
        BlobMeas blobMeas2;
        int n = 0;
        int n2 = 0;
        for (BlobMeas blobMeas2 : this) {
            if (blobMeas2.maxX > n) {
                n = blobMeas2.maxX;
            }
            if (blobMeas2.maxY <= n2) continue;
            n2 = blobMeas2.maxY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<BlobMeasList>\n");
        stringBuffer.append("\t<ImageFilePath>");
        stringBuffer.append(this.imframe.getFilePath());
        stringBuffer.append("</ImageFilePath>\n");
        stringBuffer.append("\t<ImageWidth>");
        stringBuffer.append(n + 1);
        stringBuffer.append("</ImageWidth>\n");
        stringBuffer.append("\t<ImageHeight>");
        stringBuffer.append(n2 + 1);
        stringBuffer.append("</ImageHeight>\n");
        blobMeas2 = (BlobMeas)this.getFirst();
        if (null != blobMeas2) {
            stringBuffer.append("\t<RingSize>");
            stringBuffer.append(blobMeas2.blob.getMeasuringRingSizeFactor());
            stringBuffer.append("</RingSize>\n");
        }
        for (BlobMeas blobMeas3 : this) {
            stringBuffer.append(blobMeas3.toXML("\t"));
        }
        stringBuffer.append("</BlobMeasList>\n");
        return stringBuffer;
    }

    public static BlobMeasList loadFromXML(String string) {
        try {
            Timer timer = new Timer("Loading blob data from " + string, null);
            InputSource inputSource = new InputSource(new FileReader(string));
            BlobsSaxHandler blobsSaxHandler = new BlobsSaxHandler();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setContentHandler(blobsSaxHandler);
            xMLReader.parse(inputSource);
            timer.stop();
            return blobsSaxHandler.getBlobMeasList();
        }
        catch (SAXParseException sAXParseException) {
            Util.logWarning("{0}[line {1}, col {2}]", sAXParseException.toString(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        }
        catch (SAXException sAXException) {
            Util.logWarning(sAXException.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Util.logWarning(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            Util.logWarning(iOException.toString());
        }
        Util.warning("Error", "Failed to load blob data");
        return null;
    }

    private static class BlobsSaxHandler
    extends DefaultHandler {
        private BlobMeasList bml = null;
        private int imageWidth = 0;
        private int imageHeight = 0;
        private BlobMeas meas = null;
        private boolean inImageFilePath = false;
        private boolean inImageWidth = false;
        private boolean inImageHeight = false;
        private boolean inRingSize = false;
        private boolean inBrightness = false;
        private boolean inChannelBrightnesses = false;
        private boolean inAccurateBrightnesses = false;
        private boolean inSNRatios = false;
        private boolean inCentre = false;
        private boolean inArea = false;
        private boolean inMinX = false;
        private boolean inMinY = false;
        private boolean inMaxX = false;
        private boolean inMaxY = false;
        private boolean inPt = false;
        private boolean inCommonId = false;
        private boolean inHipparcosId = false;
        private boolean inTychoId = false;
        private boolean inOtherId = false;
        private boolean inRA = false;
        private boolean inDec = false;
        private boolean inEpoch = false;
        private boolean inMag = false;
        private boolean inBand = false;
        private boolean inValue = false;
        private boolean inVar = false;
        private boolean inNSamples = false;
        private boolean inMin = false;
        private boolean inMean = false;
        private boolean inMode = false;
        private boolean inMax = false;
        private boolean inStdDev = false;
        private boolean inStdDevMode = false;
        private boolean inNPixels = false;
        private int nBands = 0;
        private int bandNo = 0;
        private Statistics stats = null;
        private List<Point> boundary = null;
        private byte[][] mask = null;
        private Star star = null;
        private Magnitude mag = null;
        private String bandId = "";
        private RA ra = null;
        private Dec dec = null;
        private Epoch epoch = null;
        private int ringSize = 0;

        private BlobsSaxHandler() {
        }

        public BlobMeasList getBlobMeasList() {
            return this.bml;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (!string3.equals("BlobMeasList")) {
                if (string3.equals("ImageFilePath")) {
                    this.inImageFilePath = true;
                } else if (string3.equals("ImageWidth")) {
                    this.inImageWidth = true;
                } else if (string3.equals("ImageHeight")) {
                    this.inImageHeight = true;
                } else if (string3.equals("RingSize")) {
                    this.inRingSize = true;
                } else if (string3.equals("BlobMeas")) {
                    this.meas = new BlobMeas();
                } else if (string3.equals("Brightness")) {
                    this.inBrightness = true;
                } else if (string3.equals("ChannelBrightnesses")) {
                    this.inChannelBrightnesses = true;
                } else if (string3.equals("AccurateBrightnesses")) {
                    this.inAccurateBrightnesses = true;
                } else if (string3.equals("SNRatios")) {
                    this.inSNRatios = true;
                } else if (string3.equals("Centre")) {
                    this.inCentre = true;
                } else if (string3.equals("Area")) {
                    this.inArea = true;
                } else if (string3.equals("MinX")) {
                    this.inMinX = true;
                } else if (string3.equals("MinY")) {
                    this.inMinY = true;
                } else if (string3.equals("MaxX")) {
                    this.inMaxX = true;
                } else if (string3.equals("MaxY")) {
                    this.inMaxY = true;
                } else if (!string3.equals("Blob")) {
                    if (string3.equals("Boundary")) {
                        this.boundary = new ArrayList<Point>();
                    } else if (string3.equals("Pt")) {
                        this.inPt = true;
                    } else if (string3.equals("Star")) {
                        this.star = new Star();
                    } else if (string3.equals("CommonId")) {
                        this.inCommonId = true;
                    } else if (string3.equals("HipparcosId")) {
                        this.inHipparcosId = true;
                    } else if (string3.equals("TychoId")) {
                        this.inTychoId = true;
                    } else if (string3.equals("OtherId")) {
                        this.inOtherId = true;
                    } else if (!string3.equals("SkyPt")) {
                        if (string3.equals("RA")) {
                            this.inRA = true;
                        } else if (string3.equals("Dec")) {
                            this.inDec = true;
                        } else if (string3.equals("Epoch")) {
                            this.inEpoch = true;
                        } else if (string3.equals("Mag")) {
                            this.inMag = true;
                        } else if (string3.equals("Band")) {
                            this.inBand = true;
                            this.inMag = false;
                        } else if (string3.equals("Value")) {
                            this.inValue = true;
                            this.inMag = false;
                        } else if (string3.equals("Var")) {
                            this.inVar = true;
                        } else if (string3.equals("Background")) {
                            this.meas.backgroundStatistics = new Statistics[this.nBands];
                        } else if (string3.equals("Statistics")) {
                            this.stats = new Statistics();
                        } else if (string3.equals("NSamples")) {
                            this.inNSamples = true;
                        } else if (string3.equals("Min")) {
                            this.inMin = true;
                        } else if (string3.equals("Mean")) {
                            this.inMean = true;
                        } else if (string3.equals("Mode")) {
                            this.inMode = true;
                        } else if (string3.equals("Max")) {
                            this.inMax = true;
                        } else if (string3.equals("StdDev")) {
                            this.inStdDev = true;
                        } else if (string3.equals("StdDevMode")) {
                            this.inStdDevMode = true;
                        } else if (string3.equals("NPixelsMeasured")) {
                            this.inNPixels = true;
                        } else {
                            Util.logWarning("Unhandled element <{0}>", string3);
                        }
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3.equals("ImageFilePath")) {
                this.inImageFilePath = false;
            } else if (string3.equals("ImageWidth")) {
                this.inImageWidth = false;
            } else if (string3.equals("ImageHeight")) {
                this.inImageHeight = false;
            } else if (string3.equals("RingSize")) {
                this.inRingSize = false;
            } else if (string3.equals("BlobMeas")) {
                this.bml.insert(this.meas);
                this.meas = null;
            } else if (string3.equals("Brightness")) {
                this.inBrightness = false;
            } else if (string3.equals("ChannelBrightnesses")) {
                this.inChannelBrightnesses = false;
            } else if (string3.equals("AccurateBrightnesses")) {
                this.inAccurateBrightnesses = false;
            } else if (string3.equals("SNRatios")) {
                this.inSNRatios = true;
            } else if (string3.equals("Centre")) {
                this.inCentre = false;
            } else if (string3.equals("Area")) {
                this.inArea = false;
            } else if (string3.equals("MinX")) {
                this.inMinX = false;
            } else if (string3.equals("MinY")) {
                this.inMinY = false;
            } else if (string3.equals("MaxX")) {
                this.inMaxX = false;
            } else if (string3.equals("MaxY")) {
                this.inMaxY = false;
            } else if (string3.equals("Blob")) {
                if (this.boundary.size() == 1) {
                    Point point = this.boundary.get(0);
                    this.meas.blob = new Blob_(point.x, point.y);
                } else {
                    this.meas.blob = new Blob_(this.boundary, this.mask);
                }
                if (null != this.meas.blob) {
                    this.meas.blob.setMeasuringRingSizeFactor(this.ringSize);
                }
                this.boundary = null;
            } else if (string3.equals("Pt")) {
                this.inPt = false;
            } else if (string3.equals("Star")) {
                this.meas.setStar(this.star);
                this.star = null;
            } else if (string3.equals("CommonId")) {
                this.inCommonId = false;
            } else if (string3.equals("HipparcosId")) {
                this.inHipparcosId = false;
            } else if (string3.equals("TychoId")) {
                this.inTychoId = false;
            } else if (string3.equals("OtherId")) {
                this.inOtherId = false;
            } else if (string3.equals("SkyPt")) {
                this.star.setPosition(new SkyPoint(this.ra, this.dec, this.epoch));
            } else if (string3.equals("RA")) {
                this.inRA = false;
            } else if (string3.equals("Dec")) {
                this.inDec = false;
            } else if (string3.equals("Epoch")) {
                this.inEpoch = false;
            } else if (string3.equals("Mag")) {
                this.inMag = false;
                this.star.addMagnitude(this.mag);
            } else if (string3.equals("Band")) {
                this.inBand = false;
            } else if (string3.equals("Value")) {
                this.inValue = false;
            } else if (string3.equals("Var")) {
                this.inVar = false;
            } else if (string3.equals("Background")) {
                this.bandNo = 0;
            } else if (string3.equals("Channel")) {
                ++this.bandNo;
            } else if (string3.equals("Statistics")) {
                this.meas.backgroundStatistics[this.bandNo] = this.stats;
                this.stats = null;
            } else if (string3.equals("NSamples")) {
                this.inNSamples = false;
            } else if (string3.equals("Min")) {
                this.inMin = false;
            } else if (string3.equals("Mean")) {
                this.inMean = false;
            } else if (string3.equals("Mode")) {
                this.inMode = false;
            } else if (string3.equals("Max")) {
                this.inMax = false;
            } else if (string3.equals("StdDev")) {
                this.inStdDev = false;
            } else if (string3.equals("StdDevMode")) {
                this.inStdDevMode = false;
            } else if (string3.equals("NPixelsMeasured")) {
                this.inNPixels = false;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            String string = new String(cArray, n, n2);
            String string2 = "";
            try {
                if (this.inImageFilePath) {
                    ImFrame imFrame = new ImFrame(string, new DefaultMeasurementHandler());
                    this.bml = new BlobMeasList(imFrame);
                    if (null != imFrame) {
                        imFrame.setBlobMeases(this.bml);
                    }
                } else if (this.inImageWidth) {
                    string2 = "ImageWidth";
                    this.imageWidth = Integer.parseInt(string);
                } else if (this.inImageHeight) {
                    string2 = "ImageHeight";
                    this.imageHeight = Integer.parseInt(string);
                    this.mask = new byte[this.imageWidth + 1][this.imageHeight + 1];
                } else if (this.inRingSize) {
                    string2 = "RingSize";
                    this.ringSize = Integer.parseInt(string);
                } else if (this.inBrightness) {
                    string2 = "Brightness";
                    this.meas.brightness = Double.parseDouble(string);
                } else if (this.inChannelBrightnesses) {
                    string2 = "ChannelBrightnesses";
                    String[] stringArray = string.split("\\,");
                    this.nBands = stringArray.length;
                    this.meas.channelBrightnesses = new long[this.nBands];
                    for (int i = 0; i < this.nBands; ++i) {
                        this.meas.channelBrightnesses[i] = Long.parseLong(stringArray[i]);
                    }
                } else if (this.inNSamples) {
                    string2 = "nSamples";
                    this.stats.n = Integer.parseInt(string);
                } else if (this.inMin) {
                    string2 = "Min";
                    this.stats.min = Integer.parseInt(string);
                } else if (this.inMean) {
                    string2 = "Mean";
                    this.stats.mean = Double.parseDouble(string);
                } else if (this.inMode) {
                    string2 = "Mode";
                    this.stats.mode = Integer.parseInt(string);
                } else if (this.inMax) {
                    string2 = "Max";
                    this.stats.max = Integer.parseInt(string);
                } else if (this.inStdDev) {
                    string2 = "StdDev";
                    this.stats.stdDev = Double.parseDouble(string);
                } else if (this.inStdDevMode) {
                    string2 = "StdDevMode";
                    this.stats.stdDevMode = Double.parseDouble(string);
                } else if (this.inAccurateBrightnesses) {
                    string2 = "AccurateBrightnesses";
                    String[] stringArray = string.split("\\,");
                    int n3 = stringArray.length;
                    this.meas.accurateBrightnesses = new long[n3];
                    for (int i = 0; i < n3; ++i) {
                        this.meas.accurateBrightnesses[i] = Long.parseLong(stringArray[i]);
                    }
                } else if (this.inSNRatios) {
                    string2 = "SNRatios";
                    String[] stringArray = string.split("\\,");
                    int n4 = stringArray.length;
                    this.meas.snRatios = new float[n4];
                    for (int i = 0; i < n4; ++i) {
                        this.meas.snRatios[i] = Float.parseFloat(stringArray[i]);
                    }
                } else if (this.inNPixels) {
                    string2 = "NPixelsMeasured";
                    this.meas.nPixelsMeasured = Integer.parseInt(string);
                } else if (this.inCentre) {
                    string2 = "Centre";
                    String[] stringArray = string.split("\\,");
                    int n5 = stringArray.length;
                    if (2 != n5) {
                        throw new NumberFormatException();
                    }
                    this.meas.centre = new PointFloat(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]));
                } else if (this.inArea) {
                    string2 = "Area";
                    this.meas.area = Integer.parseInt(string);
                } else if (this.inMinX) {
                    string2 = "MinX";
                    this.meas.minX = Integer.parseInt(string);
                } else if (this.inMinY) {
                    string2 = "MinY";
                    this.meas.minY = Integer.parseInt(string);
                } else if (this.inMaxX) {
                    string2 = "MaxX";
                    this.meas.maxX = Integer.parseInt(string);
                } else if (this.inMaxY) {
                    string2 = "MaxY";
                    this.meas.maxY = Integer.parseInt(string);
                } else if (this.inPt) {
                    string2 = "Pt";
                    String[] stringArray = string.split("\\,");
                    int n6 = stringArray.length;
                    if (2 != n6) {
                        throw new NumberFormatException();
                    }
                    this.boundary.add(new Point(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])));
                } else if (this.inCommonId) {
                    this.star.setCommonId(string);
                } else if (this.inHipparcosId) {
                    this.star.setHipparcosId(string);
                } else if (this.inTychoId) {
                    this.star.setTychoId(string);
                } else if (this.inOtherId) {
                    this.star.setOtherId(string);
                } else if (this.inRA) {
                    string2 = "RA";
                    int n7 = Integer.parseInt(string.substring(0, 2));
                    int n8 = Integer.parseInt(string.substring(3, 5));
                    double d = Double.parseDouble(string.substring(6, 11));
                    this.ra = new RA((double)n7, (double)n8, d);
                } else if (this.inDec) {
                    string2 = "Dec";
                    int n9 = 1;
                    if (string.charAt(0) == '+') {
                        string = string.substring(1);
                    } else if (string.charAt(0) == '-') {
                        n9 = -1;
                        string = string.substring(1);
                    }
                    int n10 = Integer.parseInt(string.substring(0, 2));
                    int n11 = Integer.parseInt(string.substring(3, 5));
                    double d = Double.parseDouble(string.substring(6, 10));
                    this.dec = new Dec((double)(n9 * n10), (double)(n9 * n11), (double)n9 * d);
                } else if (this.inEpoch) {
                    string2 = "Epoch";
                    this.epoch = new Epoch(Float.parseFloat(string));
                } else if (this.inMag) {
                    string2 = "Mag";
                    this.mag = new Magnitude(Float.parseFloat(string));
                } else if (this.inBand) {
                    string2 = "Band";
                    this.bandId = string;
                } else if (this.inValue) {
                    string2 = "Value";
                    this.mag = new Magnitude(Float.parseFloat(string), this.bandId);
                    this.bandId = "";
                } else if (this.inVar) {
                    string2 = "Var";
                    if (string.equals("none")) {
                        this.star.setVariability(Variability.NONE);
                    } else if (string.startsWith("small")) {
                        this.star.setVariability(Variability.SMALL);
                    } else if (string.startsWith("medium")) {
                        this.star.setVariability(Variability.MEDIUM);
                    } else if (string.startsWith("large")) {
                        this.star.setVariability(Variability.LARGE);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Util.logWarning("Invalid value for <{0}> :{1}", string2, string);
            }
        }
    }
}

