/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.grelf.PointFloat;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.grip.Blob;
import net.grelf.grip.BlobFrame;
import net.grelf.grip.BlobMask;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.Bounds;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GlassPane;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.image.Image;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageBase;

public class Blob_
implements Blob,
Serializable {
    private static final int ROWS_LIST_CAPACITY = 100;
    private List<Point> boundary;
    private List<BlobRow> rows;
    private Blob brightnessDisc = null;
    private Blob backgroundDisc = null;
    private byte[][] brightnessMask = null;
    private boolean saturated;
    private static final byte B0 = 0;
    private static final byte B1 = 1;
    private static final byte B2 = 2;
    private static final byte B3 = 3;
    private static final byte[][] CODES = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 3, 1, 1, 1, 1, 3, 3, 3}, {0, 3, 1, 1, 1, 1, 2, 3, 3}, {0, 3, 1, 1, 1, 1, 2, 2, 3}, {0, 3, 1, 1, 1, 1, 2, 2, 2}, {0, 1, 3, 3, 3, 3, 1, 1, 1}, {0, 1, 2, 3, 3, 3, 1, 1, 1}, {0, 1, 2, 2, 3, 3, 1, 1, 1}, {0, 1, 2, 2, 2, 3, 1, 1, 1}};
    private static final double ROOT2 = StrictMath.sqrt(2.0);
    static final byte BACKGROUND_MASK = 1;
    static final byte BRIGHTNESS_MASK = 3;
    private int srcX0;
    private int srcY0;
    private int srcWd;
    private int srcHt;
    private float measuringRingSizeFactor = 1.0f;

    @Override
    public List<Point> getBoundary() {
        return this.boundary;
    }

    protected List<BlobRow> getRegion() {
        return this.rows;
    }

    protected void nullRows() {
        this.rows = null;
    }

    @Override
    public boolean hasRows() {
        return this.rows != null && this.rows.size() > 0;
    }

    @Override
    public Blob getBrightnessDisc() {
        return this.brightnessDisc;
    }

    @Override
    public Blob getBackgroundDisc() {
        return this.backgroundDisc;
    }

    @Override
    public boolean isSaturated() {
        return this.saturated;
    }

    public String toString() {
        if (null == this.boundary || 0 == this.boundary.size()) {
            return "Blob with no boundary points";
        }
        return "Blob starting at " + this.boundary.get(0).toString();
    }

    @Override
    public StringBuffer toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("<Blob>\n");
        stringBuffer.append(string);
        stringBuffer.append("\t<Boundary>\n");
        for (Point point : this.boundary) {
            stringBuffer.append(string);
            stringBuffer.append("\t\t<Pt>");
            stringBuffer.append(point.x);
            stringBuffer.append(",");
            stringBuffer.append(point.y);
            stringBuffer.append("</Pt>\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("\t</Boundary>\n");
        stringBuffer.append(string);
        stringBuffer.append("</Blob>\n");
        return stringBuffer;
    }

    @Override
    public List<PointFloat> getVerticalCentreLineFromBoundary() {
        int n;
        ArrayList<PointFloat> arrayList = new ArrayList<PointFloat>();
        int n2 = n = this.boundary.get((int)0).y;
        for (Point point : this.boundary) {
            if (point.y > n2) {
                n2 = point.y;
                continue;
            }
            if (point.y >= n) continue;
            n = point.y;
        }
        for (int i = n + 1; i < n2; ++i) {
            int n3 = -1;
            int n4 = -1;
            for (Point point : this.boundary) {
                if (point.y != i) continue;
                if (n3 == -1) {
                    n3 = point.x;
                    continue;
                }
                if (n4 == -1) {
                    n4 = point.x;
                    continue;
                }
                Util.logWarning("Cannot get vertical axis for the boundary");
            }
            if (n3 <= -1 || n4 <= -1) continue;
            float f = ((float)n3 + (float)n4) * 0.5f;
            arrayList.add(new PointFloat(f, i));
        }
        return arrayList;
    }

    @Override
    public List<PointFloat> getVerticalCentreLineFromRegion() {
        ArrayList<PointFloat> arrayList = new ArrayList<PointFloat>();
        for (BlobRow blobRow : this.rows) {
            float f = ((float)blobRow.x0 + (float)blobRow.x1) * 0.5f;
            float f2 = blobRow.y0;
            arrayList.add(new PointFloat(f, f2));
        }
        return arrayList;
    }

    private boolean nextActivePoint(Bounds bounds, byte[][] byArray, Point point) {
        byte by = 0;
        do {
            if (point.x < bounds.xMax) {
                ++point.x;
                continue;
            }
            if (point.y < bounds.yMax) {
                point.x = bounds.xMin;
                ++point.y;
                continue;
            }
            return false;
        } while ((by = byArray[point.x][point.y]) != 1 && by != 2);
        return true;
    }

    public Blob_(List<Point> list, byte[][] byArray) {
        int n;
        int n2;
        int n3;
        Point point2;
        this.boundary = list;
        this.rows = new ArrayList<BlobRow>(100);
        Bounds bounds = this.getBounds();
        for (Point point2 : this.boundary) {
            byArray[point2.x][point2.y] = 3;
        }
        int n4 = this.boundary.size() - 1;
        point2 = this.boundary.get(n4 - 1);
        Point point3 = this.boundary.get(0);
        int n5 = Blob_.getDirection(point2, point3);
        for (int i = 0; i < n4; ++i) {
            Point point4 = this.boundary.get(i);
            n3 = Blob_.getDirection(point4, this.boundary.get(i + 1));
            n2 = CODES[n5][n3];
            if (n2 == 1) {
                n = byArray[point4.x][point4.y];
                n = n != 3 ? (int)(n + 1) : 1;
                byArray[point4.x][point4.y] = n;
            } else if (n2 == 2) {
                n = byArray[point4.x][point4.y];
                n = n != 3 ? (int)((byte)(n + 2)) : 2;
                byArray[point4.x][point4.y] = n;
            }
            n5 = n3;
        }
        Point point5 = new Point(bounds.xMin, bounds.yMin);
        boolean bl = true;
        n3 = point3.x;
        n2 = point3.y;
        do {
            if ((n = byArray[point5.x][point5.y]) != 1 && n != 2) continue;
            byArray[point5.x][point5.y] = 3;
            int n6 = point5.x;
            int n7 = point5.y;
            n3 = n6;
            n2 = n7;
            if (n == 1) {
                bl = this.nextActivePoint(bounds, byArray, point5);
                if (!bl) continue;
                byArray[point5.x][point5.y] = 3;
                if (n6 < point5.x) {
                    this.rows.add(new BlobRow(n6, n7, point5.x));
                } else {
                    this.rows.add(new BlobRow(point5.x, n7, n6));
                }
                n3 = point5.x;
                continue;
            }
            this.rows.add(new BlobRow(n6, n7, n6));
        } while (bl = this.nextActivePoint(bounds, byArray, point5));
    }

    public Blob_(int n, int n2) {
        this.boundary = new ArrayList<Point>();
        this.boundary.add(new Point(n, n2));
        this.rows = new ArrayList<BlobRow>();
        this.rows.add(new BlobRow(n, n2, n));
    }

    @Override
    public void erase(byte[][] byArray) {
        for (BlobRow blobRow : this.rows) {
            for (int i = blobRow.x0; i <= blobRow.x1; ++i) {
                byArray[i][blobRow.y0] = 0;
            }
        }
    }

    @Override
    public Bounds getBounds() {
        if (0 < this.boundary.size()) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            boolean bl = true;
            for (Point point : this.boundary) {
                if (bl) {
                    n = point.x;
                    n2 = point.x;
                    n3 = point.y;
                    n4 = point.y;
                    bl = false;
                    continue;
                }
                if (point.x < n) {
                    n = point.x;
                } else if (point.x > n2) {
                    n2 = point.x;
                }
                if (point.y < n3) {
                    n3 = point.y;
                    continue;
                }
                if (point.y <= n4) continue;
                n4 = point.y;
            }
            return new Bounds(n, n2, n3, n4);
        }
        return null;
    }

    @Override
    public void drawBoundary(BufferedImage bufferedImage, int[] nArray) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (Point point : this.boundary) {
            writableRaster.setPixel(point.x, point.y, nArray);
        }
    }

    @Override
    public void drawBoundary(byte[][] byArray, byte by) {
        for (Point point : this.boundary) {
            byArray[point.x][point.y] = by;
        }
    }

    @Override
    public void drawRegion(BufferedImage bufferedImage, int[] nArray) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (BlobRow blobRow : this.rows) {
            for (int i = blobRow.x0; i <= blobRow.x1; ++i) {
                writableRaster.setPixel(i, blobRow.y0, nArray);
            }
        }
    }

    @Override
    public void drawRegion(byte[][] byArray, byte by) {
        for (BlobRow blobRow : this.rows) {
            for (int i = blobRow.x0; i <= blobRow.x1; ++i) {
                byArray[i][blobRow.y0] = by;
            }
        }
    }

    @Override
    public int[] brightness(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = Image8or16Base.getNBands(bufferedImage);
        int[] nArray = new int[n];
        int[] nArray2 = new int[]{0, 0, 0};
        for (BlobRow blobRow : this.rows) {
            for (int i = blobRow.x0; i <= blobRow.x1; ++i) {
                writableRaster.getPixel(i, blobRow.y0, nArray);
                for (int j = 0; j < n; ++j) {
                    int n2 = j;
                    nArray2[n2] = nArray2[n2] + nArray[j];
                }
            }
        }
        return nArray2;
    }

    @Override
    public int area() {
        int n = 0;
        for (BlobRow blobRow : this.rows) {
            n += blobRow.x1 - blobRow.x0 + 1;
        }
        return n;
    }

    @Override
    public double perimeter() {
        double d = 0.0;
        boolean bl = true;
        Point point = null;
        for (Point point2 : this.boundary) {
            if (bl) {
                bl = false;
            } else {
                d = point2.x == point.x || point2.y == point.y ? (d += 1.0) : (d += ROOT2);
            }
            point = point2;
        }
        return d;
    }

    @Override
    public PointFloat maskCentre() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (BlobRow blobRow : this.rows) {
            for (int i = blobRow.x0; i <= blobRow.x1; ++i) {
                n += i;
                n2 += blobRow.y0;
                ++n3;
            }
        }
        return new PointFloat((float)n / (float)n3, (float)n2 / (float)n3);
    }

    @Override
    public PointFloat densityCentre(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = Image8or16Base.getNBands(bufferedImage);
        int[] nArray = new int[n];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (BlobRow blobRow : this.rows) {
            for (int i = blobRow.x0; i <= blobRow.x1; ++i) {
                writableRaster.getPixel(i, blobRow.y0, nArray);
                int n2 = 0;
                for (int j = 0; j < n; ++j) {
                    n2 += nArray[j];
                }
                double d4 = (double)n2 / (double)n;
                d += (double)i * d4;
                d2 += (double)blobRow.y0 * d4;
                d3 += d4;
            }
        }
        float f = (float)d3;
        return new PointFloat((float)d / f, (float)d2 / f);
    }

    @Override
    public BlobMeas measure(Image image) {
        int n;
        BlobMeas blobMeas = new BlobMeas();
        int n2 = image.getNBands();
        long[] lArray = new long[n2];
        for (n = 0; n < n2; ++n) {
            lArray[n] = 0L;
        }
        n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        boolean bl = true;
        for (BlobRow blobRow : this.rows) {
            if (bl) {
                blobMeas.minX = blobRow.x0;
                blobMeas.maxX = blobRow.x1;
                blobMeas.minY = blobRow.y0;
                blobMeas.maxY = blobRow.y0;
                bl = false;
            } else {
                if (blobRow.x0 < blobMeas.minX) {
                    blobMeas.minX = blobRow.x0;
                }
                if (blobRow.x1 > blobMeas.maxX) {
                    blobMeas.maxX = blobRow.x1;
                }
                if (blobRow.y0 > blobMeas.maxY) {
                    blobMeas.maxY = blobRow.y0;
                }
            }
            for (int i = blobRow.x0; i <= blobRow.x1; ++i) {
                int[] nArray = image.getPixel(i, blobRow.y0);
                double d6 = 0.0;
                for (int j = 0; j < n2; ++j) {
                    int n3 = j;
                    lArray[n3] = lArray[n3] + (long)nArray[j];
                    d6 += (double)nArray[j] * (double)nArray[j];
                }
                d6 = Math.sqrt(d6);
                d += d6;
                d2 += (double)i;
                d3 += d6 * (double)i;
                d4 += (double)blobRow.y0;
                d5 += d6 * (double)blobRow.y0;
                ++n;
            }
        }
        blobMeas.area = n;
        blobMeas.blob = this;
        blobMeas.brightness = d;
        blobMeas.channelBrightnesses = lArray;
        blobMeas.centre = d > 0.0 ? new PointFloat((float)(d3 / d), (float)(d5 / d)) : new PointFloat((float)(d2 / (double)n), (float)(d4 / (double)n));
        return blobMeas;
    }

    @Override
    public void remeasureAccurately(BlobMeas blobMeas, ImFrame imFrame) {
        int n = blobMeas.maxX - blobMeas.minX + 1;
        int n2 = blobMeas.maxY - blobMeas.minY + 1;
        int n3 = Math.round(0.5f * this.measuringRingSizeFactor * (float)Math.max(n, n2));
        int n4 = n3 * 2;
        int n5 = 2 * n4;
        int n6 = (int)blobMeas.centre.x;
        int n7 = (int)blobMeas.centre.y;
        this.srcWd = n + 2 * n5;
        this.srcHt = n2 + 2 * n5;
        this.srcX0 = n6 - this.srcWd / 2;
        this.srcY0 = n7 - this.srcHt / 2;
        this.brightnessMask = new byte[this.srcWd + 1][this.srcHt + 1];
        this.backgroundDisc = this.getDisc(3 * n3, this.srcWd, this.srcHt, (byte)1);
        this.brightnessDisc = this.getDisc(2 * n3, this.srcWd, this.srcHt, (byte)3);
        this.measureAccurately(blobMeas, imFrame);
    }

    @Override
    public void measureAccurately(BlobMeas blobMeas, ImFrame imFrame) {
        Image image = imFrame.getImPane().getImage();
        this.measureAccurately(blobMeas, image);
    }

    @Override
    public void measureAccurately(BlobMeas blobMeas, Image image) {
        int n;
        int[] nArray;
        byte by;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = image.getNBands();
        int n7 = image.getRange().high;
        blobMeas.accurateBrightnesses = new long[n6];
        blobMeas.backgroundStatistics = new Statistics[n6];
        blobMeas.snRatios = new float[n6];
        int n8 = 0;
        int n9 = 0;
        int[][] nArray2 = new int[n6][n7 + 1];
        long[] lArray = new long[n6];
        long[] lArray2 = new long[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            for (n4 = 0; n4 < n7; ++n4) {
                nArray2[n5][n4] = 0;
            }
            lArray[n5] = 0L;
        }
        n5 = 0;
        n4 = this.srcY0;
        while (n5 < this.srcHt) {
            n3 = 0;
            n2 = this.srcX0;
            while (n3 < this.srcWd) {
                by = this.brightnessMask[n3][n5];
                nArray = image.getPixel(n2, n4);
                if (1 == by) {
                    ++n8;
                    for (n = 0; n < n6; ++n) {
                        int n10 = n;
                        lArray2[n10] = lArray2[n10] + (long)nArray[n];
                        int[] nArray3 = nArray2[n];
                        int n11 = nArray[n];
                        nArray3[n11] = nArray3[n11] + 1;
                    }
                }
                ++n3;
                ++n2;
            }
            for (n3 = 0; n3 < n6; ++n3) {
                blobMeas.backgroundStatistics[n3] = new Statistics(nArray2[n3], 0, n7);
            }
            ++n5;
            ++n4;
        }
        n5 = 0;
        n4 = this.srcY0;
        while (n5 < this.srcHt) {
            n3 = 0;
            n2 = this.srcX0;
            while (n3 < this.srcWd) {
                by = this.brightnessMask[n3][n5];
                if (3 == by) {
                    ++n9;
                    nArray = image.getPixel(n2, n4);
                    for (n = 0; n < n6; ++n) {
                        int n12 = n;
                        lArray[n12] = lArray[n12] + (long)nArray[n];
                    }
                }
                ++n3;
                ++n2;
            }
            ++n5;
            ++n4;
        }
        n5 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            blobMeas.accurateBrightnesses[n4] = lArray[n4] - lArray2[n4] * (long)n9 / (long)n8;
            if (blobMeas.accurateBrightnesses[n4] < 0L) {
                n5 = 1;
            }
            blobMeas.snRatios[n4] = (float)blobMeas.accurateBrightnesses[n4] / (float)(blobMeas.backgroundStatistics[n4].stdDev * (double)n9);
        }
        blobMeas.nPixelsMeasured = n9;
        if (n5 != 0) {
            Util.warning("Negative brightness", "Suspect this image has been processed\nso that some blob pixels are darker\nthan the background");
        }
    }

    @Override
    public float getMeasuringRingSizeFactor() {
        return this.measuringRingSizeFactor;
    }

    @Override
    public void setMeasuringRingSizeFactor(float f) {
        this.measuringRingSizeFactor = f;
    }

    @Override
    public BlobFrame display(ImFrame imFrame, BlobMeas blobMeas) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = blobMeas.maxX - blobMeas.minX + 1;
        int n8 = blobMeas.maxY - blobMeas.minY + 1;
        int n9 = Math.round(0.5f * this.measuringRingSizeFactor * (float)Math.max(n7, n8));
        int n10 = n9 * 2;
        int n11 = 2 * n10;
        int n12 = (int)blobMeas.centre.x;
        int n13 = (int)blobMeas.centre.y;
        this.srcWd = n7 + 2 * n11;
        this.srcHt = n8 + 2 * n11;
        this.srcX0 = n12 - this.srcWd / 2;
        this.srcY0 = n13 - this.srcHt / 2;
        int n14 = 6;
        int n15 = this.srcWd * n14;
        int n16 = this.srcHt * n14;
        if (n15 > 800 || n16 > 800) {
            n6 = 1 + Math.max(n15 / 800, n16 / 800);
            n14 = 1 + n14 / n6;
            n15 = this.srcWd * n14;
            n16 = this.srcHt * n14;
        }
        n6 = n14 / 2;
        StringBuffer stringBuffer = new StringBuffer("@(");
        stringBuffer.append(n12);
        stringBuffer.append(", ");
        stringBuffer.append(n13);
        stringBuffer.append("), pixels x");
        stringBuffer.append(n14);
        BlobFrame blobFrame = new BlobFrame(stringBuffer.toString(), Math.max(n15, 250), Math.max(n16, 400), blobMeas, imFrame);
        ImPane imPane = imFrame.getImPane();
        Image image = imPane.getImage();
        int n17 = image.getNBands();
        int n18 = image.getRange().high;
        Image image2 = ImageBase.createImage(n15, n16, n17, image.getBitsPerChannel(), false, false);
        blobFrame.getImPane().setImage(image2);
        int n19 = n15 - n14 - 1;
        int n20 = n16 - n14 - 1;
        double d = image2.getRangeDouble().high / image.getRangeDouble().high;
        byte[][] byArray = new byte[n15][n16];
        int n21 = n14 - 1;
        this.saturated = false;
        int n22 = Math.round(blobMeas.centre.x);
        int n23 = Math.round(blobMeas.centre.y);
        int n24 = 0;
        for (n5 = blobMeas.minY - n11; n5 < image.getHeight() && n24 <= n20; ++n5, n24 += n14) {
            n4 = 0;
            for (n3 = blobMeas.minX - n11; n3 < image.getWidth() && n4 <= n19; ++n3, n4 += n14) {
                int n25;
                int[] nArray = image.getPixel(n3, n5);
                n2 = 1;
                for (n = 0; n < n17; ++n) {
                    if (nArray[n] < n18) {
                        n2 = 0;
                    }
                    nArray[n] = (int)((double)nArray[n] * d);
                }
                if (n2 != 0) {
                    if (Math.abs(n3 - n22) < 3 && Math.abs(n5 - n23) < 3) {
                        this.saturated = true;
                    }
                    for (n = 0; n < n14; ++n) {
                        for (n25 = 0; n25 < n14; ++n25) {
                            if (n25 > 0 && n25 < n21 && n > 0 && n < n21) {
                                byArray[n4 + n25][n24 + n] = 1;
                            }
                            image2.setPixel(n4 + n25, n24 + n, nArray);
                        }
                    }
                    continue;
                }
                for (n = 0; n < n14; ++n) {
                    for (n25 = 0; n25 < n14; ++n25) {
                        image2.setPixel(n4 + n25, n24 + n, nArray);
                    }
                }
            }
        }
        n24 = (n11 + n12 - blobMeas.minX) * n14 + n6;
        for (n5 = 0; n5 < n16; ++n5) {
            byArray[n24][n5] = 1;
        }
        n5 = (n11 + n13 - blobMeas.minY) * n14 + n6;
        for (n24 = 0; n24 < n15; ++n24) {
            byArray[n24][n5] = 1;
        }
        for (Point point : this.boundary) {
            n4 = (n11 + point.x - blobMeas.minX) * n14 + n6;
            n3 = (n11 + point.y - blobMeas.minY) * n14 + n6;
            for (n2 = n3 - 1; n2 <= n3 + 1; ++n2) {
                for (n = n4 - 1; n <= n4 + 1; ++n) {
                    byArray[n][n2] = 1;
                }
            }
        }
        this.brightnessMask = new byte[this.srcWd + 1][this.srcHt + 1];
        this.backgroundDisc = this.getDisc(3 * n9, this.srcWd, this.srcHt, (byte)1);
        for (Point point : this.backgroundDisc.getBoundary()) {
            n4 = point.x * n14 + n6;
            n3 = point.y * n14 + n6;
            byArray[n4][n3] = 1;
        }
        this.brightnessDisc = this.getDisc(2 * n9, this.srcWd, this.srcHt, (byte)3);
        for (Point point : this.brightnessDisc.getBoundary()) {
            n4 = point.x * n14 + n6;
            n3 = point.y * n14 + n6;
            byArray[n4][n3] = 1;
        }
        GlassPane glassPane = blobFrame.getImPane().getGlassPane();
        glassPane.setDrawingMode(DrawingMode.MASK);
        glassPane.setMask(new BlobMask(byArray));
        this.measureAccurately(blobMeas, imFrame);
        blobFrame.redisplay();
        return blobFrame;
    }

    private Blob getDisc(int n, int n2, int n3, byte by) {
        byte[][] byArray = new byte[n2][n3];
        BlobMask blobMask = new BlobMask(byArray);
        int n4 = n2 / 2;
        int n5 = n3 / 2;
        double d = n * n;
        int n6 = -n;
        int n7 = n5 - n;
        while (n6 <= n) {
            double d2 = d - (double)(n6 * n6);
            int n8 = -n;
            int n9 = n4 - n;
            while (n8 <= n) {
                if ((double)(n8 * n8) <= d2) {
                    byArray[n9][n7] = 3;
                    this.brightnessMask[n9][n7] = by;
                }
                ++n8;
                ++n9;
            }
            ++n6;
            ++n7;
        }
        List<Blob> list = blobMask.detectBlobs();
        if (1 != list.size()) {
            Util.logWarning("Should detect 1 blob but found {0}", list.size());
        }
        return list.get(0);
    }

    @Override
    public void translate(int n, int n2) {
        for (Point serializable : this.boundary) {
            serializable.x += n;
            serializable.y += n2;
        }
        if (null != this.rows) {
            for (BlobRow blobRow : this.rows) {
                blobRow.x0 += n;
                blobRow.x1 += n;
                blobRow.y0 += n2;
            }
        }
    }

    private static byte getDirection(Point point, Point point2) {
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        if (0 == n) {
            if (1 == n2) {
                return 3;
            }
            if (-1 == n2) {
                return 7;
            }
        }
        if (1 == n) {
            if (-1 == n2) {
                return 8;
            }
            if (0 == n2) {
                return 1;
            }
            if (1 == n2) {
                return 2;
            }
        }
        if (-1 == n) {
            if (-1 == n2) {
                return 6;
            }
            if (0 == n2) {
                return 5;
            }
            if (1 == n2) {
                return 4;
            }
        }
        Util.logWarning("Impossible boundary offset: dx = {0}, dy = {1}", n, n2);
        return -1;
    }

    protected static class BlobRow
    implements Serializable {
        public int x0;
        public int y0;
        public int x1;

        public BlobRow(int n, int n2, int n3) {
            this.x0 = n;
            this.y0 = n2;
            this.x1 = n3;
        }
    }
}

