/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import net.grelf.Util;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.PointList;
import net.grelf.image.HistogramAll;
import net.grelf.image.Image;
import net.grelf.image.Image32;
import net.grelf.image.Image64;
import net.grelf.image.Image8or16Base;
import net.grelf.image.RangeDouble;
import net.grelf.image.RangeInt;

public class Histogram
extends HistogramAll {
    public Histogram(Image image) {
        super(image);
    }

    public Histogram(Image image, PointList pointList, DrawingMode drawingMode) {
        if (DrawingMode.WHOLE == drawingMode) {
            this.buildData(image);
        } else {
            this.buildData(image, pointList, drawingMode);
        }
        Dimension dimension = new Dimension(340, 300);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    private void buildData(Image image, PointList pointList, DrawingMode drawingMode) {
        if (image instanceof Image8or16Base) {
            Image8or16Base image8or16Base = (Image8or16Base)image;
            BufferedImage bufferedImage = image8or16Base.getBufferedImage();
            this.nLevels = image8or16Base.getMaxLevel() + 1;
            this.xLabels = 8 == image8or16Base.getBitsPerChannel() ? new String[]{"0", "50", "100", "150", "200", "250"} : new String[]{"0", "13k", "26k", "38k", "51k", "64k"};
            this.nBands = image8or16Base.getNBands();
            this.freq = new int[this.nBands][this.nLevels + 1];
            this.fbin = new int[this.nBands][256];
            for (int i = 0; i < this.nLevels; ++i) {
                for (int j = 0; j < this.nBands; ++j) {
                    this.freq[j][i] = 0;
                }
            }
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[this.nBands];
            Point point = null;
            Point point2 = null;
            switch (drawingMode) {
                case CLOSED_CURVE: {
                    int n = pointList.size();
                    int[] nArray2 = new int[n];
                    int[] nArray3 = new int[n];
                    nArray2[0] = pointList.get((int)0).x;
                    nArray3[0] = pointList.get((int)0).y;
                    int n2 = nArray2[0];
                    int n3 = nArray2[0];
                    int n4 = nArray3[0];
                    int n5 = nArray3[0];
                    for (int i = 1; i < n; ++i) {
                        nArray2[i] = pointList.get((int)i).x;
                        nArray3[i] = pointList.get((int)i).y;
                        if (nArray2[i] < n2) {
                            n2 = nArray2[i];
                        } else if (nArray2[i] > n3) {
                            n3 = nArray2[i];
                        }
                        if (nArray3[i] < n4) {
                            n4 = nArray3[i];
                            continue;
                        }
                        if (nArray3[i] <= n5) continue;
                        n5 = nArray3[i];
                    }
                    Polygon polygon = new Polygon(nArray2, nArray3, n);
                    for (int i = n2; i <= n3; ++i) {
                        for (int j = n4; j <= n5; ++j) {
                            if (!polygon.contains(i, j)) continue;
                            writableRaster.getPixel(i, j, nArray);
                            for (int k = 0; k < this.nBands; ++k) {
                                int[] nArray4 = this.freq[k];
                                int n6 = nArray[k];
                                nArray4[n6] = nArray4[n6] + 1;
                            }
                        }
                    }
                    this.reBin();
                    break;
                }
                case RECTANGLE: {
                    if (null != pointList && 2 <= pointList.size()) {
                        point = pointList.get(0);
                        point2 = pointList.get(1);
                        for (int i = point.y; i <= point2.y; ++i) {
                            for (int j = point.x; j <= point2.x; ++j) {
                                writableRaster.getPixel(j, i, nArray);
                                for (int k = 0; k < this.nBands; ++k) {
                                    int[] nArray5 = this.freq[k];
                                    int n = nArray[k];
                                    nArray5[n] = nArray5[n] + 1;
                                }
                            }
                        }
                        this.reBin();
                        break;
                    }
                    Util.warning("Error", "Histogram: rectangle not set");
                    break;
                }
                default: {
                    Util.warning("Error", "Not possible to construct Histogram for pointset mode " + drawingMode.toString());
                    break;
                }
            }
        } else if (image instanceof Image32) {
            Image32 image32 = (Image32)image;
            RangeInt rangeInt = image32.getRangeByRescanning();
            this.nLevels = rangeInt.high + 1;
            if (this.nLevels > MAX_NLEVELS) {
                this.scale = this.nLevels / MAX_NLEVELS + 1;
                this.nLevels /= this.scale;
            }
            this.xLabels = new String[6];
            int n = rangeInt.high / 5;
            int n7 = 0;
            int n8 = 0;
            while (n7 < 6) {
                this.xLabels[n7] = "" + n8 / 1000 + "k";
                ++n7;
                n8 += n;
            }
            this.nBands = image32.getNBands();
            this.freq = new int[this.nBands][this.nLevels + 1];
            this.fbin = new int[this.nBands][256];
            for (n7 = 0; n7 < this.nLevels + 1; ++n7) {
                for (n8 = 0; n8 < this.nBands; ++n8) {
                    this.freq[n8][n7] = 0;
                }
            }
            int[] nArray = new int[this.nBands];
            Point point = null;
            Point point3 = null;
            switch (drawingMode) {
                case CLOSED_CURVE: {
                    int n9 = pointList.size();
                    int[] nArray6 = new int[n9];
                    int[] nArray7 = new int[n9];
                    nArray6[0] = pointList.get((int)0).x;
                    nArray7[0] = pointList.get((int)0).y;
                    int n10 = nArray6[0];
                    int n11 = nArray6[0];
                    int n12 = nArray7[0];
                    int n13 = nArray7[0];
                    for (int i = 1; i < n9; ++i) {
                        nArray6[i] = pointList.get((int)i).x;
                        nArray7[i] = pointList.get((int)i).y;
                        if (nArray6[i] < n10) {
                            n10 = nArray6[i];
                        } else if (nArray6[i] > n11) {
                            n11 = nArray6[i];
                        }
                        if (nArray7[i] < n12) {
                            n12 = nArray7[i];
                            continue;
                        }
                        if (nArray7[i] <= n13) continue;
                        n13 = nArray7[i];
                    }
                    Polygon polygon = new Polygon(nArray6, nArray7, n9);
                    for (int i = n10; i <= n11; ++i) {
                        for (int j = n12; j <= n13; ++j) {
                            if (!polygon.contains(i, j)) continue;
                            nArray = image32.getPixel(i, j);
                            for (int k = 0; k < this.nBands; ++k) {
                                int[] nArray8 = this.freq[k];
                                int n14 = nArray[k] / this.scale;
                                nArray8[n14] = nArray8[n14] + 1;
                            }
                        }
                    }
                    this.reBin();
                    break;
                }
                case RECTANGLE: {
                    if (null != pointList && 2 <= pointList.size()) {
                        point = pointList.get(0);
                        point3 = pointList.get(1);
                        for (int i = point.y; i <= point3.y; ++i) {
                            for (int j = point.x; j <= point3.x; ++j) {
                                nArray = image32.getPixel(j, i);
                                for (int k = 0; k < this.nBands; ++k) {
                                    int[] nArray9 = this.freq[k];
                                    int n15 = nArray[k] / this.scale;
                                    nArray9[n15] = nArray9[n15] + 1;
                                }
                            }
                        }
                        this.reBin();
                        break;
                    }
                    Util.warning("Error", "Histogram: rectangle not set");
                    break;
                }
                default: {
                    Util.warning("Error", "Not possible to construct Histogram for pointset mode " + drawingMode.toString());
                    break;
                }
            }
        } else if (image instanceof Image64) {
            Image64 image64 = (Image64)image;
            RangeDouble rangeDouble = image64.getRangeDouble();
            if (rangeDouble.low < 0.0) {
                image64.add(-rangeDouble.low);
                rangeDouble.high -= rangeDouble.low;
                rangeDouble.low = 0.0;
            }
            if (rangeDouble.high + 1.0 > (double)MAX_NLEVELS) {
                this.scale = 1 + (int)((rangeDouble.high + 1.0) / (double)MAX_NLEVELS);
                this.nLevels = (int)((rangeDouble.high + 1.0) / (double)this.scale);
            } else {
                this.nLevels = (int)rangeDouble.high + 1;
            }
            this.xLabels = new String[6];
            int n = (int)((rangeDouble.high - rangeDouble.low) / 5.0);
            int n16 = 0;
            int n17 = (int)rangeDouble.low;
            while (n16 < 6) {
                this.xLabels[n16] = "" + n17 / 1000 + "k";
                ++n16;
                n17 += n;
            }
            this.nBands = image64.getNBands();
            this.freq = new int[this.nBands][this.nLevels + 1];
            this.fbin = new int[this.nBands][256];
            n16 = 0;
            for (n17 = 0; n17 < this.nLevels + 1; ++n17) {
                for (int i = 0; i < this.nBands; ++i) {
                    this.freq[i][n17] = 0;
                }
            }
            double[] dArray = new double[this.nBands];
            Point point = null;
            Point point4 = null;
            switch (drawingMode) {
                case CLOSED_CURVE: {
                    int n18 = pointList.size();
                    int[] nArray = new int[n18];
                    int[] nArray10 = new int[n18];
                    nArray[0] = pointList.get((int)0).x;
                    nArray10[0] = pointList.get((int)0).y;
                    int n19 = nArray[0];
                    int n20 = nArray[0];
                    int n21 = nArray10[0];
                    int n22 = nArray10[0];
                    for (int i = 1; i < n18; ++i) {
                        nArray[i] = pointList.get((int)i).x;
                        nArray10[i] = pointList.get((int)i).y;
                        if (nArray[i] < n19) {
                            n19 = nArray[i];
                        } else if (nArray[i] > n20) {
                            n20 = nArray[i];
                        }
                        if (nArray10[i] < n21) {
                            n21 = nArray10[i];
                            continue;
                        }
                        if (nArray10[i] <= n22) continue;
                        n22 = nArray10[i];
                    }
                    Polygon polygon = new Polygon(nArray, nArray10, n18);
                    for (int i = n19; i <= n20; ++i) {
                        for (int j = n21; j <= n22; ++j) {
                            if (!polygon.contains(i, j)) continue;
                            dArray = image64.getPixelDouble(i, j);
                            for (int k = 0; k < this.nBands; ++k) {
                                int n23 = (int)(dArray[k] / (double)this.scale);
                                if (n23 >= 0 && n23 <= this.nLevels) {
                                    int[] nArray11 = this.freq[k];
                                    int n24 = n23;
                                    nArray11[n24] = nArray11[n24] + 1;
                                    continue;
                                }
                                n16 = 1;
                            }
                        }
                    }
                    this.reBin();
                    break;
                }
                case RECTANGLE: {
                    if (null != pointList && 2 <= pointList.size()) {
                        point = pointList.get(0);
                        point4 = pointList.get(1);
                        for (int i = point.y; i <= point4.y; ++i) {
                            for (int j = point.x; j <= point4.x; ++j) {
                                dArray = image64.getPixelDouble(j, i);
                                for (int k = 0; k < this.nBands; ++k) {
                                    int n25 = (int)(dArray[k] / (double)this.scale);
                                    if (n25 >= 0 && n25 <= this.nLevels) {
                                        int[] nArray = this.freq[k];
                                        int n26 = n25;
                                        nArray[n26] = nArray[n26] + 1;
                                        continue;
                                    }
                                    n16 = 1;
                                }
                            }
                        }
                        this.reBin();
                    } else {
                        Util.warning("Error", "Histogram: rectangle not set");
                    }
                    if (n16 == 0) break;
                    Util.logWarning("Histogram freq index went out of range");
                    break;
                }
                default: {
                    Util.warning("Error", "Not possible to construct Histogram for pointset mode " + drawingMode.toString());
                }
            }
        }
    }

    public JFrame showInJFrame(String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.getContentPane().add(this);
        jFrame.setDefaultCloseOperation(2);
        jFrame.setSize(this.getWidth() + 6, this.getHeight() + 40);
        jFrame.setLocation(0, 0);
        ImageIcon imageIcon = GRIP.getIcon();
        if (null != imageIcon) {
            jFrame.setIconImage(imageIcon.getImage());
        }
        jFrame.setVisible(true);
        return jFrame;
    }
}

