/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.grelf.AbstractDialogue;
import net.grelf.Util;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPreview;
import net.grelf.grip.ImPreviewActor;
import net.grelf.image.Image;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Timer;

public class ImAddProportionDialogue
extends AbstractDialogue
implements ChangeListener,
ActionListener,
ImPreviewActor {
    private Image image1;
    private static Image image2;
    private JSlider slider;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel buttonPanel = new JPanel();
    private ImPreview imPreview;
    private int proportion = 50;
    private boolean accepted = false;

    public int getProportion() {
        return this.proportion;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public ImAddProportionDialogue(ImFrame imFrame, ImFrame imFrame2) {
        super((Frame)imFrame, "Adjust proportion to add the images");
        this.image1 = imFrame.getImPane().getImage();
        image2 = imFrame2.getImPane().getImage();
        this.proportion = 50;
        this.slider = new JSlider(0, 0, 100, this.proportion);
        this.slider.addChangeListener(this);
        this.slider.setMajorTickSpacing(20);
        this.slider.setMinorTickSpacing(5);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setValue(this.proportion);
        this.getContentPane().add((Component)this.slider, "Center");
        this.imPreview = new ImPreview(this.image1, this);
        this.getContentPane().add((Component)this.imPreview, "North");
        this.okButton.addActionListener(this);
        this.buttonPanel.add((Component)this.okButton, "West");
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add((Component)this.cancelButton, "East");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void previewAction(Image image, Image image2, Point point, int n, int n2) {
        ImAddProportionDialogue.add(image, image2, point, n, n2, this.proportion);
    }

    public static void add(Image image, Image image2, Point point, int n, int n2, int n3) {
        double d = (double)n3 / 100.0;
        double d2 = (double)(100 - n3) / 100.0;
        int n4 = image.getNBands();
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        double d3 = image.getRangeDouble().high;
        double d4 = ImAddProportionDialogue.image2.getRangeDouble().high;
        double d5 = image2.getRangeDouble().high;
        double d6 = d5 / (d * d3 + d2 * d4);
        int n5 = point.y - n2 / 2;
        for (int i = 0; i < n2; ++i) {
            int n6 = point.x - n / 2;
            for (int j = 0; j < n; ++j) {
                dArray = image.getPixelDouble(n6, n5);
                dArray2 = ImAddProportionDialogue.image2.getPixelDouble(n6, n5);
                for (int k = 0; k < n4; ++k) {
                    dArray3[k] = (int)(d6 * (dArray[k] * d + dArray2[k] * d2));
                }
                image2.setPixelDouble(j, i, dArray3);
                ++n6;
            }
            ++n5;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSlider) {
            this.proportion = ((JSlider)object).getValue();
            this.imPreview.refresh();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.accepted = true;
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.accepted = false;
            this.setVisible(false);
        }
    }

    public static int askProportion(ImFrame imFrame, ImFrame imFrame2) {
        if (imFrame.getImPane().getImage().getBitsPerChannel() != imFrame2.getImPane().getImage().getBitsPerChannel()) {
            Util.warning("Sorry", "Cannot combine images with differing\nnumber of bits per channel");
            return 0;
        }
        int n = 50;
        ImAddProportionDialogue imAddProportionDialogue = new ImAddProportionDialogue(imFrame, imFrame2);
        boolean bl = imAddProportionDialogue.isAccepted();
        if (bl) {
            imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            n = imAddProportionDialogue.getProportion();
            String string = "Add proportion [" + n + ":" + (100 - n) + "]";
            imFrame.addHistory(string);
            Timer timer = new Timer(string, imAddProportionDialogue.image1);
            imAddProportionDialogue.applyProportion(imAddProportionDialogue.image1, image2);
            timer.stop();
            imFrame.redisplay();
            imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
        imAddProportionDialogue.setVisible(false);
        imAddProportionDialogue.dispose();
        if (bl) {
            return n;
        }
        return -1;
    }

    private void applyProportion(Image image, Image image2) {
        double d = (double)this.proportion / 100.0;
        double d2 = (double)(100 - this.proportion) / 100.0;
        try {
            image.addProportion(image2, d, d2);
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.warning("Error", incompatibleImageException);
        }
    }
}

