/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.grelf.AbstractDialogue;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPreview;
import net.grelf.grip.ImPreviewActor;
import net.grelf.image.Image;

public class ImContourDialogue
extends AbstractDialogue
implements ActionListener,
ChangeListener,
ImPreviewActor {
    private int interval;
    private ImFrame parentFrame;
    private Image image;
    private int maxLevel;
    private int nBands;
    private JLabel intervalLabel = new JLabel();
    private JSlider intervalSlider;
    private JPanel sliderPanel = new JPanel();
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel buttonPanel = new JPanel();
    private ImPreview imPreview;
    private boolean accepted = false;

    public int getInterval() {
        return this.interval;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public ImContourDialogue(ImFrame imFrame) {
        super((Frame)imFrame, "Adjust contours");
        this.parentFrame = imFrame;
        this.image = imFrame.getImPane().getImage();
        this.maxLevel = this.image.getRange().high;
        this.nBands = this.image.getNBands();
        int n = 2;
        int n2 = 100;
        this.interval = n2 / 2;
        this.intervalSlider = new JSlider(0, n, n2, this.interval);
        this.intervalSlider.setMajorTickSpacing(n2 / 4);
        this.intervalSlider.setMinorTickSpacing(n2 / 20);
        this.intervalSlider.setPaintTicks(true);
        this.intervalSlider.setBackground(Color.gray);
        this.intervalSlider.addChangeListener(this);
        this.intervalLabel.setText("Interval " + this.format(this.interval));
        this.sliderPanel.setLayout(new BorderLayout());
        this.sliderPanel.add((Component)this.intervalSlider, "East");
        this.sliderPanel.add((Component)this.intervalLabel, "West");
        this.getContentPane().add((Component)this.sliderPanel, "Center");
        this.imPreview = new ImPreview(this.image, this);
        this.getContentPane().add((Component)this.imPreview, "North");
        this.buttonPanel.setLayout(new BorderLayout());
        this.okButton.addActionListener(this);
        this.buttonPanel.add((Component)this.okButton, "Center");
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add((Component)this.cancelButton, "East");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void previewAction(Image image, Image image2, Point point, int n, int n2) {
        int[] nArray = new int[this.nBands];
        int[] nArray2 = new int[this.nBands];
        if (1 == this.nBands) {
            nArray2[0] = 0;
        } else {
            nArray2[0] = this.maxLevel;
            for (int i = 1; i < this.nBands; ++i) {
                nArray2[i] = 0;
            }
        }
        double d = image.getRange().high;
        double d2 = image2.getRange().high;
        double d3 = d2 / d;
        long l = 0L;
        long l2 = this.interval * this.nBands;
        long l3 = l2 / 4L;
        int n3 = point.y - n2 / 2;
        for (int i = 0; i < n2; ++i) {
            int n4 = point.x - n / 2;
            for (int j = 0; j < n; ++j) {
                int n5;
                nArray = image.getPixel(n4, n3);
                l = 0L;
                for (n5 = 0; n5 < this.nBands; ++n5) {
                    l += (long)nArray[n5];
                }
                if (l % l2 < l3) {
                    image2.setPixel(j, i, nArray2);
                } else {
                    for (n5 = 0; n5 < this.nBands; ++n5) {
                        nArray[n5] = (int)(d3 * (double)nArray[n5]);
                    }
                    image2.setPixel(j, i, nArray);
                }
                ++n4;
            }
            ++n3;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.accepted = true;
            this.setVisible(false);
            int n = this.image.getWidth();
            int n2 = this.image.getHeight();
            Point point = new Point(n / 2, n2 / 2);
            this.previewAction(this.image, this.image, point, n, n2);
            this.parentFrame.redisplay();
        } else if (object == this.cancelButton) {
            this.accepted = false;
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.intervalSlider) {
            this.interval = this.intervalSlider.getValue();
            this.intervalLabel.setText("Interval " + this.format(this.interval));
        }
        this.imPreview.refresh();
    }

    private String format(int n) {
        if (n < 10) {
            return "      " + n + " ";
        }
        if (n < 100) {
            return "     " + n + " ";
        }
        if (n < 1000) {
            return "    " + n + " ";
        }
        if (n < 10000) {
            return "   " + n + " ";
        }
        if (n < 100000) {
            return "  " + n + " ";
        }
        return " " + n + " ";
    }

    public static int interact(ImFrame imFrame) {
        ImContourDialogue imContourDialogue = new ImContourDialogue(imFrame);
        int n = imContourDialogue.isAccepted() ? imContourDialogue.getInterval() : -1;
        imContourDialogue.setVisible(false);
        imContourDialogue.dispose();
        return n;
    }
}

