/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.grelf.PointFloat;
import net.grelf.Util;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.GRIP;
import net.grelf.grip.MatchPair;

public class MatchList {
    private List<MatchPair> list = new ArrayList<MatchPair>();

    public int size() {
        return this.list.size();
    }

    public MatchPair get(int n) {
        return this.list.get(n);
    }

    private MatchList() {
    }

    public boolean containsImage(int n) {
        for (MatchPair matchPair : this.list) {
            if (matchPair.imNo1 != n && matchPair.imNo2 != n) continue;
            return true;
        }
        return false;
    }

    public boolean containsImageAndBlob(int n, int n2) {
        for (MatchPair matchPair : this.list) {
            if ((matchPair.imNo1 != n || matchPair.blobNo1 != n2) && (matchPair.imNo2 != n || matchPair.blobNo2 != n2)) continue;
            return true;
        }
        return false;
    }

    public static List<MatchList> makeListOfLists(List<MatchPair> list, int n, int n2) {
        int n3;
        ArrayList<MatchList> arrayList = new ArrayList<MatchList>();
        int n4 = list.size();
        boolean[] blArray = new boolean[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            blArray[n3] = false;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (blArray[n3]) continue;
            MatchList matchList = null;
            MatchPair matchPair = list.get(n3);
            blArray[n3] = true;
            if (matchPair.blobNo1 < n && matchPair.blobNo2 < n) {
                if (null == matchList) {
                    matchList = new MatchList();
                }
                matchList.list.add(matchPair);
                for (int i = n3 + 1; i < n4; ++i) {
                    MatchPair matchPair2 = list.get(i);
                    if (matchPair.imNo2 != matchPair2.imNo1 || matchPair.blobNo2 != matchPair2.blobNo1 || matchPair2.blobNo2 >= n) continue;
                    if (blArray[i]) {
                        Util.logWarning("Converging MatchPair lists found");
                    }
                    matchList.list.add(matchPair2);
                    blArray[i] = true;
                    matchPair = matchPair2;
                }
            }
            if (null == matchList || !matchList.containsImage(n2)) continue;
            arrayList.add(matchList);
        }
        return arrayList;
    }

    public static void reportListOfLists(List<MatchList> list, BlobMeas[][] blobMeasArray, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println("list,i1,b1,x1,y1,i2,b2,x2,y2");
            for (int i = 0; i < list.size(); ++i) {
                MatchList matchList = list.get(i);
                for (int j = 0; j < matchList.size(); ++j) {
                    MatchPair matchPair = matchList.get(j);
                    PointFloat pointFloat = blobMeasArray[matchPair.imNo1][matchPair.blobNo1].centre;
                    PointFloat pointFloat2 = blobMeasArray[matchPair.imNo2][matchPair.blobNo2].centre;
                    printWriter.println(i + "," + matchPair.imNo1 + "," + matchPair.blobNo1 + "," + (int)pointFloat.x + "," + (int)pointFloat.y + "," + matchPair.imNo2 + "," + matchPair.blobNo2 + "," + (int)pointFloat2.x + "," + (int)pointFloat2.y);
                }
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            Util.warning(GRIP.getInstance(), "Error", (Object)iOException.toString());
        }
    }

    public static double[] getAverageShift(int n, int n2, List<MatchPair> list, BlobMeas[][] blobMeasArray, int n3) {
        int n4;
        ArrayList<MatchPair> arrayList = new ArrayList<MatchPair>();
        for (MatchPair matchPair : list) {
            MatchPair matchPair2;
            if (matchPair.blobNo1 >= n3 || matchPair.blobNo2 >= n3) continue;
            if (matchPair.imNo2 == n && null != (matchPair2 = MatchPair.findBlobInMiddleImage(n, n4 = matchPair.blobNo2, n2))) {
                arrayList.add(matchPair2);
            }
            if (matchPair.imNo1 != n || null == (matchPair2 = MatchPair.findBlobInMiddleImage(n, n4 = matchPair.blobNo1, n2))) continue;
            arrayList.add(matchPair2);
        }
        int n5 = arrayList.size();
        if (n5 == 0) {
            Util.warning("Error", "No relevant matches found for shifting image " + (n + 1));
            return null;
        }
        int n6 = 0;
        n4 = 0;
        for (int i = 0; i < n5; ++i) {
            MatchPair matchPair = (MatchPair)arrayList.get(i);
            PointFloat pointFloat = blobMeasArray[matchPair.imNo1][matchPair.blobNo1].centre;
            PointFloat pointFloat2 = blobMeasArray[matchPair.imNo2][matchPair.blobNo2].centre;
            int n7 = (int)pointFloat.x;
            int n8 = (int)pointFloat.y;
            int n9 = (int)pointFloat2.x;
            int n10 = (int)pointFloat2.y;
            n6 += n7 - n9;
            n4 += n8 - n10;
        }
        double d = (double)n6 / (double)n5;
        double d2 = (double)n4 / (double)n5;
        return new double[]{d, d2};
    }
}

