/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.grelf.Util;
import net.grelf.astro.Star;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.Calibrator;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.GlassPane;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.Hist3D_Pane;
import net.grelf.grip.ImFrame;
import net.grelf.grip.MeasurementTable;
import net.grelf.grip.PointList;
import net.grelf.grip.Prof3D_Pane;
import net.grelf.grip.StarChartFrame;

public class MeasurementMenu
extends JMenu
implements ActionListener,
MenuListener {
    private ImFrame imframe;
    private JMenuItem itemBlob;
    private JMenuItem itemReview;
    private JMenuItem itemCalibStar;
    private JMenuItem itemSpectrum;
    private JMenuItem item2DProf;
    private JMenuItem item3DHist;

    public MeasurementMenu(ImFrame imFrame) {
        super("Measure");
        this.imframe = imFrame;
        this.setMnemonic('M');
        this.add(Util.menuItem(this, "Hover and magnify", "meashover", 72, 72));
        this.add(Util.menuItem(this, "Single point data", "measpoint", 80, 0));
        this.itemBlob = Util.menuItem(this, "Blobs/stars separation data", "blobpair", 66, 66);
        this.add(this.itemBlob);
        this.add(Util.menuItem(this, "Straight line profile", "measline", 76, 0));
        this.add(Util.menuItem(this, "Curve (freehand) profile", "meascurve", 67, 0));
        this.add(Util.menuItem(this, "Area (freehand) histogram", "measarea", 65, 0));
        this.add(Util.menuItem(this, "Rectangle histogram", "measrect", 82, 0));
        this.add(Util.menuItem(this, "Whole image histogram", "measwhole", 87, 0));
        this.add(Util.menuItem(this, "Same shape as...", "measshape", 83, 0));
        this.add(Util.menuItem(this, "Move shape", "moveshape", 77, 0));
        this.addSeparator();
        this.itemReview = Util.menuItem(this, "Review last measurements", "measshow", 69, 0);
        this.add(this.itemReview);
        this.add(Util.menuItem(this, "Compare open images", "compare", 73, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Calibrate distance", "calibdist", 68, 0));
        this.itemCalibStar = Util.menuItem(this, "Calibrate on known stars", "calibstar", 75, 0);
        this.add(this.itemCalibStar);
        this.add(Util.menuItem(this, "View calibration", "viewcalib", 86, 0));
        this.add(Util.menuItem(this, "Same calibration as...", "copycalib", 78, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Clear overlay", "clear", 79, 0));
        this.add(Util.menuItem(this, "Draw overlay into new image", "draw", 89, 0));
        this.addSeparator();
        this.itemSpectrum = Util.menuItem(this, "Star spectrum", "spectrum", 84, 0);
        this.add(this.itemSpectrum);
        this.item2DProf = Util.menuItem(this, "2D profile", "2dprof", 50, 0);
        this.add(this.item2DProf);
        this.item3DHist = Util.menuItem(this, "3D histogram", "3dhist", 51, 0);
        this.add(this.item3DHist);
        this.addSeparator();
        this.add(Util.menuItem(this, "Help about this menu", "help", 0, 0));
        this.addMenuListener(this);
    }

    public void reviseSettings() {
        this.itemBlob.setEnabled(null != this.imframe.getBlobMeases() || this.imframe instanceof StarChartFrame && null != ((StarChartFrame)this.imframe).getStarChart());
        this.itemSpectrum.setEnabled(true);
        this.item2DProf.setEnabled(true);
        this.item3DHist.setEnabled(true);
        GlassPane glassPane = this.imframe.getImPane().getGlassPane();
        switch (glassPane.getDrawingMode()) {
            case CLOSED_CURVE: 
            case OPEN_CURVE: 
            case POINT: 
            case POINT_PAIR: 
            case RECTANGLE: 
            case WHOLE: {
                this.itemReview.setEnabled(true);
                break;
            }
            default: {
                this.itemReview.setEnabled(false);
            }
        }
        int n = 0;
        BlobMeasList blobMeasList = this.imframe.getBlobMeases();
        if (null != blobMeasList) {
            for (BlobMeas blobMeas : blobMeasList) {
                Star star = blobMeas.getStar();
                if (null == star || null == star.getPosition()) continue;
                ++n;
            }
        }
        this.itemCalibStar.setEnabled(n > 1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("2dprof")) {
            Prof3D_Pane.display(this.imframe);
        } else if (string.equals("3dhist")) {
            if (3 != this.imframe.getImPane().getImage().getNBands()) {
                Util.message("Sorry", "3D histogram is only for RGB images");
            } else {
                Hist3D_Pane.display(this.imframe);
            }
        } else if (string.equals("calibdist")) {
            this.imframe.addHistory("Calibrate distance");
            this.imframe.getGP().setMeasured(false);
            Calibrator.calibrate(this.imframe);
        } else if (string.equals("calibstar")) {
            this.imframe.addHistory("Calibrated on stars");
            Calibrator.calibrateOnStars(this.imframe);
        } else if (string.equals("clear")) {
            this.clearOverlay(this.imframe);
        } else if (string.equals("compare")) {
            this.imframe.addHistory("Compare measurements");
            new MeasurementTable(this.imframe);
        } else if (string.equals("copycalib")) {
            this.copyCalibrationFromOtherFrame(this.imframe);
        } else if (string.equals("draw")) {
            this.imframe.drawOverlay(true);
        } else if (string.equals("help")) {
            HelpMenu.help("pages/meas_menu.html");
        } else if (string.equals("blobpair")) {
            this.measureBetweenBlobs(this.imframe);
        } else if (string.equals("measarea")) {
            this.measureArea(this.imframe);
        } else if (string.equals("meascurve")) {
            this.measureCurve(this.imframe);
        } else if (string.equals("meashover")) {
            this.measureHovering(this.imframe);
        } else if (string.equals("measline")) {
            this.measureStraightLine(this.imframe);
        } else if (string.equals("measpoint")) {
            this.measurePoint(this.imframe);
        } else if (string.equals("measrect")) {
            this.measureRectangle(this.imframe);
        } else if (string.equals("measshape")) {
            this.measureSameShapeAsOtherFrame(this.imframe);
        } else if (string.equals("measshow")) {
            this.reviewLastMeasurements(this.imframe);
        } else if (string.equals("measwhole")) {
            this.measureWholeImage(this.imframe);
        } else if (string.equals("moveshape")) {
            this.moveShape(this.imframe);
        } else if (string.equals("spectrum")) {
            this.imframe.analyseAsSpectrum();
        } else if (string.equals("viewcalib")) {
            Calibrator.show(this.imframe);
        }
    }

    public void clearOverlay(ImFrame imFrame) {
        imFrame.addHistory("Clear overlay");
        imFrame.getGP().setDrawingMode(DrawingMode.UNDEFINED);
        imFrame.popCaption();
    }

    /*
     * WARNING - void declaration
     */
    public void copyCalibrationFromOtherFrame(ImFrame imFrame) {
        List<ImFrame> list = GRIP.getImFramesList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ImFrame objectArray : list) {
            if (objectArray == imFrame || !objectArray.getImPane().getImage().getCalibration().isCalibrated()) continue;
            arrayList.add(objectArray.getCaption());
        }
        Object object = null;
        if (0 == arrayList.size()) {
            Util.warning("Sorry", "No other frames have been calibrated");
        } else if (1 == arrayList.size()) {
            void var5_7;
            boolean i = false;
            while (var5_7 < list.size()) {
                if (((String)arrayList.get(0)).equals(list.get((int)var5_7).getCaption())) {
                    if (!Util.confirm(imFrame, "Use same calibration as...", "...set in " + (String)arrayList.get(0) + "?")) break;
                    object = list.get((int)var5_7);
                    break;
                }
                ++var5_7;
            }
        } else {
            Object[] objectArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                objectArray[i] = (String)arrayList.get(i);
            }
            String string = (String)JOptionPane.showInputDialog(imFrame, "Use same calibration as...", "Choose an image frame", 3, null, objectArray, objectArray[0]);
            if (null != string) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!string.equals(list.get(i).getCaption())) continue;
                    object = list.get(i);
                    break;
                }
            }
        }
        if (null != object) {
            imFrame.addHistory("Copy calibration");
            imFrame.getImPane().getImage().setCalibration(((ImFrame)object).getImPane().getImage().getCalibration());
        }
    }

    @Deprecated
    public void drawOverlay(ImFrame imFrame) {
        imFrame.drawOverlay(false);
    }

    public void measureArea(ImFrame imFrame) {
        imFrame.addHistory("Measure freehand area");
        imFrame.getGP().setMeasured(false);
        imFrame.pushCaption();
        GlassPane glassPane = imFrame.getImPane().getGlassPane();
        glassPane.setDrawingMode(DrawingMode.CLOSED_CURVE);
        imFrame.setTitle("Drag mouse to draw outline, auto-closes at end");
    }

    public void measureBetweenBlobs(ImFrame imFrame) {
        imFrame.addHistory("Measure between blobs/stars");
        imFrame.getGP().setMeasured(false);
        imFrame.pushCaption();
        GlassPane glassPane = imFrame.getImPane().getGlassPane();
        if (null != imFrame.getBlobMeases()) {
            glassPane.setDrawingMode(DrawingMode.BLOB_PAIR);
        } else if (imFrame instanceof StarChartFrame && null != ((StarChartFrame)imFrame).getStarChart()) {
            glassPane.setDrawingMode(DrawingMode.STAR_PAIR);
        } else {
            Util.logWarning("User was able to select Measure between blobs/stars but could not find blobs or stars");
            return;
        }
        imFrame.setTitle("Click to set line ends on nearest blobs/stars");
    }

    public void measureCurve(ImFrame imFrame) {
        imFrame.addHistory("Measure freehand curve");
        imFrame.getGP().setMeasured(false);
        imFrame.pushCaption();
        GlassPane glassPane = imFrame.getImPane().getGlassPane();
        glassPane.setDrawingMode(DrawingMode.OPEN_CURVE);
        imFrame.setTitle("Drag mouse to draw curve");
    }

    public void measureHovering(ImFrame imFrame) {
        imFrame.getGP().setMeasured(false);
        imFrame.pushCaption();
        GlassPane glassPane = imFrame.getImPane().getGlassPane();
        glassPane.setDrawingMode(DrawingMode.HOVER);
        imFrame.setTitle("Mouse over image to see values. Click magnifies");
    }

    public void measurePoint(ImFrame imFrame) {
        imFrame.addHistory("Measure single point");
        imFrame.getGP().setMeasured(false);
        imFrame.pushCaption();
        GlassPane glassPane = imFrame.getImPane().getGlassPane();
        glassPane.setDrawingMode(DrawingMode.POINT);
        imFrame.setTitle("Click to set a single point");
    }

    public void measureRectangle(ImFrame imFrame) {
        imFrame.addHistory("Measure rectangle");
        imFrame.getGP().setMeasured(false);
        imFrame.pushCaption();
        GlassPane glassPane = imFrame.getImPane().getGlassPane();
        glassPane.setDrawingMode(DrawingMode.RECTANGLE);
        imFrame.setTitle("Click to set rectangle corners (Ctrl for square)");
    }

    /*
     * WARNING - void declaration
     */
    public void measureSameShapeAsOtherFrame(ImFrame imFrame) {
        Object object;
        List<ImFrame> list = GRIP.getImFramesList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ImFrame objectArray : list) {
            if (objectArray == imFrame || null == ((GlassPane)(object = objectArray.getGP())).getPoints()) continue;
            arrayList.add(objectArray.getCaption());
        }
        Object object2 = null;
        if (0 == arrayList.size()) {
            Util.warning("Sorry", "No other frames have got measurements");
        } else if (1 == arrayList.size()) {
            void glassPane;
            boolean i = false;
            while (glassPane < list.size()) {
                if (((String)arrayList.get(0)).equals(list.get((int)glassPane).getCaption())) {
                    if (!Util.confirm(imFrame, "Measure same shape as...", "...measured in " + (String)arrayList.get(0) + "?")) break;
                    object2 = list.get((int)glassPane);
                    break;
                }
                ++glassPane;
            }
        } else {
            Object[] objectArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                objectArray[i] = (String)arrayList.get(i);
            }
            object = (String)JOptionPane.showInputDialog(imFrame, "Measure same shape as...", "Choose an image frame", 3, null, objectArray, objectArray[0]);
            if (null != object) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)object).equals(list.get(i).getCaption())) continue;
                    object2 = list.get(i);
                    break;
                }
            }
        }
        if (null != object2) {
            GlassPane glassPane = ((ImFrame)object2).getGP();
            object = glassPane.getDrawingMode();
            PointList pointList = glassPane.getPoints();
            GlassPane glassPane2 = imFrame.getGP();
            glassPane2.setDrawingMode((DrawingMode)((Object)object));
            glassPane2.setPoints(new PointList(pointList));
            PointList pointList2 = glassPane2.getPoints();
            switch (1.$SwitchMap$net$grelf$grip$DrawingMode[((Enum)object).ordinal()]) {
                case 3: {
                    pointList2.measurePoint(imFrame);
                    break;
                }
                case 4: {
                    pointList2.measureLine(imFrame);
                    break;
                }
                case 5: {
                    pointList2.measureRectangle(imFrame);
                    break;
                }
                case 2: {
                    pointList2.measureCurve(imFrame);
                    break;
                }
                case 1: {
                    pointList2.measureArea(imFrame);
                    break;
                }
                case 6: {
                    pointList2.measureWhole(imFrame);
                }
            }
        }
    }

    public void measureStraightLine(ImFrame imFrame) {
        imFrame.addHistory("Measure straight line");
        imFrame.getGP().setMeasured(false);
        imFrame.pushCaption();
        GlassPane glassPane = imFrame.getImPane().getGlassPane();
        glassPane.setDrawingMode(DrawingMode.POINT_PAIR);
        imFrame.setTitle("Click to set line end points");
    }

    public void measureWholeImage(ImFrame imFrame) {
        imFrame.addHistory("Measure whole image");
        imFrame.getGP().setMeasured(false);
        imFrame.pushCaption();
        GlassPane glassPane = imFrame.getImPane().getGlassPane();
        glassPane.setDrawingMode(DrawingMode.WHOLE);
        imFrame.setTitle("Measuring whole image");
        glassPane.getPoints().measureWhole(imFrame);
        imFrame.popCaption();
        glassPane.setMeasured(true);
    }

    public void moveShape(ImFrame imFrame) {
        GlassPane glassPane = imFrame.getGP();
        PointList pointList = glassPane.getPoints();
        if (null != pointList && 0 < pointList.size()) {
            imFrame.addHistory("Move shape");
            glassPane.setMeasured(false);
            imFrame.pushCaption();
            glassPane.pushDrawingMode();
            glassPane.setDrawingMode(DrawingMode.MOVE);
            imFrame.setTitle("Click and drag shape; release to measure");
        } else {
            Util.warning("Sorry", "There is no measuring shape you could move");
        }
    }

    public void reviewLastMeasurements(ImFrame imFrame) {
        GlassPane glassPane = imFrame.getImPane().getGlassPane();
        PointList pointList = glassPane.getPoints();
        if (pointList != null) {
            switch (glassPane.getDrawingMode()) {
                case BLOB_PAIR: {
                    pointList.measureBlobLine(imFrame);
                    break;
                }
                case CLOSED_CURVE: {
                    pointList.measureArea(imFrame);
                    break;
                }
                case OPEN_CURVE: {
                    pointList.measureCurve(imFrame);
                    break;
                }
                case POINT: {
                    pointList.measurePoint(imFrame);
                    break;
                }
                case POINT_PAIR: {
                    pointList.measureLine(imFrame);
                    break;
                }
                case RECTANGLE: {
                    pointList.measureRectangle(imFrame);
                    break;
                }
                case STAR_PAIR: {
                    pointList.measureStarLine(imFrame);
                    break;
                }
                case WHOLE: {
                    pointList.measureWhole(imFrame);
                }
            }
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        this.reviseSettings();
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }
}

