/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.grelf.grip.BlobMask;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.GlassPane;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.image.Image;
import net.grelf.image.Image32;
import net.grelf.image.Image64;
import net.grelf.image.Image8or16Base;
import net.grelf.image.Timer;

public class StarSegmenter {
    private static final double RECIPROCAL_ROOT2 = 1.0 / Math.sqrt(2.0);

    public static void segment(ImFrame imFrame, int n, int n2) {
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        ImPane imPane = imFrame.getImPane();
        Image image = imPane.getImage();
        BlobMask blobMask = null;
        if (image instanceof Image8or16Base) {
            blobMask = StarSegmenter.segment((Image8or16Base)image, n, n2);
        } else if (image instanceof Image32) {
            blobMask = StarSegmenter.segment((Image32)image, n, n2);
        } else if (image instanceof Image64) {
            blobMask = StarSegmenter.segment((Image64)image, n, n2);
        }
        GlassPane glassPane = imPane.getGlassPane();
        glassPane.setDrawingMode(DrawingMode.MASK);
        glassPane.setMask(blobMask);
        imPane.repaint();
        glassPane.repaint();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public static BlobMask segment(Image image, int n, int n2) {
        if (image instanceof Image8or16Base) {
            return StarSegmenter.segment((Image8or16Base)image, n, n2);
        }
        if (image instanceof Image32) {
            return StarSegmenter.segment((Image32)image, n, n2);
        }
        return StarSegmenter.segment((Image64)image, n, n2);
    }

    private static BlobMask segment(Image8or16Base image8or16Base, int n, int n2) {
        Timer timer = new Timer("StarSegmenter.segment", image8or16Base);
        BufferedImage bufferedImage = image8or16Base.getBufferedImage();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = Image8or16Base.getNBands(bufferedImage);
        int n6 = Image8or16Base.getBitsPerChannel(bufferedImage);
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        int[] nArray5 = new int[n5];
        int[] nArray6 = new int[n5];
        int[] nArray7 = new int[n5];
        int[] nArray8 = new int[n5];
        int[] nArray9 = new int[n5];
        byte[][] byArray = new byte[n3][n4];
        int n7 = (int)Math.round((double)n2 * RECIPROCAL_ROOT2);
        int n8 = n;
        if (16 == n6) {
            n8 *= 256;
        }
        int n9 = n2;
        int n10 = n9 - n2;
        int n11 = n9 - n7;
        int n12 = n9 + n2;
        int n13 = n9 + n7;
        while (n9 < n4 - n2) {
            int n14 = n2;
            int n15 = n14 - n2;
            int n16 = n14 - n7;
            int n17 = n14 + n2;
            int n18 = n14 + n7;
            while (n14 < n3 - n2) {
                writableRaster.getPixel(n14, n9, nArray);
                writableRaster.getPixel(n15, n9, nArray2);
                writableRaster.getPixel(n16, n11, nArray3);
                writableRaster.getPixel(n14, n10, nArray4);
                writableRaster.getPixel(n18, n11, nArray5);
                writableRaster.getPixel(n17, n9, nArray6);
                writableRaster.getPixel(n18, n13, nArray7);
                writableRaster.getPixel(n14, n12, nArray8);
                writableRaster.getPixel(n16, n13, nArray9);
                int n19 = 0;
                for (int i = 0; i < n5; ++i) {
                    int n20 = nArray2[i] + nArray3[i] + nArray4[i] + nArray5[i] + nArray6[i] + nArray7[i] + nArray8[i] + nArray9[i] >> 3;
                    if (nArray[i] - n20 <= n8) continue;
                    n19 = 3;
                    break;
                }
                byArray[n14][n9] = n19;
                ++n14;
                ++n15;
                ++n16;
                ++n17;
                ++n18;
            }
            ++n9;
            ++n10;
            ++n11;
            ++n12;
            ++n13;
        }
        timer.stop();
        BlobMask blobMask = new BlobMask(byArray);
        blobMask.erode();
        blobMask.dilate();
        return blobMask;
    }

    private static BlobMask segment(Image32 image32, int n, int n2) {
        Timer timer = new Timer("StarSegmenter.segment", image32);
        int n3 = image32.getWidth();
        int n4 = image32.getHeight();
        int n5 = image32.getNBands();
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        int[] nArray5 = new int[n5];
        int[] nArray6 = new int[n5];
        int[] nArray7 = new int[n5];
        int[] nArray8 = new int[n5];
        int[] nArray9 = new int[n5];
        byte[][] byArray = new byte[n3][n4];
        int n6 = (int)Math.round((double)n2 * RECIPROCAL_ROOT2);
        int n7 = n * 256;
        int n8 = n2;
        int n9 = n8 - n2;
        int n10 = n8 - n6;
        int n11 = n8 + n2;
        int n12 = n8 + n6;
        while (n8 < n4 - n2) {
            int n13 = n2;
            int n14 = n13 - n2;
            int n15 = n13 - n6;
            int n16 = n13 + n2;
            int n17 = n13 + n6;
            while (n13 < n3 - n2) {
                nArray = image32.getPixel(n13, n8);
                nArray2 = image32.getPixel(n14, n8);
                nArray3 = image32.getPixel(n15, n10);
                nArray4 = image32.getPixel(n13, n9);
                nArray5 = image32.getPixel(n17, n10);
                nArray6 = image32.getPixel(n16, n8);
                nArray7 = image32.getPixel(n17, n12);
                nArray8 = image32.getPixel(n13, n11);
                nArray9 = image32.getPixel(n15, n12);
                int n18 = 0;
                for (int i = 0; i < n5; ++i) {
                    int n19 = nArray2[i] + nArray3[i] + nArray4[i] + nArray5[i] + nArray6[i] + nArray7[i] + nArray8[i] + nArray9[i] >> 3;
                    if (nArray[i] - n19 <= n7) continue;
                    n18 = 3;
                    break;
                }
                byArray[n13][n8] = n18;
                ++n13;
                ++n14;
                ++n15;
                ++n16;
                ++n17;
            }
            ++n8;
            ++n9;
            ++n10;
            ++n11;
            ++n12;
        }
        timer.stop();
        BlobMask blobMask = new BlobMask(byArray);
        blobMask.erode();
        blobMask.dilate();
        return blobMask;
    }

    private static BlobMask segment(Image64 image64, int n, int n2) {
        Timer timer = new Timer("StarSegmenter.segment", image64);
        int n3 = image64.getWidth();
        int n4 = image64.getHeight();
        int n5 = image64.getNBands();
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5];
        double[] dArray4 = new double[n5];
        double[] dArray5 = new double[n5];
        double[] dArray6 = new double[n5];
        double[] dArray7 = new double[n5];
        double[] dArray8 = new double[n5];
        double[] dArray9 = new double[n5];
        byte[][] byArray = new byte[n3][n4];
        int n6 = (int)Math.round((double)n2 * RECIPROCAL_ROOT2);
        int n7 = n * 256;
        int n8 = n2;
        int n9 = n8 - n2;
        int n10 = n8 - n6;
        int n11 = n8 + n2;
        int n12 = n8 + n6;
        while (n8 < n4 - n2) {
            int n13 = n2;
            int n14 = n13 - n2;
            int n15 = n13 - n6;
            int n16 = n13 + n2;
            int n17 = n13 + n6;
            while (n13 < n3 - n2) {
                dArray = image64.getPixelDouble(n13, n8);
                dArray2 = image64.getPixelDouble(n14, n8);
                dArray3 = image64.getPixelDouble(n15, n10);
                dArray4 = image64.getPixelDouble(n13, n9);
                dArray5 = image64.getPixelDouble(n17, n10);
                dArray6 = image64.getPixelDouble(n16, n8);
                dArray7 = image64.getPixelDouble(n17, n12);
                dArray8 = image64.getPixelDouble(n13, n11);
                dArray9 = image64.getPixelDouble(n15, n12);
                int n18 = 0;
                for (int i = 0; i < n5; ++i) {
                    double d = (dArray2[i] + dArray3[i] + dArray4[i] + dArray5[i] + dArray6[i] + dArray7[i] + dArray8[i] + dArray9[i]) / 8.0;
                    if (!(dArray[i] - d > (double)n7)) continue;
                    n18 = 3;
                    break;
                }
                byArray[n13][n8] = n18;
                ++n13;
                ++n14;
                ++n15;
                ++n16;
                ++n17;
            }
            ++n8;
            ++n9;
            ++n10;
            ++n11;
            ++n12;
        }
        timer.stop();
        BlobMask blobMask = new BlobMask(byArray);
        blobMask.erode();
        blobMask.dilate();
        return blobMask;
    }
}

