/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import net.grelf.Util;
import net.grelf.image.Calibration;
import net.grelf.image.Image;
import net.grelf.image.Image32;
import net.grelf.image.Image64;
import net.grelf.image.Image8;
import net.grelf.image.Image8or16Base;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Metadata;
import net.grelf.image.Timer;

public class Image16
extends Image8or16Base
implements Image,
Cloneable,
Serializable {
    private boolean raw = false;

    @Override
    public boolean isRaw() {
        return this.raw;
    }

    public void setRaw(boolean bl) {
        this.raw = bl;
    }

    public Image16(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public Image16(int n, int n2, int n3, boolean bl) {
        this(n, n2, n3, bl, false);
    }

    public Image16(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            Util.warning("Error", "Cannot create an image " + n + "x" + n2 + "x" + n3 + "x16");
            return;
        }
        this.bim = this.create16BitImage(n, n2, n3);
        this.raw = bl2;
        this.setCalibration(new Calibration());
        this.setFilePath("New image");
        this.setMetadata(new Metadata());
        this.zeroPxInt = new int[n3];
        this.zeroPxDouble = new double[n3];
        for (int i = 0; i < n3; ++i) {
            this.zeroPxInt[i] = 0;
            this.zeroPxDouble[i] = 0.0;
        }
        if (null != this.bim && bl) {
            WritableRaster writableRaster = this.bim.getRaster();
            for (int i = 0; i < writableRaster.getHeight(); ++i) {
                for (int j = 0; j < writableRaster.getWidth(); ++j) {
                    writableRaster.setPixel(j, i, this.zeroPxInt);
                }
            }
        }
    }

    public Image16(BufferedImage bufferedImage) throws IncompatibleImageException {
        this(bufferedImage, false);
    }

    public Image16(BufferedImage bufferedImage, boolean bl) throws IncompatibleImageException {
        WritableRaster writableRaster = bufferedImage.getRaster().createCompatibleWritableRaster();
        bufferedImage.copyData(writableRaster);
        this.bim = new BufferedImage(bufferedImage.getColorModel(), writableRaster, bufferedImage.isAlphaPremultiplied(), null);
        this.raw = bl;
        int n = Image16.getNBands(bufferedImage);
        this.zeroPxInt = new int[n];
        this.zeroPxDouble = new double[n];
        for (int i = 0; i < n; ++i) {
            this.zeroPxInt[i] = 0;
            this.zeroPxDouble[i] = 0.0;
        }
    }

    private BufferedImage create16BitImage(int n, int n2, int n3) {
        long l = (long)n * (long)n2 * (long)n3 * 6L;
        long l2 = Runtime.getRuntime().freeMemory();
        if (l + 500000L < l2) {
            try {
                ColorSpace colorSpace = ColorSpace.getInstance(1004);
                if (n3 == 1) {
                    colorSpace = ColorSpace.getInstance(1003);
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = 16;
                }
                ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, 1);
                return new BufferedImage(componentColorModel, ((ColorModel)componentColorModel).createCompatibleWritableRaster(n, n2), false, null);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cannot create image because it\nwould require ");
        stringBuffer.append(100L * (l + 500000L) / l2);
        stringBuffer.append("% of available memory.\n");
        stringBuffer.append("You might do one of the following:\n");
        stringBuffer.append(" - Geometry/Crop\n");
        stringBuffer.append(" - Geometry/Scale (down)\n");
        stringBuffer.append("and then try again.");
        Util.warning("Not enough memory", stringBuffer.toString());
        return null;
    }

    @Override
    public void add(Image image) throws IncompatibleImageException {
        if (!(image instanceof Image16)) {
            throw new IncompatibleImageException("Cannot add " + image.getBitsPerChannel() + "-bit image into 16-bit one");
        }
        this.add(((Image16)image).getBufferedImage());
    }

    @Override
    public Image clone() {
        try {
            return new Image16(this.bim);
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.logWarning("Could not clone Image16");
            return null;
        }
    }

    @Override
    public Image8 convertToImage8() {
        Timer timer = new Timer("Image16.convertToImage8", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        Image8 image8 = new Image8(n, n2, n3, false, false);
        int[] nArray = new int[n3];
        double d = 255.0 / (double)this.getRange().high;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            while (n5 < n) {
                nArray = this.getPixel(n5, i);
                for (int j = 0; j < n3; ++j) {
                    nArray[j] = (int)((double)nArray[j] * d);
                }
                image8.setPixel(n5, i, nArray);
                ++n5;
                ++n4;
            }
        }
        image8.setCalibration(this.getCalibration());
        image8.setFilePath(this.getFilePath());
        this.getMetadata().removeTiffFields();
        image8.setMetadata(this.getMetadata());
        timer.stop();
        return image8;
    }

    @Override
    public Image16 convertToImage16() {
        return this;
    }

    @Override
    public Image32 convertToImage32() {
        Timer timer = new Timer("Image16.convertToImage32", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        Image32 image32 = new Image32(n, n2, n3);
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            while (n5 < n) {
                nArray = this.getPixel(n5, i);
                image32.setPixel(n5, i, nArray);
                ++n5;
                ++n4;
            }
        }
        image32.getRangeByRescanning();
        image32.setCalibration(this.getCalibration());
        image32.setFilePath(this.getFilePath());
        this.getMetadata().removeTiffFields();
        image32.setMetadata(this.getMetadata());
        timer.stop();
        return image32;
    }

    @Override
    public Image64 convertToImage64() {
        return this.convertToImage32().convertToImage64();
    }

    @Override
    public Image gnomonicProjection(int n, double d, double d2) {
        try {
            return new Image16(this.gnomonicProjection(this.bim, n, d, d2));
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.logWarning(incompatibleImageException.toString());
            return null;
        }
    }

    @Override
    public Image inverseGnomonicProjection(int n, double d, double d2) {
        try {
            return new Image16(this.inverseGnomonicProjection(this.bim, n, d, d2));
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.logWarning(incompatibleImageException.toString());
            return null;
        }
    }

    @Override
    public Image[] splitChannels() {
        Timer timer = new Timer("Image16.splitChannels", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        Image[] imageArray = new Image16[n3];
        for (int i = 0; i < n3; ++i) {
            imageArray[i] = new Image16(n, n2, 1);
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[1];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray = this.getPixel(j, i);
                for (int k = 0; k < n3; ++k) {
                    nArray2[0] = nArray[k];
                    ((Image8or16Base)imageArray[k]).setPixel(j, i, nArray2);
                }
            }
        }
        timer.stop();
        return imageArray;
    }
}

