/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.io;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

abstract class BitReader {
    protected ImageInputStream iis;
    protected byte[] byteBuffer;
    protected int bufferSize;
    protected int bytePointer;
    protected int bitPosition;

    BitReader() {
    }

    public abstract int readBits(int var1) throws IOException;

    public void skipBits(int bitsToSkip) throws IOException {
        this.readBits(bitsToSkip);
    }

    public long getStreamPosition() throws IOException {
        return this.iis.getStreamPosition() - (long)this.bufferSize + (long)this.bytePointer;
    }

    public void seek(long position) throws IOException {
        this.resync();
        this.iis.seek(position);
    }

    public void setBitOffset(int bitPosition) {
        this.bitPosition = bitPosition;
    }

    public int getBitOffset() {
        return this.bitPosition;
    }

    protected abstract void resync();

    public abstract void setSkipZeroAfterFF(boolean var1);
}

