/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import java.util.HashMap;
import java.util.Map;

public class TagRegistry {
    private static Map registryMapByName = new HashMap();
    private Map nameMapByCode = new HashMap();
    private Map codeMapByName = new HashMap();
    private String name;

    private TagRegistry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static synchronized TagRegistry getRegistry(String name) {
        TagRegistry registry = (TagRegistry)registryMapByName.get(name);
        if (registry == null) {
            registry = new TagRegistry(name);
            registryMapByName.put(name, registry);
        }
        return registry;
    }

    public String register(int code, String name) {
        Integer iCode = new Integer(code);
        this.nameMapByCode.put(iCode, name);
        this.codeMapByName.put(name, iCode);
        return name;
    }

    public String getTagName(int code) {
        return (String)this.nameMapByCode.get(new Integer(code));
    }

    int getTagCode(String name) {
        Number code = (Number)this.codeMapByName.get(name);
        return code == null ? -1 : code.intValue();
    }

    Object getKey(Object key) {
        if (key instanceof String) {
            return key;
        }
        Object r = this.nameMapByCode.get(key);
        return r != null ? r : "#" + key;
    }

    public Object getKey(int key) {
        return this.getKey(new Integer(key));
    }
}

