/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImagerGlobal;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class ColorSelectionPanel
extends JPanel {
    Color backColor;
    Image swapImage;
    int w = 40;
    Rectangle backRect = new Rectangle(3, 15, this.w, this.w);
    Rectangle foreRect = new Rectangle(17, 35, this.w, this.w);
    Rectangle swapImageRect;

    public ColorSelectionPanel(Color color, Color color2) {
        this.setForeground(color);
        this.backColor = color2;
        this.swapImage = ImagerGlobal.loadImage("resources/swap.gif", this);
        this.swapImageRect = new Rectangle(this.backRect.x + this.backRect.width, this.foreRect.y - this.swapImage.getHeight(null), this.swapImage.getWidth(null), this.swapImage.getHeight(null));
        try {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (ColorSelectionPanel.this.foreRect.contains(mouseEvent.getPoint())) {
                        ColorSelectionPanel.this.v_getForeColor();
                    } else if (ColorSelectionPanel.this.backRect.contains(mouseEvent.getPoint())) {
                        ColorSelectionPanel.this.u_getBackColor();
                    } else if (ColorSelectionPanel.this.swapImageRect.contains(mouseEvent.getPoint())) {
                        ColorSelectionPanel.this.V_swapColor();
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.U_jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.foreRect.contains(mouseEvent.getPoint()) ? "Click to modify Foreground Color" : (this.backRect.contains(mouseEvent.getPoint()) ? "Click to modify Background Color" : (this.swapImageRect.contains(mouseEvent.getPoint()) ? "Click to swap Background and Foregound Color" : null));
    }

    private void v_getForeColor() {
        Color color = JColorChooser.showDialog(this, "Foreground Color", this.getForeground());
        if (color != null) {
            this.firePropertyChange("ForegroundColor", this.getForeground(), color);
            this.setForeground(color);
        }
        this.repaint();
    }

    private void u_getBackColor() {
        Color color = JColorChooser.showDialog(this, "BackgroundColor", this.backColor);
        if (color != null) {
            this.firePropertyChange("BackgroundColor", this.backColor, color);
            this.backColor = color;
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(this.backColor);
        graphics.fillRect(this.backRect.x, this.backRect.y, this.backRect.width, this.backRect.height);
        graphics.setColor(Color.black);
        graphics.drawRect(this.backRect.x, this.backRect.y, this.backRect.width, this.backRect.height);
        graphics.setColor(this.getForeground());
        graphics.fillRect(this.foreRect.x, this.foreRect.y, this.foreRect.width, this.foreRect.height);
        graphics.setColor(Color.black);
        graphics.drawRect(this.foreRect.x, this.foreRect.y, this.foreRect.width, this.foreRect.height);
        if (this.swapImage != null) {
            graphics.drawImage(this.swapImage, this.swapImageRect.x, this.swapImageRect.y, this.swapImageRect.width, this.swapImageRect.height, this);
        }
    }

    public void setBackColor(Color color) {
        this.backColor = color;
        this.repaint();
    }

    private void U_jbInit() throws Exception {
        this.setToolTipText("Colors");
    }

    private void V_swapColor() {
        Color color = this.getForeground();
        this.firePropertyChange("ForegroundColor", color, this.backColor);
        this.setForeground(this.backColor);
        this.firePropertyChange("BackgroundColor", this.backColor, color);
        this.backColor = color;
        this.repaint();
    }
}

