/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImagePanel;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JScrollPane;

public class ImageScrollPane
extends JScrollPane {
    ImagePanel m_ImagePanel;
    Cursor m_Cursor = new Cursor(12);
    int m_MouseX;
    int m_MouseY;
    private boolean U_draggable = false;

    public ImageScrollPane() {
    }

    public ImageScrollPane(ImagePanel imagePanel) {
        super(imagePanel);
        this.m_ImagePanel = imagePanel;
        this.addMouseListener(new ScrollPaneMouseAdapter());
        this.addMouseMotionListener(new ScrollPaneMouseMotionAdapter());
    }

    public Image getImageRegionInView() {
        Rectangle rectangle = this.getViewportBorderBounds();
        return ((BufferedImage)this.m_ImagePanel.getImage()).getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setImageRegionInView(Image image) {
        Rectangle rectangle = this.getViewportBorderBounds();
        this.m_ImagePanel.getGraphics().drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
    }

    public void setImage(Image image) {
        this.m_ImagePanel.setImage(image);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.m_ImagePanel.setPreferredSize(new Dimension(n3 - this.getVerticalScrollBar().getWidth(), n4 - this.getHorizontalScrollBar().getHeight()));
    }

    class ScrollPaneMouseAdapter
    extends MouseAdapter {
        ScrollPaneMouseAdapter() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!ImageScrollPane.this.U_draggable) {
                return;
            }
            if (!((ImageScrollPane)mouseEvent.getSource()).contains(mouseEvent.getX(), mouseEvent.getY()) && ImageScrollPane.this.getCursor() == ImageScrollPane.this.m_Cursor) {
                ImageScrollPane.this.setCursor(Cursor.getDefaultCursor());
            }
            ImageScrollPane.this.m_ImagePanel.repaint(0, 0, ImageScrollPane.this.m_ImagePanel.getImage().getWidth(null), ImageScrollPane.this.m_ImagePanel.getImage().getHeight(null));
            ImageScrollPane.this.U_draggable = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (ImageScrollPane.this.m_ImagePanel.getWidth() < ((ImageScrollPane)mouseEvent.getSource()).getWidth() && ImageScrollPane.this.m_ImagePanel.getHeight() < ((ImageScrollPane)mouseEvent.getSource()).getHeight()) {
                ImageScrollPane.this.U_draggable = false;
            } else {
                ImageScrollPane.this.U_draggable = true;
                ImageScrollPane.this.m_MouseX = mouseEvent.getX();
                ImageScrollPane.this.m_MouseY = mouseEvent.getY();
            }
        }
    }

    class ScrollPaneMouseMotionAdapter
    extends MouseMotionAdapter {
        ScrollPaneMouseMotionAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (ImageScrollPane.this.m_ImagePanel.getWidth() < ((ImageScrollPane)mouseEvent.getSource()).getWidth() && ImageScrollPane.this.m_ImagePanel.getHeight() < ((ImageScrollPane)mouseEvent.getSource()).getHeight()) {
                return;
            }
            ImageScrollPane.this.setCursor(ImageScrollPane.this.m_Cursor);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (ImageScrollPane.this.getCursor() == ImageScrollPane.this.m_Cursor) {
                ImageScrollPane.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!ImageScrollPane.this.U_draggable) {
                return;
            }
            if (ImageScrollPane.this.m_ImagePanel.getWidth() <= ((ImageScrollPane)mouseEvent.getSource()).getWidth() && ImageScrollPane.this.m_ImagePanel.getHeight() <= ((ImageScrollPane)mouseEvent.getSource()).getHeight()) {
                return;
            }
            ImageScrollPane.this.setCursor(ImageScrollPane.this.m_Cursor);
            int n = (int)((ImageScrollPane)mouseEvent.getSource()).getViewport().getViewPosition().getX() + (ImageScrollPane.this.m_MouseX - mouseEvent.getX());
            int n2 = (int)((ImageScrollPane)mouseEvent.getSource()).getViewport().getViewPosition().getY() + (ImageScrollPane.this.m_MouseY - mouseEvent.getY());
            if (n < 0) {
                n = 0;
            }
            if (n > ImageScrollPane.this.m_ImagePanel.getWidth() - ((ImageScrollPane)mouseEvent.getSource()).getWidth()) {
                n = ImageScrollPane.this.m_ImagePanel.getWidth() - ((ImageScrollPane)mouseEvent.getSource()).getWidth();
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > ImageScrollPane.this.m_ImagePanel.getHeight() - ((ImageScrollPane)mouseEvent.getSource()).getHeight()) {
                n2 = ImageScrollPane.this.m_ImagePanel.getHeight() - ((ImageScrollPane)mouseEvent.getSource()).getHeight();
            }
            ((ImageScrollPane)mouseEvent.getSource()).getViewport().setViewPosition(new Point(n, n2));
            ImageScrollPane.this.m_MouseX = mouseEvent.getX();
            ImageScrollPane.this.m_MouseY = mouseEvent.getY();
        }
    }
}

