/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.AbstractText;
import imager.Draggable;
import imager.ImagePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;

public class RectangularDraggable
extends Draggable {
    Color m_BorderColor = Color.black;
    Color m_Background = Color.white;
    int GAP = 10;
    boolean m_bTransparent = true;
    AbstractText m_Text;
    Image m_Image;
    ImagePanel m_Owner;

    public void setTransparent(boolean bl) {
        this.m_bTransparent = bl;
    }

    public boolean isTransparent() {
        return this.m_bTransparent;
    }

    public RectangularDraggable(ImagePanel imagePanel) {
        this.m_Owner = imagePanel;
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.m_Image != null) {
            this.drawImage(graphics2D);
        }
        if (this.m_Text != null) {
            this.U_drawText(graphics2D, true);
        }
    }

    private void U_drawText(Graphics2D graphics2D, boolean bl) {
        this.m_Text.draw(graphics2D, this.m_CurrBounds, bl);
    }

    private void drawImage(Graphics2D graphics2D) {
        graphics2D.drawImage(this.m_Image, this.m_CurrBounds.x, this.m_CurrBounds.y, this.m_CurrBounds.width, this.m_CurrBounds.height, null);
    }

    public void drawDraggedRegion(Graphics2D graphics2D, Graphics2D graphics2D2) {
        if (graphics2D2 != null) {
            graphics2D2.setColor(this.m_XorColor);
            graphics2D2.setXORMode(Color.white);
            if (this.m_Image != null) {
                this.drawImage(graphics2D2);
            }
            if (this.m_Text != null) {
                this.U_drawText(graphics2D2, false);
            }
            graphics2D2.setPaintMode();
        }
        if (graphics2D != null) {
            graphics2D.setColor(this.m_XorColor);
            graphics2D.setXORMode(Color.white);
            graphics2D.setStroke(Draggable.DASH_STROKE);
            graphics2D.drawRect(this.m_CurrBounds.x - 1, this.m_CurrBounds.y - 1, this.m_CurrBounds.width + 2, this.m_CurrBounds.height + 2);
            graphics2D.setPaintMode();
        }
    }

    public void updateBoundsOnAnchorChange(int n, int n2) {
    }

    public Point getAnchorPoint() {
        return this.m_OrigBounds.getLocation();
    }

    public void setText(AbstractText abstractText) {
        this.m_Text = abstractText;
    }

    public void setImage(Image image) {
        this.m_Image = image;
    }

    public Image getImage() {
        return this.m_Image;
    }

    public AbstractText getText() {
        return this.m_Text;
    }

    public boolean isTextSelection() {
        return this.m_Text != null;
    }
}

