/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.PNG;

import imager.imagefileio.PNG.PNGEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNGEncoderB
extends PNGEncoder {
    protected BufferedImage image;
    protected WritableRaster wRaster;
    protected int tType;

    public PNGEncoderB() {
        this(null, false, 0, 0);
    }

    public PNGEncoderB(BufferedImage bufferedImage) {
        this(bufferedImage, false, 0, 0);
    }

    public PNGEncoderB(BufferedImage bufferedImage, boolean bl) {
        this(bufferedImage, bl, 0, 0);
    }

    public PNGEncoderB(BufferedImage bufferedImage, boolean bl, int n) {
        this(bufferedImage, bl, n, 0);
    }

    public PNGEncoderB(BufferedImage bufferedImage, boolean bl, int n, int n2) {
        this.image = bufferedImage;
        this.encodeAlpha = bl;
        this.setFilter(n);
        if (n2 > 9) {
            n2 = 9;
        }
        if (n2 >= 0 && n2 <= 9) {
            this.compressionLevel = n2;
        }
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.pngBytes = null;
    }

    public byte[] pngEncode(boolean bl) {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (this.image == null) {
            return null;
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        if (!this.establishStorageInfo()) {
            return null;
        }
        this.pngBytes = new byte[(this.width + 1) * this.height * 3 + 200];
        this.maxPos = 0;
        this.hdrPos = this.bytePos = this.writeBytes(byArray, 0);
        this.writeHeader();
        this.dataPos = this.bytePos;
        if (this.writeImageData()) {
            this.writeEnd();
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.maxPos);
        } else {
            this.pngBytes = null;
        }
        return this.pngBytes;
    }

    public byte[] pngEncode() {
        return this.pngEncode(this.encodeAlpha);
    }

    protected boolean establishStorageInfo() {
        this.wRaster = this.image.getRaster();
        int n = this.wRaster.getNumDataElements();
        this.tType = this.wRaster.getTransferType();
        if (this.tType == 0 && n == 4 || this.tType == 3 && n == 1) {
            this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        } else if (this.tType == 0 && n == 1) {
            this.bytesPerPixel = 1;
            this.encodeAlpha = false;
        } else {
            return false;
        }
        return true;
    }

    protected void writeHeader() {
        int n = this.bytePos = this.writeInt4(13, this.bytePos);
        this.bytePos = this.writeString("IHDR", this.bytePos);
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.bytePos = this.writeInt4(this.width, this.bytePos);
        this.bytePos = this.writeInt4(this.height, this.bytePos);
        this.bytePos = this.writeByte(8, this.bytePos);
        this.bytePos = this.bytesPerPixel != 1 ? this.writeByte(this.encodeAlpha ? 6 : 2, this.bytePos) : this.writeByte(3, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.crc.reset();
        this.crc.update(this.pngBytes, n, this.bytePos - n);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected void writePalette(IndexColorModel indexColorModel) {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        byte[] byArray4 = new byte[768];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        int n = 0;
        while (n < 256) {
            byArray4[n * 3] = byArray[n];
            byArray4[n * 3 + 1] = byArray2[n];
            byArray4[n * 3 + 2] = byArray3[n];
            ++n;
        }
        this.bytePos = this.writeInt4(768, this.bytePos);
        this.bytePos = this.writeString("PLTE", this.bytePos);
        this.crc.reset();
        this.crc.update("PLTE".getBytes());
        this.bytePos = this.writeBytes(byArray4, this.bytePos);
        this.crc.update(byArray4);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected boolean writeImageData() {
        int n = this.height;
        int n2 = 0;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        if (this.bytesPerPixel == 1) {
            this.writePalette((IndexColorModel)this.image.getColorModel());
        }
        try {
            while (n > 0) {
                int[] nArray;
                byte[] byArray;
                int n3 = Math.min(Short.MAX_VALUE / (this.width * (this.bytesPerPixel + 1)), n);
                byte[] byArray2 = new byte[this.width * n3 * this.bytesPerPixel + n3];
                if (this.filter == 1) {
                    this.leftBytes = new byte[16];
                }
                if (this.filter == 2) {
                    this.priorRow = new byte[this.width * this.bytesPerPixel];
                }
                if (this.tType == 0) {
                    byArray = (byte[])this.wRaster.getDataElements(0, n2, this.width, n3, null);
                    nArray = null;
                } else {
                    nArray = (int[])this.wRaster.getDataElements(0, n2, this.width, n3, null);
                    byArray = null;
                }
                int n4 = 0;
                int n5 = 0;
                int n6 = 1;
                int n7 = 0;
                while (n7 < this.width * n3) {
                    if (n7 % this.width == 0) {
                        byArray2[n4++] = (byte)this.filter;
                        n6 = n4;
                    }
                    if (this.bytesPerPixel == 1) {
                        byArray2[n4++] = byArray[n5++];
                    } else if (this.tType == 0) {
                        byArray2[n4++] = byArray[n5++];
                        byArray2[n4++] = byArray[n5++];
                        byArray2[n4++] = byArray[n5++];
                        if (this.encodeAlpha) {
                            byArray2[n4++] = byArray[n5++];
                        } else {
                            ++n5;
                        }
                    } else {
                        byArray2[n4++] = (byte)(nArray[n5] >> 16 & 0xFF);
                        byArray2[n4++] = (byte)(nArray[n5] >> 8 & 0xFF);
                        byArray2[n4++] = (byte)(nArray[n5] & 0xFF);
                        if (this.encodeAlpha) {
                            byArray2[n4++] = (byte)(nArray[n5] >> 24 & 0xFF);
                        }
                        ++n5;
                    }
                    if (n7 % this.width == this.width - 1 && this.filter != 0) {
                        if (this.filter == 1) {
                            this.filterSub(byArray2, n6, this.width);
                        }
                        if (this.filter == 2) {
                            this.filterUp(byArray2, n6, this.width);
                        }
                    }
                    ++n7;
                }
                deflaterOutputStream.write(byArray2, 0, n4);
                n2 += n3;
                n -= n3;
            }
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n8 = byArray.length;
            this.crc.reset();
            this.bytePos = this.writeInt4(n8, this.bytePos);
            this.bytePos = this.writeString("IDAT", this.bytePos);
            this.crc.update("IDAT".getBytes());
            this.bytePos = this.writeBytes(byArray, n8, this.bytePos);
            this.crc.update(byArray, 0, n8);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
            deflater.finish();
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
    }
}

