/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.MemoryFileInputFilter;
import imager.imagefileio.TIFF.enhanced.MotorolaIntelInputFilter;
import java.io.IOException;

class DataType {
    public int type;
    public static final int MINIMUM = 0;
    public static final int NOTYPE = 0;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int MAXIMUM = 12;

    public DataType() {
        this.type = 0;
    }

    public DataType(int n) {
        this.type = n;
        if (n < 0 || n > 12) {
            System.out.println("WARNING: Unknown Data Type " + n);
        }
    }

    public int size() {
        return this.size(this.type);
    }

    public int size(int n) {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                n2 = 1;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                n2 = 4;
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                n2 = 8;
            }
        }
        return n2;
    }

    public boolean isAscii() {
        return this.type == 2;
    }

    public boolean isRational() {
        return this.type == 5 || this.type == 10;
    }

    public boolean isShort() {
        return this.type == 3 || this.type == 8;
    }

    public boolean isLong() {
        return this.type == 4 || this.type == 9;
    }

    public boolean equals(int n) {
        return this.type == n;
    }

    public void write(MotorolaIntelInputFilter motorolaIntelInputFilter) throws IOException {
        motorolaIntelInputFilter.writeShort((short)this.type);
    }

    public void read(MemoryFileInputFilter memoryFileInputFilter) {
        this.type = memoryFileInputFilter.readUnsignedShort();
    }

    public String toString() {
        return this.toString(this.type);
    }

    public String toString(int n) {
        String string = "...";
        switch (n) {
            case 0: {
                string = "NOTYPE ";
                break;
            }
            case 1: {
                string = "BYTE   ";
                break;
            }
            case 2: {
                string = "ASCII  ";
                break;
            }
            case 6: {
                string = "SBYTE  ";
                break;
            }
            case 7: {
                string = "UNDEFINED ";
                break;
            }
            case 3: {
                string = "SHORT  ";
                break;
            }
            case 8: {
                string = "SSHORT ";
                break;
            }
            case 4: {
                string = "LONG   ";
                break;
            }
            case 9: {
                string = "SLONG  ";
                break;
            }
            case 11: {
                string = "FLOAT  ";
                break;
            }
            case 5: {
                string = "RATIONAL ";
                break;
            }
            case 10: {
                string = "SRATIONAL ";
                break;
            }
            case 12: {
                string = "DOUBLE ";
            }
        }
        return string;
    }
}

