/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.MemoryFileInputFilter;
import imager.imagefileio.TIFF.enhanced.MotorolaIntelInputFilter;
import java.io.IOException;

public class Tag {
    public int id;
    public static final int MINIMUM = 254;
    public static final int MAXIMUM_STANDARD = 532;
    public static final int MINIMUM_PRIVATE = 32768;
    public static final int SUBFILETYPE = 254;
    public static final int OSUBFILETYPE = 255;
    public static final int IMAGEWIDTH = 256;
    public static final int IMAGELENGTH = 257;
    public static final int BITSPERSAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRIC = 262;
    public static final int THRESHHOLDING = 263;
    public static final int CELLWIDTH = 264;
    public static final int CELLLENGTH = 265;
    public static final int FILLORDER = 266;
    public static final int DOCUMENTNAME = 269;
    public static final int IMAGEDESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIPOFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLESPERPIXEL = 277;
    public static final int ROWSPERSTRIP = 278;
    public static final int STRIPBYTECOUNTS = 279;
    public static final int MINSAMPLEVALUE = 280;
    public static final int MAXSAMPLEVALUE = 281;
    public static final int XRESOLUTION = 282;
    public static final int YRESOLUTION = 283;
    public static final int PLANARCONFIG = 284;
    public static final int PAGENAME = 285;
    public static final int XPOSITION = 286;
    public static final int YPOSITION = 287;
    public static final int FREEOFFSETS = 288;
    public static final int FREEBYTECOUNTS = 289;
    public static final int GRAYRESPONSEUNIT = 290;
    public static final int GRAYRESPONSECURVE = 291;
    public static final int GROUP3OPTIONS = 292;
    public static final int GROUP4OPTIONS = 293;
    public static final int RESOLUTIONUNIT = 296;
    public static final int PAGENUMBER = 297;
    public static final int COLORRESPONSEUNIT = 300;
    public static final int TRANSFERFUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATETIME = 306;
    public static final int ARTIST = 315;
    public static final int HOSTCOMPUTER = 316;
    public static final int PREDICTOR = 317;
    public static final int WHITEPOINT = 318;
    public static final int PRIMARYCHROMATICITIES = 319;
    public static final int COLORMAP = 320;
    public static final int HALFTONEHINTS = 321;
    public static final int TILEWIDTH = 322;
    public static final int TILELENGTH = 323;
    public static final int TILEOFFSETS = 324;
    public static final int TILEBYTECOUNTS = 325;
    public static final int BADFAXLINES = 326;
    public static final int CLEANFAXDATA = 327;
    public static final int CONSECUTIVEBADFAXLINES = 328;
    public static final int SUBIFD = 330;
    public static final int INKSET = 332;
    public static final int INKNAMES = 333;
    public static final int NUMBEROFINKS = 334;
    public static final int DOTRANGE = 336;
    public static final int TARGETPRINTER = 337;
    public static final int EXTRASAMPLES = 338;
    public static final int SAMPLEFORMAT = 339;
    public static final int SMINSAMPLEVALUE = 340;
    public static final int SMAXSAMPLEVALUE = 341;
    public static final int JPEGTABLES = 347;
    public static final int JPEGPROC = 512;
    public static final int JPEGIFOFFSET = 513;
    public static final int JPEGIFBYTECOUNT = 514;
    public static final int JPEGRESTARTINTERVAL = 515;
    public static final int JPEGLOSSLESSPREDICTORS = 517;
    public static final int JPEGPOINTTRANSFORM = 518;
    public static final int JPEGQTABLES = 519;
    public static final int JPEGDCTABLES = 520;
    public static final int JPEGACTABLES = 521;
    public static final int YCBCRCOEFFICIENTS = 529;
    public static final int YCBCRSUBSAMPLING = 530;
    public static final int YCBCRPOSITIONING = 531;
    public static final int REFERENCEBLACKWHITE = 532;
    public static final int REFPTS = 32953;
    public static final int REGIONTACKPOINT = 32954;
    public static final int REGIONWARPCORNERS = 32955;
    public static final int REGIONAFFINE = 32956;
    public static final int MATTEING = 32995;
    public static final int DATATYPE = 32996;
    public static final int IMAGEDEPTH = 32997;
    public static final int TILEDEPTH = 32998;
    public static final int PIXAR_IMAGEFULLWIDTH = 33300;
    public static final int PIXAR_IMAGEFULLLENGTH = 33301;
    public static final int WRITERSERIALNUMBER = 33405;
    public static final int COPYRIGHT = 33432;
    public static final int UNISYS_ISIS_IFD = 33881;
    public static final int UNISYS_SIDE = 33882;
    public static final int UNISYS_IXPS_IFD = 33884;
    public static final int WEIRD = 34975;
    public static final int IT8SITE = 34016;
    public static final int IT8COLORSEQUENCE = 34017;
    public static final int IT8HEADER = 34018;
    public static final int IT8RASTERPADDING = 34019;
    public static final int IT8BITSPERRUNLENGTH = 34020;
    public static final int IT8BITSPEREXTENDEDRUNLENGTH = 34021;
    public static final int IT8COLORTABLE = 34022;
    public static final int IT8IMAGECOLORINDICATOR = 34023;
    public static final int IT8BKGCOLORINDICATOR = 34024;
    public static final int IT8IMAGECOLORVALUE = 34025;
    public static final int IT8BKGCOLORVALUE = 34026;
    public static final int IT8PIXELINTENSITYRANGE = 34027;
    public static final int IT8TRANSPARENCYINDICATOR = 34028;
    public static final int IT8COLORCHARACTERIZATION = 34029;
    public static final int FRAMECOUNT = 34232;
    public static final int ICCPROFILE = 34675;
    public static final int JBIGOPTIONS = 34750;
    public static final int FAXRECVPARAMS = 34908;
    public static final int FAXSUBADDRESS = 34909;
    public static final int FAXRECVTIME = 34910;
    public static final int DCSHUESHIFTVALUES = 65535;
    public static final int FAXMODE = 65536;
    public static final int JPEGQUALITY = 65537;
    public static final int JPEGCOLORMODE = 65538;
    public static final int JPEGTABLESMODE = 65539;
    public static final int FAXFILLFUNC = 65540;
    public static final int PIXARLOGDATAFMT = 65549;
    public static final int DCSIMAGERTYPE = 65550;
    public static final int DCSINTERPMODE = 65551;
    public static final int DCSBALANCEARRAY = 65552;
    public static final int DCSCORRECTMATRIX = 65553;
    public static final int DCSGAMMA = 65554;
    public static final int DCSTOESHOULDERPTS = 65555;
    public static final int DCSCALIBRATIONFD = 65556;
    public static final int ZIPQUALITY = 65557;
    public static final int PIXARLOGQUALITY = 65558;
    public static final int DCSCLIPRECTANGLE = 65559;

    public Tag() {
        this.id = 0;
    }

    public Tag(int n) {
        this.id = n;
        if (!this.IsStandard()) {
            System.out.println("WARNING: Non-Standard Tag " + n);
        }
    }

    public int Value() {
        return this.id;
    }

    public boolean IsStandard() {
        boolean bl = this.id >= 254 && this.id <= 532;
        bl = bl && (this.id < 260 || this.id > 261);
        bl = bl && (this.id < 267 || this.id > 268);
        bl = bl && (this.id < 275 || this.id > 276);
        bl = bl && (this.id < 294 || this.id > 295);
        bl = bl && (this.id < 298 || this.id > 299);
        bl = bl && (this.id < 302 || this.id > 304);
        bl = bl && (this.id < 307 || this.id > 314);
        bl = bl && this.id != 329 && this.id != 331;
        bl = bl && (this.id < 342 || this.id > 346);
        bl = bl && (this.id < 348 || this.id > 511);
        return bl;
    }

    public boolean IsPrivate() {
        return this.id >= 32768;
    }

    public boolean IsOffsetTag() {
        return this.id == 273 || this.id == 324 || this.id == 347 || this.id == 513;
    }

    public boolean equals(int n) {
        return this.id == n;
    }

    public void write(MotorolaIntelInputFilter motorolaIntelInputFilter) throws IOException {
        motorolaIntelInputFilter.writeShort(this.id);
    }

    public void read(MemoryFileInputFilter memoryFileInputFilter) {
        this.id = memoryFileInputFilter.readUnsignedShort();
    }

    public String toString() {
        String string = "";
        switch (this.id) {
            case 254: {
                string = "SUBFILETYPE      ";
                break;
            }
            case 255: {
                string = "OSUBFILETYPE     ";
                break;
            }
            case 256: {
                string = "IMAGEWIDTH       ";
                break;
            }
            case 257: {
                string = "IMAGELENGTH      ";
                break;
            }
            case 258: {
                string = "BITSPERSAMPLE    ";
                break;
            }
            case 259: {
                string = "COMPRESSION      ";
                break;
            }
            case 262: {
                string = "PHOTOMETRIC      ";
                break;
            }
            case 263: {
                string = "THRESHHOLDING    ";
                break;
            }
            case 264: {
                string = "CELLWIDTH        ";
                break;
            }
            case 265: {
                string = "CELLLENGTH       ";
                break;
            }
            case 266: {
                string = "FILLORDER        ";
                break;
            }
            case 269: {
                string = "DOCUMENTNAME     ";
                break;
            }
            case 270: {
                string = "IMAGEDESCRIPTION ";
                break;
            }
            case 271: {
                string = "MAKE             ";
                break;
            }
            case 272: {
                string = "MODEL            ";
                break;
            }
            case 273: {
                string = "STRIPOFFSETS     ";
                break;
            }
            case 274: {
                string = "ORIENTATION      ";
                break;
            }
            case 277: {
                string = "SAMPLESPERPIXEL  ";
                break;
            }
            case 278: {
                string = "ROWSPERSTRIP     ";
                break;
            }
            case 279: {
                string = "STRIPBYTECOUNTS  ";
                break;
            }
            case 280: {
                string = "MINSAMPLEVALUE   ";
                break;
            }
            case 281: {
                string = "MAXSAMPLEVALUE   ";
                break;
            }
            case 282: {
                string = "XRESOLUTION      ";
                break;
            }
            case 283: {
                string = "YRESOLUTION      ";
                break;
            }
            case 284: {
                string = "PLANARCONFIG     ";
                break;
            }
            case 285: {
                string = "PAGENAME         ";
                break;
            }
            case 286: {
                string = "XPOSITION        ";
                break;
            }
            case 287: {
                string = "YPOSITION        ";
                break;
            }
            case 288: {
                string = "FREEOFFSETS      ";
                break;
            }
            case 289: {
                string = "FREEBYTECOUNTS   ";
                break;
            }
            case 290: {
                string = "GRAYRESPONSEUNIT ";
                break;
            }
            case 291: {
                string = "GRAYRESPONSECURVE ";
                break;
            }
            case 292: {
                string = "GROUP3OPTIONS    ";
                break;
            }
            case 293: {
                string = "GROUP4OPTIONS    ";
                break;
            }
            case 296: {
                string = "RESOLUTIONUNIT   ";
                break;
            }
            case 297: {
                string = "PAGENUMBER       ";
                break;
            }
            case 300: {
                string = "COLORRESPONSEUNIT ";
                break;
            }
            case 301: {
                string = "TRANSFERFUNCTION ";
                break;
            }
            case 305: {
                string = "SOFTWARE         ";
                break;
            }
            case 306: {
                string = "DATETIME         ";
                break;
            }
            case 315: {
                string = "ARTIST           ";
                break;
            }
            case 316: {
                string = "HOSTCOMPUTER     ";
                break;
            }
            case 317: {
                string = "PREDICTOR        ";
                break;
            }
            case 318: {
                string = "WHITEPOINT       ";
                break;
            }
            case 319: {
                string = "PRIMARYCHROMATICITIES ";
                break;
            }
            case 320: {
                string = "COLORMAP         ";
                break;
            }
            case 321: {
                string = "HALFTONEHINTS    ";
                break;
            }
            case 322: {
                string = "TILEWIDTH        ";
                break;
            }
            case 323: {
                string = "TILELENGTH       ";
                break;
            }
            case 324: {
                string = "TILEOFFSETS      ";
                break;
            }
            case 325: {
                string = "TILEBYTECOUNTS   ";
                break;
            }
            case 326: {
                string = "BADFAXLINES      ";
                break;
            }
            case 327: {
                string = "CLEANFAXDATA     ";
                break;
            }
            case 328: {
                string = "CONSECUTIVEBADFAXLINES ";
                break;
            }
            case 332: {
                string = "INKSET           ";
                break;
            }
            case 333: {
                string = "INKNAMES         ";
                break;
            }
            case 336: {
                string = "DOTRANGE         ";
                break;
            }
            case 337: {
                string = "TARGETPRINTER    ";
                break;
            }
            case 338: {
                string = "EXTRASAMPLES     ";
                break;
            }
            case 339: {
                string = "SAMPLEFORMAT     ";
                break;
            }
            case 340: {
                string = "SMINSAMPLEVALUE  ";
                break;
            }
            case 341: {
                string = "SMAXSAMPLEVALUE  ";
                break;
            }
            case 512: {
                string = "JPEGPROC         ";
                break;
            }
            case 513: {
                string = "JPEGIFOFFSET     ";
                break;
            }
            case 514: {
                string = "JPEGIFBYTECOUNT  ";
                break;
            }
            case 515: {
                string = "JPEGRESTARTINTERVAL ";
                break;
            }
            case 517: {
                string = "JPEGLOSSLESSPREDICTORS ";
                break;
            }
            case 518: {
                string = "JPEGPOINTTRANSFORM ";
                break;
            }
            case 519: {
                string = "JPEGQTABLES      ";
                break;
            }
            case 520: {
                string = "JPEGDCTABLES     ";
                break;
            }
            case 521: {
                string = "JPEGACTABLES     ";
                break;
            }
            case 529: {
                string = "YCBCRCOEFFICIENTS ";
                break;
            }
            case 530: {
                string = "YCBCRSUBSAMPLING ";
                break;
            }
            case 531: {
                string = "YCBCRPOSITIONING ";
                break;
            }
            case 532: {
                string = "REFERENCEBLACKWHITE ";
                break;
            }
            case 32953: {
                string = "REFPTS      \t\t";
                break;
            }
            case 32954: {
                string = "REGIONTACKPOINT   ";
                break;
            }
            case 32955: {
                string = "REGIONWARPCORNERS ";
                break;
            }
            case 32956: {
                string = "REGIONAFFINE      ";
                break;
            }
            case 32995: {
                string = "MATTEING      \t";
                break;
            }
            case 32996: {
                string = "DATATYPE      \t";
                break;
            }
            case 32997: {
                string = "IMAGEDEPTH      \t";
                break;
            }
            case 32998: {
                string = "TILEDEPTH      \t";
                break;
            }
            case 33300: {
                string = "PIXAR_IMAGEFULLWIDTH ";
                break;
            }
            case 33301: {
                string = "PIXAR_IMAGEFULLLENGTH ";
                break;
            }
            case 33405: {
                string = "WRITERSERIALNUMBER ";
                break;
            }
            case 33432: {
                string = "COPYRIGHT      \t";
                break;
            }
            case 34016: {
                string = "IT8SITE      \t\t";
                break;
            }
            case 34017: {
                string = "IT8COLORSEQUENCE  ";
                break;
            }
            case 34018: {
                string = "IT8HEADER      \t";
                break;
            }
            case 34019: {
                string = "IT8RASTERPADDING  ";
                break;
            }
            case 34020: {
                string = "IT8BITSPERRUNLENGTH ";
                break;
            }
            case 34021: {
                string = "IT8BITSPEREXTENDEDRUNLENGTH ";
                break;
            }
            case 34022: {
                string = "IT8COLORTABLE     ";
                break;
            }
            case 34023: {
                string = "IT8IMAGECOLORINDICATOR ";
                break;
            }
            case 34024: {
                string = "IT8BKGCOLORINDICATOR ";
                break;
            }
            case 34025: {
                string = "IT8IMAGECOLORVALUE ";
                break;
            }
            case 34026: {
                string = "IT8BKGCOLORVALUE  ";
                break;
            }
            case 34027: {
                string = "IT8PIXELINTENSITYRANGE ";
                break;
            }
            case 34028: {
                string = "IT8TRANSPARENCYINDICATOR ";
                break;
            }
            case 34029: {
                string = "IT8COLORCHARACTERIZATION ";
                break;
            }
            case 34232: {
                string = "FRAMECOUNT      \t";
                break;
            }
            case 34675: {
                string = "ICCPROFILE      \t";
                break;
            }
            case 34750: {
                string = "JBIGOPTIONS      \t";
                break;
            }
            case 34908: {
                string = "FAXRECVPARAMS     ";
                break;
            }
            case 34909: {
                string = "FAXSUBADDRESS     ";
                break;
            }
            case 34910: {
                string = "FAXRECVTIME      \t";
                break;
            }
            case 65535: {
                string = "DCSHUESHIFTVALUES ";
                break;
            }
            case 33881: {
                string = "UNISYS_ISIS_IFD";
                break;
            }
            case 33882: {
                string = "UNISYS_SIDE";
                break;
            }
            case 33884: {
                string = "UNISYS_IXPS_IFD";
                break;
            }
            case 34975: {
                string = "BANCTEC_IFD";
                break;
            }
            default: {
                string = "Unknown Tag #" + this.id + " ";
            }
        }
        return string;
    }
}

