/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

public class Kernel {
    public static final float R2 = (float)Math.sqrt(2.0);
    public static final float[] ROBERTS_V = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] ROBERTS_H = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] PREWITT_V = new float[]{-1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f};
    public static final float[] PREWITT_H = new float[]{-1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] SOBEL_V = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
    public static float[] SOBEL_H = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
    public static final float[] FREI_CHEN_V = new float[]{-1.0f, 0.0f, 1.0f, -R2, 0.0f, R2, -1.0f, 0.0f, 1.0f};
    public static float[] FREI_CHEN_H = new float[]{-1.0f, -R2, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, R2, 1.0f};
    public static float[] EDGE_LAPLACE1 = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    public static float[] EDGE_LAPLACE2 = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 8.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    public float[] matrix = null;
    public int rows;
    public int cols;
    public int xCentre;
    public int yCentre;

    public Kernel() {
        this(new float[9]);
    }

    public Kernel(float[] fArray) {
        this.setMatrix(3, 3, 1, 1, fArray);
    }

    public Kernel(int n, int n2, float[] fArray) {
        this.setMatrix(n, n2, fArray);
    }

    public Kernel(int n, int n2, int n3, int n4, float[] fArray) {
        this.setMatrix(n, n2, n3, n4, fArray);
    }

    public void setMatrix(float[] fArray) {
        this.setMatrix(3, 3, 1, 1, fArray);
    }

    public void setMatrix(int n, int n2, float[] fArray) {
        this.setMatrix(n, n2, n / 2, n2 / 2, fArray);
    }

    public void setMatrix(int n, int n2, int n3, int n4, float[] fArray) {
        this.rows = n;
        this.cols = n2;
        this.xCentre = n3;
        this.yCentre = n4;
        this.matrix = fArray;
    }

    public float[] getMatrix() {
        return this.matrix;
    }

    public void normalize() {
        float f = 0.0f;
        int n = 0;
        while (n < this.matrix.length) {
            f += this.matrix[n];
            ++n;
        }
        if (f != 0.0f) {
            n = 0;
            while (n < this.matrix.length) {
                int n2 = n++;
                this.matrix[n2] = this.matrix[n2] / f;
            }
        }
    }
}

