/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.PreviewFilterCustomizer;
import imager.plugins.RippleFilter;
import imager.plugins.SuperGridLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RippleFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener,
ItemListener {
    private JSlider xAmplitude;
    private JSlider yAmplitude;
    private JSlider xWavelength;
    private JSlider yWavelength;
    private JComboBox U_waveChoice;
    private JComboBox u_edgeChoice;
    private RippleFilter V_filter;

    public RippleFilterCustomizer() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        SuperGridLayout superGridLayout = new SuperGridLayout(4, 2);
        jPanel.setLayout(superGridLayout);
        superGridLayout.setColWeight(1, 1);
        jPanel.add(new JLabel("X Amplitude:", 4));
        this.xAmplitude = new JSlider(0, 0, 100, 0);
        jPanel.add(this.xAmplitude);
        this.xAmplitude.setPaintTicks(true);
        this.xAmplitude.setMajorTickSpacing(50);
        this.xAmplitude.setMinorTickSpacing(5);
        this.xAmplitude.setPaintLabels(true);
        this.xAmplitude.addChangeListener(this);
        jPanel.add(new JLabel("X Wavelength:", 4));
        this.xWavelength = new JSlider(0, 0, 100, 0);
        jPanel.add(this.xWavelength);
        this.xWavelength.setPaintTicks(true);
        this.xWavelength.setMajorTickSpacing(50);
        this.xWavelength.setMinorTickSpacing(5);
        this.xWavelength.setPaintLabels(true);
        this.xWavelength.addChangeListener(this);
        jPanel.add(new JLabel("Y Amplitude:", 4));
        this.yAmplitude = new JSlider(0, 0, 100, 0);
        jPanel.add(this.yAmplitude);
        this.yAmplitude.setPaintTicks(true);
        this.yAmplitude.setMajorTickSpacing(50);
        this.yAmplitude.setMinorTickSpacing(5);
        this.yAmplitude.setPaintLabels(true);
        this.yAmplitude.addChangeListener(this);
        jPanel.add(new JLabel("Y Wavelength:", 4));
        this.yWavelength = new JSlider(0, 0, 100, 0);
        jPanel.add(this.yWavelength);
        this.yWavelength.setPaintTicks(true);
        this.yWavelength.setMajorTickSpacing(50);
        this.yWavelength.setMinorTickSpacing(5);
        this.yWavelength.setPaintLabels(true);
        this.yWavelength.addChangeListener(this);
        jPanel.add(new JLabel("Shape:", 4));
        this.U_waveChoice = new JComboBox();
        jPanel.add(this.U_waveChoice);
        this.U_waveChoice.addItemListener(this);
        this.U_waveChoice.addItem("Sine");
        this.U_waveChoice.addItem("Sawtooth");
        this.U_waveChoice.addItem("Triangle");
        this.U_waveChoice.addItem("Noise");
        jPanel.add(new JLabel("At Edges:", 4));
        this.u_edgeChoice = new JComboBox();
        jPanel.add(this.u_edgeChoice);
        this.u_edgeChoice.addItemListener(this);
        this.u_edgeChoice.addItem("Transparent");
        this.u_edgeChoice.addItem("Clamp");
        this.u_edgeChoice.addItem("Wrap");
    }

    public void setObject(Object object) {
        super.setObject(object);
        this.V_filter = (RippleFilter)object;
        this.xAmplitude.setValue((int)this.V_filter.xAmplitude);
        this.xWavelength.setValue((int)this.V_filter.xWavelength);
        this.yAmplitude.setValue((int)this.V_filter.yAmplitude);
        this.yWavelength.setValue((int)this.V_filter.yWavelength);
        this.U_waveChoice.setSelectedIndex(this.V_filter.getWaveType());
        this.u_edgeChoice.setSelectedIndex(this.V_filter.getEdgeAction());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.V_filter != null) {
            Object object = changeEvent.getSource();
            if (object instanceof JSlider && ((JSlider)object).getValueIsAdjusting()) {
                return;
            }
            if (object == this.xAmplitude) {
                this.V_filter.xAmplitude = this.xAmplitude.getValue();
            } else if (object == this.xWavelength) {
                this.V_filter.xWavelength = this.xWavelength.getValue();
            } else if (object == this.yAmplitude) {
                this.V_filter.yAmplitude = this.yAmplitude.getValue();
            } else if (object == this.yWavelength) {
                this.V_filter.yWavelength = this.yWavelength.getValue();
            }
            this.preview();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.V_filter != null) {
            Object object = itemEvent.getSource();
            if (object == this.U_waveChoice) {
                this.V_filter.setWaveType(this.U_waveChoice.getSelectedIndex());
            } else if (object == this.u_edgeChoice) {
                this.V_filter.setEdgeAction(this.u_edgeChoice.getSelectedIndex());
            }
            this.preview();
        }
    }
}

