/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.Debug;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaScrollPaneLayout;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class QuaquaScrollPaneUI
extends BasicScrollPaneUI
implements VisuallyLayoutable {
    public static ComponentUI createUI(JComponent c) {
        return new QuaquaScrollPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(QuaquaManager.getBoolean("ScrollPane.opaque"));
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(super.createPropertyChangeListener());
    }

    protected void installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        if (scrollpane.getLayout() instanceof UIResource) {
            QuaquaScrollPaneLayout.UIResource layout = new QuaquaScrollPaneLayout.UIResource();
            scrollpane.setLayout(layout);
            layout.syncWithScrollPane(scrollpane);
        }
    }

    protected void uninstallDefaults(JScrollPane scrollpane) {
        super.uninstallDefaults(scrollpane);
        if (scrollpane.getLayout() instanceof UIResource) {
            ScrollPaneLayout.UIResource layout = new ScrollPaneLayout.UIResource();
            scrollpane.setLayout(layout);
            layout.syncWithScrollPane(scrollpane);
        }
    }

    public Insets getVisualMargin(Component c) {
        Insets margin = (Insets)((JComponent)c).getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        return margin == null ? new Insets(0, 0, 0, 0) : margin;
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            Insets margin = this.getVisualMargin(c);
            g.fillRect(margin.left, margin.top, c.getWidth() - margin.left - margin.right, c.getHeight() - margin.top - margin.bottom);
            this.paint(g, c);
            Debug.paint(g, c, this);
        }
    }

    public int getBaseline(JComponent c, int width, int height) {
        return -1;
    }

    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return bounds;
        }
        JScrollPane b = (JScrollPane)c;
        if (type == 1 && b.getBorder() != null) {
            Border border = b.getBorder();
            if (border instanceof UIResource) {
                InsetsUtil.subtractInto(this.getVisualMargin(b), bounds);
            }
            return bounds;
        }
        return bounds;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeListener target;

        public PropertyChangeHandler(PropertyChangeListener target) {
            this.target = target;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            Object source = e.getSource();
            if ("Frame.active".equals(propertyName)) {
                QuaquaUtilities.repaintBorder((JComponent)source);
            }
            this.target.propertyChange(e);
        }
    }
}

