/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;

class SplashWindow
extends Window
implements Runnable {
    private Image image;
    private String message;
    private Rectangle messageRect;

    public SplashWindow(Object base, Frame frame, Image image) {
        super(frame);
        this.image = image;
        this.setSize(image.getWidth(this) + 2, image.getHeight(this) + 2);
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.messageRect != null) {
            this.repaint(this.messageRect.x, this.messageRect.y, this.messageRect.width, this.messageRect.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Dimension size = this.getSize();
        if (this.image != null) {
            graphics.drawImage(this.image, 1, 1, this);
        }
        graphics.drawRect(0, 0, size.width - 1, size.height - 1);
        if (this.message != null) {
            graphics.setColor(Color.black);
            graphics.setFont(new Font("sansserif", 0, 10));
            FontMetrics fm = graphics.getFontMetrics();
            int w = fm.stringWidth(this.message);
            this.messageRect = new Rectangle(this.getWidth() - w - 20, 35 - fm.getAscent(), w, fm.getAscent() + fm.getDescent());
            graphics.drawString(this.message, this.messageRect.x, 35);
        }
        SplashWindow splashWindow = this;
        synchronized (splashWindow) {
            this.notify();
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            Dimension size = this.getSize();
            Dimension screenSize = this.getToolkit().getScreenSize();
            this.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 3);
        }
        super.setVisible(b);
    }

    public void run() {
        this.toFront();
        this.setVisible(true);
    }

    public void dispose() {
        this.image = null;
        super.dispose();
    }
}

