/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.awt;

import com.jhlabs.awt.Alignment;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class SuperGridLayout
implements LayoutManager {
    static final long serialVersionUID = -3925957639755567096L;
    protected int hGap;
    protected int vGap;
    protected int hMargin;
    protected int vMargin;
    protected int rows;
    protected int cols;
    protected int reqRows;
    protected int reqCols;
    protected int[] rowHeights;
    protected int[] colWidths;
    protected int[] colFlags;
    protected int[] rowWeights;
    protected int[] colWeights;
    protected int alignment = 8;
    protected int fill = 3;
    protected boolean labelStyle = false;

    public SuperGridLayout() {
        this(0, 1, 2, 2);
    }

    public SuperGridLayout(int rows, int cols) {
        this(rows, cols, 2, 2);
    }

    public SuperGridLayout(int rows, int cols, int hGap, int vGap) {
        this(rows, cols, hGap, vGap, 0, 0);
    }

    public SuperGridLayout(int rows, int cols, int hGap, int vGap, int hMargin, int vMargin) {
        this.reqRows = rows;
        this.reqCols = cols;
        this.hGap = hGap;
        this.vGap = vGap;
        this.hMargin = hMargin;
        this.vMargin = vMargin;
    }

    public void setLabelStyle(boolean labelStyle) {
        this.labelStyle = labelStyle;
        this.vGap = 11;
        this.hGap = 12;
        this.vMargin = 12;
        this.hMargin = 12;
        this.fill = 0;
    }

    public boolean getLabelStyle() {
        return this.labelStyle;
    }

    public void setColumns(int cols) {
        if (cols < 1) {
            cols = 1;
        }
        this.cols = cols;
    }

    public void setRows(int rows) {
        if (rows < 1) {
            rows = 1;
        }
        this.rows = rows;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setAlignment(int a) {
        this.alignment = a;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setFill(int f) {
        this.fill = f;
    }

    public int getFill() {
        return this.fill;
    }

    private int[] setWeight(int[] w, int index, int weight) {
        if (w == null) {
            w = new int[index + 1];
        } else if (index >= w.length) {
            int[] n = new int[index + 1];
            System.arraycopy(w, 0, n, 0, w.length);
            w = n;
        }
        w[index] = weight;
        return w;
    }

    public void setRowWeight(int row, int weight) {
        this.rowWeights = this.setWeight(this.rowWeights, row, weight);
    }

    public void setColWeight(int col, int weight) {
        this.colWeights = this.setWeight(this.colWeights, col, weight);
    }

    public void setColAlignment(int col, int v) {
        this.colFlags = this.setWeight(this.colFlags, col, v);
    }

    protected int getRowWeight(int row) {
        if (this.rowWeights != null && row < this.rowWeights.length) {
            return this.rowWeights[row];
        }
        return 0;
    }

    protected int getColWeight(int col) {
        if (this.colWeights != null && col < this.colWeights.length) {
            return this.colWeights[col];
        }
        return 0;
    }

    protected int getColAlignment(int col) {
        if (this.colFlags != null && col < this.colFlags.length) {
            return this.colFlags[col];
        }
        return this.alignment;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int count = target.getComponentCount();
        this.calcCellSizes(target, true);
        dim.width = this.sumArray(this.colWidths, this.hGap, this.cols);
        dim.height = this.sumArray(this.rowHeights, this.vGap, this.rows);
        this.colWidths = null;
        this.rowHeights = null;
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + 2 * this.hMargin;
        dim.height += insets.top + insets.bottom + 2 * this.vMargin;
        return dim;
    }

    public void layoutContainer(Container target) {
        int count = target.getComponentCount();
        if (count > 0) {
            Insets insets = target.getInsets();
            Dimension size = target.getSize();
            this.calcCellSizes(target, false);
            for (int i = 0; i < count; ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                Rectangle r = new Rectangle(0, 0, d.width, d.height);
                int row = i / this.cols;
                int col = i % this.cols;
                int x = insets.left + this.sumArray(this.colWidths, this.hGap, col) + this.hMargin;
                int y = insets.top + this.sumArray(this.rowHeights, this.vGap, row) + this.vMargin;
                if (col > 0) {
                    x += this.hGap;
                }
                if (row > 0) {
                    y += this.vGap;
                }
                Rectangle cell = new Rectangle(x, y, this.colWidths[col], this.rowHeights[row]);
                Alignment.alignInCell(r, cell, this.alignmentFor(c, row, col), this.fillFor(c, row, col));
                c.setBounds(r.x, r.y, r.width, r.height);
            }
        }
        this.colWidths = null;
        this.rowHeights = null;
    }

    private Dimension calcMaxSize(Container target) {
        int count = target.getComponentCount();
        Dimension maxSize = new Dimension(0, 0);
        for (int i = 0; i < count; ++i) {
            Dimension d = target.getComponent(i).getPreferredSize();
            if (d.width > maxSize.width) {
                maxSize.width = d.width;
            }
            if (d.height <= maxSize.height) continue;
            maxSize.height = d.height;
        }
        return maxSize;
    }

    protected int sumArray(int[] array, int spacing, int size) {
        int total = 0;
        for (int i = 0; i < size; ++i) {
            total += array[i];
        }
        if (size > 1) {
            total += (size - 1) * spacing;
        }
        return total;
    }

    protected void calcCellSizes(Container target, boolean preferred) {
        int i;
        int count = target.getComponentCount();
        if (this.reqCols <= 0) {
            this.rows = this.reqRows;
            this.cols = (count + this.reqRows - 1) / this.reqRows;
        } else {
            this.rows = (count + this.reqCols - 1) / this.reqCols;
            this.cols = this.reqCols;
        }
        this.colWidths = new int[this.cols];
        for (i = 0; i < this.cols; ++i) {
            this.colWidths[i] = 0;
        }
        this.rowHeights = new int[this.rows];
        for (i = 0; i < this.rows; ++i) {
            this.rowHeights[i] = 0;
        }
        for (i = 0; i < count; ++i) {
            Component c = target.getComponent(i);
            if (!c.isVisible()) continue;
            Dimension size = c.getPreferredSize();
            int row = i / this.cols;
            int col = i % this.cols;
            if (this.colWidths[col] < size.width) {
                this.colWidths[col] = size.width;
            }
            if (this.rowHeights[row] >= size.height) continue;
            this.rowHeights[row] = size.height;
        }
        if (!preferred) {
            int remainder;
            Dimension size = target.getSize();
            Insets insets = target.getInsets();
            size.width -= insets.left + insets.right + 2 * this.hMargin;
            size.height -= insets.top + insets.bottom + 2 * this.vMargin;
            int totalSize = 0;
            int totalWeight = 0;
            for (i = 0; i < this.cols; ++i) {
                totalWeight += this.getColWeight(i);
                totalSize += this.colWidths[i];
                if (i == 0) continue;
                totalSize += this.hGap;
            }
            if (totalWeight != 0) {
                remainder = size.width - totalSize;
                for (i = 0; i < this.cols; ++i) {
                    int n = i;
                    this.colWidths[n] = this.colWidths[n] + remainder * this.getColWeight(i) / totalWeight;
                }
            }
            totalSize = 0;
            totalWeight = 0;
            for (i = 0; i < this.rows; ++i) {
                totalWeight += this.getRowWeight(i);
                totalSize += this.rowHeights[i];
                if (i == 0) continue;
                totalSize += this.vGap;
            }
            if (totalWeight != 0) {
                remainder = size.height - totalSize;
                for (i = 0; i < this.rows; ++i) {
                    int n = i;
                    this.rowHeights[n] = this.rowHeights[n] + remainder * this.getRowWeight(i) / totalWeight;
                }
            }
        }
    }

    protected int alignmentFor(Component c, int row, int col) {
        if (this.labelStyle && col == 0) {
            if (this.rowHeights[row] > c.getPreferredSize().height * 3) {
                return 2;
            }
            return 3;
        }
        return this.getColAlignment(col);
    }

    protected int fillFor(Component c, int row, int col) {
        if (this.labelStyle && col == 0) {
            return 0;
        }
        return this.fill;
    }
}

