/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.app.Application;
import com.jhlabs.app.ApplicationAction;
import com.jhlabs.app.Document;
import com.jhlabs.app.DocumentController;
import com.jhlabs.app.DocumentWindow;
import com.jhlabs.app.StatusDisplay;
import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.CompositionView;
import com.jhlabs.ie.CompositionWindow;
import com.jhlabs.ie.CustomizerDialog;
import com.jhlabs.ie.FileFormat;
import com.jhlabs.ie.Tool;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.ie.layer.TextLayer;
import com.jhlabs.ie.tool.TextTool;
import com.jhlabs.image.DilateFilter;
import com.jhlabs.image.ErodeAlphaFilter;
import com.jhlabs.image.FillFilter;
import com.jhlabs.image.FlipFilter;
import com.jhlabs.image.GaussianFilter;
import com.jhlabs.image.InvertAlphaFilter;
import com.jhlabs.image.RotateFilter;
import com.jhlabs.image.ScaleFilterCustomizer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CompositionController
extends DocumentController
implements StatusDisplay {
    private Action clearAction;
    public Action newLayerAction;
    public Action deleteLayerAction;
    public Action duplicateLayerAction;
    public Action renameLayerAction;
    public Action moveLayerUpAction;
    public Action moveLayerDownAction;
    public Action mergeLayerDownAction;
    protected ResourceBundle imageResources;

    public CompositionController(CompositionApplication application) {
        super(application);
    }

    protected void registerActions() {
        super.registerActions();
        this.imageResources = ResourceBundle.getBundle("com.jhlabs.ie.CompositionResourceBundle");
        this.registerAction(new ZoomAction(2.0));
        this.registerAction(new ZoomAction(0.5));
        this.registerAction(new ZoomToFitAction());
        this.registerAction(new ZoomAction(1));
        this.registerAction(new ZoomAction(2));
        this.registerAction(new ZoomAction(4));
        this.registerAction(new ZoomAction(8));
        this.registerAction(new ZoomAction(16));
        this.registerAction(new ShowGridAction());
        this.registerAction(new ShowSelectionAction());
        this.registerAction(new ShowSelectionAsMaskAction());
        this.registerAction(new SelectionFromAlphaAction());
        this.registerAction(new NewLayerFromSelectionAction());
        this.registerAction(new SelectAllAction());
        this.registerAction(new SelectNoneAction());
        this.registerAction(new SelectInverseAction());
        this.registerAction(new GrowSelectionAction());
        this.registerAction(new ShrinkSelectionAction());
        this.registerAction(new FeatherSelectionAction());
        this.registerAction(new CutAction());
        this.registerAction(new CopyAction());
        this.registerAction(new CopyMergedAction());
        this.registerAction(new PasteAction());
        this.clearAction = new ClearAction();
        this.registerAction(this.clearAction);
        this.registerAction(new CropAction());
        this.registerAction(new ResizeAction());
        this.registerAction(new FloatSelectionAction());
        this.registerAction(new FillSelectionAction());
        this.registerAction(new FlipAction(1, false));
        this.registerAction(new FlipAction(2, false));
        this.registerAction(new FlipAction(3, false));
        this.registerAction(new FlipAction(4, false));
        this.registerAction(new FlipAction(5, false));
        this.registerAction(new FlipAction(6, false));
        this.registerAction(new FlipAction(1, true));
        this.registerAction(new FlipAction(2, true));
        this.registerAction(new FlipAction(3, true));
        this.registerAction(new FlipAction(4, true));
        this.registerAction(new FlipAction(5, true));
        this.registerAction(new FlipAction(6, true));
        this.registerAction(new RotateAction(1.5707964f));
        this.registerAction(new RepeatFilterAction());
        this.registerAction(new ShowLastFilterAction());
        this.registerAction(new ToolPropertiesAction());
        this.registerAction(new DebugAction());
        this.registerAction(new PostURLAction());
        this.newLayerAction = new NewLayerAction();
        this.registerAction(this.newLayerAction);
        this.registerAction(new NewLayerCopyAction());
        this.registerAction(new NewLayerCutAction());
        this.deleteLayerAction = new DeleteLayerAction();
        this.registerAction(this.deleteLayerAction);
        this.duplicateLayerAction = new DuplicateLayerAction();
        this.registerAction(this.duplicateLayerAction);
        this.renameLayerAction = new RenameLayerAction();
        this.registerAction(this.renameLayerAction);
        this.moveLayerUpAction = new MoveLayerUpAction();
        this.registerAction(this.moveLayerUpAction);
        this.moveLayerDownAction = new MoveLayerDownAction();
        this.registerAction(this.moveLayerDownAction);
        this.mergeLayerDownAction = new MergeLayerDownAction();
        this.registerAction(this.mergeLayerDownAction);
    }

    public DocumentWindow makeDocumentWindow(Document document) {
        CompositionDocument imageDocument = (CompositionDocument)document;
        CompositionWindow window = new CompositionWindow(imageDocument, this);
        CompositionView view = window.getCompositionView();
        int size = Math.max(imageDocument.getWidth(), imageDocument.getHeight());
        if (size <= 32) {
            view.setScale(8.0f);
        } else if (size <= 64) {
            view.setScale(4.0f);
        }
        if (this.application.isMDI) {
            window.getInternalFrame().pack();
            window.getInternalFrame().revalidate();
        } else {
            window.getJFrame().pack();
            Dimension wSize = window.getJFrame().getSize();
            window.getJFrame().setSize(wSize.width, wSize.height + 1);
        }
        view.registerKeyboardAction(this.clearAction, KeyStroke.getKeyStroke(127, 0), 2);
        view.registerKeyboardAction(this.clearAction, KeyStroke.getKeyStroke(8, 0), 2);
        Vector tools = ((CompositionApplication)this.application).getPluginTools();
        Iterator it = tools.iterator();
        while (it.hasNext()) {
            Tool tool = (Tool)it.next();
            char c = tool.getShortcutKey();
            if (c == '\u0000') continue;
            view.registerKeyboardAction(new SelectToolAction(tool), KeyStroke.getKeyStroke(c), 2);
        }
        this.enableCommands();
        return window;
    }

    public void addSpecialMenuItem(DocumentWindow window, JMenu menu, String name) {
        if (name.equals("(filters)")) {
            Hashtable<String, JMenu> groups = new Hashtable<String, JMenu>();
            Vector filterList = ((CompositionApplication)this.application).getFilters();
            Collections.sort(filterList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            Enumeration e = filterList.elements();
            while (e.hasMoreElements()) {
                Object filter = e.nextElement();
                FilterAction action = new FilterAction(filter);
                this.registerAction(action);
                JMenu subMenu = menu;
                String filterName = filter.toString();
                int index = filterName.indexOf(47);
                if (index != -1) {
                    String group = filterName.substring(0, index);
                    filterName = filterName.substring(index + 1);
                    subMenu = (JMenu)groups.get(group);
                    if (subMenu == null) {
                        subMenu = new JMenu(group);
                        menu.add(subMenu);
                        groups.put(group, subMenu);
                    }
                }
                if ((index = filterName.indexOf(64)) != -1) {
                    filterName = filterName.substring(0, index);
                }
                JMenuItem item = this.makeMenuItem(action, null);
                subMenu.add(item);
                item.setEnabled(false);
                this.actionItems.put(action, item);
            }
        } else if (name.equals("(export)")) {
            JMenu exportMenu = new JMenu(this.localize("export"));
            menu.add(exportMenu);
            Enumeration e = ((CompositionApplication)this.application).fileFormats.elements();
            while (e.hasMoreElements()) {
                FileFormat fileFormat = (FileFormat)e.nextElement();
                if (!fileFormat.canWrite()) continue;
                ExportAction action = new ExportAction(fileFormat);
                this.registerAction(action);
                JMenuItem item = this.makeMenuItem(action, null);
                exportMenu.add(item);
                this.actionItems.put(action, item);
                item.setEnabled(false);
            }
        } else {
            super.addSpecialMenuItem(window, menu, name);
        }
    }

    public String localize(String name) {
        if (this.imageResources == null) {
            this.imageResources = ResourceBundle.getBundle("com.jhlabs.ie.CompositionResourceBundle");
        }
        try {
            return this.imageResources.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            return super.localize(name);
        }
    }

    public boolean doSaveAs(Document document) {
        CompositionDocument imageDocument = (CompositionDocument)document;
        return this.doSaveAs(imageDocument, imageDocument.getFileFormat());
    }

    public boolean doSaveAs(Document document, FileFormat fileFormat) {
        CompositionDocument imageDocument = (CompositionDocument)document;
        imageDocument.performPendingTask();
        if (fileFormat == null || !fileFormat.canWrite()) {
            Object selectedValue;
            Vector<FileFormat> fileFormats = new Vector<FileFormat>();
            Enumeration e = ((CompositionApplication)this.application).fileFormats.elements();
            while (e.hasMoreElements()) {
                FileFormat f = (FileFormat)e.nextElement();
                if (!f.canWrite()) continue;
                fileFormats.addElement(f);
            }
            if (fileFormats.size() > 1) {
                Object[] possibleValues = new Object[fileFormats.size()];
                fileFormats.copyInto(possibleValues);
                Object initialValue = imageDocument.getFileFormat();
                if (initialValue == null) {
                    initialValue = possibleValues[0];
                }
                selectedValue = JOptionPane.showInputDialog(this.getFrame(), "Choose a file format:", "Save", 3, null, possibleValues, initialValue);
            } else {
                selectedValue = (FileFormat)fileFormats.firstElement();
            }
            if (selectedValue != null) {
                fileFormat = selectedValue;
            }
        }
        if (fileFormat != null) {
            imageDocument.setFileFormat(fileFormat);
            if (fileFormat.showOptionsDialog(this.getFrame(), imageDocument)) {
                return super.doSaveAs(document);
            }
        }
        return false;
    }

    public void saveDocument(Document document) {
        File file = document.getFile();
        try {
            document.writeFile(file);
        }
        catch (Throwable e) {
            Object[] arguments = new Object[]{file.getName(), e.getMessage()};
            String message = MessageFormat.format(this.commonResources.getString("cantSaveFile"), arguments);
            JOptionPane.showMessageDialog(null, message, "Error", 0);
        }
    }

    public void revertDocument(Document document) {
        try {
            document.readFile(document.getFile());
            document.setChanged(false);
            this.application.setCurrentDocument(null);
            this.application.setCurrentDocument(document);
        }
        catch (Exception e) {
            Object[] arguments = new Object[]{document.getFile().getName(), e.getMessage()};
            ResourceBundle commonResources = ResourceBundle.getBundle("com.jhlabs.app.CommonResourceBundle");
            String message = MessageFormat.format(commonResources.getString("cantOpenFile"), arguments);
            JOptionPane.showMessageDialog(this.getFrame(), message, "Error", 0);
        }
    }

    public void doPrint(DocumentWindow window) {
        CompositionDocument document = (CompositionDocument)window.getDocument();
        PrintJob printJob = this.getFrame().getToolkit().getPrintJob(this.getFrame(), document.getTitle(), null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            Dimension size = printJob.getPageDimension();
            BufferedImage image = document.getComposition().getCompositeImage();
            JFrame observer = this.getFrame();
            graphics.drawImage(image, (size.width - ((Image)image).getWidth(observer)) / 2, (size.height - ((Image)image).getHeight(observer)) / 2, observer);
            graphics.dispose();
            printJob.end();
        }
    }

    class SelectToolAction
    extends ApplicationAction {
        private Tool tool;

        public SelectToolAction(Tool tool) {
            super("tool");
            this.tool = tool;
        }

        public void actionPerformed(ActionEvent e) {
            CompositionApplication application = (CompositionApplication)Application.getInstance();
            application.setTool(this.tool);
        }
    }

    class SimplifyLayerAction
    extends ImageAction {
        public SimplifyLayerAction() {
            super("simplifyLayer", CompositionController.this.imageResources, null);
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering() && composition.getActiveLayer() instanceof TextLayer;
        }

        public void actionPerformed(ActionEvent e) {
            CompositionDocument document = this.getCompositionDocument();
            document.doSimplifyLayer(document.getActiveLayer());
        }
    }

    class MergeLayerDownAction
    extends ImageAction {
        public MergeLayerDownAction() {
            super("mergeLayerDown", CompositionController.this.imageResources, null);
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering() && composition.getActiveLayer() != composition.getBottomLayer();
        }

        public void actionPerformed(ActionEvent e) {
            CompositionDocument document = this.getCompositionDocument();
            document.doMergeLayer(document.getActiveLayer());
        }
    }

    class MoveLayerDownAction
    extends ImageAction {
        public MoveLayerDownAction() {
            super("moveLayerDown", CompositionController.this.imageResources, null);
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering() && composition.getActiveLayer() != composition.getBottomLayer();
        }

        public void actionPerformed(ActionEvent e) {
            CompositionDocument document = this.getCompositionDocument();
            document.doReorderLayer(document.getActiveLayer(), -1, false);
        }
    }

    class MoveLayerUpAction
    extends ImageAction {
        public MoveLayerUpAction() {
            super("moveLayerUp", CompositionController.this.imageResources, null);
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering() && composition.getActiveLayer() != composition.getTopLayer();
        }

        public void actionPerformed(ActionEvent e) {
            CompositionDocument document = this.getCompositionDocument();
            document.doReorderLayer(document.getActiveLayer(), -1, true);
        }
    }

    class RenameLayerAction
    extends ImageAction {
        public RenameLayerAction() {
            super("renameLayer", CompositionController.this.imageResources, null);
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering() && composition.getActiveLayer() != null;
        }

        public void actionPerformed(ActionEvent e) {
            Composition composition = this.getComposition();
            Layer layer = composition.getActiveLayer();
            JTextField text = new JTextField(30);
            Object[] message = new Object[]{"Layer Name:", text};
            text.setText(layer.getName());
            DocumentWindow currentWindow = CompositionController.this.application.getCurrentDocumentWindow();
            if (JOptionPane.showConfirmDialog(null, message, "Rename Layer", 2, -1) == 0) {
                layer.setName(text.getText());
                composition.layerHasChanged(layer);
            }
            currentWindow.toFront();
            CompositionController.this.application.busyCursor(false);
        }
    }

    class DuplicateLayerAction
    extends ImageAction {
        public DuplicateLayerAction() {
            super("duplicateLayer", CompositionController.this.imageResources, null);
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering() && composition.getActiveLayer() != null;
        }

        public void actionPerformed(ActionEvent e) {
            CompositionDocument document = this.getCompositionDocument();
            document.doDuplicateLayer(document.getActiveLayer());
        }
    }

    class DeleteLayerAction
    extends ImageAction {
        public DeleteLayerAction() {
            super("deleteLayer", CompositionController.this.imageResources, null);
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering() && composition.getActiveLayer() != null;
        }

        public void actionPerformed(ActionEvent e) {
            CompositionDocument document = this.getCompositionDocument();
            Composition composition = this.getComposition();
            document.doRemoveLayer(document.getActiveLayer());
        }
    }

    class NewLayerCutAction
    extends ImageAction {
        public NewLayerCutAction() {
            super("newLayerCut", CompositionController.this.imageResources, null);
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering();
        }

        public void actionPerformed(ActionEvent e) {
            CompositionDocument document = this.getCompositionDocument();
            document.doAddLayer(true, true);
        }
    }

    class NewLayerCopyAction
    extends ImageAction {
        public NewLayerCopyAction() {
            super("newLayerCopy", CompositionController.this.imageResources, null);
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering();
        }

        public void actionPerformed(ActionEvent e) {
            CompositionDocument document = this.getCompositionDocument();
            document.doAddLayer(true, false);
        }
    }

    class NewLayerAction
    extends ImageAction {
        public NewLayerAction() {
            super("newLayer", CompositionController.this.imageResources, null);
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering();
        }

        public void actionPerformed(ActionEvent e) {
            CompositionDocument document = this.getCompositionDocument();
            document.doAddLayer(false, false);
        }
    }

    class PostURLAction
    extends ImageAction {
        public PostURLAction() {
            super("postURL");
        }

        public void actionPerformed(ActionEvent event) {
            String s = JOptionPane.showInputDialog("Enter a URL:");
            if (s != null) {
                try {
                    String line;
                    URL url = new URL(s);
                    URLConnection connection = url.openConnection();
                    connection.setDoOutput(true);
                    BufferedOutputStream bos = new BufferedOutputStream(connection.getOutputStream());
                    ImageIO.write((RenderedImage)this.getComposition().getCompositeImage(), "png", bos);
                    bos.flush();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    while ((line = rd.readLine()) != null) {
                        System.out.println(line);
                    }
                    bos.close();
                    rd.close();
                }
                catch (MalformedURLException e) {
                    JOptionPane.showMessageDialog(this.getApplication().getDialogParent(), "The URL is not valid", "Can't open URL", -1);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.getApplication().getDialogParent(), "Can't post to the URL: " + e.getMessage(), "Can't Post", -1);
                }
            }
        }
    }

    class ExportAction
    extends ImageAction {
        private FileFormat export;

        public ExportAction(FileFormat export) {
            super(export.toString());
            this.export = export;
        }

        public void actionPerformed(ActionEvent e) {
            CompositionController.this.doSaveAs(this.getCompositionDocument(), this.export);
        }
    }

    class DebugAction
    extends ImageAction {
        public DebugAction() {
            super("debug");
        }

        public void actionPerformed(ActionEvent e) {
            Layer l;
            CompositionDocument document = this.getCompositionDocument();
            Composition composition = document.getComposition();
            composition.startUpdate();
            composition.updateAll();
            composition.endUpdate();
            JFrame f = new JFrame();
            JPanel c = new JPanel();
            JScrollPane sp = new JScrollPane(c);
            f.getContentPane().add(sp);
            c.setLayout(new SuperGridLayout(0, 1));
            Enumeration en = composition.getLayersModel().elements();
            while (en.hasMoreElements()) {
                l = (Layer)en.nextElement();
                c.add(new JLabel(l.getName()));
                c.add(new JLabel(new ImageIcon(l.getImage())));
            }
            l = composition.getFloatingLayer();
            if (l != null) {
                c.add(new JLabel("Floating"));
                c.add(new JLabel(new ImageIcon(l.getImage())));
            }
            f.pack();
            f.setVisible(true);
        }
    }

    class ToolPropertiesAction
    extends ImageAction {
        public ToolPropertiesAction() {
            super("toolProperties");
        }

        public boolean isEnabled() {
            Tool tool = this.getCompositionApplication().getTool();
            return tool != null && tool.hasCustomizer();
        }

        public void actionPerformed(ActionEvent event) {
            Tool tool = this.getCompositionApplication().getTool();
            this.getCompositionApplication().showToolCustomizer(tool);
        }
    }

    class ShowLastFilterAction
    extends ImageAction {
        public ShowLastFilterAction() {
            super("showLastFilter");
        }

        public boolean isEnabled() {
            CompositionDocument document = this.getCompositionDocument();
            return document != null && !document.isFiltering() && this.getCompositionApplication().getLastFilter() != null;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.makePaintable()) {
                this.getCompositionDocument().showLastFilter();
            }
        }
    }

    class RepeatFilterAction
    extends ImageAction {
        public RepeatFilterAction() {
            super("repeatFilter");
        }

        public boolean isEnabled() {
            CompositionDocument document = this.getCompositionDocument();
            return document != null && !document.isFiltering() && this.getCompositionApplication().getLastFilter() != null;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.makePaintable()) {
                this.getCompositionDocument().repeatLastFilter();
            }
        }
    }

    class NewLayerFromSelectionAction
    extends ImageAction {
        public NewLayerFromSelectionAction() {
            super("newLayerFromSelection");
        }

        public void actionPerformed(ActionEvent e) {
            Composition composition = this.getComposition();
            composition.newLayerFromSelection();
        }
    }

    class SelectionFromAlphaAction
    extends ImageAction {
        public SelectionFromAlphaAction() {
            super("selectionFromAlpha", null, "selectionFromAlpha");
        }

        public void actionPerformed(ActionEvent e) {
            Composition composition = this.getComposition();
            composition.selectionFromAlpha(composition.getActiveLayer());
        }
    }

    class FillSelectionAction
    extends ImageAction {
        public FillSelectionAction() {
            super("fillSelection", null, "fillSelection");
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return this.isPaintable();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.makePaintable()) {
                this.getCompositionDocument().filterImage(new FillFilter(this.getCompositionApplication().getFgColor()));
            }
        }
    }

    class ResizeAction
    extends ImageAction {
        public ResizeAction() {
            super("resizeImage");
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !this.isFiltering();
        }

        public void actionPerformed(ActionEvent e) {
            Composition composition = this.getComposition();
            ScaleFilterCustomizer customizer = new ScaleFilterCustomizer(composition.getWidth(), composition.getHeight());
            CustomizerDialog d = new CustomizerDialog(this.getFrame(), "Resize Image", customizer);
            if (d.showDialog()) {
                BufferedImageOp filter = customizer.getFilter();
                this.getCompositionDocument().resize(customizer.getNewWidth(), customizer.getNewHeight(), filter);
            }
        }
    }

    class CropAction
    extends ImageAction {
        public CropAction() {
            super("cropImage");
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return this.isPaintable();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.makePaintable()) {
                this.getCompositionDocument().crop();
                ((CompositionWindow)this.getDocumentWindow()).sizeToFit();
            }
        }
    }

    class FilterAction
    extends ImageAction {
        private Object filter;

        public FilterAction(Object filter) {
            super("filterAction");
            String filterName = filter.toString();
            int index = filterName.indexOf(47);
            if (index != -1) {
                filterName = filterName.substring(index + 1);
            }
            this.putValue("Name", filterName);
            this.filter = filter;
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return this.isPaintable();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.makePaintable()) {
                this.performPendingTask();
                this.getCompositionDocument().filterImage(this.filter);
            }
        }
    }

    class RotateAction
    extends ImageAction {
        private float angle;

        public RotateAction(float angle) {
            super("rotate");
            this.angle = angle;
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return this.isPaintable();
        }

        public void actionPerformed(ActionEvent e) {
            this.getCompositionDocument().filterImage(new RotateFilter(this.angle));
        }
    }

    class FlipAction
    extends ImageAction {
        private int operation;
        private boolean wholeImage;

        public FlipAction(int operation, boolean wholeImage) {
            super("flip");
            this.operation = operation;
            this.wholeImage = wholeImage;
            this.putValue("Name", this.localize(this.getName()));
            this.putValue("int_name", this.getName());
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return this.isPaintable();
        }

        public void actionPerformed(ActionEvent e) {
            CompositionDocument document = this.getCompositionDocument();
            if (this.wholeImage) {
                int height;
                int width;
                Composition composition = document.getComposition();
                int w = composition.getWidth();
                int h = composition.getHeight();
                switch (this.operation) {
                    default: {
                        width = w;
                        height = h;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        width = h;
                        height = w;
                    }
                }
                document.resize(width, height, new FlipFilter(this.operation));
            } else if (this.makePaintable()) {
                document.filterImage(new FlipFilter(this.operation));
            }
        }

        public String getName() {
            String name = "flip";
            switch (this.operation) {
                case 1: {
                    name = "flipHorizontal";
                    break;
                }
                case 2: {
                    name = "flipVertical";
                    break;
                }
                case 3: {
                    name = "flipDiagonal";
                    break;
                }
                case 4: {
                    name = "rotate90cw";
                    break;
                }
                case 5: {
                    name = "rotate90ccw";
                    break;
                }
                case 6: {
                    name = "rotate180";
                }
            }
            if (this.wholeImage) {
                name = name + "Image";
            }
            return name;
        }
    }

    class FloatSelectionAction
    extends ImageAction {
        public FloatSelectionAction() {
            super("floatSelection");
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null && !composition.hasFloatingSelection() && !this.isFiltering();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.makePaintable()) {
                Composition composition = this.getComposition();
                composition.startUpdate();
                composition.floatSelection(true);
                composition.endUpdate();
                CompositionController.this.enableCommands();
            }
        }
    }

    class FeatherSelectionAction
    extends ImageAction {
        public FeatherSelectionAction() {
            super("featherSelection");
        }

        public boolean isEnabled() {
            return this.hasPaintableSelection();
        }

        public void actionPerformed(ActionEvent e) {
            JSlider slider = new JSlider(0, 0, 20, 1);
            slider.setPaintTicks(true);
            slider.setMajorTickSpacing(5);
            slider.setMinorTickSpacing(1);
            slider.setPaintLabels(true);
            Object[] message = new Object[]{"Radius:", slider};
            if (JOptionPane.showConfirmDialog(this.getFrame(), message, "Feather Selection", 2, -1) == 0 && slider.getValue() != 0) {
                this.getComposition().filterSelection(new GaussianFilter(slider.getValue()));
            }
        }
    }

    class ShrinkSelectionAction
    extends ImageAction {
        public ShrinkSelectionAction() {
            super("shrinkSelection");
        }

        public boolean isEnabled() {
            return this.hasPaintableSelection();
        }

        public void actionPerformed(ActionEvent e) {
            this.getComposition().filterSelection(new DilateFilter());
        }
    }

    class GrowSelectionAction
    extends ImageAction {
        public GrowSelectionAction() {
            super("growSelection");
        }

        public boolean isEnabled() {
            return this.hasPaintableSelection();
        }

        public void actionPerformed(ActionEvent e) {
            JSlider slider = new JSlider(0, -20, 20, 1);
            slider.setPaintTicks(true);
            slider.setMajorTickSpacing(5);
            slider.setMinorTickSpacing(1);
            slider.setPaintLabels(true);
            Object[] message = new Object[]{"Radius:", slider};
            if (JOptionPane.showConfirmDialog(this.getFrame(), message, "Grow Selection", 2, -1) == 0 && slider.getValue() != 0) {
                float radius = slider.getValue();
                float threshold = 0.75f;
                if (radius < 0.0f) {
                    radius = -radius;
                    threshold = 0.25f;
                }
                this.getComposition().filterSelection(new ErodeAlphaFilter(2.0f * radius, threshold, 0.0f));
            }
        }
    }

    class SelectInverseAction
    extends ImageAction {
        public SelectInverseAction() {
            super("selectInverse");
        }

        public void actionPerformed(ActionEvent e) {
            this.getComposition().filterSelection(new InvertAlphaFilter());
        }
    }

    class SelectNoneAction
    extends ImageAction {
        public SelectNoneAction() {
            super("selectNone", null, "selectNone");
        }

        public void actionPerformed(ActionEvent e) {
            Composition composition = this.getComposition();
            composition.startUpdate();
            composition.dropFloatingSelection();
            composition.selectNone();
            composition.endUpdate();
        }
    }

    class SelectAllAction
    extends ImageAction {
        public SelectAllAction() {
            super("selectAll", null, "selectAll");
        }

        public void actionPerformed(ActionEvent e) {
            Composition composition = this.getComposition();
            composition.startUpdate();
            composition.dropFloatingSelection();
            composition.selectAll();
            composition.endUpdate();
        }
    }

    class ZoomToFitAction
    extends ImageAction {
        public ZoomToFitAction() {
            super("zoomToFit");
        }

        public void actionPerformed(ActionEvent e) {
            this.getCompositionView().zoomToFit();
            ((CompositionWindow)this.getDocumentWindow()).sizeToFit();
        }
    }

    class ZoomAction
    extends ImageAction {
        private double factor;
        private int scale;

        public ZoomAction(double factor) {
            super(factor > 1.0 ? "zoomIn" : "zoomOut");
            this.factor = 1.0;
            this.scale = 0;
            this.factor = factor;
        }

        public ZoomAction(int scale) {
            super("zoom-" + scale);
            this.factor = 1.0;
            this.scale = 0;
            this.scale = scale;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.scale == 0) {
                this.getCompositionView().zoomBy(this.factor);
            } else {
                this.getCompositionView().setScale(this.scale);
            }
            ((CompositionWindow)this.getDocumentWindow()).sizeToFit();
        }
    }

    public class ShowSelectionAsMaskAction
    extends ImageAction {
        public ShowSelectionAsMaskAction() {
            super("showSelectionAsMask");
        }

        public void actionPerformed(ActionEvent event) {
            this.getCompositionView().setShowSelectionAsMask(!this.getCompositionView().getShowSelectionAsMask());
        }
    }

    public class ShowSelectionAction
    extends ImageAction {
        public ShowSelectionAction() {
            super("showSelection");
        }

        public void actionPerformed(ActionEvent event) {
            this.getComposition().setDrawSelectionOnly(!this.getComposition().getDrawSelectionOnly());
        }
    }

    public class ShowGridAction
    extends ImageAction {
        public ShowGridAction() {
            super("showGrid");
        }

        public void actionPerformed(ActionEvent event) {
            this.getCompositionView().setShowGrid(!this.getCompositionView().getShowGrid());
        }
    }

    class ClearAction
    extends ImageAction {
        public ClearAction() {
            super("clear", null, "Delete24");
        }

        public boolean isEnabled() {
            return this.hasPaintableSelection() || this.hasFloatingSelection();
        }

        public void actionPerformed(ActionEvent e) {
            Tool tool = this.getCompositionApplication().getTool();
            if (!(tool instanceof TextTool) && this.makePaintable()) {
                this.getCompositionDocument().doClear();
            }
        }
    }

    class PasteAction
    extends ImageAction {
        public PasteAction() {
            super("paste", null, "Paste24");
        }

        public boolean isEnabled() {
            Transferable t = CompositionApplication.clipboard.getContents(this);
            return t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor) && !this.isFiltering();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.makePaintable()) {
                this.getCompositionDocument().doPaste();
            }
        }
    }

    class CopyMergedAction
    extends ImageAction {
        public CopyMergedAction() {
            super("copyMerged");
        }

        public boolean isEnabled() {
            return this.hasPaintableSelection();
        }

        public void actionPerformed(ActionEvent e) {
            this.getCompositionDocument().doCopy(true);
            CompositionController.this.enableCommands();
        }
    }

    class CopyAction
    extends ImageAction {
        public CopyAction() {
            super("copy", null, "Copy24");
        }

        public boolean isEnabled() {
            return this.hasPaintableSelection() || this.hasFloatingSelection();
        }

        public void actionPerformed(ActionEvent e) {
            this.getCompositionDocument().doCopy(false);
            CompositionController.this.enableCommands();
        }
    }

    class CutAction
    extends ImageAction {
        public CutAction() {
            super("cut", null, "Cut24");
        }

        public boolean isEnabled() {
            return this.hasPaintableSelection() || this.hasFloatingSelection();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.makePaintable()) {
                this.getCompositionDocument().doCut();
            }
        }
    }

    public abstract class ImageAction
    extends ApplicationAction {
        public ImageAction(String name) {
            super(name);
        }

        public ImageAction(String name, ResourceBundle b, String iconName) {
            super(name, b, iconName);
        }

        public CompositionApplication getCompositionApplication() {
            return (CompositionApplication)this.getApplication();
        }

        public boolean hasCompositionDocument() {
            return this.getDocument() instanceof CompositionDocument;
        }

        public CompositionDocument getCompositionDocument() {
            return (CompositionDocument)this.getDocument();
        }

        public CompositionView getCompositionView() {
            return ((CompositionWindow)this.getDocumentWindow()).getCompositionView();
        }

        public Composition getComposition() {
            CompositionDocument document = this.getCompositionDocument();
            if (document == null) {
                return null;
            }
            return this.getCompositionDocument().getComposition();
        }

        public boolean isFiltering() {
            CompositionDocument document = this.getCompositionDocument();
            if (document == null) {
                return false;
            }
            return document.isFiltering();
        }

        public void performPendingTask() {
            CompositionDocument document = this.getCompositionDocument();
            if (document != null) {
                document.performPendingTask();
            }
        }

        public boolean isEnabled() {
            Composition composition = this.getComposition();
            return composition != null;
        }

        public boolean hasPaintableSelection() {
            Composition composition = this.getComposition();
            return composition != null && composition.getSelectedBounds() != null && !this.isFiltering();
        }

        public boolean hasFloatingSelection() {
            Composition composition = this.getComposition();
            return composition != null && composition.hasFloatingSelection();
        }

        public boolean isPaintable() {
            Composition composition = this.getComposition();
            return composition != null && composition.getActiveLayer() != null && !this.isFiltering();
        }

        public boolean makePaintable() {
            CompositionDocument document = this.getCompositionDocument();
            return document != null && document.makePaintable();
        }
    }
}

