/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.io;

import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.FileFormat;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class FileFormatClass
extends FileFormat {
    public FileFormatClass() {
        super("Java Source", "text/plain", ".java", "TEXT");
    }

    public boolean canRead(String extension) {
        return false;
    }

    public boolean canRead(byte[] fileStart) {
        return false;
    }

    public void writeImage(File file, OutputStream out, CompositionDocument document) throws IOException {
        String name = document.getTitle();
        if (name.endsWith("java")) {
            name = name.substring(0, name.length() - 5);
        }
        BufferedImage p = document.getComposition().getCompositeImage();
        int width = p.getWidth();
        int height = p.getHeight();
        PrintStream ps = new PrintStream(out);
        ps.println("import java.awt.*;");
        ps.println("import java.awt.image.*;");
        ps.println();
        ps.println("public class " + name + " {");
        ps.println("\tprivate static Image image;");
        ps.println("\tprivate static int width = " + width + ";");
        ps.println("\tprivate static int height = " + height + ";");
        ps.println("\tprivate static int[] pixels = {");
        int i = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (i == 0) {
                    ps.print("\t\t");
                } else if (i++ % 10 == 0) {
                    ps.println();
                    ps.print("\t\t");
                }
                ++i;
                ps.print(p.getRGB(x, y));
                ps.print(",");
            }
        }
        ps.println();
        ps.println("\t};");
        ps.println();
        ps.println("\tpublic static Image getImage() {");
        ps.println("\t\tif (image != null)");
        ps.println("\t\t\treturn image;");
        ps.println("\t\treturn image = Toolkit.getDefaultToolkit.createImage(new MemoryImageSource(width, height, ColorModel.getRGBdefault(), pixels, 0, width));");
        ps.println("\t}");
        ps.println("}");
        ps.close();
    }
}

