/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.io;

import com.jhlabs.app.Application;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.CustomizerDialog;
import com.jhlabs.ie.FileFormat;
import com.jhlabs.swing.SliderFactory;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiWriter;
import com.sun.jimi.core.options.JPGOptions;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageProducer;
import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class FileFormatJPEG
extends FileFormat {
    private int quality = 100;

    public FileFormatJPEG() {
        super("JPEG", new String[]{"image/jpeg"}, new String[]{".jpg", ".jpeg"}, new String[]{"JPEG"});
    }

    public boolean canRead(byte[] fileStart) {
        return false;
    }

    public ImageProducer readImage(File file, InputStream in) throws IOException {
        JFrame f = Application.getInstance().getFrame();
        Image image = f.getToolkit().getImage(file.getPath());
        MediaTracker tracker = new MediaTracker(f);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage());
        }
        tracker.removeImage(image, 0);
        return image.getSource();
    }

    public void writeImage(File file, OutputStream out, CompositionDocument document) throws IOException {
        try {
            JPGOptions options = new JPGOptions();
            options.setQuality(this.quality);
            JimiWriter writer = Jimi.createTypedJimiWriter("image/jpeg");
            writer.setSource(document.getCompositeImage().getSource());
            writer.setOptions(options);
            writer.putImage(out);
        }
        catch (JimiException e) {
            throw new IOException(e + ": " + e.getMessage());
        }
    }

    public boolean showOptionsDialog(Frame frame, CompositionDocument document) {
        JpegQualityPanel customizer = new JpegQualityPanel(this.quality);
        CustomizerDialog d = new CustomizerDialog(frame, "JPEG Options", customizer);
        if (d.showDialog()) {
            this.quality = customizer.getQuality();
            return true;
        }
        return false;
    }

    class JpegQualityPanel
    extends JPanel
    implements Customizer {
        private JSlider qualitySlider;

        public JpegQualityPanel(int quality) {
            JPanel p = new JPanel();
            this.add((Component)p, "Center");
            p.setLayout(new FlowLayout());
            p.add(new JLabel("Quality (%):", 4));
            this.qualitySlider = SliderFactory.createPercentageSlider();
            p.add(this.qualitySlider);
            this.setQuality(quality);
        }

        public void setQuality(int quality) {
            this.qualitySlider.setValue(quality);
        }

        public int getQuality() {
            return this.qualitySlider.getValue();
        }

        public void setObject(Object o) {
        }
    }
}

