/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.io;

import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.FileFormat;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileFormatPNG
extends FileFormat {
    public FileFormatPNG() {
        super("PNG", "image/png", ".png", "PNGf");
    }

    public boolean canRead(byte[] fileStart) {
        return fileStart[0] == 137 && fileStart[1] == 80 && fileStart[2] == 78 && fileStart[3] == 71 && fileStart[4] == 13 && fileStart[5] == 10 && fileStart[6] == 26 && fileStart[7] == 10;
    }

    public boolean shouldOpenFile() {
        return false;
    }

    public ImageProducer readImage(File file, InputStream in) throws IOException {
        return Jimi.getImageProducer(file.getPath());
    }

    public void writeImage(File file, OutputStream out, CompositionDocument document) throws IOException {
        try {
            PNGEncoder encoder = new PNGEncoder();
            encoder.setAlpha(Boolean.TRUE);
            encoder.encodeImages(new JimiImageEnumeration(document.getCompositeImage().getSource()), out);
            out.close();
        }
        catch (JimiException e) {
            throw new IOException(e + ": " + e.getMessage());
        }
    }
}

