/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.composite.MiscComposite;
import com.jhlabs.ie.Brush;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.DrawingTask;
import com.jhlabs.ie.ImageTool;
import com.jhlabs.ie.SimpleBrush;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.ie.tool.BrushToolCustomizer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.Random;

public class BrushTool
extends ImageTool
implements Runnable {
    protected Brush brush;
    protected Graphics2D imageGraphics;
    protected Graphics2D bufferGraphics;
    protected BufferedImage selection;
    protected static BufferedImage paperTexture;
    protected int color;
    protected int mode = 0;
    protected float opacity;
    protected boolean autoPickColor = false;
    protected int fadeOut;
    protected int fade;
    protected float pressure;
    protected int spacing = 1;
    protected int scatter;
    protected boolean moved;
    protected boolean pickOnEachDab = false;
    protected boolean pendingFirstDab = false;
    protected int nextFrame;
    protected Color paintColor;
    protected float[] paintHSB = new float[3];
    protected int minX;
    protected int maxX;
    protected int minY;
    protected int maxY;
    protected Random random = new Random();
    protected static int[] sinTable;
    protected static int[] cosTable;
    private static BrushToolCustomizer customizer;
    protected BufferedImage brushBuffer;
    protected BufferedImage brushBuffer2;
    protected float sx0;
    protected float sx1;
    protected float sx2;
    protected float sx3;
    protected float sy0;
    protected float sy1;
    protected float sy2;
    protected float sy3;
    protected float lastx;
    protected float lasty;
    private int paintMode;
    protected int sourceX;
    protected int sourceY;
    protected int destX;
    protected int destY;
    protected boolean hasDestination = false;
    protected BufferedImage sourceImage;
    protected boolean aligned;
    private Thread thread;
    private boolean running;
    private int rate;
    private DrawingTask task;

    public BrushTool() {
        this.brush = new SimpleBrush(5.0f);
        if (sinTable == null) {
            sinTable = new int[256];
            cosTable = new int[256];
            for (int i = 0; i < 256; ++i) {
                double angle = Math.PI * 2 * (double)i / 256.0;
                BrushTool.sinTable[i] = (int)(255.0 * Math.sin(angle));
                BrushTool.cosTable[i] = (int)(255.0 * Math.cos(angle));
            }
        }
    }

    public void setBrush(Brush brush) {
        this.brush = brush;
    }

    public Brush getBrush() {
        return this.brush;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setAutoPickColor(boolean autoPickColor) {
        this.autoPickColor = autoPickColor;
    }

    public boolean getAutoPickColor() {
        return this.autoPickColor;
    }

    public boolean doStartDrag() {
        this.stop();
        Composition composition = this.view.getComposition();
        int cx = this.view.XTox(this.currX);
        int cy = this.view.YToy(this.currY);
        if (this.event.isShiftDown()) {
            this.sourceImage = this.view.getActiveImage();
            this.sourceX = cx;
            this.sourceY = cy;
            this.hasDestination = false;
            return false;
        }
        if (!this.hasDestination) {
            this.destX = cx;
            this.destY = cy;
            this.hasDestination = true;
        }
        if (this.sourceImage == null) {
            this.sourceImage = this.view.getActiveImage();
        }
        this.task = new DrawingTask(composition);
        Layer layer = composition.getActiveLayer();
        this.view.doTask(this.task);
        BufferedImage image = composition.getActiveImage();
        this.imageGraphics = image.createGraphics();
        if (this.brush == null) {
            this.brush = this.view.getCompositionApplication().getBrush();
        }
        this.paintMode = this.brush.getPaintMode();
        this.paintMode = this.getPaintMode();
        this.autoPickColor = this.paintMode == 3;
        this.pickOnEachDab = this.brush.getTintVariation() != 0.0f || this.brush.getFrames() > 1 || this.paintMode == 2;
        this.aligned = this.isAligned();
        int w = this.brush.getWidth();
        int h = this.brush.getHeight();
        this.brushBuffer = new BufferedImage(w, h, 2);
        this.brushBuffer2 = new BufferedImage(w, h, 2);
        this.bufferGraphics = this.brushBuffer2.createGraphics();
        Graphics2D g = this.brushBuffer.createGraphics();
        if (this.paintMode != 1) {
            this.pickPaint(g, cx, cy);
            g.setComposite(AlphaComposite.DstIn);
        }
        this.nextFrame = 0;
        g.drawImage(this.getNextFrame(), null, 0, 0);
        g.dispose();
        this.selection = this.view.getSelection();
        Rectangle bounds = composition.getSelectedBounds();
        if (bounds == null) {
            this.selection = null;
        }
        this.opacity = this.brush.getOpacity();
        this.scatter = this.brush.getScatter();
        this.spacing = this.brush.getSpacing();
        if (this.spacing < 1) {
            this.spacing = 1;
        }
        this.fade = this.fadeOut = this.brush.getFadeOut();
        this.lastx = -10000.0f;
        this.lasty = -10000.0f;
        this.sx2 = this.sx3 = (float)cx;
        this.sx1 = this.sx3;
        this.sx0 = this.sx3;
        this.sy2 = this.sy3 = (float)cy;
        this.sy1 = this.sy3;
        this.sy0 = this.sy3;
        if (this.brush.getFollowPath()) {
            this.pendingFirstDab = true;
        } else {
            this.doApplyBrush();
        }
        this.moved = false;
        this.rate = this.brush.getRate();
        if (this.rate != 0) {
            this.start();
        }
        return true;
    }

    protected int getPaintMode() {
        return this.paintMode;
    }

    protected boolean isAligned() {
        return this.brush.isAligned();
    }

    protected void pickPaint(Graphics2D g, float x, float y) {
        if (this.getPaintMode() == 2) {
            int sy;
            int sx;
            if (this.aligned) {
                sx = this.sourceX + (int)x - this.destX;
                sy = this.sourceY + (int)y - this.destY;
            } else {
                sx = this.sourceX + (int)x - this.startX;
                sy = this.sourceY + (int)y - this.startY;
            }
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(0, 0, this.brush.getWidth(), this.brush.getHeight());
            g.setComposite(AlphaComposite.SrcOver);
            g.drawRenderedImage(this.sourceImage, AffineTransform.getTranslateInstance(-(sx -= this.brush.getWidth() / 2), -(sy -= this.brush.getHeight() / 2)));
        } else {
            this.color = this.autoPickColor ? this.sourceImage.getRGB(Math.max(0, Math.min(this.sourceImage.getWidth() - 1, this.view.XTox(this.currX))), Math.max(0, Math.min(this.sourceImage.getHeight() - 1, this.view.YToy(this.currY)))) : this.view.getPaintColor(this.event);
            this.paintColor = new Color(this.color);
            Color.RGBtoHSB(this.paintColor.getRed(), this.paintColor.getGreen(), this.paintColor.getBlue(), this.paintHSB);
            float tintVariation = this.brush.getTintVariation();
            if (tintVariation != 0.0f) {
                float v = tintVariation * (float)this.random.nextGaussian();
                this.paintColor = Color.getHSBColor(v + this.paintHSB[0], this.paintHSB[1], this.paintHSB[2]);
                g.setColor(this.paintColor);
            } else {
                g.setColor(this.paintColor);
            }
            g.fillRect(0, 0, this.brush.getWidth(), this.brush.getHeight());
        }
    }

    public synchronized void doDrag(boolean erase) {
        if (!erase) {
            this.sx0 = this.sx1;
            this.sx1 = this.sx2;
            this.sx2 = this.sx3;
            this.sx3 = this.view.XTox(this.currX);
            this.sy0 = this.sy1;
            this.sy1 = this.sy2;
            this.sy2 = this.sy3;
            this.sy3 = this.view.YToy(this.currY);
            if (this.pendingFirstDab) {
                Composition composition = this.view.getComposition();
                composition.startUpdate();
                this.minX = Integer.MAX_VALUE;
                this.maxX = -1;
                this.minY = Integer.MAX_VALUE;
                this.maxY = -1;
                this.apply(this.sx2, this.sy2, this.sx3 - this.sx2, this.sy3 - this.sy2);
                composition.update(new Rectangle(this.minX - 1, this.minY - 1, this.maxX - this.minX + 2, this.maxY - this.minY + 2));
                composition.endUpdate();
                this.lastx = this.sx2;
                this.lasty = this.sy2;
                this.pendingFirstDab = false;
            }
            this.doApplyBrush();
            this.moved = true;
        }
    }

    public void doEndDrag() {
        this.stop();
        if (this.moved) {
            this.doDrag(false);
        }
        Composition composition = this.view.getComposition();
        if (this.bufferGraphics != null) {
            this.bufferGraphics.dispose();
        }
        this.bufferGraphics = null;
        if (this.imageGraphics != null) {
            this.imageGraphics.dispose();
        }
        this.imageGraphics = null;
        this.task = null;
    }

    public void doApplyBrush() {
        Composition composition = this.view.getComposition();
        composition.startUpdate();
        float spacing2 = this.spacing * this.spacing;
        boolean first = true;
        this.minX = Integer.MAX_VALUE;
        this.maxX = -1;
        this.minY = Integer.MAX_VALUE;
        this.maxY = -1;
        this.pressure = 1.0f;
        for (float t = 0.0f; t <= 1.0f; t += 0.001f) {
            float t2 = t * t;
            float t3 = t2 * t;
            float c0 = (1.0f - 3.0f * t + 3.0f * t2 - t3) / 6.0f;
            float c1 = (4.0f - 6.0f * t2 + 3.0f * t3) / 6.0f;
            float c2 = (1.0f + 3.0f * t + 3.0f * t2 - 3.0f * t3) / 6.0f;
            float c3 = t3 / 6.0f;
            float x = c0 * this.sx0 + c1 * this.sx1 + c2 * this.sx2 + c3 * this.sx3;
            float dx = x - this.lastx;
            float y = c0 * this.sy0 + c1 * this.sy1 + c2 * this.sy2 + c3 * this.sy3;
            float dy = y - this.lasty;
            float distance = dx * dx + dy * dy;
            if (!(distance > spacing2)) continue;
            this.apply(x, y, dx, dy);
            this.lastx = x;
            this.lasty = y;
            first = false;
        }
        composition.update(new Rectangle(this.minX - 1, this.minY - 1, this.maxX - this.minX + 2, this.maxY - this.minY + 2));
        composition.endUpdate();
    }

    public void dabBrush(float x, float y) {
        if (this.getPaintMode() == 2) {
            x = (float)Math.floor(x);
            y = (float)Math.floor(y);
        }
        if (this.selection != null) {
            BufferedImageOp filter = null;
            this.bufferGraphics.setComposite(AlphaComposite.Src);
            this.bufferGraphics.drawImage(this.brushBuffer, filter, 0, 0);
            this.bufferGraphics.setComposite(AlphaComposite.DstIn);
            this.bufferGraphics.drawRenderedImage(this.selection, AffineTransform.getTranslateInstance(-x, -y));
            this.imageGraphics.drawRenderedImage(this.brushBuffer2, AffineTransform.getTranslateInstance(x, y));
        } else {
            this.imageGraphics.drawRenderedImage(this.brushBuffer, AffineTransform.getTranslateInstance(x, y));
        }
    }

    public void apply(float x, float y, float dx, float dy) {
        int w = this.brush.getWidth();
        int h = this.brush.getHeight();
        float o = this.opacity;
        if (this.fadeOut != 0) {
            o = o * (float)this.fade / (float)this.fadeOut;
            if (this.fade > 0) {
                --this.fade;
            }
        }
        if ((o *= this.pressure) == 0.0f) {
            return;
        }
        if (this.scatter != 0) {
            double distance = (double)this.scatter * this.random.nextGaussian();
            int angle = this.random.nextInt() & 0xFF;
            x = (float)((double)x + distance * (double)cosTable[angle] / 255.0);
            y = (float)((double)y + distance * (double)sinTable[angle] / 255.0);
        }
        if (this.pickOnEachDab) {
            Graphics2D g = this.brushBuffer.createGraphics();
            this.pickPaint(g, x, y);
            if (this.getPaintMode() == 1) {
                g.setComposite(AlphaComposite.Src);
            } else {
                g.setComposite(AlphaComposite.DstIn);
            }
            g.drawImage(this.getNextFrame(), null, 0, 0);
            g.dispose();
        }
        x -= (float)(w / 2);
        y -= (float)(h / 2);
        int m = this.mode;
        if (m == 0) {
            m = this.brush.getBlendMode();
        }
        this.imageGraphics.setComposite(MiscComposite.getInstance(m, o));
        int nw = w;
        int nh = h;
        AffineTransform t = this.imageGraphics.getTransform();
        float rotation = this.brush.getRotation();
        float scaleVariation = this.brush.getScale();
        boolean followPath = this.brush.getFollowPath();
        float tx = x + (float)(w / 2);
        float ty = y + (float)(h / 2);
        float rotate = 0.0f;
        float scale = 1.0f;
        if (!this.brush.imageIsTransformed()) {
            scale = 2.0f * this.brush.getRadius() / (float)w;
            rotate = this.brush.getAngle();
        }
        if (scaleVariation != 0.0f) {
            scale = (float)((double)scale * (1.0 + (double)scaleVariation * this.random.nextGaussian()));
        }
        if (followPath || rotation != 0.0f) {
            rotate = (float)((double)rotate + (double)rotation * this.random.nextGaussian());
            if (followPath) {
                rotate = (float)((double)rotate + Math.atan2(dx, -dy));
            }
        }
        if (scale != 1.0f || rotate != 0.0f) {
            this.imageGraphics.translate(tx, ty);
            if (scale != 1.0f) {
                this.imageGraphics.scale(scale, scale);
                nw = (int)((float)nw * scale);
                nh = (int)((float)nh * scale);
            }
            if (rotate != 0.0f) {
                this.imageGraphics.rotate(rotate);
                nw = (int)((double)nw * 1.4142);
                nh = (int)((double)nh * 1.4142);
            }
            this.imageGraphics.translate(-tx, -ty);
        }
        this.task.touchRectangle((int)(x - (float)nw + (float)w), (int)(y - (float)nh + (float)h), 2 * nw - w + 1, 2 * nh - h + 1);
        this.dabBrush(x, y);
        this.imageGraphics.setTransform(t);
        this.minX = Math.min(this.minX, (int)x - nw + w);
        this.maxX = Math.max(this.maxX, (int)x + nw + 1);
        this.minY = Math.min(this.minY, (int)y - nh + h);
        this.maxY = Math.max(this.maxY, (int)y + nh + 1);
    }

    private BufferedImage getNextFrame() {
        int frames = this.brush.getFrames();
        if (frames > 1) {
            switch (this.brush.getFramePolicy()) {
                case 0: {
                    return this.brush.getImage((int)(Math.random() * (double)frames));
                }
                case 1: {
                    this.nextFrame = (this.nextFrame + 1) % frames;
                    return this.brush.getImage(this.nextFrame);
                }
            }
        }
        return this.brush.getImage();
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        if (customizer == null) {
            customizer = new BrushToolCustomizer();
        }
        return customizer;
    }

    private void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void stop() {
        this.running = false;
        this.thread = null;
    }

    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Thread.sleep(this.rate);
                if (!this.running) continue;
                Composition composition = this.view.getComposition();
                this.minX = Integer.MAX_VALUE;
                this.maxX = -1;
                this.minY = Integer.MAX_VALUE;
                this.maxY = -1;
                this.apply(this.lastX, this.lastY, 1.0f, 0.0f);
                composition.startUpdate();
                composition.update(new Rectangle(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY));
                composition.endUpdate();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public String getToolTipText() {
        return "Brush Tool";
    }
}

