/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.GrabHandle;
import com.jhlabs.ie.ImageTask;
import com.jhlabs.ie.ImageTool;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.ie.layer.TextLayer;
import com.jhlabs.ie.ui.FontChooser;
import com.jhlabs.image.FilterCustomizer;
import com.jhlabs.image.PaintingContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;

public class TextTool
extends ImageTool
implements PropertyChangeListener {
    private Font font = new Font("dialog", 0, 24);
    private JTextArea textField = new TransformedTextArea();
    private TransformedPanel transformedPanel = new TransformedPanel(this.textField);
    protected boolean editing = false;
    protected boolean selectionOnly = false;
    private static Insets insets = new Insets(0, 0, 0, 0);

    public TextTool() {
        this.textField.setOpaque(false);
        this.textField.setBorder(null);
        this.transformedPanel.add(this.textField);
        PaintingContext.getInstance().addPropertyChangeListener(this);
    }

    public boolean isSelectionTool() {
        return true;
    }

    public boolean isPaintingTool() {
        return false;
    }

    public boolean usesFloatingSelection() {
        return true;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setSelectionOnly(boolean selectionOnly) {
        this.selectionOnly = selectionOnly;
    }

    public boolean getSelectionOnly() {
        return this.selectionOnly;
    }

    public boolean doStartDrag() {
        return !this.editing;
    }

    public void doEndDrag() {
        int handle = 0;
        this.view.add(this.transformedPanel);
        FontMetrics fontMetrics = this.view.getFontMetrics(this.font);
        Insets insets = this.textField.getInsets();
        Composition composition = this.getComposition();
        Layer layer = composition.getFloatingLayer();
        if (layer != null && layer instanceof TextLayer) {
            AffineTransform viewTransform = this.view.getViewTransform();
            AffineTransform layerTransform = layer.getTransform();
            if (layerTransform == null) {
                layerTransform = new AffineTransform();
            }
            if ((handle = GrabHandle.findHandle(this.startX, this.startY, layer.getBounds(), layerTransform, viewTransform, 8)) != 0) {
                TextLayer textLayer = (TextLayer)layer;
                this.textField.setText(textLayer.getText());
                Rectangle r = layer.getBounds();
                Point2D.Double sxy = new Point2D.Double(r.getMinX(), (int)r.getMaxY());
                layerTransform.transform(sxy, sxy);
                this.startX = (int)sxy.x;
                this.startY = (int)sxy.y;
                this.transformedPanel.setTransform(layerTransform);
                textLayer.setVisible(false);
                composition.startUpdate();
                composition.updateAll();
                composition.endUpdate();
            }
        }
        if (handle == 0) {
            this.startX = this.view.XTox(this.startX);
            this.startY = this.view.YToy(this.startY);
            this.startY -= fontMetrics.getAscent();
            this.textField.setText("");
            this.transformedPanel.setTransform(AffineTransform.getTranslateInstance(this.startX, this.startY));
        }
        this.textField.setBounds(0, 0, 2000, 2000);
        this.transformedPanel.setBounds(0, 0, 2000, 2000);
        this.textField.setForeground(new Color(this.view.getPaintColor(this.event)));
        this.textField.setFont(this.font);
        this.textField.setCaretPosition(0);
        this.textField.setVisible(true);
        this.transformedPanel.setVisible(true);
        this.textField.requestFocus();
        this.editing = true;
        CompositionDocument document = this.view.getDocument();
        document.setPendingTask(new TextTask(document.getComposition(), this.startX, this.startY, handle == 0));
    }

    private BufferedImage commitText() {
        BufferedImage image = null;
        String text = this.textField.getText();
        if (text != null && text.length() != 0) {
            Dimension size = this.textField.getPreferredSize();
            if (this.font.isItalic()) {
                size.width += this.font.getSize();
            }
            Composition composition = this.view.getComposition();
            image = new BufferedImage(size.width, size.height, 2);
            Graphics2D g = image.createGraphics();
            this.textField.select(0, 0);
            Caret caret = this.textField.getCaret();
            caret.setVisible(false);
            SwingUtilities.paintComponent(g, this.textField, new Container(), 0, 0, size.width, size.height);
            this.transformedPanel.add(this.textField);
            caret.setVisible(true);
            g.dispose();
        }
        this.transformedPanel.setVisible(false);
        this.view.remove(this.transformedPanel);
        this.editing = false;
        return image;
    }

    public char getShortcutKey() {
        return 't';
    }

    public String getToolTipText() {
        return "Text Tool";
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("fgColor".equals(name)) {
            Color c = (Color)event.getNewValue();
            this.textField.setForeground(c);
        }
    }

    public void setActive(boolean active) {
        CompositionDocument document;
        super.setActive(active);
        if (!active && this.view != null && (document = this.view.getDocument()) != null) {
            document.performPendingTask();
        }
        this.editing = false;
    }

    public void setCursor(Component c) {
        c.setCursor(Cursor.getPredefinedCursor(2));
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new TextToolCustomizer();
    }

    class TransformedPanel
    extends JPanel {
        private AffineTransform transform;
        private GlassPane glassPane;
        private Component textField;

        public TransformedPanel(Component textField) {
            this.textField = textField;
            this.setOpaque(false);
            this.setBackground(Color.green);
            this.setLayout(null);
            this.glassPane = new GlassPane();
            this.add(this.glassPane);
            this.glassPane.setVisible(true);
            this.glassPane.setBounds(0, 0, 1000, 1000);
            this.glassPane.setBackground(Color.orange);
        }

        public void doLayout() {
            this.glassPane.setBounds(0, 0, this.getWidth(), this.getHeight());
        }

        public void setTransform(AffineTransform transform) {
            this.transform = transform;
            this.repaint();
        }

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform viewTransform = TextTool.this.view.getViewTransform();
            g2.transform(viewTransform);
            g2.transform(this.transform);
            super.paint(g2);
            g2.dispose();
        }

        class GlassPane
        extends JPanel {
            private Component mouseEnteredComponent;
            private Component mouseDraggedComponent;
            private Component mouseCurrentComponent;

            public GlassPane() {
                this.setOpaque(false);
                this.enableEvents(16L);
                this.enableEvents(32L);
            }

            private MouseEvent transformMouseEvent(MouseEvent event) {
                MouseEvent newEvent = new MouseEvent(event.getComponent(), event.getID(), event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
                if (TransformedPanel.this.transform.getDeterminant() != 0.0) {
                    double x = newEvent.getX();
                    double y = newEvent.getY();
                    AffineTransform viewTransform = TextTool.this.view.getViewTransform();
                    Point2D p = new Point2D.Double(x, y);
                    try {
                        p = viewTransform.inverseTransform(p, p);
                        p = TransformedPanel.this.transform.inverseTransform(p, p);
                    }
                    catch (NoninvertibleTransformException ex) {
                        // empty catch block
                    }
                    this.mouseCurrentComponent = TransformedPanel.this.textField;
                    newEvent.setSource(TransformedPanel.this.textField);
                    newEvent.translatePoint((int)p.getX() - event.getX(), (int)p.getY() - event.getY());
                }
                return newEvent;
            }

            protected void processMouseEvent(MouseEvent e) {
                MouseEvent transformedEvent = this.transformMouseEvent(e);
                switch (e.getID()) {
                    case 504: {
                        this.dispatchMouseEvent(transformedEvent);
                        break;
                    }
                    case 505: {
                        this.dispatchMouseEvent(this.createEnterExitEvent(this.mouseEnteredComponent, 505, e));
                        break;
                    }
                    case 502: {
                        this.dispatchMouseEvent(transformedEvent);
                        break;
                    }
                    default: {
                        this.dispatchMouseEvent(transformedEvent);
                    }
                }
                super.processMouseEvent(e);
            }

            private void dispatchMouseEvent(MouseEvent event) {
                MouseListener[] mouseListeners = event.getComponent().getMouseListeners();
                block7: for (int i = 0; i < mouseListeners.length; ++i) {
                    MouseListener listener = mouseListeners[i];
                    switch (event.getID()) {
                        case 501: {
                            listener.mousePressed(event);
                            continue block7;
                        }
                        case 502: {
                            listener.mouseReleased(event);
                            continue block7;
                        }
                        case 500: {
                            listener.mouseClicked(event);
                            continue block7;
                        }
                        case 505: {
                            listener.mouseExited(event);
                            continue block7;
                        }
                        case 504: {
                            listener.mouseEntered(event);
                        }
                    }
                }
            }

            protected void processMouseMotionEvent(MouseEvent e) {
                MouseEvent transformedEvent = this.transformMouseEvent(e);
                if (this.mouseEnteredComponent == null) {
                    this.mouseEnteredComponent = this.mouseCurrentComponent;
                }
                this.mouseEnteredComponent = this.mouseCurrentComponent;
                MouseMotionListener[] mouseMotionListeners = transformedEvent.getComponent().getMouseMotionListeners();
                block4: for (int i = 0; i < mouseMotionListeners.length; ++i) {
                    MouseMotionListener listener = mouseMotionListeners[i];
                    switch (transformedEvent.getID()) {
                        case 503: {
                            listener.mouseMoved(transformedEvent);
                            continue block4;
                        }
                        case 506: {
                            listener.mouseDragged(transformedEvent);
                        }
                    }
                }
                super.processMouseMotionEvent(e);
            }

            private MouseEvent createEnterExitEvent(Component c, int eventId, MouseEvent mouseEvent) {
                return new MouseEvent(c, eventId, mouseEvent.getWhen(), 0, mouseEvent.getX(), mouseEvent.getY(), 0, false, 0);
            }
        }
    }

    class TransformedTextArea
    extends JTextArea {
        TransformedTextArea() {
        }

        public void repaint(int x, int y, int width, int height) {
            this.repaint();
        }

        public Insets getInsets() {
            return insets;
        }
    }

    class TextToolCustomizer
    extends FilterCustomizer
    implements ActionListener {
        private TextTool tool;
        private FontChooser chooser;

        public TextToolCustomizer() {
            this.setLayout(new SuperGridLayout(1, 0));
            this.chooser = new FontChooser();
            this.add(this.chooser);
            this.chooser.setLayout(new FlowLayout(0, 5, 0));
            this.chooser.setFont(TextTool.this.textField.getFont());
            this.chooser.addActionListener(this);
        }

        public void setObject(Object o) {
            this.tool = (TextTool)o;
            this.chooser.setObject(this.tool.getFont());
            TextTool.this.textField.setFont(this.tool.getFont());
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            this.tool.setFont(this.chooser.getObject());
            TextTool.this.textField.setFont(this.chooser.getObject());
            TextTool.this.textField.repaint();
        }
    }

    public class TextTask
    extends ImageTask {
        private String text;
        private BufferedImage image;
        private int x;
        private int y;
        private boolean newLayer;

        public TextTask(Composition composition, int x, int y, boolean newLayer) {
            super(composition);
            this.x = x;
            this.y = y;
            this.newLayer = newLayer;
        }

        public void doTask() {
            this.text = TextTool.this.textField.getText();
            this.image = TextTool.this.commitText();
            if (this.image == null) {
                return;
            }
            Composition composition = this.getComposition();
            super.doTask();
            if (TextTool.this.selectionOnly) {
                BufferedImage selection = composition.getSelection();
                Graphics2D g = selection.createGraphics();
                g.drawImage(selection, null, this.x, this.y);
                g.dispose();
            } else {
                Layer layer = composition.getFloatingLayer();
                if (!this.newLayer && layer != null && layer instanceof TextLayer) {
                    TextLayer textLayer = (TextLayer)layer;
                    textLayer.setText(this.text);
                    textLayer.setImage(this.image);
                    textLayer.setVisible(true);
                } else {
                    TextLayer textLayer = new TextLayer("Floating Selection", this.image);
                    textLayer.setTransform(AffineTransform.getTranslateInstance(this.x, this.y));
                    textLayer.setText(this.text);
                    composition.dropFloatingSelection();
                    composition.setFloatingLayer(textLayer, composition.addNewImageLayer(this.text));
                }
            }
            composition.startUpdate();
            composition.updateAll();
            composition.endUpdate();
        }
    }
}

