/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.app.AppInternalFrame;
import com.jhlabs.app.Application;
import com.jhlabs.awt.DoubleClickAdapter;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.Palette;
import com.jhlabs.ie.ui.ColormapIcon;
import com.jhlabs.ie.ui.ColormapIconFactory;
import com.jhlabs.ie.ui.GradientEditor;
import com.jhlabs.image.Colormap;
import com.jhlabs.image.ColormapTransferable;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.GradientHandler;
import com.jhlabs.image.LinearColormap;
import com.jhlabs.image.PaintingContext;
import com.jhlabs.xml.XMLParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ColormapChooser
extends JPanel
implements Palette,
ActionListener,
ListSelectionListener {
    private CompositionApplication application = (CompositionApplication)CompositionApplication.getInstance();
    private JList list;
    private JScrollPane scrollPane;
    private Colormap colormap;
    private JMenuItem loadItem;
    private JMenuItem saveItem;
    private JMenuItem newItem;
    private JMenuItem duplicateItem;
    private JMenuItem removeItem;
    private JMenuItem editItem;

    public ColormapChooser() {
        this.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("Gradients");
        fileMenu.setIcon(new ImageIcon(this.getClass().getResource("menu.png")));
        menuBar.add(fileMenu);
        this.loadItem = new JMenuItem("Load");
        fileMenu.add(this.loadItem);
        this.saveItem = new JMenuItem("Save...");
        fileMenu.add(this.saveItem);
        fileMenu.addSeparator();
        this.newItem = new JMenuItem("New");
        fileMenu.add(this.newItem);
        this.duplicateItem = new JMenuItem("Duplicate");
        fileMenu.add(this.duplicateItem);
        this.removeItem = new JMenuItem("Remove");
        fileMenu.add(this.removeItem);
        fileMenu.addSeparator();
        this.editItem = new JMenuItem("Edit");
        fileMenu.add(this.editItem);
        this.loadItem.addActionListener(this);
        this.saveItem.addActionListener(this);
        this.newItem.addActionListener(this);
        this.duplicateItem.addActionListener(this);
        this.removeItem.addActionListener(this);
        this.editItem.addActionListener(this);
        this.add((Component)menuBar, "North");
        this.loadDefaultColormaps();
        this.list = new ColormapList((ListModel)this.application.getColormaps());
        this.scrollPane = new JScrollPane(this.list);
        this.add((Component)this.scrollPane, "Center");
        this.list.setCellRenderer(new ColormapCellRenderer());
        this.list.setBackground(Color.white);
        this.list.getSelectionModel().addListSelectionListener(this);
        new DoubleClickAdapter(this, this.list);
        this.setSize(this.getPreferredSize().width, 200);
    }

    public void startup(Application application) {
        this.addPropertyChangeListener((CompositionApplication)application);
    }

    public void shutdown() {
    }

    public void valueChanged(ListSelectionEvent e) {
        Colormap oldValue = this.colormap;
        this.colormap = (Colormap)this.list.getSelectedValue();
        PaintingContext.getInstance().setColormap(this.colormap);
        Object o = this.list.getSelectedValue();
        this.removeItem.setEnabled(o != null);
        this.duplicateItem.setEnabled(o != null && o instanceof Gradient);
        this.editItem.setEnabled(o != null && o instanceof Gradient);
    }

    private void loadDefaultColormaps() {
        try {
            InputStream is = this.getClass().getResourceAsStream("gradients.xml");
            if (is != null) {
                this.loadColormaps(is);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.application.getFrame(), "Can't read file", "Error", 0);
        }
    }

    private void doLoad() {
        File file = this.application.getFileToOpen();
        if (file != null) {
            try {
                FileInputStream is = new FileInputStream(file);
                this.loadColormaps(is);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.application.getFrame(), "Can't read file", "Error", 0);
            }
        }
    }

    private void loadColormaps(InputStream is) throws IOException, SAXException {
        GradientHandler handler = new GradientHandler();
        XMLParser xp = new XMLParser();
        xp.setDocumentHandler(handler);
        xp.parse(new InputSource(is));
        Vector v = handler.getColormaps();
        if (v != null) {
            DefaultListModel list = this.application.getColormaps();
            Iterator it = v.iterator();
            while (it.hasNext()) {
                list.addElement(it.next());
            }
        }
    }

    private void doSave() {
        File file = this.application.getFileToSave();
        if (file != null) {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                PrintStream out = new PrintStream(fos);
                Enumeration e = this.application.getColormaps().elements();
                String[] blends = new String[]{"linear", "linear", "spline", "circle-up", "circle-down", "constant"};
                String[] types = new String[]{"rgb", "hue-cw", "hue-ccw"};
                out.println("<colormaps>");
                while (e.hasMoreElements()) {
                    Colormap c;
                    Colormap cm = (Colormap)e.nextElement();
                    if (cm instanceof Gradient) {
                        Gradient g = (Gradient)cm;
                        out.println(" <gradient-colormap>");
                        for (int j = 1; j < g.getNumKnots() - 1; ++j) {
                            String type = types[g.getKnotType(j)];
                            String blend = blends[g.getKnotBlend(j) >> 4];
                            out.println("  <knot x='" + g.getKnotPosition(j) + "' rgb='#" + Integer.toHexString(g.getKnot(j)) + "' blend='" + blend + "' type='" + type + "'/>");
                        }
                        out.println(" </gradient-colormap>");
                        continue;
                    }
                    if (cm instanceof LinearColormap) {
                        c = (LinearColormap)cm;
                        out.println(" <linear-colormap rgb1='#" + Integer.toHexString(((LinearColormap)c).getColor1()) + "  rgb2='#" + Integer.toHexString(((LinearColormap)c).getColor2()) + "'/>");
                        continue;
                    }
                    if (!(cm instanceof Colormap)) continue;
                    c = cm;
                    out.println(" <colormap>");
                    for (int i = 0; i < 256; ++i) {
                        out.println("  <color rgb='#" + Integer.toHexString(c.getColor((float)i / 255.0f)) + "'/>");
                    }
                    out.println(" </colormap>");
                }
                out.println("</colormaps>");
                out.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.application.getFrame(), "Can't save file", "Error", 0);
            }
        }
    }

    private void doNew() {
        this.application.getColormaps().addElement(new Gradient());
        int i = this.list.getModel().getSize() - 1;
        this.list.setSelectedIndex(i);
        this.list.ensureIndexIsVisible(i);
    }

    private void doDuplicate() {
        Object o = this.list.getSelectedValue();
        if (o != null) {
            this.application.getColormaps().addElement(((Gradient)o).clone());
            int i = this.list.getModel().getSize() - 1;
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        }
    }

    private void doRemove() {
        Object o = this.list.getSelectedValue();
        if (o != null) {
            int index = this.list.getLeadSelectionIndex();
            this.application.getColormaps().removeElement(o);
            ColormapIconFactory.disposeIcon((Colormap)o);
            int size = this.list.getModel().getSize() - 1;
            index = index <= size ? index : size;
            this.list.setSelectedIndex(index);
            this.list.ensureIndexIsVisible(index);
        }
    }

    private void doEdit() {
        Object o = this.list.getSelectedValue();
        if (o != null && o instanceof Gradient) {
            GradientEditorDialog gradientEditorDialog = new GradientEditorDialog((Gradient)o);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.loadItem) {
            this.doLoad();
        } else if (source == this.saveItem) {
            this.doSave();
        } else if (source == this.newItem) {
            this.doNew();
        } else if (source == this.duplicateItem) {
            this.doDuplicate();
        } else if (source == this.removeItem) {
            this.doRemove();
        } else if (source == this.editItem || source == this.list) {
            this.doEdit();
        }
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public String getName() {
        return "showGradients";
    }

    class ColormapCellRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        public ColormapCellRenderer() {
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(128, 16));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Dimension size = list.getSize();
            ColormapIcon icon = ColormapIconFactory.getIcon((Colormap)value);
            super.getListCellRendererComponent((JList<?>)list, icon, index, isSelected, cellHasFocus);
            this.setText(null);
            return this;
        }
    }

    class GradientEditorDialog
    implements ActionListener {
        private JButton applyButton;
        private JButton okButton;
        private JButton cancelButton;
        private AppInternalFrame iframe;
        private JFrame frame;
        private GradientEditor gradientEditor;
        private Gradient colormap;
        private Gradient newColormap;

        public GradientEditorDialog(Gradient colormap) {
            this.colormap = colormap;
            this.newColormap = (Gradient)colormap.clone();
            this.gradientEditor = new GradientEditor(this.newColormap);
            JPanel p2 = new JPanel();
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(1, 3));
            this.cancelButton = new JButton("Close");
            p.add(this.cancelButton);
            this.cancelButton.addActionListener(this);
            this.applyButton = new JButton("Apply");
            p.add(this.applyButton);
            this.applyButton.addActionListener(this);
            this.okButton = new JButton("OK");
            p.add(this.okButton);
            this.okButton.addActionListener(this);
            p2.add(p);
            if (((ColormapChooser)ColormapChooser.this).application.isMDI) {
                this.iframe = new AppInternalFrame("Gradient", false, false, false, true);
                this.iframe.getContentPane().add((Component)this.gradientEditor, "Center");
                this.iframe.getContentPane().add((Component)p2, "South");
                this.iframe.setLocation(100, 100);
                ColormapChooser.this.application.getDesktopPane().add((Component)this.iframe, JLayeredPane.MODAL_LAYER);
                this.iframe.pack();
                this.iframe.setVisible(true);
                this.iframe.toFront();
            } else {
                this.frame = new JFrame("Gradient");
                this.frame.getContentPane().add((Component)this.gradientEditor, "Center");
                this.frame.getContentPane().add((Component)p2, "South");
                this.frame.setLocation(100, 100);
                this.frame.pack();
                this.frame.setVisible(true);
                this.frame.toFront();
            }
        }

        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == this.okButton || source == this.cancelButton) {
                if (this.iframe != null) {
                    try {
                        this.iframe.setClosed(true);
                    }
                    catch (PropertyVetoException ex) {}
                } else {
                    this.frame.dispose();
                }
            }
            if (source == this.okButton || source == this.applyButton) {
                this.newColormap.copyTo(this.colormap);
                ColormapIcon icon = ColormapIconFactory.getIcon(this.colormap);
                if (icon != null) {
                    icon.rebuild();
                }
                ColormapChooser.this.list.repaint();
                PaintingContext.getInstance().setColormap(this.colormap);
            }
        }
    }

    static class ColormapList
    extends JList
    implements DragGestureListener,
    DragSourceListener {
        private DragSource dragSource = DragSource.getDefaultDragSource();
        private DragSourceContext dragSourceContext = null;

        public ColormapList(ListModel model) {
            super(model);
            DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
            dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            Colormap colormap = (Colormap)this.getSelectedValue();
            if (colormap != null) {
                ColormapTransferable transferable = new ColormapTransferable(colormap);
                Cursor cursor = DragSource.DefaultCopyNoDrop;
                int action = e.getDragAction();
                if (action == 2) {
                    cursor = DragSource.DefaultMoveNoDrop;
                }
                ColormapList colormapList = this;
                if (colormapList.dragSource.isDragImageSupported()) {
                    Image image = ColormapIconFactory.getIcon(colormap).getImage().getScaledInstance(128, 12, 8);
                    Point p = e.getDragOrigin();
                    p.y -= this.indexToLocation((int)this.locationToIndex((Point)p)).y;
                    this.dragSource.startDrag(e, cursor, image, new Point(-p.x, -p.y), transferable, this);
                } else {
                    this.dragSource.startDrag(e, cursor, transferable, this);
                }
            }
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dsde) {
        }
    }
}

