/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.BorderFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BorderFilterCustomizer
extends PreviewFilterCustomizer
implements DocumentListener {
    private JTextField leftText;
    private JTextField rightText;
    private JTextField topText;
    private JTextField bottomText;
    private BorderFilter filter;

    public BorderFilterCustomizer() {
        JPanel p = new JPanel();
        SuperGridLayout sgl = new SuperGridLayout(4, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        this.add((Component)p, "Center");
        p.add(new JLabel("Left:", 4));
        this.leftText = new JTextField(5);
        p.add(this.leftText);
        this.leftText.getDocument().addDocumentListener(this);
        p.add(new JLabel("Right:", 4));
        this.rightText = new JTextField(5);
        p.add(this.rightText);
        this.rightText.getDocument().addDocumentListener(this);
        p.add(new JLabel("Top:", 4));
        this.topText = new JTextField(5);
        p.add(this.topText);
        this.topText.getDocument().addDocumentListener(this);
        p.add(new JLabel("Bottom:", 4));
        this.bottomText = new JTextField(5);
        p.add(this.bottomText);
        this.bottomText.getDocument().addDocumentListener(this);
        this.leftText.selectAll();
        this.leftText.requestFocus();
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (BorderFilter)o;
        this.leftText.setText(Integer.toString(this.filter.getLeftBorder()));
        this.rightText.setText(Integer.toString(this.filter.getRightBorder()));
        this.topText.setText(Integer.toString(this.filter.getTopBorder()));
        this.bottomText.setText(Integer.toString(this.filter.getBottomBorder()));
    }

    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void textValueChanged(DocumentEvent event) {
        if (this.filter != null) {
            try {
                this.filter.setLeftBorder(Integer.parseInt(this.leftText.getText()));
                this.filter.setRightBorder(Integer.parseInt(this.rightText.getText()));
                this.filter.setTopBorder(Integer.parseInt(this.topText.getText()));
                this.filter.setBottomBorder(Integer.parseInt(this.bottomText.getText()));
                this.preview();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

