/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ColorTransferable;
import com.jhlabs.image.PaintingContext;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorWell
extends JComponent
implements MouseListener,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    private Color color = Color.white;
    private boolean mouseIn = false;
    private boolean dragIn = false;
    private boolean firingChangeEvent = false;
    private DragSource dragSource = null;
    private DragSourceContext dragSourceContext = null;
    private static boolean standalone = false;

    public ColorWell() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setPreferredSize(new Dimension(24, 24));
        this.setMaximumSize(new Dimension(24, 24));
        if (!standalone) {
            this.setToolTipText("Click here to drop the current foreground color");
        }
        this.addMouseListener(this);
        this.dragSource = DragSource.getDefaultDragSource();
        DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
        DropTarget dropTarget = new DropTarget(this, this);
    }

    public static void setStandalone(boolean s) {
        standalone = s;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setRGB(int rgb) {
        this.color = new Color(rgb);
        this.repaint();
    }

    public int getRGB() {
        return this.color.getRGB();
    }

    public void paintComponent(Graphics g) {
        if (this.color != null) {
            Dimension size = this.getSize();
            g.setColor(this.color);
            g.fillRect(0, 0, size.width, size.height);
            if (this.dragIn) {
                g.setColor(Color.black);
                g.drawRect(1, 1, size.width - 3, size.height - 3);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (standalone) {
            Color newColor = JColorChooser.showDialog(this, "Choose a color", this.color);
            if (newColor != null) {
                this.color = newColor;
                this.fireChangeEvent();
                this.repaint();
            }
        } else if (e.isMetaDown()) {
            PaintingContext.getInstance().setFgColor(this.color.getRGB());
        } else {
            this.color = new Color(PaintingContext.getInstance().getFgColor());
            this.fireChangeEvent();
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseIn = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseIn = false;
        this.repaint();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        if (!this.firingChangeEvent) {
            this.firingChangeEvent = true;
            ChangeEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? ColorWell.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                if (e == null) {
                    e = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
            this.firingChangeEvent = false;
        }
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        if (this.color != null) {
            ColorTransferable transferable = new ColorTransferable(this.color);
            Cursor cursor = DragSource.DefaultCopyNoDrop;
            int action = e.getDragAction();
            if (action == 2) {
                cursor = DragSource.DefaultMoveNoDrop;
            }
            this.mouseIn = false;
            this.repaint();
            ColorWell colorWell = this;
            if (colorWell.dragSource.isDragImageSupported()) {
                BufferedImage image = new BufferedImage(16, 16, 2);
                Graphics2D g = image.createGraphics();
                g.setColor(this.color);
                g.fillRect(0, 0, 16, 16);
                g.dispose();
                Point p = e.getDragOrigin();
                this.dragSource.startDrag(e, cursor, image, new Point(-p.x, -p.y), transferable, this);
            } else {
                this.dragSource.startDrag(e, cursor, transferable, this);
            }
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dsde) {
    }

    public void drop(DropTargetDropEvent e) {
        try {
            Transferable tr = e.getTransferable();
            if (tr.isDataFlavorSupported(ColorTransferable.COLOR_FLAVOR)) {
                Color color = (Color)tr.getTransferData(ColorTransferable.COLOR_FLAVOR);
                this.setColor(color);
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
                e.acceptDrop(1);
                e.getDropTargetContext().dropComplete(true);
                this.fireChangeEvent();
            }
        }
        catch (Exception ex) {
            e.rejectDrop();
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(ColorTransferable.COLOR_FLAVOR)) {
            this.dragIn = true;
        }
        this.repaint();
    }

    public void dragExit(DropTargetEvent e) {
        this.dragIn = false;
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent e) {
        e.acceptDrag(1);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

