/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.FadeFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FadeFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener {
    private JSlider angle;
    private JSlider sides;
    private JSlider start;
    private JSlider width;
    private JCheckBox invertCheck;
    private FadeFilter filter;

    public FadeFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "South");
        SuperGridLayout sgl = new SuperGridLayout(3, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        p.add(new JLabel("Angle:", 4));
        this.angle = new JSlider(0, 0, 360, 0);
        p.add(this.angle);
        this.angle.setPaintTicks(true);
        this.angle.setMajorTickSpacing(360);
        this.angle.setMinorTickSpacing(30);
        this.angle.setPaintLabels(true);
        this.angle.addChangeListener(this);
        p.add(new JLabel("Fade Start:", 4));
        this.start = new JSlider(0, 0, 100, 0);
        p.add(this.start);
        this.start.setPaintTicks(true);
        this.start.setMajorTickSpacing(100);
        this.start.setMinorTickSpacing(10);
        this.start.setPaintLabels(true);
        this.start.addChangeListener(this);
        p.add(new JLabel("Fade Width:", 4));
        this.width = new JSlider(0, 0, 100, 0);
        p.add(this.width);
        this.width.setPaintTicks(true);
        this.width.setMajorTickSpacing(100);
        this.width.setMinorTickSpacing(10);
        this.width.setPaintLabels(true);
        this.width.addChangeListener(this);
        p.add(new JLabel("Sides:", 4));
        this.sides = new JSlider(0, 1, 6, 1);
        p.add(this.sides);
        this.sides.setPaintTicks(true);
        this.sides.setMajorTickSpacing(6);
        this.sides.setMinorTickSpacing(1);
        this.sides.setPaintLabels(true);
        this.sides.addChangeListener(this);
        this.invertCheck = new JCheckBox("Invert:");
        p.add(this.invertCheck);
        this.invertCheck.addChangeListener(this);
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (FadeFilter)o;
        this.angle.setValue((int)((double)(this.filter.getAngle() * 180.0f) / Math.PI));
        this.sides.setValue(this.filter.getSides());
        this.start.setValue((int)this.filter.getFadeStart());
        this.width.setValue((int)this.filter.getFadeWidth());
        this.invertCheck.setSelected(this.filter.getInvert());
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source == this.angle) {
                this.filter.setAngle((float)this.angle.getValue() * (float)Math.PI / 180.0f);
            } else if (source == this.sides) {
                this.filter.setSides(this.sides.getValue());
            } else if (source == this.start) {
                this.filter.setFadeStart(this.start.getValue());
            } else if (source == this.width) {
                this.filter.setFadeWidth(this.width.getValue());
            } else if (source == this.invertCheck) {
                this.filter.setInvert(this.invertCheck.isSelected());
            }
            this.preview();
        }
    }
}

