/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.image.MapFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.math.ImageFunction2D;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MapFilterCustomizer
extends PreviewFilterCustomizer
implements ItemListener,
ActionListener {
    private JTextField xField;
    private JTextField yField;
    private JButton xButton;
    private JButton yButton;
    private JComboBox edgeChoice;
    private MapFilter filter;

    public MapFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "South");
        SuperGridLayout sgl = new SuperGridLayout(3, 3);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        p.add(new JLabel("X Map:"));
        this.xField = new JTextField(30);
        p.add(this.xField);
        this.xField.setEditable(false);
        this.xButton = new JButton("Choose...");
        p.add(this.xButton);
        this.xButton.addActionListener(this);
        p.add(new JLabel("Y Map:"));
        this.yField = new JTextField(30);
        p.add(this.yField);
        this.yField.setEditable(false);
        this.yButton = new JButton("Choose...");
        p.add(this.yButton);
        this.yButton.addActionListener(this);
        p.add(new JLabel("At Edges:", 4));
        this.edgeChoice = new JComboBox();
        p.add(this.edgeChoice);
        this.edgeChoice.addItemListener(this);
        this.edgeChoice.addItem("Transparent");
        this.edgeChoice.addItem("Clamp");
        this.edgeChoice.addItem("Wrap");
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (MapFilter)o;
        this.edgeChoice.setSelectedIndex(this.filter.getEdgeAction());
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source == this.edgeChoice) {
                this.filter.setEdgeAction(this.edgeChoice.getSelectedIndex());
            }
            this.preview();
        }
    }

    public void actionPerformed(ActionEvent e) {
        CompositionDocument document;
        Object source;
        if (this.filter != null && ((source = e.getSource()) == this.xButton || source == this.yButton) && (document = this.chooseImage()) != null) {
            BufferedImage map = document.getActiveLayer().getImage();
            ImageFunction2D f = new ImageFunction2D(map, 2, false);
            if (source == this.xButton) {
                this.filter.setXMapFunction(f);
                this.xField.setText(document.getTitle());
            } else {
                this.filter.setYMapFunction(f);
                this.yField.setText(document.getTitle());
            }
            this.preview();
        }
    }

    public CompositionDocument chooseImage() {
        CompositionApplication application = (CompositionApplication)CompositionApplication.getInstance();
        Vector<CompositionDocument> v = new Vector<CompositionDocument>();
        Enumeration en = application.getDocuments();
        while (en.hasMoreElements()) {
            CompositionDocument document = (CompositionDocument)en.nextElement();
            v.addElement(document);
        }
        Object[] possibleValues = new Object[v.size()];
        v.copyInto(possibleValues);
        Object selectedValue = JOptionPane.showInputDialog(null, "Choose an image:", "Bump Map", 3, null, possibleValues, possibleValues[0]);
        if (selectedValue != null) {
            return (CompositionDocument)selectedValue;
        }
        return null;
    }
}

