/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;
import java.util.Random;

public class ReactDiffuse
extends WholeImageFilter {
    private Random random;
    public int iterations = 20;
    public float xScale = 1.0f;
    public float yScale = 1.0f;
    public float amount = 1.0f;
    public boolean spots = true;
    private boolean initialized = false;
    private int width = 64;
    private int height = 64;
    private int value_switch = 1;
    private float[][] a;
    private float[][] b;
    private float[][] c;
    private float[][] d;
    private float[][] e;
    private float[][] da;
    private float[][] db;
    private float[][] dc;
    private float[][] dd;
    private float[][] de;
    private float[][] ai;
    private float minValue;
    private float maxValue;
    public float p1 = 0.04f;
    public float p2 = 0.06f;
    public float p3 = 0.04f;
    private float diff1;
    private float diff2;
    private float arand;
    private float a_steady;
    private float b_steady;
    private float beta_init;
    private float beta_rand;
    private float speed = 1.0f;
    private Colormap colormap = new Gradient();

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void initialize(int w, int h) {
        this.a = new float[w][h];
        this.b = new float[w][h];
        this.c = new float[w][h];
        this.d = new float[w][h];
        this.e = new float[w][h];
        this.da = new float[w][h];
        this.db = new float[w][h];
        this.dc = new float[w][h];
        this.dd = new float[w][h];
        this.de = new float[w][h];
        this.ai = new float[w][h];
    }

    public void stripes(int[] inPixels, int width, int height) {
        this.diff1 = 0.009f;
        this.diff2 = 0.2f;
        this.arand = 0.02f;
        this.value_switch = 1;
        this.compute(inPixels, width, height);
    }

    public void spots(int[] inPixels, int width, int height) {
        this.beta_init = 12.0f;
        this.beta_rand = 0.1f;
        this.a_steady = 4.0f;
        this.b_steady = 4.0f;
        this.diff1 = 0.25f;
        this.diff2 = 0.0625f;
        this.p1 = 0.2f;
        this.p2 = 0.0f;
        this.p3 = 0.0f;
        this.value_switch = 2;
        this.compute(inPixels, width, height);
    }

    private void compute(int[] inPixels, int width, int height) {
        this.calcSemistableEquilibria(inPixels, width, height);
        for (int k = 0; k < this.iterations; ++k) {
            if (this.spots) {
                this.turing();
                continue;
            }
            this.multiplicative_help();
        }
        switch (this.value_switch) {
            case 1: {
                this.normalize(this.a);
                break;
            }
            case 2: {
                this.normalize(this.b);
                break;
            }
            case 3: {
                this.normalize(this.c);
                break;
            }
            case 4: {
                this.normalize(this.d);
                break;
            }
            case 5: {
                this.normalize(this.e);
            }
        }
    }

    private void multiplicative_help() {
        int j;
        int i;
        for (i = 0; i < this.width; ++i) {
            float ka = -this.p1 - 4.0f * this.diff1;
            float kc = -this.p2;
            float kd = -this.p3 - 4.0f * this.diff2;
            int iprev = (i + this.width - 1) % this.width;
            int inext = (i + 1) % this.width;
            for (j = 0; j < this.height; ++j) {
                int jprev = (j + this.height - 1) % this.height;
                int jnext = (j + 1) % this.height;
                float aval = this.a[i][j];
                float bval = this.b[i][j];
                float cval = this.c[i][j];
                float dval = this.d[i][j];
                float eval = this.e[i][j];
                float temp1 = 0.01f * aval * aval * eval * this.ai[i][j];
                float temp2 = 0.01f * bval * bval * dval;
                float dda = this.a[i][jprev] + this.a[i][jnext] + this.a[iprev][j] + this.a[inext][j];
                float ddb = this.b[i][jprev] + this.b[i][jnext] + this.b[iprev][j] + this.b[inext][j];
                float ddd = this.d[i][jprev] + this.d[i][jnext] + this.d[iprev][j] + this.d[inext][j];
                float dde = this.e[i][jprev] + this.e[i][jnext] + this.e[iprev][j] + this.e[inext][j];
                this.da[i][j] = aval * ka + this.diff1 * dda + temp1 / cval;
                this.db[i][j] = bval * ka + this.diff1 * ddb + temp2 / cval;
                this.dc[i][j] = cval * kc + temp1 + temp2;
                this.dd[i][j] = dval * kd + this.diff2 * ddd + this.p3 * aval;
                this.de[i][j] = eval * kd + this.diff2 * dde + this.p3 * bval;
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                float[] fArray = this.a[i];
                int n = j;
                fArray[n] = fArray[n] + this.speed * this.da[i][j];
                float[] fArray2 = this.b[i];
                int n2 = j;
                fArray2[n2] = fArray2[n2] + this.speed * this.db[i][j];
                float[] fArray3 = this.c[i];
                int n3 = j;
                fArray3[n3] = fArray3[n3] + this.speed * this.dc[i][j];
                float[] fArray4 = this.d[i];
                int n4 = j;
                fArray4[n4] = fArray4[n4] + this.speed * this.dd[i][j];
                float[] fArray5 = this.e[i];
                int n5 = j;
                fArray5[n5] = fArray5[n5] + this.speed * this.de[i][j];
            }
        }
    }

    private void turing() {
        int j;
        int i;
        float Diff1 = this.diff1 / 2.0f;
        float Diff2 = this.diff2 / 2.0f;
        float ka = this.p1 / 16.0f;
        for (i = 0; i < this.width; ++i) {
            int iprev = (i + this.width - 1) % this.width;
            int inext = (i + 1) % this.width;
            for (j = 0; j < this.height; ++j) {
                int jprev = (j + this.height - 1) % this.height;
                int jnext = (j + 1) % this.height;
                float aval = this.a[i][j];
                float bval = this.b[i][j];
                float dda = this.a[i][jprev] + this.a[i][jnext] + this.a[iprev][j] + this.a[inext][j] - 4.0f * aval;
                float ddb = this.b[i][jprev] + this.b[i][jnext] + this.b[iprev][j] + this.b[inext][j] - 4.0f * bval;
                this.da[i][j] = ka * (16.0f - aval * bval) + Diff1 * dda;
                this.db[i][j] = ka * (aval * bval - bval - this.c[i][j]) + Diff2 * ddb;
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                float[] fArray = this.a[i];
                int n = j;
                fArray[n] = fArray[n] + this.speed * this.da[i][j];
                float[] fArray2 = this.b[i];
                int n2 = j;
                fArray2[n2] = fArray2[n2] + this.speed * this.db[i][j];
                if (!(this.b[i][j] < 0.0f)) continue;
                this.b[i][j] = 0.0f;
            }
        }
    }

    private void calcSemistableEquilibria(int[] inPixels, int width, int height) {
        float ainit;
        float binit;
        float cinit;
        float dinit;
        float einit;
        int index = 0;
        if (this.spots) {
            einit = 0.0f;
            dinit = 0.0f;
            cinit = 0.0f;
            binit = 0.0f;
            ainit = 0.0f;
        } else {
            binit = ainit = this.p2 / (2.0f * this.p1);
            cinit = 0.02f * ainit * ainit * ainit / this.p2;
            dinit = ainit;
            einit = ainit;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = inPixels[index++];
                int rd = rgb >> 16 & 0xFF;
                int gr = rgb >> 8 & 0xFF;
                int bl = rgb & 0xFF;
                float value = (float)(rd + gr + bl) / 3.0f / 255.0f;
                if (this.spots) {
                    this.a[x][y] = this.a_steady;
                    this.b[x][y] = this.b_steady;
                    this.c[x][y] = value;
                    continue;
                }
                this.a[x][y] = ainit;
                this.b[x][y] = binit;
                this.c[x][y] = cinit;
                this.d[x][y] = dinit;
                this.e[x][y] = einit;
                this.ai[x][y] = value;
            }
        }
    }

    private void normalize(float[][] values) {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                min = Math.min(min, values[i][j]);
                max = Math.max(max, values[i][j]);
            }
        }
        if (min == max) {
            min = max - 1.0f;
            max = min + 2.0f;
        }
        this.minValue = min;
        this.maxValue = max;
    }

    private float frand(float min, float max) {
        return min + this.random.nextFloat() * (max - min);
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        this.random = new Random(0L);
        width = this.originalSpace.width;
        height = this.originalSpace.height;
        int index = 0;
        this.initialize(width, height);
        if (this.spots) {
            this.spots(inPixels, width, height);
        } else {
            this.stripes(inPixels, width, height);
        }
        int[] outPixels = new int[width * height];
        index = 0;
        float[][] v = this.value_switch == 2 ? this.b : this.a;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                outPixels[index++] = this.colormap.getColor(this.amount * (v[x % width][y % height] - this.minValue) / (this.maxValue - this.minValue));
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Texture/Reaction-diffusion...";
    }
}

