/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.math;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.math.CellularFunction2D;
import java.awt.Component;
import java.beans.Customizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CellularFunction2DCustomizer
extends JPanel
implements Customizer,
ChangeListener {
    private JSlider[] coefficients = new JSlider[4];
    private CellularFunction2D function;

    public CellularFunction2DCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "South");
        SuperGridLayout sgl = new SuperGridLayout(3, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        for (int i = 0; i < 4; ++i) {
            p.add(new JLabel("Coefficient " + i + ":", 4));
            this.coefficients[i] = new JSlider(0, 0, 100, 0);
            p.add(this.coefficients[i]);
            this.coefficients[i].setPaintTicks(true);
            this.coefficients[i].setMajorTickSpacing(50);
            this.coefficients[i].setMinorTickSpacing(10);
            this.coefficients[i].setPaintLabels(true);
            this.coefficients[i].addChangeListener(this);
        }
    }

    public void setObject(Object o) {
        this.function = (CellularFunction2D)o;
        for (int i = 0; i < 4; ++i) {
            this.coefficients[i].setValue((int)(this.function.getCoefficient(i) * 100.0f));
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.function != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                if (source != this.coefficients[i]) continue;
                this.function.setCoefficient(i, (float)this.coefficients[i].getValue() / 100.0f);
            }
        }
    }
}

