/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.paint;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.LinearColormap;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ExtendedGradientPaint
implements Paint {
    public static final int LINEAR = 0;
    public static final int BILINEAR = 1;
    public static final int RADIAL = 2;
    public static final int CONICAL = 3;
    public static final int BICONICAL = 4;
    public static final int SQUARE = 5;
    public static final int INT_LINEAR = 0;
    public static final int INT_CIRCLE_UP = 1;
    public static final int INT_CIRCLE_DOWN = 2;
    public static final int INT_SMOOTH = 3;
    private float angle = 0.0f;
    private int color1 = -16777216;
    private int color2 = -1;
    private Point p1 = new Point(0, 0);
    private Point p2 = new Point(64, 64);
    private boolean repeat = false;
    private Colormap colormap = null;
    private int type;
    private int interpolation = 0;

    public ExtendedGradientPaint() {
    }

    public ExtendedGradientPaint(Point p1, Point p2, int color1, int color2, boolean repeat, int type, int interpolation) {
        this.p1 = p1;
        this.p2 = p2;
        this.color1 = color1;
        this.color2 = color2;
        this.repeat = repeat;
        this.type = type;
        this.interpolation = interpolation;
        this.colormap = new LinearColormap(color1, color2);
    }

    public void setPoint1(Point point1) {
        this.p1 = point1;
    }

    public Point getPoint1() {
        return this.p1;
    }

    public void setPoint2(Point point2) {
        this.p2 = point2;
    }

    public Point getPoint2() {
        return this.p2;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.p2 = new Point((int)(64.0 * Math.cos(angle)), (int)(64.0 * Math.sin(angle)));
    }

    public float getAngle() {
        return this.angle;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return new Context(cm);
    }

    public int getTransparency() {
        return 3;
    }

    class Context
    implements PaintContext {
        private ColorModel model;
        private float x1;
        private float y1;
        private float x2;
        private float y2;
        private float dx;
        private float dy;

        public Context(ColorModel model) {
            this.model = model;
        }

        public void dispose() {
        }

        public ColorModel getColorModel() {
            return this.model;
        }

        public Raster getRaster(int x, int y, int w, int h) {
            float lenSq;
            if (w <= 0 || h <= 0) {
                System.out.println(w + " " + h);
                h = 1;
                w = 1;
            }
            WritableRaster raster = this.model.createCompatibleWritableRaster(w, h);
            this.x1 = ((ExtendedGradientPaint)ExtendedGradientPaint.this).p1.x - x;
            this.x2 = ((ExtendedGradientPaint)ExtendedGradientPaint.this).p2.x - x;
            this.y1 = ((ExtendedGradientPaint)ExtendedGradientPaint.this).p1.y - y;
            this.y2 = ((ExtendedGradientPaint)ExtendedGradientPaint.this).p2.y - y;
            int rgb1 = ExtendedGradientPaint.this.color1;
            int rgb2 = ExtendedGradientPaint.this.color2;
            this.dx = this.x2 - this.x1;
            this.dy = this.y2 - this.y1;
            if (this.dx < 0.0f && (ExtendedGradientPaint.this.type == 0 || ExtendedGradientPaint.this.type == 1)) {
                this.dx = -this.dx;
                this.dy = -this.dy;
                float t = this.x1;
                this.x1 = this.x2;
                this.x2 = t;
                t = this.y1;
                this.y1 = this.y2;
                this.y2 = t;
                int c = rgb1;
                rgb1 = rgb2;
                rgb2 = c;
            }
            if ((lenSq = this.dx * this.dx + this.dy * this.dy) != 0.0f) {
                this.dx /= lenSq;
                this.dy /= lenSq;
                if (ExtendedGradientPaint.this.repeat) {
                    this.dx %= 1.0f;
                    this.dy %= 1.0f;
                }
            }
            int[] pixels = null;
            for (int i = 0; i < h; ++i) {
                pixels = (int[])raster.getDataElements(0, i, w, 1, pixels);
                switch (ExtendedGradientPaint.this.type) {
                    case 0: 
                    case 1: {
                        this.linearGradient(pixels, i, w, 1);
                        break;
                    }
                    case 2: {
                        this.radialGradient(pixels, i, w, 1);
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.conicalGradient(pixels, i, w, 1);
                        break;
                    }
                    case 5: {
                        this.squareGradient(pixels, i, w, 1);
                    }
                }
                raster.setDataElements(0, i, w, 1, pixels);
            }
            return raster;
        }

        private void repeatGradient(int[] pixels, int w, int h, float rowrel, float dx, float dy) {
            int off = 0;
            for (int y = 0; y < h; ++y) {
                float colrel = rowrel;
                int j = w;
                while (--j >= 0) {
                    int rgb = ExtendedGradientPaint.this.type == 1 ? ExtendedGradientPaint.this.colormap.getColor(this.map(ImageMath.triangle(colrel))) : ExtendedGradientPaint.this.colormap.getColor(this.map(ImageMath.mod(colrel, 1.0f)));
                    pixels[off] = rgb;
                    ++off;
                    colrel += dx;
                }
                rowrel += dy;
            }
        }

        private void singleGradient(int[] pixels, int w, int h, float rowrel, float dx, float dy) {
            int off = 0;
            for (int y = 0; y < h; ++y) {
                int rgb;
                float colrel = rowrel;
                int j = w;
                if ((double)colrel <= 0.0) {
                    rgb = ExtendedGradientPaint.this.colormap.getColor(0.0f);
                    do {
                        pixels[off] = rgb;
                        ++off;
                    } while (--j > 0 && (double)(colrel += dx) <= 0.0);
                }
                while ((double)colrel < 1.0 && --j >= 0) {
                    rgb = ExtendedGradientPaint.this.type == 1 ? ExtendedGradientPaint.this.colormap.getColor(this.map(ImageMath.triangle(colrel))) : ExtendedGradientPaint.this.colormap.getColor(this.map(colrel));
                    pixels[off] = rgb;
                    ++off;
                    colrel += dx;
                }
                if (j > 0) {
                    rgb = ExtendedGradientPaint.this.type == 1 ? ExtendedGradientPaint.this.colormap.getColor(0.0f) : ExtendedGradientPaint.this.colormap.getColor(1.0f);
                    do {
                        pixels[off] = rgb;
                        ++off;
                    } while (--j > 0);
                }
                rowrel += dy;
            }
        }

        private void linearGradient(int[] pixels, int y, int w, int h) {
            boolean x = false;
            float rowrel = ((float)x - this.x1) * this.dx + ((float)y - this.y1) * this.dy;
            if (ExtendedGradientPaint.this.repeat) {
                this.repeatGradient(pixels, w, h, rowrel, this.dx, this.dy);
            } else {
                this.singleGradient(pixels, w, h, rowrel, this.dx, this.dy);
            }
        }

        private void radialGradient(int[] pixels, int y, int w, int h) {
            int off = 0;
            float radius = this.distance(this.x2 - this.x1, this.y2 - this.y1);
            for (int x = 0; x < w; ++x) {
                int rgb;
                float distance = this.distance((float)x - this.x1, (float)y - this.y1);
                float ratio = distance / radius;
                if (ExtendedGradientPaint.this.repeat) {
                    ratio %= 2.0f;
                } else if ((double)ratio > 1.0) {
                    ratio = 1.0f;
                }
                pixels[off] = rgb = ExtendedGradientPaint.this.colormap.getColor(this.map(ratio));
                ++off;
            }
        }

        private void squareGradient(int[] pixels, int y, int w, int h) {
            int off = 0;
            float radius = Math.max(Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1));
            for (int x = 0; x < w; ++x) {
                int rgb;
                float distance = Math.max(Math.abs((float)x - this.x1), Math.abs((float)y - this.y1));
                float ratio = distance / radius;
                if (ExtendedGradientPaint.this.repeat) {
                    ratio %= 2.0f;
                } else if ((double)ratio > 1.0) {
                    ratio = 1.0f;
                }
                pixels[off] = rgb = ExtendedGradientPaint.this.colormap.getColor(this.map(ratio));
                ++off;
            }
        }

        private void conicalGradient(int[] pixels, int y, int w, int h) {
            int off = 0;
            float angle0 = (float)Math.atan2(this.x2 - this.x1, this.y2 - this.y1);
            for (int x = 0; x < w; ++x) {
                int rgb;
                float angle = (float)(Math.atan2((float)x - this.x1, (float)y - this.y1) - (double)angle0) / ((float)Math.PI * 2);
                angle += 1.0f;
                angle %= 1.0f;
                if (ExtendedGradientPaint.this.type == 4) {
                    angle = ImageMath.triangle(angle);
                }
                pixels[off] = rgb = ExtendedGradientPaint.this.colormap.getColor(this.map(angle));
                ++off;
            }
        }

        private float map(float v) {
            if (ExtendedGradientPaint.this.repeat) {
                v = (double)v > 1.0 ? 2.0f - v : v;
            }
            switch (ExtendedGradientPaint.this.interpolation) {
                case 1: {
                    v = ImageMath.circleUp(ImageMath.clamp(v, 0.0f, 1.0f));
                    break;
                }
                case 2: {
                    v = ImageMath.circleDown(ImageMath.clamp(v, 0.0f, 1.0f));
                    break;
                }
                case 3: {
                    v = ImageMath.smoothStep(0.0f, 1.0f, v);
                }
            }
            return v;
        }

        private float distance(float a, float b) {
            return (float)Math.sqrt(a * a + b * b);
        }
    }
}

