/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributeListImpl;

public class XMLParser
implements Parser {
    private static Hashtable entities;
    private DocumentHandler handler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;
    private InputStream inputStream;
    private Reader reader;
    private Stack tagStack;
    private boolean beforeRoot = true;
    private boolean afterRoot = false;
    private boolean leadingWhitespace;
    private boolean atEOF = false;
    private char ch;
    private char lastCh;
    private int lineNo = 1;
    private boolean closeInput = true;
    private static final SAXException EOF;
    private static final AttributeList NULL_ATTRIBUTES;

    public XMLParser() {
    }

    public XMLParser(boolean closeInput) {
        this.closeInput = closeInput;
    }

    private void read() throws SAXException {
        try {
            int c = this.reader.read();
            this.lastCh = this.ch;
            this.ch = (char)c;
            if (c == 13 || c == 10 && this.lastCh != '\r') {
                ++this.lineNo;
            }
            if (c == -1) {
                if (this.atEOF) {
                    throw EOF;
                }
                this.atEOF = true;
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private static boolean isInitial(char c) {
        return Character.isLetter(c) || c == ':' || c == '_';
    }

    private void skipWhiteSpace() throws SAXException {
        while (XMLParser.isWhiteSpace(this.ch)) {
            this.read();
        }
    }

    private String parseAttributeValue() throws SAXException {
        StringBuffer sb = new StringBuffer();
        if (this.ch != '\'' && this.ch != '\"') {
            this.fatalError("Attribute values must be quoted");
        }
        char quote = this.ch;
        this.read();
        while (this.ch != quote) {
            if (this.ch == '<') {
                this.fatalError("Attribute value contains illegal character");
            } else if (this.ch == '&') {
                sb.append(this.parseEntity());
            } else {
                sb.append(this.ch);
            }
            this.read();
        }
        this.read();
        this.skipWhiteSpace();
        return sb.toString();
    }

    private String parseEntity() throws SAXException {
        StringBuffer sb = new StringBuffer();
        this.read();
        while (this.ch != ';') {
            if (this.ch != '#' && !Character.isLetterOrDigit(this.ch)) {
                this.fatalError("Character reference contains illegal character");
            }
            sb.append(this.ch);
            this.read();
        }
        String name = sb.toString();
        if (name.startsWith("#x")) {
            try {
                return String.valueOf((char)Integer.parseInt(name.substring(2), 16));
            }
            catch (NumberFormatException e) {
            }
        } else if (name.startsWith("#")) {
            try {
                return String.valueOf((char)Integer.parseInt(name.substring(1), 10));
            }
            catch (NumberFormatException e) {
            }
        } else {
            String s = (String)entities.get(name);
            if (s != null) {
                return s;
            }
        }
        this.fatalError("Bad character reference: " + name);
        return null;
    }

    private String parseAttributeName() throws SAXException {
        if (!XMLParser.isInitial(this.ch)) {
            this.fatalError("Illegal tag name");
        }
        StringBuffer sb = new StringBuffer();
        do {
            sb.append(this.ch);
            this.read();
        } while (Character.isLetterOrDigit(this.ch) || this.ch == '.' || this.ch == '-' || this.ch == '_' || this.ch == ':');
        this.skipWhiteSpace();
        return sb.toString();
    }

    private AttributeList parseAttributes() throws SAXException {
        AttributeList attributes = null;
        while (XMLParser.isInitial(this.ch)) {
            String name = this.parseAttributeName();
            if (this.ch != '=') {
                this.fatalError("'=' expected after attribute name");
            }
            this.read();
            this.skipWhiteSpace();
            String value = this.parseAttributeValue();
            if (attributes == null) {
                attributes = new AttributeListImpl();
            }
            ((AttributeListImpl)attributes).addAttribute(name, "PCDATA", value);
        }
        return attributes != null ? attributes : NULL_ATTRIBUTES;
    }

    private void readCommentOrCDATA(char term) throws SAXException {
        StringBuffer sb = new StringBuffer();
        for (int length = 0; this.ch != '>' || length < 2 || sb.charAt(length - 2) != term || sb.charAt(length - 1) != term; ++length) {
            if (term == '-' && length >= 2 && sb.charAt(length - 2) == '-' && sb.charAt(length - 1) == '-') {
                this.fatalError("-- found in comment");
            }
            sb.append(this.ch);
            this.read();
        }
    }

    private void readDOCTYPE() throws SAXException {
        StringBuffer sb = new StringBuffer();
        int brackets = 0;
        while (this.ch != '>' || brackets != 0) {
            sb.append(this.ch);
            if (this.ch == '[') {
                ++brackets;
            }
            if (this.ch == ']') {
                --brackets;
            }
            this.read();
        }
    }

    private String readChars(int count) throws SAXException {
        StringBuffer sb = new StringBuffer();
        while (sb.length() < count) {
            sb.append(this.ch);
            this.read();
        }
        return sb.toString();
    }

    private void parseExclTag() throws SAXException {
        this.read();
        String name = this.ch == '-' ? this.readChars(2) : (this.ch == '[' ? this.readChars(7) : this.readChars(7));
        if (name.equals("--")) {
            this.readCommentOrCDATA('-');
        } else if (name.equals("[CDATA[")) {
            this.readCommentOrCDATA(']');
        } else if (name.equals("DOCTYPE")) {
            this.readDOCTYPE();
        } else {
            this.fatalError("Unknown <!> tag");
        }
    }

    private void parsePITag() throws SAXException {
        this.read();
        String name = this.parseAttributeName();
        StringBuffer sb = new StringBuffer();
        char c1 = this.ch;
        this.read();
        while (c1 != '?' || this.ch != '>') {
            sb.append(c1);
            c1 = this.ch;
            this.read();
        }
        if (name.toLowerCase().equals("xml") && (!this.beforeRoot || this.leadingWhitespace)) {
            this.fatalError("<?xml?> tag must be the first tag");
        }
        if (this.afterRoot) {
            this.fatalError("Tag found outside the root tag");
        }
        this.beforeRoot = false;
        this.handler.processingInstruction(sb.toString(), null);
    }

    private boolean parseEndTag() throws SAXException {
        boolean end = false;
        if (this.ch != '/' && this.ch != '>') {
            this.fatalError("Tag close expected");
        }
        if (this.ch == '/') {
            end = true;
            this.read();
        }
        if (this.ch != '>') {
            this.fatalError("Tag close expected");
        }
        this.read();
        return end;
    }

    private void parseElement() throws SAXException {
        String name = this.parseAttributeName();
        this.handler.startElement(name, this.parseAttributes());
        if (this.parseEndTag()) {
            this.handler.endElement(name);
        } else {
            this.tagStack.push(name);
        }
        if (this.afterRoot) {
            this.fatalError("Tag found outside the root tag");
        }
        this.beforeRoot = false;
    }

    private void parseClosingElement() throws SAXException {
        String s;
        this.read();
        String name = this.parseAttributeName();
        this.skipWhiteSpace();
        if (this.parseEndTag()) {
            this.fatalError("Closing tag ends with />");
        }
        if (this.tagStack.size() == 0) {
            this.fatalError("Too many closing elements");
        }
        if (!(s = (String)this.tagStack.pop()).equals(name)) {
            this.fatalError("Opening element '" + s + "' doesn't match closing '" + name + "'");
        }
        this.handler.endElement(name);
    }

    private void parseCDATA() throws SAXException {
        char[] a;
        int lastNonWhite = -1;
        StringBuffer sb = new StringBuffer();
        while (XMLParser.isWhiteSpace(this.ch)) {
            sb.append(this.ch);
            this.read();
        }
        if (sb.length() != 0) {
            a = sb.toString().toCharArray();
            this.handler.ignorableWhitespace(a, 0, sb.length());
            sb = new StringBuffer();
        }
        while (this.ch != '<') {
            if (this.ch == '&') {
                sb.append(this.parseEntity());
            } else {
                sb.append(this.ch);
            }
            if (!XMLParser.isWhiteSpace(this.ch)) {
                lastNonWhite = sb.length();
            }
            this.read();
        }
        a = sb.toString().toCharArray();
        if (lastNonWhite == sb.length()) {
            this.handler.characters(a, 0, sb.length());
        } else if (lastNonWhite == -1) {
            this.handler.ignorableWhitespace(a, 0, sb.length());
        } else {
            this.handler.characters(a, 0, lastNonWhite);
            this.handler.ignorableWhitespace(a, lastNonWhite, sb.length() - lastNonWhite);
        }
        if (this.beforeRoot || this.afterRoot) {
            this.fatalError("Character data found outside the root tag");
        }
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.handler = handler;
    }

    public DocumentHandler getDocumentHandler() {
        return this.handler;
    }

    public void setLocale(Locale locale) {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public void parse(String systemId) throws SAXException {
        this.parse(new InputSource(systemId));
    }

    public void parse(InputSource source) throws SAXException {
        block15: {
            this.tagStack = new Stack();
            this.reader = source.getCharacterStream();
            if (this.reader == null) {
                this.reader = new InputStreamReader(source.getByteStream());
            }
            if (!(this.reader instanceof BufferedReader)) {
                this.reader = new BufferedReader(this.reader);
            }
            this.read();
            this.leadingWhitespace = this.ch != '<';
            this.handler.startDocument();
            try {
                block9: while (true) {
                    if (this.ch == '<') {
                        this.read();
                        if (this.ch != '\uffffffff') {
                            switch (this.ch) {
                                case '?': {
                                    this.parsePITag();
                                    continue block9;
                                }
                                case '!': {
                                    this.parseExclTag();
                                    continue block9;
                                }
                                case '/': {
                                    this.parseClosingElement();
                                    continue block9;
                                }
                            }
                            this.parseElement();
                            continue;
                        }
                        break;
                    }
                    this.parseCDATA();
                }
            }
            catch (Exception e) {
                if (this.atEOF && this.tagStack.size() == 0) break block15;
                e.printStackTrace();
                throw new SAXException(e.toString());
            }
        }
        try {
            if (this.closeInput) {
                this.reader.close();
            }
            this.reader = null;
        }
        catch (Exception e) {
            throw new SAXException(e.toString());
        }
        this.handler.endDocument();
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorHandler == null) {
            throw exception;
        }
        this.errorHandler.warning(exception);
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.errorHandler == null) {
            throw exception;
        }
        this.errorHandler.warning(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.errorHandler == null) {
            throw exception;
        }
        this.errorHandler.warning(exception);
    }

    private void fatalError(String msg) throws SAXException {
        msg = "Error at line " + this.lineNo + ": " + msg;
        this.fatalError(new SAXParseException(msg, "", "", this.lineNo, 0));
    }

    static {
        EOF = new SAXException("EOF");
        NULL_ATTRIBUTES = new AttributeListImpl();
        entities = new Hashtable();
        entities.put("lt", "<");
        entities.put("gt", ">");
        entities.put("amp", "&");
        entities.put("quot", "\"");
        entities.put("apos", "'");
    }
}

