/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.crw;

import it.tidalwave.imageio.crw.CRWImageReader;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.imageio.ImageReader;

public class CRWImageReaderSpi
extends RAWImageReaderSpiSupport {
    private static final String CLASS = CRWImageReaderSpi.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public CRWImageReaderSpi() {
        super("CRW", "crw", "image/x-canon-crw", CRWImageReader.class);
    }

    @Nonnull
    public String getDescription(@Nonnull Locale locale) {
        return "Standard CRW Image Reader";
    }

    @Nonnull
    public ImageReader createReaderInstance(@Nonnull Object extension) throws IOException {
        return new CRWImageReader(this);
    }

    public boolean canDecodeInput(@Nonnull RAWImageInputStream iis) throws IOException {
        iis.seek(6L);
        byte[] marker = new byte[8];
        iis.readFully(marker);
        String markerAsString = new String(marker);
        logger.finest("canDecodeInput(%s) -- marker: %s", iis, markerAsString);
        return "HEAPCCDR".equals(markerAsString);
    }
}

