/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    public static Hashtable parseQueryString(String string) {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            while (i < n && (Character.isWhitespace(c2 = string.charAt(i)) || c2 == '&')) {
                ++i;
            }
            int n2 = 0;
            while (i < n && (c2 = string.charAt(i)) != '=') {
                if (c2 == '+') {
                    byArray[n2++] = 32;
                } else if (c2 == '%' && i + 2 < n) {
                    char c3 = string.charAt(++i);
                    c = string.charAt(++i);
                    byArray[n2++] = (byte)((HttpUtils.toHex(c3) << 4) + HttpUtils.toHex(c));
                } else {
                    byArray[n2++] = (byte)c2;
                }
                ++i;
            }
            if (n2 == 0) break;
            String string2 = new String(byArray, 0, n2);
            n2 = 0;
            ++i;
            while (i < n && (c2 = string.charAt(i)) != '&') {
                if (c2 == '+') {
                    byArray[n2++] = 32;
                } else if (c2 != ' ') {
                    if (c2 == '%' && i + 2 < n) {
                        c = string.charAt(++i);
                        char c4 = string.charAt(++i);
                        byArray[n2++] = (byte)((HttpUtils.toHex(c) << 4) + HttpUtils.toHex(c4));
                    } else {
                        byArray[n2++] = (byte)c2;
                    }
                }
                ++i;
            }
            String string3 = new String(byArray, 0, n2);
            String[] stringArray = (String[])hashtable.get(string2);
            if (stringArray == null) {
                hashtable.put(string2, new String[]{string3});
                continue;
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string3;
            hashtable.put(string2, stringArray2);
        }
        return hashtable;
    }

    public static Hashtable parsePostData(int n, ServletInputStream servletInputStream) {
        try {
            if (n >= 0) {
                byte[] byArray = new byte[n];
                int n2 = 0;
                while (n > 0) {
                    int n3 = servletInputStream.read(byArray, n2, n);
                    if (n3 > 0) {
                        n2 += n3;
                        n -= n3;
                        continue;
                    }
                    throw new IOException("unexpected end of file");
                }
                return HttpUtils.parseQueryString(new String(byArray, 0, byArray.length));
            }
            return new Hashtable();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("illegal post data");
        }
    }

    public static StringBuffer getRequestURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(httpServletRequest.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (httpServletRequest.getServerPort() > 0 && httpServletRequest.getServerPort() != 80 && httpServletRequest.getServerPort() != 443) {
            stringBuffer.append(":");
            stringBuffer.append(httpServletRequest.getServerPort());
        }
        stringBuffer.append(httpServletRequest.getRequestURI());
        return stringBuffer;
    }

    private static int toHex(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }
}

