/*
 * Decompiled with CFR 0.152.
 */
package quicktime;

import java.lang.reflect.Field;
import quicktime.QTSession;
import quicktime.util.QTBuild;

public class QTException
extends Exception {
    private int eCode = 0;

    public static String errorCodeToString(int n) {
        try {
            if (n == -108) {
                return "memFullErr";
            }
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("quicktime.Errors");
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (fieldArray[i].getInt(null) != n) continue;
                return fieldArray[i].getName();
            }
        }
        catch (Exception exception) {
            return "Exception generated: " + exception.toString();
        }
        return "Unknown Error Code";
    }

    public QTException(String string) {
        super(string);
    }

    public QTException(int n) {
        this(new Integer(n).toString());
        this.eCode = n;
    }

    public static void checkError(int n) throws QTException {
        if (n < 0 && QTException.isDrawingError(n) < 0) {
            throw new QTException(n);
        }
    }

    public static int isDrawingError(int n) {
        switch (n) {
            case -8988: 
            case -8985: 
            case -8984: 
            case -8983: 
            case -8982: 
            case -8981: 
            case -8980: 
            case -8976: {
                return 0;
            }
        }
        return n;
    }

    public int errorCode() {
        return this.eCode;
    }

    public String errorCodeToString() {
        return QTException.errorCodeToString(this.eCode);
    }

    public String toString() {
        String string = this.eCode == 0 ? this.getMessage() : Integer.toString(this.eCode) + "=" + this.errorCodeToString();
        return this.getClass().getName() + QTBuild.info() + "," + string + ",QT.vers:" + Integer.toHexString(QTSession.getQTVersion());
    }
}

