/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.actions;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.MouseResponder;
import quicktime.app.spaces.Collection;
import quicktime.app.spaces.ListenerController;
import quicktime.app.spaces.Space;

public abstract class MouseController
implements ListenerController,
Collection,
MouseListener,
MouseMotionListener {
    private boolean wholespace;
    private Vector table;
    private MouseResponder responder;
    private Object mouseMoveCurrentTarget;
    private Object originalDragTarget;
    private Object currentTargetInDrag;
    protected int xLocationOffset;
    protected int yLocationOffset;

    protected MouseController(MouseResponder mouseResponder, boolean bl) {
        this.responder = mouseResponder;
        if (mouseResponder == null) {
            throw new NullPointerException("Responder must NOT be null");
        }
        this.wholespace = bl;
        this.table = new Vector();
        this.responder.controller = this;
    }

    public abstract Space getSpace();

    public final void addedToSpace(Space space) {
        this.setTargetSpace(space);
        this.responder.setTargetSpace(space);
    }

    public void removedFromSpace() {
        this.setTargetSpace(null);
        this.responder.setTargetSpace(null);
    }

    protected MouseResponder getResponder() {
        return this.responder;
    }

    protected abstract void setTargetSpace(Space var1);

    public void addedTo(Object object) {
        if (object instanceof Component) {
            if (this.responder.isInterested(51)) {
                ((Component)object).addMouseListener(this);
            }
            if (this.responder.isInterested(12)) {
                ((Component)object).addMouseMotionListener(this);
            }
        }
    }

    public void removedFrom(Object object) {
        if (object instanceof Component) {
            ((Component)object).removeMouseListener(this);
            ((Component)object).removeMouseMotionListener(this);
        }
    }

    protected abstract Object getSelected(MouseEvent var1) throws QTException;

    public boolean isWholespace() {
        return this.wholespace;
    }

    public void setWholespace(boolean bl) {
        this.wholespace = bl;
    }

    public boolean addMember(Object object) {
        if (!this.isAppropriate(object)) {
            return false;
        }
        if (!this.hasMember(object)) {
            this.table.addElement(object);
        }
        return true;
    }

    public boolean isAppropriate(Object object) {
        return this.responder.isAppropriate(object);
    }

    public void removeMember(Object object) {
        this.table.removeElement(object);
    }

    public Enumeration members() {
        return this.table.elements();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int size() {
        return this.table.size();
    }

    public boolean hasMember(Object object) {
        return object == null ? false : this.table.contains(object);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.responder.isInterested(16, mouseEvent.getModifiers())) {
            boolean bl = this.responder.isActive();
            if (!bl) {
                this.responder.activate(16);
                this.responderActivated();
            }
            this.responder.mouseEntered(mouseEvent);
            if (!bl) {
                this.deactivateResponder();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.responder.isInterested(32, mouseEvent.getModifiers())) {
            boolean bl = this.responder.isActive();
            if (!bl) {
                this.responder.activate(32);
                this.responderActivated();
            }
            this.responder.mouseExited(mouseEvent);
            if (this.mouseMoveCurrentTarget != null) {
                this.responder.mouseExitedTarget(mouseEvent);
                this.mouseMoveCurrentTarget = null;
            }
            if (bl) {
                this.deactivateResponder();
            }
        }
    }

    protected void setTranslation() {
        this.xLocationOffset = 0;
        this.yLocationOffset = 0;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.responder.isInterested(2, mouseEvent.getModifiers())) {
            this.setTranslation();
            mouseEvent.translatePoint(-this.xLocationOffset, -this.yLocationOffset);
            if (this._activateResponder(mouseEvent, 2)) {
                this.responder.mousePressed(mouseEvent);
            }
            mouseEvent.translatePoint(this.xLocationOffset, this.yLocationOffset);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.responder.isInterested(2, mouseEvent.getModifiers()) && this.responder.isActive()) {
            this.setTranslation();
            mouseEvent.translatePoint(-this.xLocationOffset, -this.yLocationOffset);
            this.responder.mouseReleased(mouseEvent);
            if (this.mouseMoveCurrentTarget == null) {
                this.deactivateResponder();
            } else if (this.currentTargetInDrag == null) {
                this.deactivateResponder();
                this.mouseMoveCurrentTarget = null;
            }
            this.originalDragTarget = null;
            mouseEvent.translatePoint(this.xLocationOffset, this.yLocationOffset);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.responder.isInterested(1, mouseEvent.getModifiers())) {
            this.setTranslation();
            mouseEvent.translatePoint(-this.xLocationOffset, -this.yLocationOffset);
            if (this._activateResponder(mouseEvent, 1)) {
                this.responder.mouseClicked(mouseEvent);
                this.deactivateResponder();
            }
            mouseEvent.translatePoint(this.xLocationOffset, this.yLocationOffset);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mouseMoved(MouseEvent mouseEvent) {
        block14: {
            if (!this.responder.isInterested(72, mouseEvent.getModifiers())) {
                return;
            }
            this.setTranslation();
            mouseEvent.translatePoint(-this.xLocationOffset, -this.yLocationOffset);
            if (this.responder.isInterested(64, mouseEvent.getModifiers())) {
                try {
                    Object object = this.getSelected(mouseEvent);
                    if (object == null) {
                        if (this.mouseMoveCurrentTarget != null) {
                            this.responder.mouseExitedTarget(mouseEvent);
                            this.deactivateResponder();
                            this.mouseMoveCurrentTarget = null;
                        }
                        break block14;
                    }
                    if (this.responder.isAppropriate(object)) {
                        if (this.mouseMoveCurrentTarget == null) {
                            this.responder.setTarget(object);
                            this.responder.activate(64);
                            this.responderActivated();
                            this.responder.mouseEnteredTarget(mouseEvent);
                            this.mouseMoveCurrentTarget = object;
                            break block14;
                        } else {
                            if (this.mouseMoveCurrentTarget == object) {
                                this.responder.mouseMoved(mouseEvent);
                                mouseEvent.translatePoint(this.xLocationOffset, this.yLocationOffset);
                                return;
                            }
                            this.responder.mouseExitedTarget(mouseEvent);
                            this.deactivateResponder();
                            this.responder.setTarget(object);
                            this.responder.activate(64);
                            this.responderActivated();
                            this.responder.mouseEnteredTarget(mouseEvent);
                            this.mouseMoveCurrentTarget = object;
                        }
                        break block14;
                    }
                    if (this.mouseMoveCurrentTarget != null) {
                        this.responder.mouseExitedTarget(mouseEvent);
                        this.deactivateResponder();
                        this.mouseMoveCurrentTarget = null;
                    }
                }
                catch (QTException qTException) {
                    QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "getSelected");
                }
            }
        }
        if (this.responder.isInterested(8, mouseEvent.getModifiers())) {
            boolean bl = this.responder.isActive();
            if (!bl) {
                this.responder.activate(8);
                this.responderActivated();
            }
            this.responder.mouseMoved(mouseEvent);
            if (!bl) {
                this.deactivateResponder();
            }
        }
        mouseEvent.translatePoint(this.xLocationOffset, this.yLocationOffset);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.responder.isInterested(4) && this.responder.isActive()) {
            this.setTranslation();
            mouseEvent.translatePoint(-this.xLocationOffset, -this.yLocationOffset);
            this.doDragTarget(mouseEvent);
            this.responder.mouseDragged(mouseEvent);
            mouseEvent.translatePoint(this.xLocationOffset, this.yLocationOffset);
        }
    }

    protected void doDragTarget(MouseEvent mouseEvent) {
        if (this.responder.isInterested(64, mouseEvent.getModifiers())) {
            try {
                Object object = this.getSelected(mouseEvent);
                if (object == null && this.currentTargetInDrag != null) {
                    this.responder.mouseExitedTarget(mouseEvent);
                    this.currentTargetInDrag = null;
                } else if (object != null && this.currentTargetInDrag == null && object == this.originalDragTarget) {
                    this.responder.mouseEnteredTarget(mouseEvent);
                    this.currentTargetInDrag = object;
                }
            }
            catch (QTException qTException) {
                QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "getSelected");
            }
        }
    }

    private boolean _activateResponder(MouseEvent mouseEvent, int n) {
        try {
            Object object = this.getSelected(mouseEvent);
            if (object != null && this.responder.isAppropriate(object)) {
                this.responder.activate(n);
                this.responder.setTarget(object);
                this.originalDragTarget = object;
                this.currentTargetInDrag = object;
                this.responderActivated();
                return true;
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "activateResponder");
        }
        return false;
    }

    protected void deactivateResponder() {
        this.responder.deactivate();
        this.originalDragTarget = null;
    }

    protected void responderActivated() {
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

