/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.Drawable;
import quicktime.qd.QDRect;
import quicktime.qd.Region;

public class ImageDrawer
implements Drawable {
    private static ImageDrawer logo;
    protected Image im;
    private QDRect bounds = new QDRect();
    protected Component canv;

    public static final ImageDrawer getQTLogo() {
        if (logo == null) {
            try {
                Class<?> clazz = Class.forName("quicktime.app.image.ImageDrawer");
                Object object = null;
                class PrivilegedGetLogoAction {
                    Class clazz;

                    PrivilegedGetLogoAction(Class clazz) {
                        this.clazz = clazz;
                    }

                    Object getContent() {
                        return AccessController.doPrivileged(new PrivilegedAction(this){
                            private final /* synthetic */ PrivilegedGetLogoAction this$0;
                            {
                                this.this$0 = privilegedGetLogoAction;
                            }

                            public Object run() {
                                Object object = null;
                                try {
                                    URL uRL = this.this$0.clazz.getResource("/qt3logo.jpg");
                                    object = uRL.getContent();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return object;
                            }
                        });
                    }
                }
                object = QTSession.getJavaVersion() == 65537 ? clazz.getResource("/qt3logo.jpg").getContent() : new PrivilegedGetLogoAction(clazz).getContent();
                Image image = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
                logo = new ImageDrawer(new Dimension(162, 162), image);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return logo;
    }

    public ImageDrawer() {
    }

    public ImageDrawer(Dimension dimension, Image image) {
        this.bounds = new QDRect(dimension);
        this.im = image;
    }

    public void addedTo(Object object) {
        if (object instanceof Component) {
            this.canv = (Component)object;
            if (this.im != null) {
                this.canv.prepareImage(this.im, this.canv);
            }
        }
    }

    public void removedFrom(Object object) {
        if (object instanceof Component) {
            this.canv = null;
        }
    }

    public Image getImage() {
        return this.im;
    }

    public void setDisplayBounds(QDRect qDRect) throws QTException {
        this.bounds = qDRect;
    }

    public QDRect getDisplayBounds() throws QTException {
        return this.bounds;
    }

    public void redraw(Region region) throws QTException {
        if (this.canv != null && this.im != null) {
            Graphics graphics = this.canv.getGraphics();
            QDRect qDRect = this.bounds;
            if (qDRect == null) {
                qDRect = new QDRect(this.canv.getSize());
            }
            graphics.drawImage(this.im, 0, 0, qDRect.getWidth(), qDRect.getHeight(), this.canv);
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        logo = null;
    }
}

