/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.awt.Dimension;
import java.io.IOException;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.Compositable;
import quicktime.app.image.GraphicsImporterDrawer;
import quicktime.app.image.ImageDataSequence;
import quicktime.app.image.ImageSettable;
import quicktime.app.image.ImageSpec;
import quicktime.io.QTFile;
import quicktime.qd.Pict;
import quicktime.qd.PixMap;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.qd.SetGWorld;
import quicktime.std.StdQTException;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.DSequence;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.ICMPixelFormatInfo;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.std.image.QTImage;
import quicktime.util.ByteEncodedImage;
import quicktime.util.EncodedImage;
import quicktime.util.IntEncodedImage;
import quicktime.util.RawEncodedImage;

public class ImagePresenter
implements QTDrawable,
Compositable,
ImageSettable {
    private static final boolean doDrawProfile = false;
    private ImageDescription mImageDescription = null;
    private DSequence mImageSeq = null;
    private QDRect mDisplayBounds = null;
    private ByteEncodedImage mDataB;
    private RawEncodedImage mDataR;
    private IntEncodedImage mDataI;
    private EncodedImage mData;
    private QDGraphics port = QDGraphics.scratch;
    private int origWidth;
    private int origHeight;
    private Matrix mat = new Matrix();
    private Region clip;
    private GraphicsMode gMode = new GraphicsMode();
    private boolean optimiseRedraw = true;

    public static ImagePresenter fromFile(QTFile qTFile) throws IOException, QTException {
        return ImagePresenter.fromGraphicsImporterDrawer(new GraphicsImporterDrawer(qTFile));
    }

    public static ImagePresenter fromGraphicsImporter(GraphicsImporter graphicsImporter) throws IOException, QTException {
        return ImagePresenter.fromGraphicsImporterDrawer(new GraphicsImporterDrawer(graphicsImporter));
    }

    public static ImagePresenter fromGraphicsImporterDrawer(GraphicsImporterDrawer graphicsImporterDrawer) throws IOException, QTException {
        QDRect qDRect = new QDRect(graphicsImporterDrawer.getDisplayBounds().getWidth(), graphicsImporterDrawer.getDisplayBounds().getHeight());
        QDGraphics qDGraphics = new QDGraphics(qDRect);
        graphicsImporterDrawer.setDisplayBounds(qDRect);
        graphicsImporterDrawer.setGWorld(qDGraphics);
        graphicsImporterDrawer.redraw(null);
        return ImagePresenter.fromGWorld(qDGraphics);
    }

    public static ImagePresenter fromImageSpec(ImageSpec imageSpec) throws QTException {
        return ImagePresenter.fromQTImage(imageSpec.getImage(), imageSpec.getDescription());
    }

    public static ImagePresenter fromImageSequence(ImageDataSequence imageDataSequence, int n) throws QTException {
        return ImagePresenter.fromQTImage(imageDataSequence.getImage(n), imageDataSequence.getDescription());
    }

    public static ImagePresenter fromGWorld(QDGraphics qDGraphics) throws QTException {
        PixMap pixMap = qDGraphics.getPixMap();
        return new ImagePresenter(pixMap.getPixelData(), new ImageDescription(pixMap));
    }

    public static ImagePresenter fromGWorld(QDGraphics qDGraphics, QDRect qDRect, int n, int n2, int n3, CodecComponent codecComponent) throws QTException {
        int n4 = QTImage.getMaxCompressionSize(qDGraphics, qDRect, n, n2, n3, codecComponent);
        RawEncodedImage rawEncodedImage = new RawEncodedImage(n4, true);
        ImageDescription imageDescription = QTImage.compress(qDGraphics, qDRect, n2, n3, rawEncodedImage);
        rawEncodedImage.setSize(imageDescription.getDataSize());
        ImagePresenter imagePresenter = new ImagePresenter(qDRect);
        imagePresenter.optimiseRedraw = false;
        imagePresenter.setImageData(rawEncodedImage, imageDescription);
        return imagePresenter;
    }

    public static ImagePresenter fromPict(Pict pict) throws QTException {
        ImageDescription imageDescription = new ImageDescription(1902408311);
        QDRect qDRect = pict.getPictFrame();
        imageDescription.setVersion(-2);
        imageDescription.setVendor(1634758764);
        imageDescription.setSpatialQuality(1024);
        imageDescription.setWidth(qDRect.getWidth());
        imageDescription.setHeight(qDRect.getHeight());
        imageDescription.setHRes(72.0f);
        imageDescription.setVRes(72.0f);
        imageDescription.setDataSize(pict.getSize());
        imageDescription.setFrameCount(1);
        imageDescription.setDepth(24);
        imageDescription.setClutID(-1);
        return new ImagePresenter(pict.toEncodedImage(), imageDescription);
    }

    public static ImagePresenter fromQTImage(EncodedImage encodedImage, ImageDescription imageDescription) throws QTException {
        return new ImagePresenter(encodedImage, imageDescription);
    }

    public ImagePresenter(QDRect qDRect) {
        this.mDisplayBounds = qDRect;
        this.origWidth = qDRect.getWidth();
        this.origHeight = qDRect.getHeight();
    }

    private ImagePresenter(EncodedImage encodedImage, ImageDescription imageDescription) throws QTException {
        this.setImageData(encodedImage, imageDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageData(EncodedImage encodedImage, ImageDescription imageDescription) throws QTException {
        int n = imageDescription.getCType();
        this.mImageDescription = imageDescription;
        if (encodedImage != null && this.optimiseRedraw && !(n == 1919706400 || n == 1918990112 || n == 1902408311 || n == 1885434984 || ICMPixelFormatInfo.isValidPixelFormat(n))) {
            SetGWorld setGWorld = null;
            try {
                QDGraphics qDGraphics = new QDGraphics(new QDRect(imageDescription.getWidth(), imageDescription.getHeight()));
                DSequence dSequence = new DSequence(imageDescription, qDGraphics, null, null, null, 0, 768, CodecComponent.anyCodec);
                dSequence.decompressFrameS(encodedImage, 0);
                PixMap pixMap = qDGraphics.getPixMap();
                this.mImageDescription = new ImageDescription(pixMap);
                encodedImage = pixMap.getPixelData();
            }
            catch (QTException qTException) {
                this.mImageDescription = imageDescription;
            }
            finally {
                if (setGWorld != null) {
                    setGWorld.reset();
                }
            }
        }
        this.mImageDescription.setFrameCount(1);
        this.origWidth = imageDescription.getWidth();
        this.origHeight = imageDescription.getHeight();
        if (this.mDisplayBounds == null) {
            this.mDisplayBounds = new QDRect(imageDescription.getWidth(), imageDescription.getHeight());
        }
        this.setDisplayBounds(this.mDisplayBounds);
        this.setImageData(encodedImage);
    }

    public void setImageData(EncodedImage encodedImage) throws QTException {
        this.mData = encodedImage;
        if (this.mData instanceof ByteEncodedImage) {
            this.mDataB = (ByteEncodedImage)this.mData;
            this.mDataI = null;
            this.mDataR = null;
        } else if (this.mData instanceof IntEncodedImage) {
            this.mDataI = (IntEncodedImage)this.mData;
            this.mDataB = null;
            this.mDataR = null;
        } else if (this.mData instanceof RawEncodedImage) {
            this.mDataR = (RawEncodedImage)this.mData;
            this.mDataI = null;
            this.mDataB = null;
        } else {
            this.mDataR = null;
            this.mDataI = null;
            this.mDataB = null;
        }
        if (this.mData != null) {
            this.mImageDescription.setDataSize(this.mData.getSize());
            if (this.mImageSeq == null) {
                this.setGWorld(this.port);
            }
        }
    }

    public void setRedrawOptimised(boolean bl) {
        this.optimiseRedraw = bl;
    }

    public boolean isRedrawOptimised() {
        return this.optimiseRedraw;
    }

    public void removeImageData() throws QTException {
        this.setGWorld(QDGraphics.scratch);
        this.mData = null;
        this.mDataI = null;
        this.mDataB = null;
        this.mDataR = null;
        this.mImageDescription = null;
    }

    public ImageDescription getDescription() {
        return this.mImageDescription;
    }

    public DSequence getDSequence() {
        return this.mImageSeq;
    }

    public Region getClip() throws QTException {
        return this.clip;
    }

    public synchronized void setClip(Region region) throws StdQTException {
        if (this.mImageSeq != null) {
            this.mImageSeq.setMask(region);
        }
        this.clip = region;
    }

    public void addedTo(Object object) {
    }

    public void removedFrom(Object object) {
    }

    public Matrix getMatrix() throws StdQTException {
        return this.mImageSeq != null ? this.mImageSeq.getMatrix() : this.mat;
    }

    public void setMatrix(Matrix matrix) throws QTException {
        if (this.mImageSeq != null) {
            this.mImageSeq.setMatrix(matrix);
        }
        this.mDisplayBounds.setX(matrix.getTx() + 0.5f);
        this.mDisplayBounds.setY(matrix.getTy() + 0.5f);
        this.mDisplayBounds.setWidth((float)this.origWidth * matrix.getSx() + 0.5f);
        this.mDisplayBounds.setHeight((float)this.origHeight * matrix.getSy() + 0.5f);
        this.mat = matrix;
    }

    public Dimension getInitialSize() throws QTException {
        return new Dimension(this.origWidth, this.origHeight);
    }

    public QDDimension getOriginalSize() throws QTException {
        return new QDDimension(this.origWidth, this.origHeight);
    }

    public EncodedImage getImage() {
        return this.mData;
    }

    public QDGraphics getGWorld() {
        return this.port;
    }

    public void setGWorld(QDGraphics qDGraphics) throws QTException {
        if (this.mData != null && this.mImageDescription != null) {
            if (QDGraphics.scratch.equals(qDGraphics)) {
                this.mImageSeq = null;
            } else {
                this.mImageSeq = new DSequence(this.mImageDescription, qDGraphics, null, this.getMatrix(), this.getClip(), 0, 768, CodecComponent.bestFidelityCodec);
                this.setGraphicsMode(this.gMode);
            }
        }
        this.port = qDGraphics;
    }

    public void setDisplayBounds(QDRect qDRect) throws StdQTException {
        Matrix matrix = new Matrix();
        matrix.setTx(qDRect.getX());
        matrix.setTy(qDRect.getY());
        matrix.setSx((float)qDRect.getWidth() / (float)this.origWidth);
        matrix.setSy((float)qDRect.getHeight() / (float)this.origHeight);
        if (this.mImageSeq != null) {
            this.mImageSeq.setMatrix(matrix);
        }
        this.mat = matrix;
        this.mDisplayBounds = qDRect;
    }

    public void setLocation(int n, int n2) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        qDRect.setX(n);
        qDRect.setY(n2);
        this.setDisplayBounds(qDRect);
    }

    public QDRect getDisplayBounds() {
        return this.mDisplayBounds;
    }

    public synchronized void redraw(Region region) throws QTException {
        if (this.mImageSeq == null) {
            return;
        }
        long l = 0L;
        if (region != null) {
            if (this.clip == null) {
                this.mImageSeq.setMask(region);
            } else {
                this.mImageSeq.invalidate(region);
            }
            this.doDraw();
            if (this.clip == null) {
                this.mImageSeq.setMask(this.clip);
            }
        } else {
            this.doDraw();
        }
    }

    protected final void doDraw() throws QTException {
        if (this.mDataR != null) {
            this.mImageSeq.decompressFrameS(this.mDataR, 0);
        } else if (this.mDataI != null) {
            this.mImageSeq.decompressFrameS(this.mDataI, 0);
        } else if (this.mDataB != null) {
            this.mImageSeq.decompressFrameS(this.mDataB, 0);
        }
    }

    public void setGraphicsMode(GraphicsMode graphicsMode) throws QTException {
        if (this.mImageSeq != null) {
            this.mImageSeq.setGraphicsMode(graphicsMode);
        }
        this.gMode = graphicsMode;
    }

    public GraphicsMode getGraphicsMode() {
        return this.gMode;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.mData + "," + this.mImageDescription + "]";
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

