/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.awt.Dimension;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.Redrawable;
import quicktime.app.time.TaskThread;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.clocks.TimeBase;
import quicktime.std.comp.ComponentDescription;
import quicktime.std.comp.ComponentIdentifier;
import quicktime.std.image.DSequence;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.ICMFrameTime;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.std.movies.Atom;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.AtomData;
import quicktime.util.EncodedImage;
import quicktime.util.EndianOrder;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;

public class QTEffect
implements QTDrawable,
Redrawable {
    ImageDescription effectDesc;
    QDRect mDisplayBounds;
    QDDimension initSize;
    private QDGraphics mDestPort = QDGraphics.scratch;
    int mNumberOfFrames = 1;
    AtomContainer effectSample;
    RawEncodedImage effectSamplePtr;
    private Region clip;
    TimeBase tb;
    DSequence effectSequence;
    Matrix mat;
    GraphicsMode gMode;
    private TaskThread tt;
    ICMFrameTime ft = new ICMFrameTime();
    int currentFrame = 1;
    private boolean mRedrawFlag;
    private int singleFrameFlag;
    boolean needsRedraw = false;

    public QTEffect() throws QTException {
        this(2, new QDDimension());
    }

    public QTEffect(Dimension dimension) throws QTException {
        this(2, new QDDimension(dimension.width, dimension.height));
    }

    public QTEffect(int n) throws QTException {
        this(n, new QDDimension());
    }

    public QTEffect(int n, Dimension dimension) throws QTException {
        this(n, new QDDimension(dimension.width, dimension.height));
    }

    public QTEffect(int n, QDDimension qDDimension) throws QTException {
        this.mRedrawFlag = n == 2;
        this.singleFrameFlag = n;
        this.effectDesc = new ImageDescription(0);
        this.effectDesc.setTemporalQuality(512);
        this.effectDesc.setSpatialQuality(512);
        this.effectDesc.setHRes(72.0f);
        this.effectDesc.setVRes(72.0f);
        this.effectDesc.setDepth(24);
        this.effectDesc.setFrameCount(1);
        this.effectDesc.setClutID(-1);
        this.mat = new Matrix();
        if (qDDimension != null && qDDimension.getWidth() != 0 && qDDimension.getHeight() != 0) {
            this.setDisplayBounds(new QDRect(qDDimension));
        }
        this.initSize = qDDimension;
    }

    public void setRedrawing(boolean bl) {
        this.mRedrawFlag = bl;
    }

    public boolean isRedrawing() {
        return this.mRedrawFlag;
    }

    public boolean isSingleFrame() {
        return this.singleFrameFlag == 1;
    }

    public void setGraphicsMode(GraphicsMode graphicsMode) throws QTException {
        if (this.effectSequence != null) {
            this.effectSequence.setGraphicsMode(graphicsMode);
        }
        this.gMode = graphicsMode;
    }

    public GraphicsMode getGraphicsMode() {
        return this.gMode;
    }

    public void setClip(Region region) throws StdQTException {
        this.clip = region;
        if (this.effectSequence != null) {
            this.effectSequence.setMask(this.clip);
        }
    }

    public Region getClip() {
        return this.clip;
    }

    public AtomContainer getEffect() throws StdQTException {
        return this.effectSample.copyAtom(Atom.kParentIsContainer);
    }

    public void setEffect(AtomContainer atomContainer) throws QTException {
        if (atomContainer == null) {
            this.effectSamplePtr = null;
            if (this.effectSample != null) {
                this.effectSample.unlock();
            }
            this.effectSample = null;
            return;
        }
        this.effectSample = atomContainer;
        Atom atom = this.effectSample.findChildByID_Atom(Atom.kParentIsContainer, 2003329396, 1);
        this.effectSample.lock();
        AtomData atomData = this.effectSample.getAtomData(atom);
        this.effectDesc.setCType(EndianOrder.flipBigEndianToNative32(atomData.getInt(0)));
        this.effectSamplePtr = RawEncodedImage.fromQTPointer(this.effectSample.toQTPointer());
        this.setUpSequence();
    }

    protected synchronized boolean setUpSequence() throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        if (QDGraphics.scratch.equals(this.getGWorld()) || this.effectSamplePtr == null || qDRect == null) {
            return false;
        }
        this.mat.setTx(qDRect.getX());
        this.mat.setTy(qDRect.getY());
        this.effectSequence = new DSequence(this.effectDesc, this.effectSamplePtr, this.getGWorld(), null, this.mat, this.getClip(), 0, 512, null);
        if (this.gMode != null) {
            this.effectSequence.setGraphicsMode(this.gMode);
        }
        this.tb = new TimeBase();
        this.tb.setRate(0.0f);
        this.effectSequence.setTimeBase(this.tb);
        return true;
    }

    public int getFrames() {
        return this.mNumberOfFrames;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public void checkForEffect(int n) throws QTException {
        ComponentDescription componentDescription = new ComponentDescription();
        componentDescription.setType(QTUtils.toOSType("imdc"));
        componentDescription.setSubType(n);
        ComponentIdentifier componentIdentifier = ComponentIdentifier.find(componentDescription);
        if (componentIdentifier == null) {
            throw new StdQTException(-50);
        }
    }

    public void addedTo(Object object) {
    }

    public void removedFrom(Object object) {
    }

    public synchronized void setGWorld(QDGraphics qDGraphics) throws QTException {
        this.mDestPort = qDGraphics;
        if (QDGraphics.scratch.equals(qDGraphics)) {
            this.effectSequence = null;
        } else {
            this.setUpSequence();
        }
    }

    public synchronized QDGraphics getGWorld() throws QTException {
        return this.mDestPort;
    }

    public synchronized void setDisplayBounds(QDRect qDRect) throws QTException {
        this.mDisplayBounds = qDRect;
        this.effectDesc.setHeight(qDRect.getHeight());
        this.effectDesc.setWidth(qDRect.getWidth());
        this.mat.setTx(qDRect.getX());
        this.mat.setTy(qDRect.getY());
        this.setUpSequence();
    }

    public void setLocation(int n, int n2) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        qDRect.setX(n);
        qDRect.setY(n2);
        this.setDisplayBounds(qDRect);
    }

    public QDRect getDisplayBounds() throws QTException {
        return this.mDisplayBounds == null ? new QDRect(this.initSize.getWidth(), this.initSize.getHeight()) : this.mDisplayBounds;
    }

    public DSequence getDSequence() {
        return this.effectSequence;
    }

    public EncodedImage getImage() {
        return this.effectSamplePtr;
    }

    public ImageDescription getDescription() throws QTException {
        return this.effectDesc;
    }

    public Dimension getInitialSize() throws QTException {
        QDDimension qDDimension = this.getOriginalSize();
        return new Dimension(qDDimension.getWidth(), qDDimension.getHeight());
    }

    public QDDimension getOriginalSize() throws QTException {
        return this.initSize.copy();
    }

    public Matrix getMatrix() throws QTException {
        return this.mat.copy();
    }

    public void setMatrix(Matrix matrix) throws QTException {
        this.mat = matrix.copy();
        if (this.effectSequence != null) {
            this.effectSequence.setMatrix(this.mat);
        }
    }

    public synchronized void redraw(Region region) throws QTException {
        if (this.effectSequence != null) {
            this.tb.setValue(this.currentFrame, this.mNumberOfFrames);
            this.ft.setValue(this.currentFrame);
            if (region != null) {
                if (this.getClip() == null) {
                    this.effectSequence.setMask(region);
                } else {
                    this.effectSequence.invalidate(region);
                }
            }
            this.effectSequence.decompressFrameWhen(this.effectSamplePtr, 0, this.ft);
            if (region != null && this.getClip() == null) {
                this.effectSequence.setMask(this.getClip());
            }
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

